/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.defaults.internal;

import com.liferay.gradle.plugins.cache.CachePlugin;
import com.liferay.gradle.plugins.defaults.internal.util.CIUtil;
import com.liferay.gradle.plugins.defaults.internal.util.GradleUtil;
import com.liferay.gradle.plugins.node.tasks.DownloadNodeTask;
import com.liferay.gradle.plugins.node.tasks.ExecuteNodeTask;
import com.liferay.gradle.plugins.node.tasks.ExecutePackageManagerTask;
import com.liferay.gradle.plugins.node.tasks.NpmInstallTask;
import com.liferay.gradle.plugins.node.tasks.YarnInstallTask;
import com.liferay.gradle.plugins.test.integration.TestIntegrationPlugin;
import com.liferay.gradle.util.Validator;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskContainer;

public class LiferayCIPlugin
implements Plugin<Project> {
    public static final Plugin<Project> INSTANCE = new LiferayCIPlugin();
    private static final File _NODE_MODULES_CACHE_DIR = new File(System.getProperty("user.home"), ".liferay/node-modules-cache");
    private static final int _NPM_INSTALL_RETRIES = 3;
    private static final String _SASS_BINARY_SITE_ARG = "--sass-binary-site=";
    private static final List<String> _excludes = Arrays.asList("**/bin/", "**/build/", "**/classes/", "**/node_modules/", "**/node_modules_cache/", "**/test-classes/", "**/tmp/");
    private static final List<String> _includes = Arrays.asList("yarn.lock", "private/yarn.lock", "apps/*/yarn.lock", "private/apps/*/yarn.lock");

    public void apply(final Project project) {
        this._configureTasksDownloadNode(project);
        this._configureTasksExecuteNode(project);
        this._configureTasksExecutePackageManager(project);
        this._configureTasksNpmInstall(project);
        this._configureTasksYarnInstall(project);
        GradleUtil.withPlugin(project, TestIntegrationPlugin.class, new Action<TestIntegrationPlugin>(){

            public void execute(TestIntegrationPlugin testIntegrationPlugin) {
                LiferayCIPlugin.this._configureTaskTestIntegration(project);
            }
        });
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                LiferayCIPlugin.this._configureTasksNpmInstallArgs(project);
            }
        });
    }

    private LiferayCIPlugin() {
    }

    private void _configureTaskDownloadNode(DownloadNodeTask downloadNodeTask) {
        downloadNodeTask.doFirst((Action)new Action<Task>(){

            public void execute(Task task) {
                if (GradleUtil.hasPlugin(task.getProject(), CachePlugin.class)) {
                    throw new GradleException("Unable to use Node.js on CI, please configure com.liferay.cache or update the cache");
                }
            }
        });
    }

    private void _configureTaskExecuteNode(ExecuteNodeTask executeNodeTask) {
        executeNodeTask.setNpmInstallRetries(3);
    }

    private void _configureTaskExecuteNodeArgs(ExecuteNodeTask executeNodeTask, Map<String, String> newArgs) {
        List args = executeNodeTask.getArgs();
        for (Map.Entry<String, String> entry : newArgs.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            boolean changed = false;
            for (int i = 0; i < args.size(); ++i) {
                String arg = GradleUtil.toString(args.get(i));
                if (!arg.startsWith(key)) continue;
                changed = true;
                args.set(i, key + value);
                break;
            }
            if (changed) continue;
            args.add(key + value);
        }
        executeNodeTask.setArgs((Iterable)args);
    }

    private void _configureTaskExecutePackageManager(ExecutePackageManagerTask executePackageManagerTask) {
        String ciRegistry;
        String ciNodeEnv = GradleUtil.getProperty((ExtensionAware)executePackageManagerTask.getProject(), (String)"nodejs.ci.node.env", (String)null);
        if (Validator.isNotNull((String)ciNodeEnv)) {
            executePackageManagerTask.environment((Object)"NODE_ENV", (Object)ciNodeEnv);
        }
        if (Validator.isNotNull((String)(ciRegistry = GradleUtil.getProperty((ExtensionAware)executePackageManagerTask.getProject(), (String)"nodejs.npm.ci.registry", (String)null)))) {
            executePackageManagerTask.setRegistry((Object)ciRegistry);
        }
    }

    private void _configureTaskNpmInstall(NpmInstallTask npmInstallTask) {
        npmInstallTask.setNodeModulesCacheDir((Object)_NODE_MODULES_CACHE_DIR);
        npmInstallTask.setRemoveShrinkwrappedUrls((Object)Boolean.TRUE);
        npmInstallTask.setUseNpmCI((Object)Boolean.FALSE);
    }

    private void _configureTasksDownloadNode(Project project) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(DownloadNodeTask.class, (Action)new Action<DownloadNodeTask>(){

            public void execute(DownloadNodeTask downloadNodeTask) {
                LiferayCIPlugin.this._configureTaskDownloadNode(downloadNodeTask);
            }
        });
    }

    private void _configureTasksExecuteNode(Project project) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(ExecuteNodeTask.class, (Action)new Action<ExecuteNodeTask>(){

            public void execute(ExecuteNodeTask executeNodeTask) {
                LiferayCIPlugin.this._configureTaskExecuteNode(executeNodeTask);
            }
        });
    }

    private void _configureTasksExecutePackageManager(Project project) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(ExecutePackageManagerTask.class, (Action)new Action<ExecutePackageManagerTask>(){

            public void execute(ExecutePackageManagerTask executePackageManagerTask) {
                LiferayCIPlugin.this._configureTaskExecutePackageManager(executePackageManagerTask);
            }
        });
    }

    private void _configureTasksNpmInstall(Project project) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(NpmInstallTask.class, (Action)new Action<NpmInstallTask>(){

            public void execute(NpmInstallTask npmInstallTask) {
                LiferayCIPlugin.this._configureTaskNpmInstall(npmInstallTask);
            }
        });
    }

    private void _configureTasksNpmInstallArgs(Project project) {
        final String ciSassBinarySite = GradleUtil.getProperty((ExtensionAware)project, (String)"nodejs.npm.ci.sass.binary.site", (String)null);
        if (Validator.isNull((String)ciSassBinarySite)) {
            return;
        }
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(NpmInstallTask.class, (Action)new Action<NpmInstallTask>(){

            public void execute(NpmInstallTask npmInstallTask) {
                LiferayCIPlugin.this._configureTaskExecuteNodeArgs((ExecuteNodeTask)npmInstallTask, Collections.singletonMap(LiferayCIPlugin._SASS_BINARY_SITE_ARG, ciSassBinarySite));
            }
        });
    }

    private void _configureTasksYarnInstall(Project project) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(YarnInstallTask.class, (Action)new Action<YarnInstallTask>(){

            public void execute(YarnInstallTask yarnInstallTask) {
                String taskName = yarnInstallTask.getName();
                if (taskName.equals("yarnInstall")) {
                    LiferayCIPlugin.this._configureTaskYarnInstall(yarnInstallTask);
                }
            }
        });
    }

    private void _configureTaskTestIntegration(Project project) {
        Task testIntegrationTask = GradleUtil.getTask((Project)project, (String)"testIntegration");
        Action<Task> action = new Action<Task>(){

            public void execute(Task task) {
                Project project = task.getProject();
                Logger logger = project.getLogger();
                SourceSet sourceSet = GradleUtil.getSourceSet((Project)project, (String)"testIntegration");
                Configuration configuration = GradleUtil.getConfiguration((Project)project, (String)sourceSet.getCompileConfigurationName());
                DependencySet dependencySet = configuration.getDependencies();
                for (ProjectDependency projectDependency : dependencySet.withType(ProjectDependency.class)) {
                    Project dependencyProject = projectDependency.getDependencyProject();
                    if (CIUtil.isExcludedDependencyProject(project, dependencyProject)) {
                        if (!logger.isLifecycleEnabled()) continue;
                        logger.lifecycle("Excluded project dependency {} for {}", new Object[]{dependencyProject.getPath(), project.getPath()});
                        continue;
                    }
                    File lfrBuildCIFile = dependencyProject.file((Object)".lfrbuild-ci");
                    File lfrBuildCISkipTestIntegrationCheckFile = dependencyProject.file((Object)".lfrbuild-ci-skip-test-integration-check");
                    File lfrBuildPortalDeprecatedFile = dependencyProject.file((Object)".lfrbuild-portal-deprecated");
                    File lfrBuildPortalFile = dependencyProject.file((Object)".lfrbuild-portal");
                    if (lfrBuildCISkipTestIntegrationCheckFile.exists()) {
                        if (!lfrBuildCIFile.exists() && !lfrBuildPortalFile.exists()) continue;
                        throw new GradleException("Please delete marker file " + lfrBuildCISkipTestIntegrationCheckFile);
                    }
                    if (lfrBuildCIFile.exists() || lfrBuildPortalDeprecatedFile.exists() || lfrBuildPortalFile.exists()) continue;
                    throw new GradleException("Please create marker file " + lfrBuildPortalFile);
                }
            }
        };
        testIntegrationTask.doFirst((Action)action);
    }

    private void _configureTaskYarnInstall(YarnInstallTask yarnInstallTask) {
        yarnInstallTask.doFirst((Action)new Action<Task>(){

            public void execute(Task task) {
                Project project = task.getProject();
                String ciRegistry = GradleUtil.getProperty((ExtensionAware)project, (String)"nodejs.npm.ci.registry", (String)null);
                Logger logger = project.getLogger();
                if (logger.isLifecycleEnabled()) {
                    logger.lifecycle("Using registry {}", new Object[]{ciRegistry});
                }
                HashMap<String, Object> args = new HashMap<String, Object>();
                args.put("dir", project.getProjectDir());
                args.put("excludes", _excludes);
                args.put("includes", _includes);
                ConfigurableFileTree fileTree = project.fileTree(args);
                fileTree.forEach(yarnLockFile -> this._updateYarnLockFile(ciRegistry, (File)yarnLockFile));
            }

            private void _updateYarnLockFile(String ciRegistry, File yarnLockFile) {
                try {
                    String text = new String(Files.readAllBytes(yarnLockFile.toPath()), StandardCharsets.UTF_8);
                    text = text.replaceAll("https://registry.yarnpkg.com", ciRegistry);
                    Files.write(yarnLockFile.toPath(), text.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                }
                catch (IOException ioe) {
                    throw new UncheckedIOException((Throwable)ioe);
                }
            }
        });
    }
}

