/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.defaults.internal.util;

import com.liferay.gradle.plugins.defaults.internal.util.GradleUtil;
import com.liferay.gradle.util.Validator;
import groovy.json.JsonSlurper;
import java.io.File;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.AuthenticationContainer;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.artifacts.repositories.PasswordCredentials;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.internal.authentication.DefaultBasicAuthentication;

public class GradlePluginsDefaultsUtil {
    public static final String DEFAULT_REPOSITORY_URL = "https://repository-cdn.liferay.com/nexus/content/groups/public";
    public static final String[] JSON_VERSION_FILE_NAMES = new String[]{"npm-shrinkwrap.json", "package-lock.json", "package.json"};
    public static final String[] PARENT_THEME_PROJECT_NAMES = new String[]{"frontend-theme-styled", "frontend-theme-unstyled"};
    public static final String SNAPSHOT_PROPERTY_NAME = "snapshot";
    public static final String SNAPSHOT_VERSION_SUFFIX = "-SNAPSHOT";
    public static final String TMP_MAVEN_REPOSITORY_DIR_NAME = ".m2-tmp";
    public static final Pattern jsonVersionPattern = Pattern.compile("\\n(\\t|  )\"version\": \"(.+)\"");
    private static final String _BUILD_PROFILE_FILE_NAME_PREFIX = ".lfrbuild-";
    private static final String _TEST_PROJECT_SUFFIX = "-test";

    public static void configureRepositories(Project project, File portalRootDir) {
        RepositoryHandler repositoryHandler = project.getRepositories();
        if (!Boolean.getBoolean("maven.local.ignore")) {
            repositoryHandler.mavenLocal();
            File tmpMavenRepositoryDir = null;
            if (portalRootDir != null) {
                tmpMavenRepositoryDir = new File(portalRootDir, TMP_MAVEN_REPOSITORY_DIR_NAME);
            }
            if (tmpMavenRepositoryDir != null && tmpMavenRepositoryDir.exists()) {
                GradleUtil.addMavenArtifactRepository(repositoryHandler, tmpMavenRepositoryDir);
            }
        }
        String url = System.getProperty("repository.url", DEFAULT_REPOSITORY_URL);
        GradleUtil.addMavenArtifactRepository(repositoryHandler, url);
        final String repositoryPrivatePassword = System.getProperty("repository.private.password");
        final String repositoryPrivateUrl = System.getProperty("repository.private.url");
        final String repositoryPrivateUsername = System.getProperty("repository.private.username");
        if (Validator.isNotNull((String)repositoryPrivatePassword) && Validator.isNotNull((String)repositoryPrivateUrl) && Validator.isNotNull((String)repositoryPrivateUsername)) {
            MavenArtifactRepository mavenArtifactRepository = repositoryHandler.maven((Action)new Action<MavenArtifactRepository>(){

                public void execute(MavenArtifactRepository mavenArtifactRepository) {
                    mavenArtifactRepository.setUrl((Object)repositoryPrivateUrl);
                }
            });
            mavenArtifactRepository.authentication((Action)new Action<AuthenticationContainer>(){

                public void execute(AuthenticationContainer authenticationContainer) {
                    authenticationContainer.add((Object)new DefaultBasicAuthentication("basic"));
                }
            });
            mavenArtifactRepository.credentials((Action)new Action<PasswordCredentials>(){

                public void execute(PasswordCredentials passwordCredentials) {
                    passwordCredentials.setPassword(repositoryPrivatePassword);
                    passwordCredentials.setUsername(repositoryPrivateUsername);
                }
            });
        }
    }

    public static Set<String> getBuildProfileFileNames(String buildProfile, boolean publicBranch) {
        if (Validator.isNull((String)buildProfile)) {
            return null;
        }
        String suffix = "private";
        if (publicBranch) {
            suffix = "public";
        }
        HashSet<String> fileNames = new HashSet<String>();
        fileNames.add(_BUILD_PROFILE_FILE_NAME_PREFIX + buildProfile + "-" + suffix);
        fileNames.add(_BUILD_PROFILE_FILE_NAME_PREFIX + buildProfile);
        if (buildProfile.equals("portal-deprecated")) {
            fileNames.add(".lfrbuild-portal-" + suffix);
            fileNames.add(".lfrbuild-portal");
        }
        return fileNames;
    }

    public static boolean hasNPMParentThemesDependencies(Project project) {
        if (!GradlePluginsDefaultsUtil.isSubrepository(project)) {
            return false;
        }
        File packageJSONFile = project.file((Object)"package.json");
        if (!packageJSONFile.exists()) {
            return false;
        }
        JsonSlurper jsonSlurper = new JsonSlurper();
        Map packageJSONMap = (Map)jsonSlurper.parse(packageJSONFile);
        Map devDependencies = (Map)packageJSONMap.get("devDependencies");
        if (devDependencies == null) {
            return false;
        }
        for (String key : devDependencies.keySet()) {
            if (!key.startsWith("liferay-theme-deps-")) continue;
            return true;
        }
        for (String parentThemeProjectName : PARENT_THEME_PROJECT_NAMES) {
            String name = "liferay-" + parentThemeProjectName;
            if (devDependencies.containsKey(name)) continue;
            return false;
        }
        return true;
    }

    public static boolean isPrivateProject(Project project) {
        String path = project.getPath();
        return path.startsWith(":private:");
    }

    public static boolean isSnapshot(Project project) {
        String version = String.valueOf(project.getVersion());
        return version.endsWith(SNAPSHOT_VERSION_SUFFIX);
    }

    public static boolean isSnapshot(Project project, String ... propertyNames) {
        boolean snapshot = false;
        if (project.hasProperty(SNAPSHOT_PROPERTY_NAME)) {
            snapshot = GradleUtil.getProperty((ExtensionAware)project, (String)SNAPSHOT_PROPERTY_NAME, (boolean)true);
        }
        if (!snapshot) {
            for (String propertyName : propertyNames) {
                if (!project.hasProperty(propertyName) || !GradleUtil.getProperty((ExtensionAware)project, (String)propertyName, (boolean)true)) continue;
                snapshot = true;
                break;
            }
        }
        return snapshot;
    }

    public static boolean isSubrepository(Project project) {
        String[] dirNames;
        File gitRepoDir = GradleUtil.getRootDir((Project)project, (String)".gitrepo");
        if (gitRepoDir != null) {
            return true;
        }
        for (String dirName : dirNames = new String[]{"build-working-dir.xml", "portal-impl"}) {
            if (GradleUtil.getRootDir((Project)project, (String)dirName) == null) continue;
            return false;
        }
        return true;
    }

    public static boolean isTestProject(File dir) {
        String dirName = dir.getName();
        return dirName.endsWith(_TEST_PROJECT_SUFFIX);
    }

    public static boolean isTestProject(Project project) {
        String projectName = project.getName();
        return projectName.endsWith(_TEST_PROJECT_SUFFIX);
    }

    public static void setProjectSnapshotVersion(Project project, String ... propertyNames) {
        String version = String.valueOf(project.getVersion());
        if (GradlePluginsDefaultsUtil.isSnapshot(project, propertyNames) && !version.endsWith(SNAPSHOT_VERSION_SUFFIX)) {
            project.setVersion((Object)(version + SNAPSHOT_VERSION_SUFFIX));
        }
    }
}

