/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.defaults;

import com.liferay.gradle.plugins.SourceFormatterDefaultsPlugin;
import com.liferay.gradle.plugins.defaults.internal.util.GradlePluginsDefaultsUtil;
import com.liferay.gradle.plugins.defaults.internal.util.GradleUtil;
import com.liferay.gradle.plugins.source.formatter.SourceFormatterPlugin;
import com.liferay.gradle.plugins.test.integration.TestIntegrationBasePlugin;
import com.liferay.gradle.util.Validator;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.tasks.testing.Test;
import org.gradle.api.tasks.testing.logging.TestExceptionFormat;
import org.gradle.api.tasks.testing.logging.TestLogEvent;
import org.gradle.api.tasks.testing.logging.TestLoggingContainer;
import org.gradle.plugins.ide.eclipse.EclipsePlugin;
import org.gradle.plugins.ide.idea.IdeaPlugin;
import org.springframework.boot.gradle.plugin.SpringBootPlugin;
import org.springframework.boot.gradle.run.BootRunTask;

public class LiferaySpringBootDefaultsPlugin
implements Plugin<Project> {
    private static final String _GROUP = "com.liferay";

    public void apply(Project project) {
        this._applyPlugins(project);
        File portalRootDir = GradleUtil.getRootDir((Project)project.getRootProject(), (String)"portal-impl");
        GradlePluginsDefaultsUtil.configureRepositories(project, portalRootDir);
        this._configureProject(project);
        this._addTaskRun(project);
        this._configureTaskBootRun(project);
        this._configureTaskCheck(project);
        this._configureTaskTest(project);
        this._configureTaskTestIntegration(project);
    }

    private Task _addTaskRun(Project project) {
        Task task = project.task("run");
        BootRunTask bootRunTask = (BootRunTask)GradleUtil.getTask((Project)project, (String)"bootRun");
        task.dependsOn(new Object[]{bootRunTask});
        task.setDescription("Runs Spring Boot '" + bootRunTask.getName() + "' task.");
        task.setGroup("build");
        return task;
    }

    private void _applyPlugins(Project project) {
        GradleUtil.applyPlugin((Project)project, EclipsePlugin.class);
        GradleUtil.applyPlugin((Project)project, IdeaPlugin.class);
        GradleUtil.applyPlugin((Project)project, JavaPlugin.class);
        GradleUtil.applyPlugin((Project)project, SourceFormatterDefaultsPlugin.class);
        GradleUtil.applyPlugin((Project)project, SourceFormatterPlugin.class);
        GradleUtil.applyPlugin((Project)project, SpringBootPlugin.class);
        GradleUtil.applyPlugin((Project)project, TestIntegrationBasePlugin.class);
    }

    private void _configureProject(Project project) {
        String group = GradleUtil.getGradlePropertiesValue((Project)project, (String)"project.group", (String)_GROUP);
        project.setGroup((Object)group);
    }

    private void _configureTaskBootRun(Project project) {
        String springBootJavaOpts = System.getenv("SPRING_BOOT_JAVA_OPTS");
        if (Validator.isNotNull((String)springBootJavaOpts)) {
            BootRunTask bootRunTask = (BootRunTask)GradleUtil.getTask((Project)project, (String)"bootRun");
            bootRunTask.setJvmArgs(Collections.singleton(springBootJavaOpts));
        }
    }

    private void _configureTaskCheck(Project project) {
        Task checkTask = GradleUtil.getTask((Project)project, (String)"check");
        Task testIntegrationTask = GradleUtil.getTask((Project)project, (String)"testIntegration");
        checkTask.dependsOn(new Object[]{testIntegrationTask});
    }

    private void _configureTaskTest(Project project) {
        Test test = (Test)GradleUtil.getTask((Project)project, (String)"test");
        test.setIgnoreFailures(false);
        this._configureTaskTestLogging(test);
    }

    private void _configureTaskTestIntegration(Project project) {
        Test test = (Test)GradleUtil.getTask((Project)project, (String)"testIntegration");
        test.setIgnoreFailures(false);
        this._configureTaskTestLogging(test);
    }

    private void _configureTaskTestLogging(Test test) {
        HashSet<TestLogEvent> testLogEvents = new HashSet<TestLogEvent>();
        testLogEvents.add(TestLogEvent.FAILED);
        testLogEvents.add(TestLogEvent.PASSED);
        testLogEvents.add(TestLogEvent.SKIPPED);
        testLogEvents.add(TestLogEvent.STANDARD_ERROR);
        testLogEvents.add(TestLogEvent.STARTED);
        TestLoggingContainer testLoggingContainer = test.getTestLogging();
        testLoggingContainer.setEvents(testLogEvents);
        testLoggingContainer.setExceptionFormat((Object)TestExceptionFormat.FULL);
        testLoggingContainer.setShowCauses(true);
        testLoggingContainer.setShowExceptions(true);
        testLoggingContainer.setShowStackTraces(true);
    }
}

