/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.defaults.internal;

import com.liferay.gradle.plugins.cache.CachePlugin;
import com.liferay.gradle.plugins.defaults.internal.util.FileUtil;
import com.liferay.gradle.plugins.defaults.internal.util.GradleUtil;
import com.liferay.gradle.plugins.defaults.tasks.ReplaceRegexTask;
import com.liferay.gradle.plugins.node.tasks.DownloadNodeTask;
import com.liferay.gradle.plugins.node.tasks.ExecuteNodeTask;
import com.liferay.gradle.plugins.node.tasks.ExecuteNpmTask;
import com.liferay.gradle.plugins.node.tasks.NpmInstallTask;
import com.liferay.gradle.plugins.test.integration.TestIntegrationPlugin;
import com.liferay.gradle.util.Validator;
import groovy.lang.Closure;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.bundling.Jar;

public class LiferayCIPlugin
implements Plugin<Project> {
    public static final Plugin<Project> INSTANCE = new LiferayCIPlugin();
    public static final String RESTORE_HOTFIX_VERSION_TASK_NAME = "restoreHotfixVersion";
    public static final String UPDATE_HOTFIX_VERSION_TASK_NAME = "updateHotfixVersion";
    private static final String _BND_HOTFIX_VERSION_FILE_NAME = "bnd.bnd";
    private static final String[] _JSON_HOTFIX_VERSION_FILE_NAMES = new String[]{"package-lock.json", "package.json"};
    private static final File _NODE_MODULES_CACHE_DIR = new File(System.getProperty("user.home"), ".liferay/node-modules-cache");
    private static final int _NPM_INSTALL_RETRIES = 3;
    private static final String _SASS_BINARY_SITE_ARG = "--sass-binary-site=";
    private static final Pattern _bndHotfixVersionPattern = Pattern.compile("\\nBundle-Version: (.+)");
    private static final Pattern _jsonHotfixVersionPattern = Pattern.compile("\\n(\\t|  )\"version\": \"(.+)\"");

    public void apply(final Project project) {
        ReplaceRegexTask restoreHotfixVersionTask = this._addTaskRestoreHotfixVersion(project);
        ReplaceRegexTask updateHotfixVersionTask = this._addTaskUpdateHotfixVersion(project);
        this._configureTasksDownloadNode(project);
        this._configureTasksExecuteNode(project);
        this._configureTasksExecuteNpm(project, restoreHotfixVersionTask, updateHotfixVersionTask);
        this._configureTasksNpmInstall(project);
        GradleUtil.withPlugin(project, TestIntegrationPlugin.class, new Action<TestIntegrationPlugin>(){

            public void execute(TestIntegrationPlugin testIntegrationPlugin) {
                LiferayCIPlugin.this._configureTaskTestIntegration(project);
            }
        });
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                LiferayCIPlugin.this._configureTasksNpmInstallArgs(project);
            }
        });
    }

    private LiferayCIPlugin() {
    }

    private ReplaceRegexTask _addTaskRestoreHotfixVersion(Project project) {
        ReplaceRegexTask replaceRegexTask = (ReplaceRegexTask)GradleUtil.addTask((Project)project, (String)RESTORE_HOTFIX_VERSION_TASK_NAME, ReplaceRegexTask.class);
        if (FileUtil.exists((Project)project, (String)_BND_HOTFIX_VERSION_FILE_NAME)) {
            replaceRegexTask.match(_bndHotfixVersionPattern.pattern(), project.file((Object)_BND_HOTFIX_VERSION_FILE_NAME));
        }
        for (String fileName : _JSON_HOTFIX_VERSION_FILE_NAMES) {
            if (!FileUtil.exists((Project)project, (String)fileName)) continue;
            replaceRegexTask.match(_jsonHotfixVersionPattern.pattern(), project.file((Object)fileName));
        }
        replaceRegexTask.setDescription("Updates the project hotfix version.");
        replaceRegexTask.setReplacement(new Closure<String>((Object)project){

            public String doCall(String version) {
                int index = version.indexOf("-hotfix");
                if (index == -1) {
                    return version;
                }
                String suffix = version.substring(index + 7);
                return version.substring(0, index) + ".hotfix" + suffix;
            }
        });
        return replaceRegexTask;
    }

    private ReplaceRegexTask _addTaskUpdateHotfixVersion(Project project) {
        ReplaceRegexTask replaceRegexTask = (ReplaceRegexTask)GradleUtil.addTask((Project)project, (String)UPDATE_HOTFIX_VERSION_TASK_NAME, ReplaceRegexTask.class);
        if (FileUtil.exists((Project)project, (String)_BND_HOTFIX_VERSION_FILE_NAME)) {
            replaceRegexTask.match(_bndHotfixVersionPattern.pattern(), project.file((Object)_BND_HOTFIX_VERSION_FILE_NAME));
        }
        for (String fileName : _JSON_HOTFIX_VERSION_FILE_NAMES) {
            if (!FileUtil.exists((Project)project, (String)fileName)) continue;
            replaceRegexTask.match(_jsonHotfixVersionPattern.pattern(), project.file((Object)fileName));
        }
        replaceRegexTask.setDescription("Restores the project hotfix version.");
        replaceRegexTask.setReplacement(new Closure<String>((Object)project){

            public String doCall(String version) {
                int index = version.indexOf(".hotfix");
                if (index == -1) {
                    return version;
                }
                String suffix = version.substring(index + 7);
                return version.substring(0, index) + "-hotfix" + suffix;
            }
        });
        return replaceRegexTask;
    }

    private void _configureTaskDownloadNode(DownloadNodeTask downloadNodeTask) {
        downloadNodeTask.doFirst((Action)new Action<Task>(){

            public void execute(Task task) {
                if (GradleUtil.hasPlugin(task.getProject(), CachePlugin.class)) {
                    throw new GradleException("Unable to use Node.js on CI, please configure com.liferay.cache or update the cache");
                }
            }
        });
    }

    private void _configureTaskExecuteNode(ExecuteNodeTask executeNodeTask) {
        executeNodeTask.setNpmInstallRetries(3);
    }

    private void _configureTaskExecuteNodeArgs(ExecuteNodeTask executeNodeTask, Map<String, String> newArgs) {
        List args = executeNodeTask.getArgs();
        for (Map.Entry<String, String> entry : newArgs.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            boolean changed = false;
            for (int i = 0; i < args.size(); ++i) {
                String arg = GradleUtil.toString(args.get(i));
                if (!arg.startsWith(key)) continue;
                changed = true;
                args.set(i, key + value);
                break;
            }
            if (changed) continue;
            args.add(key + value);
        }
        executeNodeTask.setArgs((Iterable)args);
    }

    private void _configureTaskExecuteNpm(ExecuteNpmTask executeNpmTask, String registry, ReplaceRegexTask restoreHotfixVersionTask, ReplaceRegexTask updateHotfixVersionTask) {
        if (Validator.isNotNull((String)registry)) {
            executeNpmTask.setRegistry((Object)registry);
        }
        executeNpmTask.dependsOn(new Object[]{updateHotfixVersionTask});
        Project project = executeNpmTask.getProject();
        TaskContainer taskContainer = project.getTasks();
        if (taskContainer.findByName("jar") != null) {
            Jar jar = (Jar)GradleUtil.getTask((Project)executeNpmTask.getProject(), (String)"jar");
            jar.finalizedBy(new Object[]{restoreHotfixVersionTask});
        }
    }

    private void _configureTaskNpmInstall(NpmInstallTask npmInstallTask) {
        if (Validator.isNull((String)System.getenv("FIX_PACKS_RELEASE_ENVIRONMENT"))) {
            npmInstallTask.setNodeModulesCacheDir((Object)_NODE_MODULES_CACHE_DIR);
        }
        npmInstallTask.setRemoveShrinkwrappedUrls((Object)Boolean.TRUE);
        npmInstallTask.setUseNpmCI((Object)Boolean.FALSE);
    }

    private void _configureTasksDownloadNode(Project project) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(DownloadNodeTask.class, (Action)new Action<DownloadNodeTask>(){

            public void execute(DownloadNodeTask downloadNodeTask) {
                LiferayCIPlugin.this._configureTaskDownloadNode(downloadNodeTask);
            }
        });
    }

    private void _configureTasksExecuteNode(Project project) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(ExecuteNodeTask.class, (Action)new Action<ExecuteNodeTask>(){

            public void execute(ExecuteNodeTask executeNodeTask) {
                LiferayCIPlugin.this._configureTaskExecuteNode(executeNodeTask);
            }
        });
    }

    private void _configureTasksExecuteNpm(Project project, final ReplaceRegexTask restoreHotfixVersionTask, final ReplaceRegexTask updateHotfixVersionTask) {
        final String ciRegistry = GradleUtil.getProperty((ExtensionAware)project, (String)"nodejs.npm.ci.registry", (String)null);
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(ExecuteNpmTask.class, (Action)new Action<ExecuteNpmTask>(){

            public void execute(ExecuteNpmTask executeNpmTask) {
                LiferayCIPlugin.this._configureTaskExecuteNpm(executeNpmTask, ciRegistry, restoreHotfixVersionTask, updateHotfixVersionTask);
            }
        });
    }

    private void _configureTasksNpmInstall(Project project) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(NpmInstallTask.class, (Action)new Action<NpmInstallTask>(){

            public void execute(NpmInstallTask npmInstallTask) {
                LiferayCIPlugin.this._configureTaskNpmInstall(npmInstallTask);
            }
        });
    }

    private void _configureTasksNpmInstallArgs(Project project) {
        final String ciSassBinarySite = GradleUtil.getProperty((ExtensionAware)project, (String)"nodejs.npm.ci.sass.binary.site", (String)null);
        if (Validator.isNull((String)ciSassBinarySite)) {
            return;
        }
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(NpmInstallTask.class, (Action)new Action<NpmInstallTask>(){

            public void execute(NpmInstallTask npmInstallTask) {
                LiferayCIPlugin.this._configureTaskExecuteNodeArgs((ExecuteNodeTask)npmInstallTask, Collections.singletonMap(LiferayCIPlugin._SASS_BINARY_SITE_ARG, ciSassBinarySite));
            }
        });
    }

    private void _configureTaskTestIntegration(Project project) {
        Task testIntegrationTask = GradleUtil.getTask((Project)project, (String)"testIntegration");
        Action<Task> action = new Action<Task>(){

            public void execute(Task task) {
                Project project = task.getProject();
                SourceSet sourceSet = GradleUtil.getSourceSet((Project)project, (String)"testIntegration");
                Configuration configuration = GradleUtil.getConfiguration((Project)project, (String)sourceSet.getCompileConfigurationName());
                DependencySet dependencySet = configuration.getDependencies();
                for (ProjectDependency projectDependency : dependencySet.withType(ProjectDependency.class)) {
                    Project dependencyProject = projectDependency.getDependencyProject();
                    File lfrBuildCIFile = dependencyProject.file((Object)".lfrbuild-ci");
                    File lfrBuildCISkipTestIntegrationCheckFile = dependencyProject.file((Object)".lfrbuild-ci-skip-test-integration-check");
                    File lfrBuildPortalFile = dependencyProject.file((Object)".lfrbuild-portal");
                    if (lfrBuildCISkipTestIntegrationCheckFile.exists()) {
                        if (!lfrBuildCIFile.exists() && !lfrBuildPortalFile.exists()) continue;
                        throw new GradleException("Please delete marker file " + lfrBuildCISkipTestIntegrationCheckFile);
                    }
                    if (lfrBuildCIFile.exists() || lfrBuildPortalFile.exists()) continue;
                    throw new GradleException("Please create marker file " + lfrBuildPortalFile);
                }
            }
        };
        testIntegrationTask.doFirst((Action)action);
    }
}

