/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.defaults.internal.util;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.LinkedList;
import java.util.Queue;
import org.gradle.BuildAdapter;
import org.gradle.BuildResult;
import org.gradle.api.UncheckedIOException;

public class BackupFilesBuildAdapter
extends BuildAdapter {
    private final Queue<Path> _paths = new LinkedList<Path>();

    public void backUp(Path path) {
        try {
            Path backupPath = this._getBackupPath(path);
            Files.copy(path, backupPath, StandardCopyOption.REPLACE_EXISTING);
            this._paths.add(path);
        }
        catch (IOException ioe) {
            throw new UncheckedIOException((Throwable)ioe);
        }
    }

    public void buildFinished(BuildResult buildResult) {
        try {
            while (!this._paths.isEmpty()) {
                Path path = this._paths.remove();
                Path backupPath = this._getBackupPath(path);
                if (!Files.exists(backupPath, new LinkOption[0])) continue;
                Files.move(backupPath, path, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException ioe) {
            throw new UncheckedIOException((Throwable)ioe);
        }
    }

    private Path _getBackupPath(Path path) {
        return Paths.get(path.toString() + ".backup", new String[0]);
    }
}

