/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.gradle.plugins.defaults.internal.util;

import java.io.File;
import java.io.IOException;

import java.nio.charset.StandardCharsets;
import java.nio.file.Files;

import org.gradle.api.UncheckedIOException;

/**
 * @author Andrea Di Giorgi
 */
public class GitRepo {

	public static GitRepo getGitRepo(File dir) {
		dir = GradleUtil.getRootDir(dir, _GIT_REPO_FILE_NAME);

		if (dir == null) {
			return null;
		}

		String content;

		try {
			File file = new File(dir, _GIT_REPO_FILE_NAME);

			content = new String(
				Files.readAllBytes(file.toPath()), StandardCharsets.UTF_8);
		}
		catch (IOException ioe) {
			throw new UncheckedIOException(ioe);
		}

		boolean readOnly = false;

		if (content.contains("mode = pull")) {
			readOnly = true;
		}

		return new GitRepo(dir, readOnly);
	}

	public final File dir;
	public final boolean readOnly;

	private GitRepo(File dir, boolean readOnly) {
		this.dir = dir;
		this.readOnly = readOnly;
	}

	private static final String _GIT_REPO_FILE_NAME = ".gitrepo";

}