/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.defaults;

import com.liferay.gradle.plugins.LiferayAntPlugin;
import com.liferay.gradle.plugins.defaults.internal.util.GradlePluginsDefaultsUtil;
import com.liferay.gradle.plugins.defaults.internal.util.GradleUtil;
import com.liferay.gradle.plugins.defaults.tasks.CopyIvyDependenciesTask;
import com.liferay.gradle.plugins.defaults.tasks.ReplaceRegexTask;
import groovy.lang.Closure;
import java.io.File;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.plugins.MavenPlugin;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.Upload;
import org.gradle.api.tasks.ant.AntTarget;

public class LiferayAntDefaultsPlugin
implements Plugin<Project> {
    public static final String COPY_IVY_DEPENDENCIES_TASK_NAME = "copyIvyDependencies";
    private static final String _GROUP = "com.liferay.plugins";

    public void apply(Project project) {
        File ivyXmlFile = project.file((Object)"ivy.xml");
        if (ivyXmlFile.exists()) {
            File portalRootDir = GradleUtil.getRootDir(project.getRootProject(), "portal-impl");
            GradlePluginsDefaultsUtil.configureRepositories(project, portalRootDir);
            CopyIvyDependenciesTask copyIvyDependenciesTask = this._addTaskCopyIvyDependencies(project, ivyXmlFile);
            copyIvyDependenciesTask.writeChecksumFile();
        }
        GradleUtil.applyPlugin((Project)project, LiferayAntPlugin.class);
        this._applyPlugins(project);
        this._addTaskInstall(project);
        this._applyConfigScripts(project);
        final ReplaceRegexTask updateVersionTask = this._addTaskUpdateVersion(project);
        this._configureProject(project);
        GradleUtil.excludeTasksWithProperty(project, "snapshotIfStale", true, "install", "uploadArchives");
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                GradlePluginsDefaultsUtil.setProjectSnapshotVersion(project, new String[0]);
                LiferayAntDefaultsPlugin.this._configureTaskUploadArchives(project, (Task)updateVersionTask);
            }
        });
    }

    private CopyIvyDependenciesTask _addTaskCopyIvyDependencies(Project project, File inputFile) {
        final CopyIvyDependenciesTask copyIvyDependenciesTask = (CopyIvyDependenciesTask)GradleUtil.addTask((Project)project, (String)COPY_IVY_DEPENDENCIES_TASK_NAME, CopyIvyDependenciesTask.class);
        copyIvyDependenciesTask.setDescription("Copies the dependencies declared in the ivy.xml file.");
        File destinationDir = project.file((Object)"docroot");
        destinationDir = destinationDir.exists() ? new File(destinationDir, "WEB-INF/lib") : project.file((Object)"lib");
        copyIvyDependenciesTask.setDestinationDir(destinationDir);
        copyIvyDependenciesTask.setInputFile(inputFile);
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(AntTarget.class, (Action)new Action<AntTarget>(){

            public void execute(AntTarget antTarget) {
                antTarget.dependsOn(new Object[]{copyIvyDependenciesTask});
            }
        });
        return copyIvyDependenciesTask;
    }

    private Upload _addTaskInstall(Project project) {
        Upload upload = GradleUtil.addTask(project, "install", Upload.class, true);
        Configuration configuration = GradleUtil.getConfiguration((Project)project, (String)"archives");
        upload.setConfiguration(configuration);
        upload.setDescription("Installs the '" + configuration.getName() + "' artifacts into the local Maven repository.");
        return upload;
    }

    private ReplaceRegexTask _addTaskUpdateVersion(Project project) {
        ReplaceRegexTask replaceRegexTask = (ReplaceRegexTask)GradleUtil.addTask((Project)project, (String)"updateVersion", ReplaceRegexTask.class);
        replaceRegexTask.match("module-incremental-version=(\\d+)", "docroot/WEB-INF/liferay-plugin-package.properties");
        replaceRegexTask.setDescription("Updates \"module-incremental-version\" in the liferay-plugin-package.properties file.");
        replaceRegexTask.setReplacement(new Closure<String>((Object)project){

            public String doCall(String group) {
                int moduleIncrementalVersion = Integer.parseInt(group);
                return String.valueOf(moduleIncrementalVersion + 1);
            }
        });
        return replaceRegexTask;
    }

    private void _applyConfigScripts(Project project) {
        GradleUtil.applyScript((Project)project, (String)"com/liferay/gradle/plugins/defaults/dependencies/config-maven.gradle", (Object)project);
    }

    private void _applyPlugins(Project project) {
        GradleUtil.applyPlugin((Project)project, MavenPlugin.class);
    }

    private void _configureProject(Project project) {
        String group = GradleUtil.getGradlePropertiesValue(project, "project.group", _GROUP);
        project.setGroup((Object)group);
    }

    private void _configureTaskUploadArchives(Project project, Task updatePluginVersionTask) {
        if (GradlePluginsDefaultsUtil.isSnapshot(project)) {
            return;
        }
        Task uploadArchivesTask = GradleUtil.getTask((Project)project, (String)"uploadArchives");
        uploadArchivesTask.finalizedBy(new Object[]{updatePluginVersionTask});
    }
}

