/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.gradle.plugins.defaults.internal.util;

import com.liferay.gradle.util.OSDetector;

import java.io.ByteArrayOutputStream;

import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.process.ExecSpec;

/**
 * @author Andrea Di Giorgi
 */
public class GitUtil {

	public static void commit(Project project, String message, boolean quiet) {
		final String messageArg = "--message=\"" + message + "\"";

		if (quiet) {
			project.exec(
				new Action<ExecSpec>() {

					@Override
					public void execute(ExecSpec execSpec) {
						if (OSDetector.isWindows()) {
							execSpec.setExecutable("cmd");

							execSpec.args("/c");
						}
						else {
							execSpec.setExecutable("sh");

							execSpec.args("-c");
						}

						execSpec.args(
							"(git diff-index --cached --quiet HEAD || git " +
								"commit " + messageArg + ")");
					}

				});
		}
		else {
			executeGit(project, "commit", messageArg);
		}
	}

	public static void executeGit(Project project, final Object... args) {
		project.exec(
			new Action<ExecSpec>() {

				@Override
				public void execute(ExecSpec execSpec) {
					execSpec.args(args);
					execSpec.setExecutable("git");
				}

			});
	}

	public static String getGitResult(Project project, final Object... args) {
		final ByteArrayOutputStream byteArrayOutputStream =
			new ByteArrayOutputStream();

		project.exec(
			new Action<ExecSpec>() {

				@Override
				public void execute(ExecSpec execSpec) {
					execSpec.args(args);
					execSpec.setExecutable("git");
					execSpec.setStandardOutput(byteArrayOutputStream);
				}

			});

		String result = byteArrayOutputStream.toString();

		return result.trim();
	}

}