/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.defaults.internal;

import com.liferay.gradle.plugins.BaseDefaultsPlugin;
import com.liferay.gradle.plugins.defaults.internal.MavenDefaultsPlugin;
import com.liferay.gradle.plugins.defaults.internal.util.GradlePluginsDefaultsUtil;
import com.liferay.gradle.plugins.defaults.internal.util.GradleUtil;
import com.liferay.gradle.plugins.node.NodePlugin;
import com.liferay.gradle.plugins.node.tasks.NpmShrinkwrapTask;
import com.liferay.gradle.plugins.node.tasks.PublishNodeModuleTask;
import java.util.Collections;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.tasks.Delete;
import org.gradle.api.tasks.TaskContainer;

public class NodeDefaultsPlugin
extends BaseDefaultsPlugin<NodePlugin> {
    public static final Plugin<Project> INSTANCE = new NodeDefaultsPlugin();
    private static final Iterable<String> _NPM_SHRINKWRAP_EXCLUDED_DEPENDENCIES = Collections.singleton("fsevents");

    protected void configureDefaults(Project project, NodePlugin nodePlugin) {
        this._configureTaskClean(project);
        this._configureTaskNpmShrinkwrap(project);
        this._configureTasksPublishNodeModule(project);
    }

    protected Class<NodePlugin> getPluginClass() {
        return NodePlugin.class;
    }

    private NodeDefaultsPlugin() {
    }

    private void _configureTaskClean(Project project) {
        boolean cleanNodeModules = Boolean.getBoolean("clean.node.modules");
        if (cleanNodeModules) {
            Delete delete = (Delete)GradleUtil.getTask((Project)project, (String)"clean");
            delete.delete(new Object[]{"node_modules"});
        }
    }

    private void _configureTaskNpmShrinkwrap(Project project) {
        NpmShrinkwrapTask npmShrinkwrapTask = (NpmShrinkwrapTask)GradleUtil.getTask((Project)project, (String)"npmShrinkwrap");
        npmShrinkwrapTask.excludeDependencies(_NPM_SHRINKWRAP_EXCLUDED_DEPENDENCIES);
    }

    private void _configureTaskPublishNodeModule(PublishNodeModuleTask publishNodeModuleTask) {
        final Project project = publishNodeModuleTask.getProject();
        publishNodeModuleTask.doFirst(MavenDefaultsPlugin.failReleaseOnWrongBranchAction);
        if (GradlePluginsDefaultsUtil.isPrivateProject(project)) {
            publishNodeModuleTask.setEnabled(false);
        }
        publishNodeModuleTask.setModuleAuthor((Object)"Nathan Cavanaugh <nathan.cavanaugh@liferay.com> (https://github.com/natecavanaugh)");
        publishNodeModuleTask.setModuleBugsUrl((Object)"https://issues.liferay.com/");
        publishNodeModuleTask.setModuleLicense((Object)"LGPL");
        publishNodeModuleTask.setModuleMain((Object)"package.json");
        publishNodeModuleTask.setModuleRepository((Object)"liferay/liferay-portal");
        publishNodeModuleTask.setModuleVersion((Object)new Callable<String>(){

            @Override
            public String call() throws Exception {
                String version = String.valueOf(project.getVersion());
                if (version.endsWith("-SNAPSHOT")) {
                    version = version.substring(0, version.length() - "-SNAPSHOT".length());
                    version = version + "-alpha." + System.currentTimeMillis();
                }
                return version;
            }
        });
        publishNodeModuleTask.setOverriddenPackageJsonKeys(new String[]{"version"});
    }

    private void _configureTasksPublishNodeModule(Project project) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(PublishNodeModuleTask.class, (Action)new Action<PublishNodeModuleTask>(){

            public void execute(PublishNodeModuleTask publishNodeModuleTask) {
                NodeDefaultsPlugin.this._configureTaskPublishNodeModule(publishNodeModuleTask);
            }
        });
    }
}

