/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.defaults.internal.util;

import com.github.jk1.license.LicenseReportPlugin;
import com.github.jk1.license.ManifestData;
import com.github.jk1.license.ModuleData;
import com.github.jk1.license.PomData;
import com.github.jk1.license.ProjectData;
import com.github.jk1.license.render.SingleInfoReportRenderer;
import com.liferay.gradle.plugins.defaults.internal.util.XMLUtil;
import com.liferay.gradle.util.Validator;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import javax.xml.parsers.DocumentBuilder;
import org.gradle.api.GradleException;
import org.gradle.api.UncheckedIOException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class VersionsXmlReportRenderer
extends SingleInfoReportRenderer {
    private final String _fileName;
    private final LicenseReportPlugin.LicenseReportExtension _licenseReportExtension;
    private final Callable<String> _moduleFileNamePrefixCallable;

    public VersionsXmlReportRenderer(String fileName, LicenseReportPlugin.LicenseReportExtension licenseReportExtension, Callable<String> moduleFileNamePrefixCallable) {
        this._fileName = fileName;
        this._licenseReportExtension = licenseReportExtension;
        this._moduleFileNamePrefixCallable = moduleFileNamePrefixCallable;
    }

    public void render(ProjectData projectData) {
        try {
            this._render(projectData);
        }
        catch (IOException ioe) {
            throw new UncheckedIOException((Throwable)ioe);
        }
        catch (Exception e) {
            throw new GradleException("Unable to render " + projectData, (Throwable)e);
        }
    }

    protected boolean isExcluded(ModuleData moduleData) {
        return false;
    }

    private void _appendLibraryElement(Document document, Element librariesElement, String fileName, ModuleData moduleData) {
        List moduleLicenseInfo = this.moduleLicenseInfo(this._licenseReportExtension, moduleData);
        String projectUrl = (String)moduleLicenseInfo.get(0);
        String licenseName = (String)moduleLicenseInfo.get(1);
        String licenseUrl = (String)moduleLicenseInfo.get(2);
        Element libraryElement = XMLUtil.appendElement(document, librariesElement, "library");
        XMLUtil.appendElement(document, libraryElement, "file-name", fileName);
        XMLUtil.appendElement(document, libraryElement, "version", moduleData.getVersion());
        XMLUtil.appendElement(document, libraryElement, "project-name", this._getProjectName(moduleData));
        XMLUtil.appendElement(document, libraryElement, "project-url", projectUrl);
        if (Validator.isNotNull((String)licenseName) || Validator.isNotNull((String)licenseUrl)) {
            Element licensesElement = XMLUtil.appendElement(document, libraryElement, "licenses");
            Element licenseElement = XMLUtil.appendElement(document, licensesElement, "license");
            XMLUtil.appendElement(document, licenseElement, "license-name", licenseName);
            XMLUtil.appendElement(document, licenseElement, "license-url", licenseUrl);
        }
    }

    private String _getProjectName(ModuleData moduleData) {
        String name = null;
        for (ManifestData manifestData : moduleData.getManifests()) {
            name = this._getProjectName(manifestData.getName(), name);
        }
        for (PomData pomData : moduleData.getPoms()) {
            name = this._getProjectName(pomData.getName(), name);
        }
        if (Validator.isNotNull(name)) {
            return name;
        }
        return moduleData.getGroup() + ":" + moduleData.getName();
    }

    private String _getProjectName(String name, String previousName) {
        if (Validator.isNull((String)name) || !Character.isAlphabetic(name.charAt(0))) {
            return previousName;
        }
        if (Validator.isNull((String)previousName)) {
            return name;
        }
        if (name.indexOf(32) != -1 && previousName.indexOf(32) == -1) {
            return name;
        }
        if (name.length() > previousName.length()) {
            return name;
        }
        return previousName;
    }

    private void _render(ProjectData projectData) throws Exception {
        TreeMap<String, ModuleData> fileNameModuleDataMap = new TreeMap<String, ModuleData>();
        String moduleFileNamePrefix = this._moduleFileNamePrefixCallable.call();
        for (ModuleData moduleData : projectData.getAllDependencies()) {
            if (this.isExcluded(moduleData)) continue;
            String moduleFileName = moduleFileNamePrefix + "!" + moduleData.getName() + ".jar";
            fileNameModuleDataMap.put(moduleFileName, moduleData);
        }
        DocumentBuilder documentBuilder = XMLUtil.getDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element versionsElement = XMLUtil.appendElement(document, document, "versions");
        Element versionElement = XMLUtil.appendElement(document, versionsElement, "version");
        Element librariesElement = XMLUtil.appendElement(document, versionElement, "libraries");
        for (Map.Entry entry : fileNameModuleDataMap.entrySet()) {
            this._appendLibraryElement(document, librariesElement, (String)entry.getKey(), (ModuleData)entry.getValue());
        }
        File file = new File(this._licenseReportExtension.getOutputDir(), this._fileName);
        XMLUtil.write(document, file);
    }
}

