/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.defaults;

import aQute.bnd.version.Version;
import com.liferay.gradle.plugins.LiferayOSGiPlugin;
import com.liferay.gradle.plugins.baseline.BaselinePlugin;
import com.liferay.gradle.plugins.baseline.BaselineTask;
import com.liferay.gradle.plugins.cache.CacheExtension;
import com.liferay.gradle.plugins.cache.CachePlugin;
import com.liferay.gradle.plugins.cache.task.TaskCache;
import com.liferay.gradle.plugins.defaults.internal.FindSecurityBugsPlugin;
import com.liferay.gradle.plugins.defaults.internal.WhipDefaultsPlugin;
import com.liferay.gradle.plugins.defaults.internal.util.BackupFilesBuildAdapter;
import com.liferay.gradle.plugins.defaults.internal.util.FileUtil;
import com.liferay.gradle.plugins.defaults.internal.util.GitUtil;
import com.liferay.gradle.plugins.defaults.internal.util.GradleUtil;
import com.liferay.gradle.plugins.defaults.internal.util.IncrementVersionClosure;
import com.liferay.gradle.plugins.defaults.internal.util.copy.RenameDependencyAction;
import com.liferay.gradle.plugins.defaults.tasks.InstallCacheTask;
import com.liferay.gradle.plugins.defaults.tasks.ReplaceRegexTask;
import com.liferay.gradle.plugins.defaults.tasks.WritePropertiesTask;
import com.liferay.gradle.plugins.dependency.checker.DependencyCheckerExtension;
import com.liferay.gradle.plugins.dependency.checker.DependencyCheckerPlugin;
import com.liferay.gradle.plugins.extensions.LiferayExtension;
import com.liferay.gradle.plugins.extensions.LiferayOSGiExtension;
import com.liferay.gradle.plugins.node.tasks.PublishNodeModuleTask;
import com.liferay.gradle.plugins.patcher.PatchTask;
import com.liferay.gradle.plugins.service.builder.BuildServiceTask;
import com.liferay.gradle.plugins.service.builder.ServiceBuilderPlugin;
import com.liferay.gradle.plugins.tlddoc.builder.tasks.TLDDocTask;
import com.liferay.gradle.plugins.upgrade.table.builder.UpgradeTableBuilderPlugin;
import com.liferay.gradle.plugins.util.PortalTools;
import com.liferay.gradle.plugins.whip.WhipPlugin;
import com.liferay.gradle.plugins.wsdd.builder.BuildWSDDTask;
import com.liferay.gradle.plugins.wsdd.builder.WSDDBuilderPlugin;
import com.liferay.gradle.plugins.wsdl.builder.WSDLBuilderPlugin;
import com.liferay.gradle.plugins.xsd.builder.XSDBuilderPlugin;
import com.liferay.gradle.util.StringUtil;
import com.liferay.gradle.util.Validator;
import com.liferay.gradle.util.copy.ExcludeExistingFileAction;
import com.liferay.gradle.util.copy.RenameDependencyClosure;
import com.liferay.gradle.util.copy.ReplaceLeadingPathAction;
import groovy.json.JsonSlurper;
import groovy.lang.Closure;
import groovy.time.Duration;
import groovy.time.TimeCategory;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import nebula.plugin.extraconfigurations.OptionalBasePlugin;
import nebula.plugin.extraconfigurations.ProvidedBasePlugin;
import org.dm.gradle.plugins.bundle.BundleExtension;
import org.gradle.BuildListener;
import org.gradle.StartParameter;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.JavaVersion;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.DependencySubstitutions;
import org.gradle.api.artifacts.ExcludeRule;
import org.gradle.api.artifacts.ExternalDependency;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.ResolutionStrategy;
import org.gradle.api.artifacts.ResolvableDependencies;
import org.gradle.api.artifacts.ResolveException;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.dsl.ArtifactHandler;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.maven.Conf2ScopeMappingContainer;
import org.gradle.api.artifacts.repositories.AuthenticationContainer;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.artifacts.repositories.PasswordCredentials;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.DuplicatesStrategy;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.TaskOutputsInternal;
import org.gradle.api.internal.artifacts.publish.ArchivePublishArtifact;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.ApplicationPlugin;
import org.gradle.api.plugins.BasePluginConvention;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.MavenPlugin;
import org.gradle.api.plugins.MavenPluginConvention;
import org.gradle.api.plugins.quality.FindBugs;
import org.gradle.api.plugins.quality.FindBugsPlugin;
import org.gradle.api.plugins.quality.FindBugsReports;
import org.gradle.api.plugins.quality.FindBugsXmlReport;
import org.gradle.api.plugins.quality.Pmd;
import org.gradle.api.plugins.quality.PmdExtension;
import org.gradle.api.plugins.quality.PmdPlugin;
import org.gradle.api.reporting.SingleFileReport;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetOutput;
import org.gradle.api.tasks.StopActionException;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.VerificationTask;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.javadoc.Javadoc;
import org.gradle.api.tasks.testing.JUnitXmlReport;
import org.gradle.api.tasks.testing.Test;
import org.gradle.api.tasks.testing.TestTaskReports;
import org.gradle.api.tasks.testing.logging.TestExceptionFormat;
import org.gradle.api.tasks.testing.logging.TestLogEvent;
import org.gradle.api.tasks.testing.logging.TestLoggingContainer;
import org.gradle.execution.ProjectConfigurer;
import org.gradle.external.javadoc.CoreJavadocOptions;
import org.gradle.external.javadoc.StandardJavadocDocletOptions;
import org.gradle.internal.authentication.DefaultBasicAuthentication;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.plugins.ide.api.XmlFileContentMerger;
import org.gradle.plugins.ide.eclipse.EclipsePlugin;
import org.gradle.plugins.ide.eclipse.model.Classpath;
import org.gradle.plugins.ide.eclipse.model.ClasspathEntry;
import org.gradle.plugins.ide.eclipse.model.EclipseClasspath;
import org.gradle.plugins.ide.eclipse.model.EclipseModel;
import org.gradle.plugins.ide.eclipse.model.SourceFolder;
import org.gradle.plugins.ide.idea.IdeaPlugin;
import org.gradle.plugins.ide.idea.model.IdeaModel;
import org.gradle.plugins.ide.idea.model.IdeaModule;
import org.gradle.process.ExecSpec;
import org.gradle.util.CollectionUtils;
import org.gradle.util.GUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class LiferayOSGiDefaultsPlugin
implements Plugin<Project> {
    public static final String ASPECTJ_WEAVER_CONFIGURATION_NAME = "aspectJWeaver";
    public static final String COMMIT_CACHE_TASK_NAME = "commitCache";
    public static final String COPY_LIBS_TASK_NAME = "copyLibs";
    public static final String DEFAULT_REPOSITORY_URL = "https://cdn.lfrs.sl/repository.liferay.com/nexus/content/groups/public";
    public static final String DEPLOY_APP_SERVER_LIB_TASK_NAME = "deployAppServerLib";
    public static final String DEPLOY_DEPENDENCIES_TASK_NAME = "deployDependencies";
    public static final String DEPLOY_TOOL_TASK_NAME = "deployTool";
    public static final String DOWNLOAD_COMPILED_JSP_TASK_NAME = "downloadCompiledJSP";
    public static final String INSTALL_CACHE_TASK_NAME = "installCache";
    public static final String JAR_JAVADOC_TASK_NAME = "jarJavadoc";
    public static final String JAR_JSP_TASK_NAME = "jarJSP";
    public static final String JAR_SOURCES_TASK_NAME = "jarSources";
    public static final String JAR_TLDDOC_TASK_NAME = "jarTLDDoc";
    public static final String PORTAL_TEST_CONFIGURATION_NAME = "portalTest";
    public static final String RELEASE_PORTAL_ROOT_DIR_PROPERTY_NAME = "release.versions.test.other.dir";
    public static final String SNAPSHOT_IF_STALE_PROPERTY_NAME = "snapshotIfStale";
    public static final String SYNC_RELEASE_PROPERTY_NAME = "syncRelease";
    public static final String SYNC_VERSIONS_TASK_NAME = "syncVersions";
    public static final String UPDATE_FILE_VERSIONS_TASK_NAME = "updateFileVersions";
    private static final String _APP_BND_FILE_NAME = "app.bnd";
    private static final String _BUNDLE_VERSION_REGEX = "Bundle-Version: (.+)(?:\\s|$)";
    private static final String _CACHE_COMMIT_MESSAGE = "FAKE GRADLE CACHE";
    private static final char _DEPENDENCY_KEY_SEPARATOR = '/';
    private static final String _GIT_REPO_FILE_NAME = ".gitrepo";
    private static final String _GROUP = "com.liferay";
    private static final String _GROUP_PORTAL = "com.liferay.portal";
    private static final JavaVersion _JAVA_VERSION = JavaVersion.VERSION_1_7;
    private static final boolean _MAVEN_LOCAL_IGNORE = Boolean.getBoolean("maven.local.ignore");
    private static final String _PMD_PORTAL_TOOL_NAME = "com.liferay.pmd";
    private static final Duration _PORTAL_TOOL_MAX_AGE = TimeCategory.getDays((Integer)30);
    private static final String _REPOSITORY_PRIVATE_PASSWORD = System.getProperty("repository.private.password");
    private static final String _REPOSITORY_PRIVATE_URL = System.getProperty("repository.private.url");
    private static final String _REPOSITORY_PRIVATE_USERNAME = System.getProperty("repository.private.username");
    private static final String _REPOSITORY_URL = System.getProperty("repository.url", "https://cdn.lfrs.sl/repository.liferay.com/nexus/content/groups/public");
    private static final String _SERVICE_BUILDER_PORTAL_TOOL_NAME = "com.liferay.portal.tools.service.builder";
    private static final String _SOURCE_FORMATTER_PORTAL_TOOL_NAME = "com.liferay.source.formatter";
    private static final BackupFilesBuildAdapter _backupFilesBuildAdapter = new BackupFilesBuildAdapter();
    private static final Pattern _jsonVersionPattern = Pattern.compile("\\n\\t\"version\": \"(.+)\"");

    public void apply(final Project project) {
        final File portalRootDir = GradleUtil.getRootDir(project.getRootProject(), "portal-impl");
        GradleUtil.applyPlugin((Project)project, LiferayOSGiPlugin.class);
        final LiferayExtension liferayExtension = (LiferayExtension)GradleUtil.getExtension((ExtensionAware)project, LiferayExtension.class);
        final GitRepo gitRepo = this._getGitRepo(project.getProjectDir());
        final boolean testProject = GradleUtil.isTestProject(project);
        File versionOverrideFile = this._getVersionOverrideFile(project, gitRepo);
        boolean syncReleaseVersions = this._syncReleaseVersions(project, portalRootDir, versionOverrideFile, testProject);
        this._applyVersionOverrides(project, versionOverrideFile);
        Gradle gradle = project.getGradle();
        gradle.addBuildListener((BuildListener)_backupFilesBuildAdapter);
        StartParameter startParameter = gradle.getStartParameter();
        List taskNames = startParameter.getTaskNames();
        boolean publishing = this._isPublishing(project);
        boolean deployToAppServerLibs = false;
        boolean deployToTools = false;
        if (FileUtil.exists((Project)project, (String)".lfrbuild-app-server-lib")) {
            deployToAppServerLibs = true;
        } else if (FileUtil.exists((Project)project, (String)".lfrbuild-tool")) {
            deployToTools = true;
        }
        this._applyPlugins(project);
        this._configureMavenConf2ScopeMappings(project);
        this._applyConfigScripts(project);
        this._addDependenciesPmd(project);
        if (testProject || this._hasTests(project)) {
            GradleUtil.applyPlugin((Project)project, WhipPlugin.class);
            WhipDefaultsPlugin.INSTANCE.apply((Object)project);
            Configuration aspectJWeaverConfiguration = this._addConfigurationAspectJWeaver(project);
            Configuration portalConfiguration = GradleUtil.getConfiguration((Project)project, (String)"portal");
            Configuration portalTestConfiguration = this._addConfigurationPortalTest(project);
            this._addDependenciesPortalTest(project);
            this._addDependenciesTestCompile(project);
            this._configureEclipse(project, portalTestConfiguration);
            this._configureIdea(project, portalTestConfiguration);
            this._configureSourceSetTest(project, portalConfiguration, portalTestConfiguration);
            this._configureSourceSetTestIntegration(project, portalConfiguration, portalTestConfiguration);
            this._configureTaskTestAspectJWeaver(project, "test", aspectJWeaverConfiguration);
            this._configureTaskTestAspectJWeaver(project, "testIntegration", aspectJWeaverConfiguration);
        }
        Task baselineTask = GradleUtil.getTask((Project)project, (String)"baseline");
        ReplaceRegexTask syncVersionsTask = this._addTaskSyncVersions(project);
        baselineTask.finalizedBy(new Object[]{syncVersionsTask});
        if (syncReleaseVersions) {
            this._configureTaskBaselineSyncReleaseVersions(baselineTask, versionOverrideFile);
        }
        InstallCacheTask installCacheTask = this._addTaskInstallCache(project);
        this._addTaskCommitCache(project, installCacheTask);
        this._addTaskCopyLibs(project);
        Copy deployDependenciesTask = this._addTaskDeployDependencies(project, liferayExtension);
        if (deployToAppServerLibs) {
            this._addTaskAlias(project, DEPLOY_APP_SERVER_LIB_TASK_NAME, "deploy");
        } else if (deployToTools) {
            this._addTaskAlias(project, DEPLOY_TOOL_TASK_NAME, "deploy");
        }
        final Jar jarJSPsTask = this._addTaskJarJSP(project);
        final Jar jarJavadocTask = this._addTaskJarJavadoc(project);
        final Jar jarSourcesTask = this._addTaskJarSources(project, testProject);
        final Jar jarTLDDocTask = this._addTaskJarTLDDoc(project);
        final ReplaceRegexTask updateFileVersionsTask = this._addTaskUpdateFileVersions(project, gitRepo);
        final ReplaceRegexTask updateVersionTask = this._addTaskUpdateVersion(project);
        this._configureBasePlugin(project, portalRootDir);
        this._configureBundleDefaultInstructions(project, portalRootDir, publishing);
        this._configureConfigurations(project, gitRepo, liferayExtension);
        this._configureDependencyChecker(project);
        this._configureDeployDir(project, liferayExtension, deployToAppServerLibs, deployToTools);
        this._configureEclipse(project);
        this._configureJavaPlugin(project);
        this._configureLocalPortalTool(project, portalRootDir, "sourceFormatter", _SOURCE_FORMATTER_PORTAL_TOOL_NAME);
        this._configurePmd(project);
        this._configureProject(project);
        LiferayOSGiDefaultsPlugin.configureRepositories(project);
        this._configureSourceSetMain(project);
        this._configureTaskDeploy(project, deployDependenciesTask);
        this._configureTaskJar(project, testProject);
        this._configureTaskJavadoc(project, portalRootDir);
        this._configureTaskTest(project);
        this._configureTaskTestIntegration(project);
        this._configureTaskTlddoc(project, portalRootDir);
        this._configureTasksBaseline(project);
        this._configureTasksFindBugs(project);
        this._configureTasksJavaCompile(project);
        this._configureTasksPmd(project);
        this._configureTasksPublishNodeModule(project);
        if (publishing) {
            this._configureTasksEnabledIfStaleSnapshot(project, testProject, "install", "uploadArchives");
        }
        GradleUtil.withPlugin(project, ServiceBuilderPlugin.class, new Action<ServiceBuilderPlugin>(){

            public void execute(ServiceBuilderPlugin serviceBuilderPlugin) {
                LiferayOSGiDefaultsPlugin.this._configureLocalPortalTool(project, portalRootDir, "serviceBuilder", LiferayOSGiDefaultsPlugin._SERVICE_BUILDER_PORTAL_TOOL_NAME);
                LiferayOSGiDefaultsPlugin.this._configureTaskBuildService(project);
            }
        });
        GradleUtil.withPlugin(project, WSDDBuilderPlugin.class, new Action<WSDDBuilderPlugin>(){

            public void execute(WSDDBuilderPlugin wsddBuilderPlugin) {
                LiferayOSGiDefaultsPlugin.this._configureTaskBuildWSDD(project);
            }
        });
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                LiferayOSGiDefaultsPlugin.this._checkVersion(project);
                LiferayOSGiDefaultsPlugin.this._configureArtifacts(project, jarJSPsTask, jarJavadocTask, jarSourcesTask, jarTLDDocTask);
                LiferayOSGiDefaultsPlugin.this._configureTaskJarSources(jarSourcesTask);
                LiferayOSGiDefaultsPlugin.this._configureTaskUpdateFileVersions(updateFileVersionsTask, portalRootDir);
                GradleUtil.setProjectSnapshotVersion(project, LiferayOSGiDefaultsPlugin.SNAPSHOT_IF_STALE_PROPERTY_NAME);
                if (GradleUtil.hasPlugin(project, CachePlugin.class)) {
                    LiferayOSGiDefaultsPlugin.this._configureTaskUpdateVersionForCachePlugin(updateVersionTask);
                }
                LiferayOSGiDefaultsPlugin.this._configureTaskCompileJSP(project, liferayExtension);
                LiferayOSGiDefaultsPlugin.this._configureTaskUploadArchives(project, testProject, updateFileVersionsTask, updateVersionTask);
                LiferayOSGiDefaultsPlugin.this._configureProjectBndProperties(project, liferayExtension);
            }
        });
        if (taskNames.contains("eclipse") || taskNames.contains("idea")) {
            this._forceProjectDependenciesEvaluation(project);
        }
        TaskExecutionGraph taskExecutionGraph = gradle.getTaskGraph();
        taskExecutionGraph.whenReady((Closure)new Closure<Void>((Object)project){

            public void doCall(TaskExecutionGraph taskExecutionGraph) {
                Task jarTask = GradleUtil.getTask((Project)project, (String)"jar");
                if (taskExecutionGraph.hasTask(jarTask)) {
                    LiferayOSGiDefaultsPlugin.this._configureBundleInstructions(project, gitRepo);
                }
            }
        });
    }

    protected static void configureRepositories(Project project) {
        RepositoryHandler repositoryHandler = project.getRepositories();
        if (!_MAVEN_LOCAL_IGNORE) {
            repositoryHandler.mavenLocal();
        }
        repositoryHandler.maven((Action)new Action<MavenArtifactRepository>(){

            public void execute(MavenArtifactRepository mavenArtifactRepository) {
                mavenArtifactRepository.setUrl((Object)_REPOSITORY_URL);
            }
        });
        if (Validator.isNotNull((String)_REPOSITORY_PRIVATE_PASSWORD) && Validator.isNotNull((String)_REPOSITORY_PRIVATE_URL) && Validator.isNotNull((String)_REPOSITORY_PRIVATE_USERNAME)) {
            MavenArtifactRepository mavenArtifactRepository = repositoryHandler.maven((Action)new Action<MavenArtifactRepository>(){

                public void execute(MavenArtifactRepository mavenArtifactRepository) {
                    mavenArtifactRepository.setUrl((Object)_REPOSITORY_PRIVATE_URL);
                }
            });
            mavenArtifactRepository.authentication((Action)new Action<AuthenticationContainer>(){

                public void execute(AuthenticationContainer authenticationContainer) {
                    authenticationContainer.add((Object)new DefaultBasicAuthentication("basic"));
                }
            });
            mavenArtifactRepository.credentials((Action)new Action<PasswordCredentials>(){

                public void execute(PasswordCredentials passwordCredentials) {
                    passwordCredentials.setPassword(_REPOSITORY_PRIVATE_PASSWORD);
                    passwordCredentials.setUsername(_REPOSITORY_PRIVATE_USERNAME);
                }
            });
        }
    }

    private Configuration _addConfigurationAspectJWeaver(final Project project) {
        Configuration configuration = GradleUtil.addConfiguration((Project)project, (String)ASPECTJ_WEAVER_CONFIGURATION_NAME);
        configuration.defaultDependencies((Action)new Action<DependencySet>(){

            public void execute(DependencySet dependencySet) {
                LiferayOSGiDefaultsPlugin.this._addDependenciesAspectJWeaver(project);
            }
        });
        configuration.setDescription("Configures AspectJ Weaver to apply to the test tasks.");
        configuration.setTransitive(false);
        configuration.setVisible(false);
        return configuration;
    }

    private Configuration _addConfigurationPortalTest(Project project) {
        Configuration configuration = GradleUtil.addConfiguration((Project)project, (String)PORTAL_TEST_CONFIGURATION_NAME);
        configuration.setDescription("Configures Liferay portal test utility artifacts for this project.");
        configuration.setVisible(false);
        return configuration;
    }

    private void _addDependenciesAspectJWeaver(Project project) {
        GradleUtil.addDependency((Project)project, (String)ASPECTJ_WEAVER_CONFIGURATION_NAME, (String)"org.aspectj", (String)"aspectjweaver", (String)"1.8.9");
    }

    private void _addDependenciesPmd(Project project) {
        String version = PortalTools.getVersion((Project)project, (String)_PMD_PORTAL_TOOL_NAME);
        if (Validator.isNotNull((String)version)) {
            GradleUtil.addDependency((Project)project, (String)"pmd", (String)_GROUP, (String)_PMD_PORTAL_TOOL_NAME, (String)version);
        }
    }

    private void _addDependenciesPortalTest(Project project) {
        GradleUtil.addDependency((Project)project, (String)PORTAL_TEST_CONFIGURATION_NAME, (String)_GROUP_PORTAL, (String)"com.liferay.portal.test", (String)"default");
        GradleUtil.addDependency((Project)project, (String)PORTAL_TEST_CONFIGURATION_NAME, (String)_GROUP_PORTAL, (String)"com.liferay.portal.test.integration", (String)"default");
    }

    private void _addDependenciesTestCompile(Project project) {
        GradleUtil.addDependency((Project)project, (String)"testCompile", (String)"org.mockito", (String)"mockito-core", (String)"1.10.8");
        ModuleDependency moduleDependency = (ModuleDependency)GradleUtil.addDependency((Project)project, (String)"testCompile", (String)"org.powermock", (String)"powermock-api-mockito", (String)"1.6.1");
        HashMap<String, String> excludeArgs = new HashMap<String, String>();
        excludeArgs.put("group", "org.mockito");
        excludeArgs.put("module", "mockito-all");
        moduleDependency.exclude(excludeArgs);
        GradleUtil.addDependency((Project)project, (String)"testCompile", (String)"org.powermock", (String)"powermock-module-junit4", (String)"1.6.1");
        GradleUtil.addDependency((Project)project, (String)"testCompile", (String)"org.springframework", (String)"spring-test", (String)"3.2.15.RELEASE");
    }

    private Task _addTaskAlias(Project project, String taskName, String originalTaskName) {
        Task task = project.task(taskName);
        Task originalTask = GradleUtil.getTask((Project)project, (String)originalTaskName);
        task.dependsOn(new Object[]{originalTask});
        task.setDescription("Alias for " + originalTask);
        task.setGroup(originalTask.getGroup());
        return task;
    }

    private Task _addTaskCommitCache(Project project, final InstallCacheTask installCacheTask) {
        Task task = project.task(COMMIT_CACHE_TASK_NAME);
        task.dependsOn(new Object[]{installCacheTask});
        task.doLast((Action)new Action<Task>(){

            public void execute(Task task) {
                File cachedVersionDir = installCacheTask.getCacheDestinationDir();
                File cachedArtifactDir = cachedVersionDir.getParentFile();
                File[] cachedVersionDirs = FileUtil.getDirectories(cachedArtifactDir);
                if (cachedVersionDirs.length != 2) {
                    throw new StopActionException("Skipping old cached version deletion");
                }
                File oldCachedVersionDir = cachedVersionDirs[0];
                if (cachedVersionDir.equals(oldCachedVersionDir)) {
                    oldCachedVersionDir = cachedVersionDirs[1];
                }
                Logger logger = task.getLogger();
                Project project = task.getProject();
                boolean deleted = project.delete(new Object[]{oldCachedVersionDir});
                if (!deleted && logger.isWarnEnabled()) {
                    logger.warn("Unable to delete old cached version in " + oldCachedVersionDir);
                }
            }
        });
        task.doLast((Action)new Action<Task>(){

            public void execute(Task task) {
                Project project = task.getProject();
                project.exec((Action)new Action<ExecSpec>(){

                    public void execute(ExecSpec execSpec) {
                        execSpec.setCommandLine(new Object[]{"git", "add", "."});
                        File cachedVersionDir = installCacheTask.getCacheDestinationDir();
                        execSpec.setWorkingDir((Object)cachedVersionDir.getParentFile());
                    }
                });
            }
        });
        task.doLast((Action)new Action<Task>(){

            public void execute(Task task) {
                Project project = task.getProject();
                final String commitSubject = GitUtil.getGitResult(project, "log", "-1", "--pretty=%s");
                project.exec((Action)new Action<ExecSpec>(){

                    public void execute(ExecSpec execSpec) {
                        String message = LiferayOSGiDefaultsPlugin._CACHE_COMMIT_MESSAGE;
                        int index = commitSubject.indexOf(32);
                        if (index != -1) {
                            message = commitSubject.substring(0, index + 1) + LiferayOSGiDefaultsPlugin._CACHE_COMMIT_MESSAGE;
                        }
                        execSpec.setCommandLine(new Object[]{"git", "commit", "-m", message});
                    }
                });
            }
        });
        task.setDescription("Installs and commits the project to the local Gradle cache for testing.");
        task.setGroup("upload");
        return task;
    }

    private Copy _addTaskCopyLibs(Project project) {
        Copy copy = (Copy)GradleUtil.addTask((Project)project, (String)COPY_LIBS_TASK_NAME, Copy.class);
        File libDir = this._getLibDir(project);
        copy.eachFile((Action)new ExcludeExistingFileAction(libDir));
        Configuration configuration = GradleUtil.getConfiguration((Project)project, (String)"runtime");
        copy.from(new Object[]{configuration});
        copy.into((Object)libDir);
        copy.rename((Closure)new RenameDependencyClosure(project, new String[]{configuration.getName()}));
        copy.setEnabled(false);
        Task classesTask = GradleUtil.getTask((Project)project, (String)"classes");
        classesTask.dependsOn(new Object[]{copy});
        return copy;
    }

    private Copy _addTaskDeployDependencies(Project project, final LiferayExtension liferayExtension) {
        final Copy copy = (Copy)GradleUtil.addTask((Project)project, (String)DEPLOY_DEPENDENCIES_TASK_NAME, Copy.class);
        final boolean keepVersions = Boolean.getBoolean("deploy.dependencies.keep.versions");
        GradleUtil.setProperty((ExtensionAware)copy, (String)"autoClean", (Object)false);
        GradleUtil.setProperty((ExtensionAware)copy, (String)"keepVersions", (Object)keepVersions);
        String renameSuffix = ".jar";
        if (keepVersions) {
            renameSuffix = "-$1.jar";
        }
        GradleUtil.setProperty((ExtensionAware)copy, (String)"renameSuffix", (Object)renameSuffix);
        copy.into((Object)new Callable<File>(){

            @Override
            public File call() throws Exception {
                return liferayExtension.getDeployDir();
            }
        });
        copy.setDescription("Deploys additional dependencies.");
        TaskOutputsInternal taskOutputs = copy.getOutputs();
        taskOutputs.upToDateWhen((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                return false;
            }
        });
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                copy.eachFile((Action)new RenameDependencyAction(keepVersions));
            }
        });
        return copy;
    }

    private Copy _addTaskDownloadCompiledJSP(JavaCompile compileJSPTask, Properties artifactProperties) {
        final String artifactJspcURL = artifactProperties.getProperty("artifact.jspc.url");
        if (Validator.isNull((String)artifactJspcURL)) {
            return null;
        }
        final Project project = compileJSPTask.getProject();
        Copy copy = (Copy)GradleUtil.addTask((Project)project, (String)DOWNLOAD_COMPILED_JSP_TASK_NAME, Copy.class);
        copy.exclude(new String[]{"META-INF/MANIFEST.MF"});
        copy.from(new Object[]{new Callable<FileTree>(){

            @Override
            public FileTree call() throws Exception {
                File file = FileUtil.get((Project)project, (String)artifactJspcURL);
                return project.zipTree((Object)file);
            }
        }});
        copy.setDescription("Downloads the latest compiled JSP classes for this project.");
        copy.setDestinationDir(compileJSPTask.getDestinationDir());
        copy.setIncludeEmptyDirs(false);
        return copy;
    }

    private InstallCacheTask _addTaskInstallCache(final Project project) {
        InstallCacheTask installCacheTask = (InstallCacheTask)GradleUtil.addTask((Project)project, (String)INSTALL_CACHE_TASK_NAME, InstallCacheTask.class);
        installCacheTask.dependsOn(new Object[]{"clean" + StringUtil.capitalize((String)installCacheTask.getName()), "install"});
        installCacheTask.doFirst((Action)new Action<Task>(){

            public void execute(Task task) {
                String result = GitUtil.getGitResult(task.getProject(), "status", "--porcelain", ".");
                if (Validator.isNotNull((String)result)) {
                    throw new GradleException("Unable to install project to the local Gradle cache, commit changes first");
                }
            }
        });
        installCacheTask.setArtifactGroup(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return project.getGroup();
            }
        });
        installCacheTask.setArtifactName(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return GradleUtil.getArchivesBaseName(project);
            }
        });
        installCacheTask.setArtifactVersion(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return project.getVersion();
            }
        });
        installCacheTask.setDescription("Installs the project to the local Gradle cache for testing.");
        installCacheTask.setGroup("upload");
        GradleUtil.setProperty((ExtensionAware)installCacheTask, (String)"autoClean", (Object)false);
        return installCacheTask;
    }

    private Jar _addTaskJarJavadoc(Project project) {
        Jar jar = (Jar)GradleUtil.addTask((Project)project, (String)JAR_JAVADOC_TASK_NAME, Jar.class);
        jar.setClassifier("javadoc");
        jar.setDescription("Assembles a jar archive containing the Javadoc files for this project.");
        jar.setGroup("build");
        Javadoc javadoc = (Javadoc)GradleUtil.getTask((Project)project, (String)"javadoc");
        jar.from(new Object[]{javadoc});
        return jar;
    }

    private Jar _addTaskJarJSP(Project project) {
        Jar jar = (Jar)GradleUtil.addTask((Project)project, (String)JAR_JSP_TASK_NAME, Jar.class);
        jar.setClassifier("jspc");
        jar.setDescription("Assembles a jar archive containing the compiled JSP classes for this project.");
        jar.setGroup("build");
        jar.setIncludeEmptyDirs(false);
        JavaCompile javaCompile = (JavaCompile)GradleUtil.getTask((Project)project, (String)"compileJSP");
        jar.from(new Object[]{javaCompile});
        return jar;
    }

    private Jar _addTaskJarSources(Project project, boolean testProject) {
        Jar jar = (Jar)GradleUtil.addTask((Project)project, (String)JAR_SOURCES_TASK_NAME, Jar.class);
        jar.setClassifier("sources");
        jar.setGroup("build");
        jar.setDescription("Assembles a jar archive containing the main source files.");
        jar.setDuplicatesStrategy(DuplicatesStrategy.EXCLUDE);
        File docrootDir = project.file((Object)"docroot");
        if (docrootDir.exists()) {
            jar.from(new Object[]{docrootDir});
        } else {
            SourceSet sourceSet = GradleUtil.getSourceSet((Project)project, (String)"main");
            jar.from(new Object[]{sourceSet.getAllSource()});
            if (testProject) {
                sourceSet = GradleUtil.getSourceSet((Project)project, (String)"test");
                jar.from(new Object[]{sourceSet.getAllSource()});
                sourceSet = GradleUtil.getSourceSet((Project)project, (String)"testIntegration");
                jar.from(new Object[]{sourceSet.getAllSource()});
            }
        }
        return jar;
    }

    private Jar _addTaskJarTLDDoc(Project project) {
        Jar jar = (Jar)GradleUtil.addTask((Project)project, (String)JAR_TLDDOC_TASK_NAME, Jar.class);
        jar.setClassifier("taglibdoc");
        jar.setDescription("Assembles a jar archive containing the Tag Library Documentation files for this project.");
        jar.setGroup("build");
        TLDDocTask tlddocTask = (TLDDocTask)GradleUtil.getTask((Project)project, (String)"tlddoc");
        jar.from(new Object[]{tlddocTask});
        return jar;
    }

    private ReplaceRegexTask _addTaskSyncVersions(final Project project) {
        ReplaceRegexTask replaceRegexTask = (ReplaceRegexTask)GradleUtil.addTask((Project)project, (String)SYNC_VERSIONS_TASK_NAME, ReplaceRegexTask.class);
        this._configureTaskReplaceRegexJSMatches(replaceRegexTask);
        replaceRegexTask.setDescription("Updates the version in additional project files based on the current Bundle-Version.");
        if (!FileUtil.exists((Project)project, (String)"bnd.bnd")) {
            replaceRegexTask.setEnabled(false);
        }
        replaceRegexTask.setReplacement(new Callable<String>(){

            @Override
            public String call() throws Exception {
                File bndFile = project.file((Object)"bnd.bnd");
                Properties properties = GUtil.loadProperties((File)bndFile);
                return properties.getProperty("Bundle-Version");
            }
        });
        return replaceRegexTask;
    }

    private ReplaceRegexTask _addTaskUpdateFileVersions(final Project project, final GitRepo gitRepo) {
        ReplaceRegexTask replaceRegexTask = (ReplaceRegexTask)GradleUtil.addTask((Project)project, (String)UPDATE_FILE_VERSIONS_TASK_NAME, ReplaceRegexTask.class);
        replaceRegexTask.pre(new Closure<String>((Object)project){

            public String doCall(String content, File file) {
                String fileName = file.getName();
                if (!fileName.equals("build.gradle")) {
                    return content;
                }
                String configuration = ProvidedBasePlugin.getPROVIDED_CONFIGURATION_NAME() + " ";
                return content.replaceAll(Pattern.quote(configuration + LiferayOSGiDefaultsPlugin.this._getProjectDependency(project)), Matcher.quoteReplacement(configuration + LiferayOSGiDefaultsPlugin.this._getModuleDependency(project, true)));
            }
        });
        replaceRegexTask.replaceOnlyIf(new Closure<Boolean>((Object)project){

            public Boolean doCall(String group, String replacement, String content, File contentFile) {
                GitRepo contentGitRepo = LiferayOSGiDefaultsPlugin.this._getGitRepo(contentFile.getParentFile());
                if (contentGitRepo != null && contentGitRepo.readOnly && (gitRepo == null || !contentGitRepo.dir.equals(gitRepo.dir))) {
                    return false;
                }
                String projectPath = project.getPath();
                if (!(projectPath.startsWith(":apps:") || projectPath.startsWith(":core:") || projectPath.startsWith(":private:") || gitRepo != null)) {
                    return true;
                }
                Version groupVersion = LiferayOSGiDefaultsPlugin.this._getVersion(group);
                Version replacementVersion = LiferayOSGiDefaultsPlugin.this._getVersion(replacement);
                if (groupVersion == null || replacementVersion == null || groupVersion.getMajor() != replacementVersion.getMajor()) {
                    return true;
                }
                return false;
            }
        });
        replaceRegexTask.setDescription("Updates the project version in external files.");
        replaceRegexTask.setReplacement(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return project.getVersion();
            }
        });
        return replaceRegexTask;
    }

    private ReplaceRegexTask _addTaskUpdateVersion(Project project) {
        ReplaceRegexTask replaceRegexTask = (ReplaceRegexTask)GradleUtil.addTask((Project)project, (String)"updateVersion", ReplaceRegexTask.class);
        this._configureTaskReplaceRegexJSMatches(replaceRegexTask);
        replaceRegexTask.match(_BUNDLE_VERSION_REGEX, "bnd.bnd");
        replaceRegexTask.onlyIf((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                Project project = task.getProject();
                String version = String.valueOf(project.getVersion());
                return !version.contains("LIFERAY-PATCHED-");
            }
        });
        replaceRegexTask.setDescription("Updates the project version in the Bundle-Version header.");
        replaceRegexTask.setReplacement((Object)IncrementVersionClosure.MICRO_INCREMENT);
        return replaceRegexTask;
    }

    private void _applyConfigScripts(Project project) {
        GradleUtil.applyScript((Project)project, (String)"com/liferay/gradle/plugins/defaults/dependencies/config-maven.gradle", (Object)project);
    }

    private void _applyPlugins(Project project) {
        if (Validator.isNotNull((String)this._getBundleInstruction(project, "Main-Class"))) {
            GradleUtil.applyPlugin((Project)project, ApplicationPlugin.class);
        }
        GradleUtil.applyPlugin((Project)project, BaselinePlugin.class);
        GradleUtil.applyPlugin((Project)project, DependencyCheckerPlugin.class);
        GradleUtil.applyPlugin((Project)project, EclipsePlugin.class);
        GradleUtil.applyPlugin((Project)project, FindBugsPlugin.class);
        GradleUtil.applyPlugin((Project)project, IdeaPlugin.class);
        GradleUtil.applyPlugin((Project)project, MavenPlugin.class);
        GradleUtil.applyPlugin((Project)project, OptionalBasePlugin.class);
        GradleUtil.applyPlugin((Project)project, PmdPlugin.class);
        GradleUtil.applyPlugin((Project)project, ProvidedBasePlugin.class);
        if (FileUtil.exists((Project)project, (String)"service.xml")) {
            GradleUtil.applyPlugin((Project)project, ServiceBuilderPlugin.class);
            GradleUtil.applyPlugin((Project)project, UpgradeTableBuilderPlugin.class);
            GradleUtil.applyPlugin((Project)project, WSDDBuilderPlugin.class);
        }
        if (FileUtil.exists((Project)project, (String)"wsdl")) {
            GradleUtil.applyPlugin((Project)project, WSDLBuilderPlugin.class);
        }
        if (FileUtil.exists((Project)project, (String)"xsd")) {
            GradleUtil.applyPlugin((Project)project, XSDBuilderPlugin.class);
        }
        FindSecurityBugsPlugin.INSTANCE.apply((Object)project);
    }

    private void _applyVersionOverrideJson(Project project, String fileName) throws IOException {
        File file = project.file((Object)fileName);
        if (!file.exists()) {
            return;
        }
        Path path = file.toPath();
        _backupFilesBuildAdapter.backUp(path);
        String json = new String(Files.readAllBytes(path), StandardCharsets.UTF_8);
        Matcher matcher = _jsonVersionPattern.matcher(json);
        if (!matcher.find()) {
            return;
        }
        json = json.substring(0, matcher.start(1)) + project.getVersion() + json.substring(matcher.end(1));
        Files.write(path, json.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    private void _applyVersionOverrides(Project project, File versionOverrideFile) {
        if (versionOverrideFile == null || !versionOverrideFile.exists()) {
            return;
        }
        final Properties versionOverrides = GUtil.loadProperties((File)versionOverrideFile);
        String bundleVersion = versionOverrides.getProperty("Bundle-Version");
        if (Validator.isNotNull((String)bundleVersion)) {
            Map<String, String> bundleInstructions = this._getBundleInstructions(project);
            bundleInstructions.put("Bundle-Version", bundleVersion);
            project.setVersion((Object)bundleVersion);
            try {
                this._applyVersionOverrideJson(project, "npm-shrinkwrap.json");
                this._applyVersionOverrideJson(project, "package.json");
            }
            catch (IOException ioe) {
                throw new UncheckedIOException((Throwable)ioe);
            }
        }
        ConfigurationContainer configurationContainer = project.getConfigurations();
        Action<Configuration> action = new Action<Configuration>(){

            public void execute(Configuration configuration) {
                ResolutionStrategy resolutionStrategy = configuration.getResolutionStrategy();
                DependencySubstitutions dependencySubstitutions = resolutionStrategy.getDependencySubstitution();
                for (String key : versionOverrides.stringPropertyNames()) {
                    if (key.indexOf(47) == -1) continue;
                    String dependencyNotation = key.replace('/', ':');
                    ComponentSelector componentSelector = dependencySubstitutions.module(dependencyNotation);
                    DependencySubstitutions.Substitution substitution = dependencySubstitutions.substitute(componentSelector);
                    String value = versionOverrides.getProperty(key);
                    ComponentSelector newComponentSelector = value.indexOf(58) != -1 ? dependencySubstitutions.project(value) : dependencySubstitutions.module(dependencyNotation + ":" + value);
                    substitution.with(newComponentSelector);
                }
            }
        };
        configurationContainer.all((Action)action);
        GradleInternal gradleInternal = (GradleInternal)project.getGradle();
        ServiceRegistry serviceRegistry = gradleInternal.getServices();
        ProjectConfigurer projectConfigurer = (ProjectConfigurer)serviceRegistry.get(ProjectConfigurer.class);
        for (String key : versionOverrides.stringPropertyNames()) {
            ProjectInternal dependencyProject;
            String value;
            if (key.indexOf(47) == -1 || (value = versionOverrides.getProperty(key)).indexOf(58) == -1 || (dependencyProject = (ProjectInternal)project.findProject(value)) == null) continue;
            projectConfigurer.configure(dependencyProject);
        }
        final Copy copy = (Copy)GradleUtil.getTask((Project)project, (String)"processResources");
        copy.filesMatching("**/packageinfo", (Action)new Action<FileCopyDetails>(){

            public void execute(final FileCopyDetails fileCopyDetails) {
                fileCopyDetails.filter((Closure)new Closure<Void>((Object)copy){

                    public String doCall(String line) {
                        if (Validator.isNull((String)line)) {
                            return line;
                        }
                        String packagePath = fileCopyDetails.getPath();
                        packagePath = packagePath.substring(0, packagePath.lastIndexOf(47));
                        String versionOverride = versionOverrides.getProperty(packagePath = packagePath.replace('/', '.'));
                        if (Validator.isNotNull((String)versionOverride)) {
                            return "version " + versionOverride;
                        }
                        return line;
                    }
                });
            }
        });
    }

    private void _checkJsonVersion(Project project, String fileName) {
        File file = project.file((Object)fileName);
        if (!file.exists()) {
            return;
        }
        JsonSlurper jsonSlurper = new JsonSlurper();
        Map map = (Map)jsonSlurper.parse(file);
        String jsonVersion = (String)map.get("version");
        if (Validator.isNotNull((String)jsonVersion) && !jsonVersion.equals(String.valueOf(project.getVersion()))) {
            throw new GradleException("Version in " + fileName + " must match project version");
        }
    }

    private void _checkVersion(Project project) {
        this._checkJsonVersion(project, "npm-shrinkwrap.json");
        this._checkJsonVersion(project, "package.json");
    }

    private void _configureArtifacts(Project project, Jar jarJSPTask, Jar jarJavadocTask, Jar jarSourcesTask, Jar jarTLDDocTask) {
        BuildWSDDTask buildWSDDTask;
        Task tlddocTask;
        Task javadocTask;
        Object spec;
        ArtifactHandler artifactHandler = project.getArtifacts();
        SourceSet sourceSet = GradleUtil.getSourceSet((Project)project, (String)"main");
        SourceDirectorySet resourcesFileCollection = sourceSet.getResources();
        FileCollection jspFileCollection = resourcesFileCollection.filter((Spec)new Spec<File>(){

            public boolean isSatisfiedBy(File file) {
                String fileName = file.getName();
                return fileName.endsWith(".jsp") || fileName.endsWith(".jspf");
            }
        });
        if (!jspFileCollection.isEmpty()) {
            artifactHandler.add("archives", (Object)jarJSPTask);
        }
        if (FileUtil.hasSourceFiles((Task)jarSourcesTask, spec = new Spec<File>(){

            public boolean isSatisfiedBy(File file) {
                String fileName = file.getName();
                return !fileName.equals("MANIFEST.MF");
            }
        })) {
            artifactHandler.add("archives", (Object)jarSourcesTask);
        }
        if (FileUtil.hasSourceFiles(javadocTask = GradleUtil.getTask((Project)project, (String)"javadoc"), spec = new Spec<File>(){

            public boolean isSatisfiedBy(File file) {
                String fileName = file.getName();
                return fileName.endsWith(".java");
            }
        })) {
            artifactHandler.add("archives", (Object)jarJavadocTask);
        }
        if (FileUtil.hasSourceFiles(tlddocTask = GradleUtil.getTask((Project)project, (String)"tlddoc"), spec = new Spec<File>(){

            public boolean isSatisfiedBy(File file) {
                String fileName = file.getName();
                return fileName.endsWith(".tld");
            }
        })) {
            artifactHandler.add("archives", (Object)jarTLDDocTask);
        }
        if (GradleUtil.hasPlugin(project, WSDDBuilderPlugin.class) && (buildWSDDTask = (BuildWSDDTask)GradleUtil.getTask((Project)project, (String)"buildWSDD")).getEnabled()) {
            Task buildWSDDJarTask = GradleUtil.getTask((Project)project, (String)(buildWSDDTask.getName() + "Jar"));
            artifactHandler.add("archives", (Object)buildWSDDJarTask, (Closure)new Closure<Void>((Object)project){

                public void doCall(ArchivePublishArtifact archivePublishArtifact) {
                    archivePublishArtifact.setClassifier("wsdd");
                }
            });
        }
    }

    private void _configureBasePlugin(Project project, File portalRootDir) {
        if (portalRootDir == null) {
            return;
        }
        BasePluginConvention basePluginConvention = (BasePluginConvention)GradleUtil.getConvention((Project)project, BasePluginConvention.class);
        File dir = new File(portalRootDir, "tools/sdk/dist");
        String dirName = FileUtil.relativize((File)dir, (File)project.getBuildDir());
        basePluginConvention.setDistsDirName(dirName);
        basePluginConvention.setLibsDirName(dirName);
    }

    private void _configureBundleDefaultInstructions(Project project, File portalRootDir, boolean publishing) {
        File packageJsonFile;
        File appBndFile;
        LiferayOSGiExtension liferayOSGiExtension = (LiferayOSGiExtension)GradleUtil.getExtension((ExtensionAware)project, LiferayOSGiExtension.class);
        HashMap<String, String> bundleDefaultInstructions = new HashMap<String, String>();
        bundleDefaultInstructions.put("Bundle-Vendor", "Liferay, Inc.");
        bundleDefaultInstructions.put("-donotcopy", "(.*\\.wsdd|.touch)");
        bundleDefaultInstructions.put("-fixupmessages.deprecated", "annotations are deprecated");
        bundleDefaultInstructions.put("-sources", "false");
        if (publishing) {
            bundleDefaultInstructions.put("Git-Descriptor", "${system-allow-fail;git describe --dirty --always}");
            bundleDefaultInstructions.put("Git-SHA", "${system-allow-fail;git rev-list -1 HEAD}");
        }
        if ((appBndFile = this._getAppBndFile(project, portalRootDir)) != null) {
            bundleDefaultInstructions.put("-include", FileUtil.getRelativePath(project, appBndFile));
        }
        if ((packageJsonFile = project.file((Object)"package.json")).exists()) {
            bundleDefaultInstructions.put("-includeresource.packagejson", FileUtil.getRelativePath(project, packageJsonFile));
        }
        liferayOSGiExtension.bundleDefaultInstructions(bundleDefaultInstructions);
    }

    private void _configureBundleInstructions(Project project, GitRepo gitRepo) {
        String exportPackage;
        Map<String, String> bundleInstructions = this._getBundleInstructions(project);
        String projectPath = project.getPath();
        if ((projectPath.startsWith(":apps:") || projectPath.startsWith(":private:") || gitRepo != null) && Validator.isNotNull((String)(exportPackage = bundleInstructions.get("Export-Package")))) {
            exportPackage = "!com.liferay.*.kernel.*," + exportPackage;
            bundleInstructions.put("Export-Package", exportPackage);
        }
        if (!bundleInstructions.containsKey("-exportcontents") && !bundleInstructions.containsKey("-check")) {
            bundleInstructions.put("-check", "exports");
        }
    }

    private void _configureConfiguration(Configuration configuration) {
        DependencySet dependencySet = configuration.getDependencies();
        dependencySet.withType(ExternalDependency.class, (Action)new Action<ExternalDependency>(){

            public void execute(ExternalDependency externalDependency) {
                String version = externalDependency.getVersion();
                if (version.endsWith("-SNAPSHOT")) {
                    throw new GradleException("Please use a timestamp version for " + externalDependency);
                }
            }
        });
        dependencySet.withType(ModuleDependency.class, (Action)new Action<ModuleDependency>(){

            public void execute(ModuleDependency moduleDependency) {
                String name = moduleDependency.getName();
                if (name.equals("com.liferay.arquillian.arquillian-container-liferay") || name.equals("com.liferay.arquillian.extension.junit.bridge")) {
                    moduleDependency.exclude(Collections.singletonMap("group", LiferayOSGiDefaultsPlugin._GROUP_PORTAL));
                }
            }
        });
    }

    private void _configureConfigurationDefault(Project project) {
        final Configuration defaultConfiguration = GradleUtil.getConfiguration((Project)project, (String)"default");
        Configuration providedConfiguration = GradleUtil.getConfiguration((Project)project, (String)ProvidedBasePlugin.getPROVIDED_CONFIGURATION_NAME());
        DependencySet dependencySet = providedConfiguration.getDependencies();
        dependencySet.withType(ProjectDependency.class, (Action)new Action<ProjectDependency>(){

            public void execute(ProjectDependency projectDependency) {
                defaultConfiguration.exclude(Collections.singletonMap("module", projectDependency.getName()));
            }
        });
    }

    private void _configureConfigurationJspC(final Project project, final LiferayExtension liferayExtension) {
        final Logger logger = project.getLogger();
        final boolean compilingJSP = GradleUtil.hasStartParameterTask(project, "compileJSP");
        GradleInternal gradleInternal = (GradleInternal)project.getGradle();
        ServiceRegistry serviceRegistry = gradleInternal.getServices();
        final ProjectConfigurer projectConfigurer = (ProjectConfigurer)serviceRegistry.get(ProjectConfigurer.class);
        final Configuration configuration = GradleUtil.getConfiguration((Project)project, (String)"jspC");
        DependencySet dependencySet = configuration.getAllDependencies();
        dependencySet.withType(ExternalModuleDependency.class, (Action)new Action<ExternalModuleDependency>(){

            public void execute(ExternalModuleDependency externalModuleDependency) {
                String name;
                String group = externalModuleDependency.getGroup();
                if (LiferayOSGiDefaultsPlugin.this._isTaglibDependency(group, name = externalModuleDependency.getName())) {
                    String projectName = name.substring(12);
                    projectName = projectName.replace('.', '-');
                    Project taglibProject = GradleUtil.getProject(project.getRootProject(), projectName);
                    if (taglibProject != null) {
                        LogLevel logLevel = LogLevel.INFO;
                        if (compilingJSP) {
                            logLevel = LogLevel.LIFECYCLE;
                        }
                        logger.log(logLevel, "Compiling JSP files of {} with {} as dependency in place of '{}:{}:{}'", new Object[]{project, taglibProject, group, name, externalModuleDependency.getVersion()});
                        projectConfigurer.configure((ProjectInternal)taglibProject);
                        GradleUtil.substituteModuleDependencyWithProject(configuration, (ModuleVersionSelector)externalModuleDependency, taglibProject);
                    } else {
                        HashMap<String, String> args = new HashMap<String, String>();
                        args.put("group", group);
                        args.put("module", name);
                        configuration.exclude(args);
                    }
                } else if (LiferayOSGiDefaultsPlugin.this._isUtilTaglibDependency(group, name)) {
                    HashMap<String, String> args = new HashMap<String, String>();
                    args.put("group", group);
                    args.put("module", name);
                    configuration.exclude(args);
                }
            }
        });
        ResolvableDependencies resolvableDependencies = configuration.getIncoming();
        Action<ResolvableDependencies> action = new Action<ResolvableDependencies>(){

            public void execute(ResolvableDependencies resolvableDependencies) {
                for (ExcludeRule excludeRule : configuration.getExcludeRules()) {
                    File file;
                    String name;
                    String group = excludeRule.getGroup();
                    if (LiferayOSGiDefaultsPlugin.this._isTaglibDependency(group, name = excludeRule.getModule())) {
                        File dir = new File(liferayExtension.getLiferayHome(), "osgi");
                        String fileName = name + ".jar";
                        try {
                            file = FileUtil.findFile(dir, fileName);
                        }
                        catch (IOException ioe) {
                            throw new UncheckedIOException((Throwable)ioe);
                        }
                        if (file == null) {
                            throw new GradleException("Unable to find " + fileName + " in " + dir);
                        }
                    } else if (LiferayOSGiDefaultsPlugin.this._isUtilTaglibDependency(group, name)) {
                        file = new File(liferayExtension.getAppServerPortalDir(), "WEB-INF/lib/util-taglib.jar");
                        if (!file.exists()) {
                            throw new GradleException("Unable to find " + file);
                        }
                    } else {
                        return;
                    }
                    if (logger.isLifecycleEnabled()) {
                        logger.lifecycle("Compiling JSP files of {} with {} as dependency in place of '{}:{}'", new Object[]{project, file.getAbsolutePath(), group, name});
                    }
                    GradleUtil.addDependency((Project)project, (String)configuration.getName(), (File)file);
                }
            }
        };
        resolvableDependencies.beforeResolve((Action)action);
    }

    private void _configureConfigurationNoCache(Configuration configuration) {
        ResolutionStrategy resolutionStrategy = configuration.getResolutionStrategy();
        resolutionStrategy.cacheChangingModulesFor(0, TimeUnit.SECONDS);
        resolutionStrategy.cacheDynamicVersionsFor(0, TimeUnit.SECONDS);
    }

    private void _configureConfigurations(Project project, GitRepo gitRepo, LiferayExtension liferayExtension) {
        this._configureConfigurationDefault(project);
        this._configureConfigurationJspC(project, liferayExtension);
        String projectPath = project.getPath();
        if (projectPath.startsWith(":apps:") || projectPath.startsWith(":core:") || projectPath.startsWith(":private:apps:") || projectPath.startsWith(":private:core:") || gitRepo != null) {
            this._configureConfigurationTransitive(project, "compile", false);
            this._configureConfigurationTransitive(project, "compileClasspath", false);
        }
        this._configureDependenciesTransitive(project, "compileInclude", false);
        ConfigurationContainer configurationContainer = project.getConfigurations();
        configurationContainer.all((Action)new Action<Configuration>(){

            public void execute(Configuration configuration) {
                LiferayOSGiDefaultsPlugin.this._configureConfiguration(configuration);
            }
        });
    }

    private void _configureConfigurationTransitive(Project project, String name, boolean transitive) {
        Configuration configuration = GradleUtil.getConfiguration((Project)project, (String)name);
        configuration.setTransitive(transitive);
    }

    private void _configureDependenciesTransitive(Project project, String configurationName, final boolean transitive) {
        Configuration configuration = GradleUtil.getConfiguration((Project)project, (String)configurationName);
        DependencySet dependencySet = configuration.getAllDependencies();
        dependencySet.withType(ModuleDependency.class, (Action)new Action<ModuleDependency>(){

            public void execute(ModuleDependency moduleDependency) {
                moduleDependency.setTransitive(transitive);
            }
        });
    }

    private void _configureDependencyChecker(Project project) {
        DependencyCheckerExtension dependencyCheckerExtension = (DependencyCheckerExtension)GradleUtil.getExtension((ExtensionAware)project, DependencyCheckerExtension.class);
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("configuration", "sourceFormatter");
        args.put("group", _GROUP);
        args.put("maxAge", _PORTAL_TOOL_MAX_AGE);
        args.put("name", _SOURCE_FORMATTER_PORTAL_TOOL_NAME);
        args.put("throwError", Boolean.TRUE);
        dependencyCheckerExtension.maxAge(args);
    }

    private void _configureDeployDir(final Project project, final LiferayExtension liferayExtension, final boolean deployToAppServerLibs, final boolean deployToTools) {
        liferayExtension.setDeployDir((Object)new Callable<File>(){

            @Override
            public File call() throws Exception {
                if (deployToAppServerLibs) {
                    return new File(liferayExtension.getAppServerPortalDir(), "WEB-INF/lib");
                }
                if (deployToTools) {
                    return new File(liferayExtension.getLiferayHome(), "tools/" + project.getName());
                }
                if (FileUtil.exists((Project)project, (String)".lfrbuild-static")) {
                    return new File(liferayExtension.getLiferayHome(), "osgi/static");
                }
                String archivesBaseName = GradleUtil.getArchivesBaseName(project);
                if (archivesBaseName.startsWith("com.liferay.portal.")) {
                    return new File(liferayExtension.getLiferayHome(), "osgi/portal");
                }
                return new File(liferayExtension.getLiferayHome(), "osgi/modules");
            }
        });
    }

    private void _configureEclipse(Project project) {
        EclipseModel eclipseModel = (EclipseModel)GradleUtil.getExtension((ExtensionAware)project, EclipseModel.class);
        EclipseClasspath eclipseClasspath = eclipseModel.getClasspath();
        XmlFileContentMerger xmlFileContentMerger = eclipseClasspath.getFile();
        xmlFileContentMerger.whenMerged((Closure)new Closure<Void>((Object)project){

            public void doCall(Classpath classpath) {
                for (ClasspathEntry classpathEntry : classpath.getEntries()) {
                    SourceFolder sourceFolder;
                    File archetypeResourcesDir;
                    if (!(classpathEntry instanceof SourceFolder) || !(archetypeResourcesDir = new File((sourceFolder = (SourceFolder)classpathEntry).getDir(), "archetype-resources")).isDirectory()) continue;
                    List excludes = sourceFolder.getExcludes();
                    excludes.add("**/*.java");
                }
            }
        });
    }

    private void _configureEclipse(Project project, Configuration portalTestConfiguration) {
        EclipseModel eclipseModel = (EclipseModel)GradleUtil.getExtension((ExtensionAware)project, EclipseModel.class);
        EclipseClasspath eclipseClasspath = eclipseModel.getClasspath();
        Collection plusConfigurations = eclipseClasspath.getPlusConfigurations();
        plusConfigurations.add(portalTestConfiguration);
    }

    private void _configureIdea(Project project, Configuration portalTestConfiguration) {
        IdeaModel ideaModel = (IdeaModel)GradleUtil.getExtension((ExtensionAware)project, IdeaModel.class);
        IdeaModule ideaModule = ideaModel.getModule();
        Map scopes = ideaModule.getScopes();
        Map testScope = (Map)scopes.get("TEST");
        Collection plusConfigurations = (Collection)testScope.get("plus");
        plusConfigurations.add(portalTestConfiguration);
    }

    private void _configureJavaPlugin(Project project) {
        JavaPluginConvention javaPluginConvention = (JavaPluginConvention)GradleUtil.getConvention((Project)project, JavaPluginConvention.class);
        javaPluginConvention.setSourceCompatibility((Object)_JAVA_VERSION);
        javaPluginConvention.setTargetCompatibility((Object)_JAVA_VERSION);
        File testResultsDir = project.file((Object)"test-results/unit");
        javaPluginConvention.setTestResultsDirName(FileUtil.relativize((File)testResultsDir, (File)project.getBuildDir()));
    }

    private void _configureLocalPortalTool(Project project, File portalRootDir, String configurationName, String portalToolName) {
        if (portalRootDir == null || GradleUtil.getProperty((ExtensionAware)project, (String)(portalToolName + ".ignore.local"), (boolean)true)) {
            return;
        }
        File dir = new File(portalRootDir, "tools/sdk/dependencies/" + portalToolName + "/lib");
        if (!dir.exists()) {
            Logger logger = project.getLogger();
            if (logger.isWarnEnabled()) {
                logger.warn("Unable to find {}, using default version of {}", (Object)dir, (Object)portalToolName);
            }
            return;
        }
        Configuration configuration = GradleUtil.getConfiguration((Project)project, (String)configurationName);
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("group", _GROUP);
        args.put("module", portalToolName);
        configuration.exclude(args);
        FileTree fileTree = FileUtil.getJarsFileTree(project, dir, new String[0]);
        GradleUtil.addDependency((Project)project, (String)configuration.getName(), (FileCollection)fileTree);
    }

    private void _configureMavenConf2ScopeMappings(Project project) {
        MavenPluginConvention mavenPluginConvention = (MavenPluginConvention)GradleUtil.getConvention((Project)project, MavenPluginConvention.class);
        Conf2ScopeMappingContainer conf2ScopeMappingContainer = mavenPluginConvention.getConf2ScopeMappings();
        Map mappings = conf2ScopeMappingContainer.getMappings();
        Configuration configuration = GradleUtil.getConfiguration((Project)project, (String)"testCompile");
        mappings.remove(configuration);
        configuration = GradleUtil.getConfiguration((Project)project, (String)"testRuntime");
        mappings.remove(configuration);
    }

    private void _configurePmd(Project project) {
        PmdExtension pmdExtension = (PmdExtension)GradleUtil.getExtension((ExtensionAware)project, PmdExtension.class);
        Gradle gradle = project.getGradle();
        File ruleSetFile = new File(gradle.getGradleUserHomeDir(), "../tools/sdk/dependencies/net.sourceforge.pmd/rulesets/java/standard-rules.xml");
        if (ruleSetFile.exists()) {
            pmdExtension.setRuleSetFiles((FileCollection)project.files(new Object[]{ruleSetFile}));
        }
        List ruleSets = Collections.emptyList();
        pmdExtension.setRuleSets(ruleSets);
    }

    private void _configureProject(Project project) {
        String group = GradleUtil.getGradlePropertiesValue(project, "project.group", _GROUP);
        project.setGroup((Object)group);
    }

    private void _configureProjectBndProperties(Project project, LiferayExtension liferayExtension) {
        File appServerPortalDir = liferayExtension.getAppServerPortalDir();
        GradleUtil.setProperty((ExtensionAware)project, (String)"app.server.portal.dir", (Object)project.relativePath((Object)appServerPortalDir));
        File appServerLibPortalDir = new File(appServerPortalDir, "WEB-INF/lib");
        GradleUtil.setProperty((ExtensionAware)project, (String)"app.server.lib.portal.dir", (Object)project.relativePath((Object)appServerLibPortalDir));
    }

    private void _configureSourceSetClassesDir(Project project, SourceSet sourceSet, String classesDirName) {
        SourceSetOutput sourceSetOutput = sourceSet.getOutput();
        if (FileUtil.isChild((File)sourceSetOutput.getClassesDir(), (File)project.getBuildDir())) {
            sourceSetOutput.setClassesDir((Object)classesDirName);
            sourceSetOutput.setResourcesDir((Object)classesDirName);
        }
    }

    private void _configureSourceSetMain(Project project) {
        SourceSet sourceSet = GradleUtil.getSourceSet((Project)project, (String)"main");
        this._configureSourceSetClassesDir(project, sourceSet, "classes");
    }

    private void _configureSourceSetTest(Project project, Configuration portalConfiguration, Configuration portalTestConfiguration) {
        SourceSet sourceSet = GradleUtil.getSourceSet((Project)project, (String)"test");
        this._configureSourceSetClassesDir(project, sourceSet, "test-classes/unit");
        Configuration compileClasspathConfiguration = GradleUtil.getConfiguration((Project)project, (String)"compileClasspath");
        sourceSet.setCompileClasspath(FileUtil.join(new FileCollection[]{compileClasspathConfiguration, portalConfiguration, sourceSet.getCompileClasspath(), portalTestConfiguration}));
        sourceSet.setRuntimeClasspath(FileUtil.join(new FileCollection[]{compileClasspathConfiguration, portalConfiguration, sourceSet.getRuntimeClasspath(), portalTestConfiguration}));
    }

    private void _configureSourceSetTestIntegration(Project project, Configuration portalConfiguration, Configuration portalTestConfiguration) {
        SourceSet sourceSet = GradleUtil.getSourceSet((Project)project, (String)"testIntegration");
        this._configureSourceSetClassesDir(project, sourceSet, "test-classes/integration");
        sourceSet.setCompileClasspath(FileUtil.join(new FileCollection[]{portalConfiguration, sourceSet.getCompileClasspath(), portalTestConfiguration}));
        sourceSet.setRuntimeClasspath(FileUtil.join(new FileCollection[]{portalConfiguration, sourceSet.getRuntimeClasspath(), portalTestConfiguration}));
    }

    private void _configureTaskBaseline(BaselineTask baselineTask) {
        Project project = baselineTask.getProject();
        String reportLevel = GradleUtil.getProperty((ExtensionAware)project, (String)"baseline.jar.report.level", (String)"standard");
        boolean reportLevelIsDiff = reportLevel.equals("diff");
        boolean reportLevelIsPersist = reportLevel.equals("persist");
        if (reportLevelIsPersist && FileUtil.exists((Project)project, (String)"bnd.bnd")) {
            baselineTask.setBndFile((Object)"bnd.bnd");
        }
        boolean reportDiff = false;
        if (reportLevelIsDiff || reportLevelIsPersist) {
            reportDiff = true;
        }
        baselineTask.setReportDiff(reportDiff);
        boolean reportOnlyDirtyPackages = GradleUtil.getProperty((ExtensionAware)project, (String)"baseline.jar.report.only.dirty.packages", (boolean)true);
        baselineTask.setReportOnlyDirtyPackages(reportOnlyDirtyPackages);
    }

    private void _configureTaskBaselineSyncReleaseVersions(Task task, final File versionOverrideFile) {
        Action<Task> action = new Action<Task>(){

            public void execute(Task task) {
                try {
                    this._execute(task.getProject());
                }
                catch (IOException ioe) {
                    throw new UncheckedIOException((Throwable)ioe);
                }
            }

            private void _execute(Project project) throws IOException {
                boolean hasPackageInfoFiles = this._hasPackageInfoFiles(project);
                if (versionOverrideFile != null) {
                    Properties versions = LiferayOSGiDefaultsPlugin.this._getVersions(project.getProjectDir(), null);
                    if (hasPackageInfoFiles) {
                        GitUtil.executeGit(project, "checkout", "--", "bnd.bnd", "**/packageinfo");
                    } else {
                        GitUtil.executeGit(project, "checkout", "--", "bnd.bnd");
                    }
                    Properties committedVersions = LiferayOSGiDefaultsPlugin.this._getVersions(project.getProjectDir(), null);
                    this._removeDuplicates(versions, committedVersions);
                    if (versionOverrideFile.exists()) {
                        Properties versionOverrides = GUtil.loadProperties((File)versionOverrideFile);
                        for (String key : versionOverrides.stringPropertyNames()) {
                            if (key.indexOf(47) == -1) continue;
                            versions.setProperty(key, versionOverrides.getProperty(key));
                        }
                    }
                    boolean addVersionOverrideFile = false;
                    String versionOverrideRelativePath = project.relativePath((Object)versionOverrideFile);
                    String gitResult = GitUtil.getGitResult(project, "ls-files", versionOverrideRelativePath);
                    if (Validator.isNotNull((String)gitResult)) {
                        addVersionOverrideFile = true;
                    }
                    LiferayOSGiDefaultsPlugin.this._saveVersions(project.getProjectDir(), versions, versionOverrideFile);
                    if (versionOverrideFile.exists()) {
                        addVersionOverrideFile = true;
                    }
                    if (addVersionOverrideFile) {
                        GitUtil.executeGit(project, "add", versionOverrideRelativePath);
                    }
                } else if (hasPackageInfoFiles) {
                    GitUtil.executeGit(project, "add", "bnd.bnd", "**/packageinfo");
                } else {
                    GitUtil.executeGit(project, "add", "bnd.bnd");
                }
                String message = project.getName() + " packageinfo";
                GitUtil.commit(project, message, true);
            }

            private boolean _hasPackageInfoFiles(Project project) {
                HashMap<String, Object> args = new HashMap<String, Object>();
                args.put("dir", project.getProjectDir());
                args.put("include", "src/main/resources/**/packageinfo");
                ConfigurableFileTree fileTree = project.fileTree(args);
                return !fileTree.isEmpty();
            }

            private void _removeDuplicates(Properties properties, Properties otherProperties) {
                Set<Map.Entry<Object, Object>> entrySet = properties.entrySet();
                Iterator<Map.Entry<Object, Object>> iterator = entrySet.iterator();
                while (iterator.hasNext()) {
                    Map.Entry<Object, Object> entry = iterator.next();
                    String key = (String)entry.getKey();
                    if (!Objects.equals(entry.getValue(), otherProperties.getProperty(key))) continue;
                    iterator.remove();
                }
            }
        };
        task.doLast((Action)action);
        if (task instanceof VerificationTask) {
            VerificationTask verificationTask = (VerificationTask)task;
            verificationTask.setIgnoreFailures(true);
        }
    }

    private void _configureTaskBuildService(Project project) {
        BuildServiceTask buildServiceTask = (BuildServiceTask)GradleUtil.getTask((Project)project, (String)"buildService");
        buildServiceTask.setBuildNumberIncrement(false);
    }

    private void _configureTaskBuildWSDD(final Project project) {
        BuildWSDDTask buildWSDDTask = (BuildWSDDTask)GradleUtil.getTask((Project)project, (String)"buildWSDD");
        buildWSDDTask.setOutputDir((Object)new Callable<File>(){

            @Override
            public File call() throws Exception {
                File dir = new File(project.getBuildDir(), "wsdd/output");
                dir.mkdirs();
                return dir;
            }
        });
        buildWSDDTask.setServerConfigFile((Object)new Callable<File>(){

            @Override
            public File call() throws Exception {
                return new File(project.getBuildDir(), "wsdd/server-config.wsdd");
            }
        });
        boolean remoteServices = false;
        try {
            remoteServices = this._hasRemoteServices(buildWSDDTask);
        }
        catch (Exception e) {
            throw new GradleException("Unable to read " + buildWSDDTask.getInputFile(), (Throwable)e);
        }
        if (!remoteServices) {
            buildWSDDTask.setEnabled(false);
            buildWSDDTask.setFinalizedBy(Collections.emptySet());
        }
    }

    private void _configureTaskCompileJSP(Project project, LiferayExtension liferayExtension) {
        Copy copy;
        boolean jspPrecompileEnabled = GradleUtil.getProperty((ExtensionAware)project, (String)"jsp.precompile.enabled", (boolean)false);
        if (!jspPrecompileEnabled) {
            return;
        }
        JavaCompile javaCompile = (JavaCompile)GradleUtil.getTask((Project)project, (String)"compileJSP");
        Properties artifactProperties = null;
        String dirName = null;
        TaskContainer taskContainer = project.getTasks();
        WritePropertiesTask recordArtifactTask = (WritePropertiesTask)((Object)taskContainer.findByName("recordArtifact"));
        if (recordArtifactTask != null) {
            String artifactURL = null;
            File artifactPropertiesFile = recordArtifactTask.getOutputFile();
            if (artifactPropertiesFile.exists()) {
                artifactProperties = GUtil.loadProperties((File)artifactPropertiesFile);
                artifactURL = artifactProperties.getProperty("artifact.url");
            }
            if (Validator.isNotNull(artifactURL)) {
                int index = artifactURL.lastIndexOf(47);
                dirName = artifactURL.substring(index + 1, artifactURL.length() - 4);
            }
        }
        if (Validator.isNull(dirName)) {
            dirName = GradleUtil.getArchivesBaseName(project) + "-" + project.getVersion();
        }
        File dir = new File(liferayExtension.getLiferayHome(), "work/" + dirName);
        javaCompile.setDestinationDir(dir);
        boolean jspPrecompileFromSource = GradleUtil.getProperty((ExtensionAware)project, (String)"jsp.precompile.from.source", (boolean)true);
        if (!jspPrecompileFromSource && artifactProperties != null && (copy = this._addTaskDownloadCompiledJSP(javaCompile, artifactProperties)) != null) {
            javaCompile.deleteAllActions();
            javaCompile.setDependsOn(Collections.singleton(copy));
        }
    }

    private void _configureTaskDeploy(Project project, Copy deployDepenciesTask) {
        Task deployTask = GradleUtil.getTask((Project)project, (String)"deploy");
        deployTask.finalizedBy(new Object[]{deployDepenciesTask});
    }

    private void _configureTaskFindBugs(FindBugs findBugs) {
        findBugs.setMaxHeapSize("3g");
        FindBugsReports findBugsReports = findBugs.getReports();
        SingleFileReport htmlReport = findBugsReports.getHtml();
        htmlReport.setEnabled(true);
        FindBugsXmlReport xmlReport = findBugsReports.getXml();
        xmlReport.setEnabled(false);
    }

    private void _configureTaskJar(Project project, boolean testProject) {
        Jar jar = (Jar)GradleUtil.getTask((Project)project, (String)"jar");
        if (testProject) {
            jar.dependsOn(new Object[]{"testClasses"});
            SourceSet sourceSet = GradleUtil.getSourceSet((Project)project, (String)"testIntegration");
            jar.dependsOn(new Object[]{sourceSet.getClassesTaskName()});
        }
        jar.setDuplicatesStrategy(DuplicatesStrategy.EXCLUDE);
    }

    private void _configureTaskJarSources(final Jar jarSourcesTask) {
        final Project project = jarSourcesTask.getProject();
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(PatchTask.class, (Action)new Action<PatchTask>(){

            public void execute(final PatchTask patchTask) {
                jarSourcesTask.from((Object)new Callable<FileCollection>(){

                    @Override
                    public FileCollection call() throws Exception {
                        return project.zipTree((Object)patchTask.getOriginalLibSrcFile());
                    }
                }, (Closure)new Closure<Void>((Object)project){

                    public void doCall(CopySpec copySpec) {
                        String originalLibSrcDirName = patchTask.getOriginalLibSrcDirName();
                        if (originalLibSrcDirName.equals(".")) {
                            return;
                        }
                        HashMap<String, String> leadingPathReplacementsMap = new HashMap<String, String>();
                        leadingPathReplacementsMap.put(originalLibSrcDirName, "");
                        copySpec.eachFile((Action)new ReplaceLeadingPathAction(leadingPathReplacementsMap));
                        copySpec.include(new String[]{originalLibSrcDirName + "/"});
                        copySpec.setIncludeEmptyDirs(false);
                    }
                });
                jarSourcesTask.from((Object)new Callable<File>(){

                    @Override
                    public File call() throws Exception {
                        return patchTask.getPatchesDir();
                    }
                }, (Closure)new Closure<Void>((Object)project){

                    public void doCall(CopySpec copySpec) {
                        copySpec.into((Object)"META-INF/patches");
                    }
                });
            }
        });
    }

    private void _configureTaskJavaCompile(JavaCompile javaCompile) {
        CompileOptions compileOptions = javaCompile.getOptions();
        compileOptions.setEncoding(StandardCharsets.UTF_8.name());
        compileOptions.setWarnings(false);
    }

    private void _configureTaskJavadoc(Project project, File portalRootDir) {
        Javadoc javadoc = (Javadoc)GradleUtil.getTask((Project)project, (String)"javadoc");
        this._configureTaskJavadocFilter(javadoc);
        this._configureTaskJavadocOptions(javadoc, portalRootDir);
        this._configureTaskJavadocTitle(javadoc);
        JavaVersion javaVersion = JavaVersion.current();
        if (javaVersion.isJava8Compatible()) {
            CoreJavadocOptions coreJavadocOptions = (CoreJavadocOptions)javadoc.getOptions();
            coreJavadocOptions.addStringOption("Xdoclint:none", "-quiet");
        }
    }

    private void _configureTaskJavadocFilter(Javadoc javadoc) {
        String[] exportPackageArray;
        String exportPackage = this._getBundleInstruction(javadoc.getProject(), "Export-Package");
        if (Validator.isNull((String)exportPackage)) {
            javadoc.exclude(new String[]{"**/"});
            return;
        }
        for (String pattern : exportPackageArray = exportPackage.split(",")) {
            int end;
            pattern = pattern.trim();
            boolean excludePattern = false;
            int start = 0;
            if (pattern.startsWith("!")) {
                excludePattern = true;
                start = 1;
            }
            if ((end = pattern.indexOf(59)) == -1) {
                end = pattern.length();
            }
            pattern = pattern.substring(start, end);
            pattern = "**/" + pattern.replace('.', '/');
            pattern = pattern.endsWith("/*") ? pattern.substring(0, pattern.length() - 1) : pattern + "/*";
            if (excludePattern) {
                javadoc.exclude(new String[]{pattern});
                continue;
            }
            javadoc.include(new String[]{pattern});
        }
    }

    private void _configureTaskJavadocOptions(Javadoc javadoc, File portalRootDir) {
        File stylesheetFile;
        StandardJavadocDocletOptions standardJavadocDocletOptions = (StandardJavadocDocletOptions)javadoc.getOptions();
        standardJavadocDocletOptions.setEncoding(StandardCharsets.UTF_8.name());
        Project project = javadoc.getProject();
        File overviewFile = null;
        SourceSet sourceSet = GradleUtil.getSourceSet((Project)project, (String)"main");
        SourceDirectorySet sourceDirectorySet = sourceSet.getJava();
        for (File dir : sourceDirectorySet.getSrcDirs()) {
            File file = new File(dir, "overview.html");
            if (!file.exists()) continue;
            overviewFile = file;
            break;
        }
        if (overviewFile != null) {
            standardJavadocDocletOptions.setOverview(project.relativePath(overviewFile));
        }
        standardJavadocDocletOptions.tags(new String[]{"generated"});
        if (portalRootDir != null && (stylesheetFile = new File(portalRootDir, "tools/styles/javadoc.css")).exists()) {
            standardJavadocDocletOptions.setStylesheetFile(stylesheetFile);
        }
    }

    private void _configureTaskJavadocTitle(Javadoc javadoc) {
        Project project = javadoc.getProject();
        StringBuilder sb = new StringBuilder();
        sb.append("Module ");
        sb.append(GradleUtil.getArchivesBaseName(project));
        sb.append(' ');
        sb.append(project.getVersion());
        sb.append(" - ");
        String moduleName = project.getDescription();
        if (Validator.isNull((String)moduleName)) {
            moduleName = project.getName();
        }
        sb.append(moduleName);
        javadoc.setTitle(sb.toString());
    }

    private void _configureTaskPmd(Pmd pmd) {
        pmd.setClasspath(null);
    }

    private void _configureTaskPublishNodeModule(PublishNodeModuleTask publishNodeModuleTask) {
        publishNodeModuleTask.setModuleAuthor((Object)"Nathan Cavanaugh <nathan.cavanaugh@liferay.com> (https://github.com/natecavanaugh)");
        publishNodeModuleTask.setModuleBugsUrl((Object)"https://issues.liferay.com/");
        publishNodeModuleTask.setModuleLicense((Object)"LGPL");
        publishNodeModuleTask.setModuleMain((Object)"package.json");
        publishNodeModuleTask.setModuleRepository((Object)"liferay/liferay-portal");
    }

    private void _configureTaskReplaceRegexJSMatches(ReplaceRegexTask replaceRegexTask) {
        File packageJsonFile;
        Project project = replaceRegexTask.getProject();
        File npmShrinkwrapJsonFile = project.file((Object)"npm-shrinkwrap.json");
        if (npmShrinkwrapJsonFile.exists()) {
            replaceRegexTask.match(_jsonVersionPattern.pattern(), npmShrinkwrapJsonFile);
        }
        if ((packageJsonFile = project.file((Object)"package.json")).exists()) {
            replaceRegexTask.match(_jsonVersionPattern.pattern(), packageJsonFile);
        }
    }

    private void _configureTasksBaseline(Project project) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(BaselineTask.class, (Action)new Action<BaselineTask>(){

            public void execute(BaselineTask baselineTask) {
                LiferayOSGiDefaultsPlugin.this._configureTaskBaseline(baselineTask);
            }
        });
    }

    private void _configureTasksEnabledIfStaleSnapshot(Project project, boolean testProject, String ... taskNames) {
        boolean snapshotIfStale = false;
        if (project.hasProperty(SNAPSHOT_IF_STALE_PROPERTY_NAME)) {
            snapshotIfStale = GradleUtil.getProperty((ExtensionAware)project, (String)SNAPSHOT_IF_STALE_PROPERTY_NAME, (boolean)true);
        }
        if (!snapshotIfStale || !testProject && this._isSnapshotStale(project)) {
            return;
        }
        for (String taskName : taskNames) {
            Task task = GradleUtil.getTask((Project)project, (String)taskName);
            task.setDependsOn(Collections.emptySet());
            task.setEnabled(false);
            task.setFinalizedBy(Collections.emptySet());
        }
    }

    private void _configureTasksFindBugs(Project project) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(FindBugs.class, (Action)new Action<FindBugs>(){

            public void execute(FindBugs findBugs) {
                LiferayOSGiDefaultsPlugin.this._configureTaskFindBugs(findBugs);
            }
        });
    }

    private void _configureTasksJavaCompile(Project project) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(JavaCompile.class, (Action)new Action<JavaCompile>(){

            public void execute(JavaCompile javaCompile) {
                LiferayOSGiDefaultsPlugin.this._configureTaskJavaCompile(javaCompile);
            }
        });
    }

    private void _configureTasksPmd(Project project) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(Pmd.class, (Action)new Action<Pmd>(){

            public void execute(Pmd pmd) {
                LiferayOSGiDefaultsPlugin.this._configureTaskPmd(pmd);
            }
        });
    }

    private void _configureTasksPublishNodeModule(Project project) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(PublishNodeModuleTask.class, (Action)new Action<PublishNodeModuleTask>(){

            public void execute(PublishNodeModuleTask publishNodeModuleTask) {
                LiferayOSGiDefaultsPlugin.this._configureTaskPublishNodeModule(publishNodeModuleTask);
            }
        });
    }

    private void _configureTaskTest(Project project) {
        Test test = (Test)GradleUtil.getTask((Project)project, (String)"test");
        this._configureTaskTestIgnoreFailures(test);
        this._configureTaskTestJvmArgs(test, "junit.java.unit.gc");
        this._configureTaskTestLogging(test);
    }

    private void _configureTaskTestAspectJWeaver(Project project, String taskName, final Configuration aspectJWeaverConfiguration) {
        Test test = (Test)GradleUtil.getTask((Project)project, (String)taskName);
        test.doFirst((Action)new Action<Task>(){

            public void execute(Task task) {
                Test test = (Test)task;
                test.jvmArgs(new Object[]{"-javaagent:" + FileUtil.getAbsolutePath((File)aspectJWeaverConfiguration.getSingleFile())});
            }
        });
        test.systemProperty("org.aspectj.weaver.loadtime.configuration", (Object)"com/liferay/aspectj/modules/aop.xml");
    }

    private void _configureTaskTestIgnoreFailures(Test test) {
        test.setIgnoreFailures(true);
    }

    private void _configureTaskTestIntegration(Project project) {
        Test test = (Test)GradleUtil.getTask((Project)project, (String)"testIntegration");
        this._configureTaskTestIgnoreFailures(test);
        this._configureTaskTestJvmArgs(test, "junit.java.integration.gc");
        this._configureTaskTestLogging(test);
        test.systemProperty("org.apache.maven.offline", (Object)Boolean.TRUE);
        File resultsDir = project.file((Object)"test-results/integration");
        test.setBinResultsDir(new File(resultsDir, "binary/testIntegration"));
        TestTaskReports testTaskReports = test.getReports();
        JUnitXmlReport jUnitXmlReport = testTaskReports.getJunitXml();
        jUnitXmlReport.setDestination((Object)resultsDir);
    }

    private void _configureTaskTestJvmArgs(Test test, String propertyName) {
        String jvmArgs = GradleUtil.getProperty((ExtensionAware)test.getProject(), (String)propertyName, (String)null);
        if (Validator.isNotNull((String)jvmArgs)) {
            test.jvmArgs((Object[])jvmArgs.split("\\s+"));
        }
    }

    private void _configureTaskTestLogging(Test test) {
        TestLoggingContainer testLoggingContainer = test.getTestLogging();
        testLoggingContainer.setEvents(EnumSet.allOf(TestLogEvent.class));
        testLoggingContainer.setExceptionFormat((Object)TestExceptionFormat.FULL);
        testLoggingContainer.setStackTraceFilters(Collections.emptyList());
    }

    private void _configureTaskTlddoc(Project project, File portalRootDir) {
        if (portalRootDir == null) {
            return;
        }
        TLDDocTask tlddocTask = (TLDDocTask)GradleUtil.getTask((Project)project, (String)"tlddoc");
        File xsltDir = new File(portalRootDir, "tools/styles/taglibs");
        tlddocTask.setXsltDir((Object)xsltDir);
    }

    private void _configureTaskUpdateFileVersions(ReplaceRegexTask updateFileVersionsTask, File portalRootDir) {
        Project project = updateFileVersionsTask.getProject();
        String regex = this._getModuleDependencyRegex(project);
        HashMap<String, Object> args = new HashMap<String, Object>();
        if (portalRootDir == null) {
            portalRootDir = project.getRootDir();
        }
        args.put("dir", portalRootDir);
        args.put("includes", Arrays.asList("**/*.gradle", "**/sdk/*/README.markdown"));
        updateFileVersionsTask.match(regex, project.fileTree(args));
    }

    private void _configureTaskUpdateVersionForCachePlugin(ReplaceRegexTask updateVersionTask) {
        Project project = updateVersionTask.getProject();
        CacheExtension cacheExtension = (CacheExtension)GradleUtil.getExtension((ExtensionAware)project, CacheExtension.class);
        for (TaskCache taskCache : cacheExtension.getTasks()) {
            String regex = "\"" + project.getName() + "@(.+?)\\/";
            HashMap<String, Object> args = new HashMap<String, Object>();
            args.put("dir", taskCache.getCacheDir());
            args.put("includes", Arrays.asList("config.json", "**/*.js"));
            ConfigurableFileTree fileTree = project.fileTree(args);
            updateVersionTask.match(regex, fileTree);
            updateVersionTask.finalizedBy(new Object[]{taskCache.getRefreshDigestTaskName()});
        }
    }

    private void _configureTaskUploadArchives(Project project, boolean testProject, ReplaceRegexTask updateFileVersionsTask, ReplaceRegexTask updateVersionTask) {
        Task uploadArchivesTask = GradleUtil.getTask((Project)project, (String)"uploadArchives");
        if (testProject) {
            uploadArchivesTask.setDependsOn(Collections.emptySet());
            uploadArchivesTask.setEnabled(false);
            uploadArchivesTask.setFinalizedBy(Collections.emptySet());
            return;
        }
        if (GradleUtil.isSnapshot(project)) {
            return;
        }
        TaskContainer taskContainer = project.getTasks();
        TaskCollection publishNodeModuleTasks = taskContainer.withType(PublishNodeModuleTask.class);
        uploadArchivesTask.dependsOn(new Object[]{publishNodeModuleTasks});
        uploadArchivesTask.finalizedBy(new Object[]{updateFileVersionsTask, updateVersionTask});
    }

    private void _forceProjectDependenciesEvaluation(Project project) {
        GradleInternal gradleInternal = (GradleInternal)project.getGradle();
        ServiceRegistry serviceRegistry = gradleInternal.getServices();
        final ProjectConfigurer projectConfigurer = (ProjectConfigurer)serviceRegistry.get(ProjectConfigurer.class);
        EclipseModel eclipseModel = (EclipseModel)GradleUtil.getExtension((ExtensionAware)project, EclipseModel.class);
        EclipseClasspath eclipseClasspath = eclipseModel.getClasspath();
        for (Configuration configuration : eclipseClasspath.getPlusConfigurations()) {
            DependencySet dependencySet = configuration.getAllDependencies();
            dependencySet.withType(ProjectDependency.class, (Action)new Action<ProjectDependency>(){

                public void execute(ProjectDependency projectDependency) {
                    Project dependencyProject = projectDependency.getDependencyProject();
                    projectConfigurer.configure((ProjectInternal)dependencyProject);
                }
            });
        }
    }

    private File _getAppBndFile(Project project, File portalRootDir) {
        File dir = GradleUtil.getRootDir(project, _APP_BND_FILE_NAME);
        if (dir != null) {
            return new File(dir, _APP_BND_FILE_NAME);
        }
        File modulesDir = new File(portalRootDir, "modules");
        File modulesPrivateDir = new File(modulesDir, "private");
        if (!FileUtil.isChild((File)project.getProjectDir(), (File)modulesPrivateDir)) {
            return null;
        }
        String path = FileUtil.relativize((File)project.getProjectDir(), (File)modulesPrivateDir);
        if (File.pathSeparatorChar != '/') {
            path = path.replace(File.pathSeparatorChar, '/');
        }
        File file;
        while (!(file = new File(modulesDir, path + "/" + _APP_BND_FILE_NAME)).exists()) {
            int index = path.lastIndexOf(47);
            if (index == -1) {
                return null;
            }
            path = path.substring(0, index);
        }
        return file;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long _getArtifactLastModifiedTime(Project project) {
        DependencyHandler dependencyHandler = project.getDependencies();
        HashMap<String, Object> dependencyNotation = new HashMap<String, Object>();
        dependencyNotation.put("group", project.getGroup());
        dependencyNotation.put("name", GradleUtil.getArchivesBaseName(project));
        dependencyNotation.put("version", "latest.integration");
        Dependency dependency = dependencyHandler.create(dependencyNotation);
        ConfigurationContainer configurationContainer = project.getConfigurations();
        Configuration configuration = configurationContainer.detachedConfiguration(new Dependency[]{dependency});
        this._configureConfigurationNoCache(configuration);
        File file = (File)CollectionUtils.single((Iterable)configuration.resolve());
        if (GradleUtil.isFromMavenLocal(project, file)) {
            throw new GradleException("Please delete " + file.getParent() + " and try again");
        }
        try (JarFile jarFile = new JarFile(file);){
            Manifest manifest = jarFile.getManifest();
            Attributes attributes = manifest.getMainAttributes();
            String lastModified = attributes.getValue("Bnd-LastModified");
            long l = Long.valueOf(lastModified);
            return l;
        }
        catch (IOException ioe) {
            throw new UncheckedIOException((Throwable)ioe);
        }
    }

    private String _getBundleInstruction(Project project, String key) {
        Map<String, String> bundleInstructions = this._getBundleInstructions(project);
        return bundleInstructions.get(key);
    }

    private Map<String, String> _getBundleInstructions(Project project) {
        BundleExtension bundleExtension = (BundleExtension)GradleUtil.getExtension((ExtensionAware)project, BundleExtension.class);
        return (Map)bundleExtension.getInstructions();
    }

    private GitRepo _getGitRepo(File dir) {
        String content;
        if ((dir = GradleUtil.getRootDir(dir, _GIT_REPO_FILE_NAME)) == null) {
            return null;
        }
        try {
            File file = new File(dir, _GIT_REPO_FILE_NAME);
            content = new String(Files.readAllBytes(file.toPath()), StandardCharsets.UTF_8);
        }
        catch (IOException ioe) {
            throw new UncheckedIOException((Throwable)ioe);
        }
        boolean readOnly = false;
        if (content.contains("mode = pull")) {
            readOnly = true;
        }
        return new GitRepo(dir, readOnly);
    }

    private File _getLibDir(Project project) {
        File docrootDir = project.file((Object)"docroot");
        if (docrootDir.exists()) {
            return new File(docrootDir, "WEB-INF/lib");
        }
        return project.file((Object)"lib");
    }

    private String _getModuleDependency(Project project, boolean roundToMinorVersion) {
        Version version;
        StringBuilder sb = new StringBuilder();
        sb.append("group: \"");
        sb.append(project.getGroup());
        sb.append("\", name: \"");
        sb.append(GradleUtil.getArchivesBaseName(project));
        sb.append("\", version: \"");
        String versionString = String.valueOf(project.getVersion());
        if (roundToMinorVersion && (version = this._getVersion(versionString)) != null) {
            version = new Version(version.getMajor(), version.getMinor(), 0);
            versionString = version.toString();
        }
        sb.append(versionString);
        sb.append('\"');
        return sb.toString();
    }

    private String _getModuleDependencyRegex(Project project) {
        StringBuilder sb = new StringBuilder();
        sb.append("group: \"");
        sb.append(project.getGroup());
        sb.append("\", name: \"");
        sb.append(GradleUtil.getArchivesBaseName(project));
        sb.append("\", version: \"");
        return Pattern.quote(sb.toString()) + "(\\d.+)\"";
    }

    private String _getProjectDependency(Project project) {
        return "project(\"" + project.getPath() + "\")";
    }

    private Version _getVersion(Object version) {
        try {
            return Version.parseVersion((String)String.valueOf(version));
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
    }

    private File _getVersionOverrideFile(Project project, GitRepo gitRepo) {
        if (gitRepo == null || !gitRepo.readOnly) {
            return null;
        }
        String fileName = ".version-override-" + project.getName() + ".properties";
        return new File(gitRepo.dir.getParentFile(), fileName);
    }

    private Properties _getVersions(File projectDir, Properties versionOverrides) throws IOException {
        File packageInfoRootDir;
        Path packageInfoRootDirPath;
        Properties bundleProperties;
        String bundleVersion;
        final Properties versions = new Properties();
        if (versionOverrides != null) {
            versions.putAll((Map<?, ?>)versionOverrides);
        }
        if (Validator.isNull((String)(bundleVersion = versions.getProperty("Bundle-Version"))) && Validator.isNotNull((String)(bundleVersion = (bundleProperties = GUtil.loadProperties((File)new File(projectDir, "bnd.bnd"))).getProperty("Bundle-Version")))) {
            versions.setProperty("Bundle-Version", bundleVersion);
        }
        if (Files.notExists(packageInfoRootDirPath = (packageInfoRootDir = new File(projectDir, "src/main/resources")).toPath(), new LinkOption[0])) {
            return versions;
        }
        Files.walkFileTree(packageInfoRootDirPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dirPath, BasicFileAttributes basicFileAttributes) throws IOException {
                Path packageInfoPath = dirPath.resolve("packageinfo");
                if (Files.notExists(packageInfoPath, new LinkOption[0])) {
                    return FileVisitResult.CONTINUE;
                }
                Path relativePath = packageInfoRootDirPath.relativize(dirPath);
                String packagePath = relativePath.toString();
                String packageVersion = versions.getProperty(packagePath = packagePath.replace(File.separatorChar, '.'));
                if (Validator.isNotNull((String)packageVersion)) {
                    return FileVisitResult.CONTINUE;
                }
                packageVersion = new String(Files.readAllBytes(packageInfoPath), StandardCharsets.UTF_8);
                packageVersion = packageVersion.trim();
                packageVersion = packageVersion.substring(8);
                versions.setProperty(packagePath, packageVersion);
                return FileVisitResult.CONTINUE;
            }
        });
        return versions;
    }

    private boolean _hasRemoteServices(BuildWSDDTask buildWSDDTask) throws Exception {
        if (FileUtil.exists((Project)buildWSDDTask.getProject(), (String)"server-config.wsdd")) {
            return true;
        }
        File serviceXmlFile = buildWSDDTask.getInputFile();
        if (!serviceXmlFile.exists()) {
            return false;
        }
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(serviceXmlFile);
        Element serviceBuilderElement = document.getDocumentElement();
        NodeList entityNodeList = serviceBuilderElement.getElementsByTagName("entity");
        for (int i = 0; i < entityNodeList.getLength(); ++i) {
            Element entityElement = (Element)entityNodeList.item(i);
            String remoteService = entityElement.getAttribute("remote-service");
            if (!Validator.isNull((String)remoteService) && !Boolean.parseBoolean(remoteService)) continue;
            return true;
        }
        return false;
    }

    private boolean _hasTests(Project project) {
        SourceSet sourceSet = GradleUtil.getSourceSet((Project)project, (String)"test");
        SourceDirectorySet sourceDirectorySet = sourceSet.getAllSource();
        if (!sourceDirectorySet.isEmpty()) {
            return true;
        }
        sourceSet = GradleUtil.getSourceSet((Project)project, (String)"testIntegration");
        sourceDirectorySet = sourceSet.getAllSource();
        return !sourceDirectorySet.isEmpty();
    }

    private boolean _isPublishing(Project project) {
        Gradle gradle = project.getGradle();
        StartParameter startParameter = gradle.getStartParameter();
        List taskNames = startParameter.getTaskNames();
        return taskNames.contains("install") || taskNames.contains("uploadArchives");
    }

    private boolean _isSnapshotStale(Project project) {
        String[] lines;
        Logger logger = project.getLogger();
        try {
            long lastModifiedTime = this._getArtifactLastModifiedTime(project);
        }
        catch (ResolveException re) {
            if (logger.isInfoEnabled()) {
                logger.info("Unable to get artifact last modified time for " + project + ", a new snapshot will be published", (Throwable)re);
            }
            return true;
        }
        String result = GitUtil.getGitResult(project, "log", "--format=%s", "--since=" + (lastModifiedTime /= 1000L), ".");
        for (String line : lines = result.split("\\r?\\n")) {
            if (logger.isInfoEnabled()) {
                logger.info(line);
            }
            if (Validator.isNull((String)line) || line.contains("artifact:ignore")) continue;
            return true;
        }
        return false;
    }

    private boolean _isTaglibDependency(String group, String name) {
        return group.equals(_GROUP) && name.startsWith("com.liferay.") && name.contains(".taglib");
    }

    private boolean _isUtilTaglibDependency(String group, String name) {
        return group.equals(_GROUP_PORTAL) && name.equals("com.liferay.util.taglib");
    }

    private void _saveVersions(File projectDir, Properties versions, File versionOverrideFile) throws IOException {
        if (versionOverrideFile != null) {
            if (versions.isEmpty()) {
                versionOverrideFile.delete();
            } else {
                FileUtil.writeProperties(versionOverrideFile, versions);
            }
        }
        Path projectDirPath = projectDir.toPath();
        String version = versions.getProperty("Bundle-Version");
        if (Validator.isNotNull((String)version)) {
            FileUtil.replace(projectDirPath.resolve("bnd.bnd"), _BUNDLE_VERSION_REGEX, version);
        }
        Path packageInfoRootDirPath = projectDirPath.resolve("src/main/resources");
        for (String key : versions.stringPropertyNames()) {
            Path packageDirPath;
            Path packageInfoPath;
            String oldPackageInfo;
            String packageInfo;
            if (key.indexOf(47) != -1 || key.equals("Bundle-Version") || Validator.isNull((String)(version = versions.getProperty(key))) || (packageInfo = "version " + version).equals((oldPackageInfo = new String(Files.readAllBytes(packageInfoPath = (packageDirPath = packageInfoRootDirPath.resolve(key.replace('.', '/'))).resolve("packageinfo")), StandardCharsets.UTF_8)).trim())) continue;
            Files.createDirectories(packageDirPath, new FileAttribute[0]);
            Files.write(packageInfoPath, packageInfo.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
    }

    private boolean _syncReleaseVersions(Project project, File portalRootDir, File versionOverrideFile, boolean testProject) {
        boolean syncRelease = false;
        if (project.hasProperty(SYNC_RELEASE_PROPERTY_NAME)) {
            syncRelease = GradleUtil.getProperty((ExtensionAware)project, (String)SYNC_RELEASE_PROPERTY_NAME, (boolean)true);
        }
        if (portalRootDir == null || !syncRelease || testProject || !GradleUtil.hasStartParameterTask(project, "baseline")) {
            return false;
        }
        File releasePortalRootDir = GradleUtil.getProperty((Project)project, (String)RELEASE_PORTAL_ROOT_DIR_PROPERTY_NAME, (File)null);
        if (releasePortalRootDir == null) {
            throw new GradleException("Please set the property \"release.versions.test.other.dir\".");
        }
        Logger logger = project.getLogger();
        String relativePath = FileUtil.relativize((File)project.getProjectDir(), (File)portalRootDir);
        File releaseProjectDir = new File(releasePortalRootDir, relativePath);
        if (!releaseProjectDir.exists()) {
            if (logger.isInfoEnabled()) {
                logger.info("Unable to synchronize release versions of {}, {} does not exist", (Object)project, (Object)releaseProjectDir);
            }
            return false;
        }
        if (logger.isLifecycleEnabled()) {
            logger.lifecycle("Synchronizing release versions of {} with {}", new Object[]{project, releaseProjectDir});
        }
        Properties releaseVersions = null;
        Properties versions = null;
        if (versionOverrideFile != null && versionOverrideFile.exists()) {
            versions = GUtil.loadProperties((File)versionOverrideFile);
        }
        try {
            releaseVersions = this._getVersions(releaseProjectDir, null);
            versions = this._getVersions(project.getProjectDir(), versions);
            for (String key : releaseVersions.stringPropertyNames()) {
                Version version;
                Version releaseVersion;
                if (key.indexOf(47) != -1 || !versions.containsKey(key) || (releaseVersion = Version.parseVersion((String)releaseVersions.getProperty(key))).compareTo(version = Version.parseVersion((String)versions.getProperty(key))) <= 0) continue;
                versions.setProperty(key, releaseVersion.toString());
            }
            this._saveVersions(project.getProjectDir(), versions, versionOverrideFile);
        }
        catch (IOException ioe) {
            throw new UncheckedIOException((Throwable)ioe);
        }
        String bundleVersion = versions.getProperty("Bundle-Version");
        if (Validator.isNotNull((String)bundleVersion)) {
            project.setVersion((Object)bundleVersion);
        }
        return true;
    }

    private static class GitRepo {
        public final File dir;
        public final boolean readOnly;

        public GitRepo(File dir, boolean readOnly) {
            this.dir = dir;
            this.readOnly = readOnly;
        }
    }
}

