/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.defaults.internal;

import com.liferay.gradle.plugins.defaults.internal.util.GradleUtil;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.tasks.testing.Test;

public class JaCoCoPlugin
implements Plugin<Project> {
    public static final Plugin<Project> INSTANCE = new JaCoCoPlugin();

    public void apply(Project project) {
        Test test = (Test)GradleUtil.getTask((Project)project, (String)"test");
        test.doFirst((Action)new Action<Task>(){

            public void execute(Task task) {
                Test test = (Test)task;
                Project project = test.getProject();
                String jaCoCoAgentJar = GradleUtil.getProperty((ExtensionAware)project, (String)"jacoco.agent.jar", (String)null);
                String jaCoCoAgentConfiguration = GradleUtil.getProperty((ExtensionAware)project, (String)"jacoco.agent.configuration", (String)null);
                String jaCoCoJvmArg = "-javaagent:" + jaCoCoAgentJar + jaCoCoAgentConfiguration;
                List allJVMArgs = test.getAllJvmArgs();
                for (int i = 0; i < allJVMArgs.size(); ++i) {
                    String jvmArg = (String)allJVMArgs.get(i);
                    if (!jvmArg.contains("-javaagent:")) continue;
                    jvmArg = jvmArg.replaceFirst("-javaagent:", jaCoCoJvmArg + " -javaagent:");
                    allJVMArgs.set(i, jvmArg);
                    test.setAllJvmArgs(allJVMArgs);
                    return;
                }
                test.jvmArgs(new Object[]{jaCoCoJvmArg});
            }
        });
        test.systemProperty("junit.code.coverage", (Object)"true");
    }

    private JaCoCoPlugin() {
    }
}

