/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.defaults;

import com.liferay.gradle.plugins.defaults.internal.util.GitRepo;
import com.liferay.gradle.plugins.defaults.internal.util.GradlePluginsDefaultsUtil;
import com.liferay.gradle.plugins.defaults.internal.util.GradleUtil;
import com.liferay.gradle.plugins.poshi.runner.PoshiRunnerResourcesExtension;
import com.liferay.gradle.plugins.poshi.runner.PoshiRunnerResourcesPlugin;
import com.liferay.gradle.util.Validator;
import java.util.List;
import org.gradle.StartParameter;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.PublishArtifactSet;
import org.gradle.api.internal.artifacts.publish.ArchivePublishArtifact;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.publish.PublicationContainer;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.api.publish.maven.plugins.MavenPublishPlugin;
import org.gradle.api.publish.maven.tasks.PublishToMavenRepository;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;

public class PoshiRunnerResourcesDefaultsPlugin
implements Plugin<Project> {
    public static final String ARTIFACT_APPENDIX_PROPERTY_NAME = "artifactAppendix";
    public static final String ARTIFACT_VERSION_PROPERTY_NAME = "artifactVersion";
    public static final String UPLOAD_POSHI_RUNNER_RESOURCES_TASK_NAME = "uploadPoshiRunnerResources";
    private static final String _GROUP_ID = "com.liferay.poshi.runner.resources";
    private static final String _ROOT_DIR_NAME = "testFunctional";

    public void apply(Project project) {
        GradlePluginsDefaultsUtil.configureRepositories(project, null);
        GradleUtil.applyPlugin((Project)project, MavenPublishPlugin.class);
        GradleUtil.applyPlugin((Project)project, PoshiRunnerResourcesPlugin.class);
        this._applyConfigScripts(project);
        Task uploadPoshiRunnerResourcesTask = this._addTaskUploadPoshiRunnerResources(project);
        this._configurePoshiRunnerResources(project);
        Gradle gradle = project.getGradle();
        StartParameter startParameter = gradle.getStartParameter();
        List taskNames = startParameter.getTaskNames();
        if (taskNames.contains(UPLOAD_POSHI_RUNNER_RESOURCES_TASK_NAME)) {
            this._configurePublishing(project);
            this._configureTaskUploadPoshiRunnerResources(uploadPoshiRunnerResourcesTask);
        }
    }

    private Task _addTaskUploadPoshiRunnerResources(Project project) {
        Task task = GradleUtil.addTask((Project)project, (String)UPLOAD_POSHI_RUNNER_RESOURCES_TASK_NAME, Task.class);
        task.setDescription("Uploads all Poshi Runner resources artifacts.");
        task.setGroup("publishing");
        return task;
    }

    private void _applyConfigScripts(Project project) {
        GradleUtil.applyScript((Project)project, (String)"com/liferay/gradle/plugins/defaults/dependencies/config-maven-publish.gradle", (Object)project);
    }

    private void _configurePoshiRunnerResources(Project project) {
        PoshiRunnerResourcesExtension poshiRunnerResourcesExtension = (PoshiRunnerResourcesExtension)GradleUtil.getExtension((ExtensionAware)project, PoshiRunnerResourcesExtension.class);
        poshiRunnerResourcesExtension.setRootDirName((Object)_ROOT_DIR_NAME);
        if (project.hasProperty(ARTIFACT_APPENDIX_PROPERTY_NAME)) {
            poshiRunnerResourcesExtension.setArtifactAppendix((Object)GradleUtil.getProperty((ExtensionAware)project, (String)ARTIFACT_APPENDIX_PROPERTY_NAME, (String)null));
        }
        if (project.hasProperty(ARTIFACT_VERSION_PROPERTY_NAME)) {
            poshiRunnerResourcesExtension.setArtifactVersion((Object)GradleUtil.getProperty((ExtensionAware)project, (String)ARTIFACT_VERSION_PROPERTY_NAME, (String)null));
        }
    }

    private void _configurePublishing(final Project project) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(PublishToMavenRepository.class, (Action)new Action<PublishToMavenRepository>(){

            public void execute(PublishToMavenRepository publishToMavenRepository) {
                publishToMavenRepository.onlyIf((Spec)new Spec<Task>(){

                    public boolean isSatisfiedBy(Task task) {
                        GitRepo gitRepo = GitRepo.getGitRepo(project.getProjectDir());
                        return gitRepo == null || !gitRepo.readOnly;
                    }
                });
            }
        });
        Configuration configuration = GradleUtil.getConfiguration((Project)project, (String)"poshiRunnerResources");
        PublishArtifactSet publishArtifactSet = configuration.getAllArtifacts();
        publishArtifactSet.withType(ArchivePublishArtifact.class, (Action)new Action<ArchivePublishArtifact>(){

            public void execute(ArchivePublishArtifact archivePublishArtifact) {
                final AbstractArchiveTask abstractArchiveTask = archivePublishArtifact.getArchiveTask();
                PublishingExtension publishingExtension = (PublishingExtension)GradleUtil.getExtension((ExtensionAware)project, PublishingExtension.class);
                publishingExtension.publications((Action)new Action<PublicationContainer>(){

                    public void execute(PublicationContainer publicationContainer) {
                        MavenPublication mavenPublication = (MavenPublication)publicationContainer.maybeCreate("poshiRunnerResources", MavenPublication.class);
                        mavenPublication.artifact((Object)abstractArchiveTask);
                        String appendix = abstractArchiveTask.getAppendix();
                        String artifactId = abstractArchiveTask.getBaseName();
                        if (Validator.isNotNull((String)appendix)) {
                            artifactId = artifactId + '-' + appendix;
                        }
                        mavenPublication.setArtifactId(artifactId);
                        mavenPublication.setGroupId(PoshiRunnerResourcesDefaultsPlugin._GROUP_ID);
                        mavenPublication.setVersion(abstractArchiveTask.getVersion());
                    }
                });
            }
        });
    }

    private void _configureTaskUploadPoshiRunnerResources(Task uploadPoshiRunnerResourcesTask) {
        uploadPoshiRunnerResourcesTask.finalizedBy(new Object[]{"publishPoshiRunnerResourcesPublicationToReleasesRepository"});
    }
}

