/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.defaults.internal;

import com.liferay.gradle.plugins.BaseDefaultsPlugin;
import com.liferay.gradle.plugins.defaults.internal.MavenPublishDefaultsPlugin;
import com.liferay.gradle.plugins.defaults.internal.util.GradlePluginsDefaultsUtil;
import com.liferay.gradle.plugins.defaults.internal.util.GradleUtil;
import com.liferay.gradle.plugins.node.NodeExtension;
import com.liferay.gradle.plugins.node.NodePlugin;
import com.liferay.gradle.plugins.node.task.ExecutePackageManagerTask;
import com.liferay.gradle.plugins.node.task.NpmInstallTask;
import com.liferay.gradle.plugins.node.task.PackageRunTestTask;
import com.liferay.gradle.plugins.node.task.PublishNodeModuleTask;
import com.liferay.gradle.plugins.util.PortalTools;
import com.liferay.gradle.util.Validator;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.util.VersionNumber;

public class NodeDefaultsPlugin
extends BaseDefaultsPlugin<NodePlugin> {
    public static final Plugin<Project> INSTANCE = new NodeDefaultsPlugin();

    protected void applyPluginDefaults(Project project, NodePlugin nodePlugin) {
        String portalVersion = PortalTools.getPortalVersion((Project)project);
        this._configureNode(project, portalVersion);
        this._configureTaskNpmInstall(project, portalVersion);
        this._configureTaskExecutePackageManager(project);
        this._configureTaskPackageRunTest(project);
        this._configureTasksPublishNodeModule(project);
    }

    protected Class<NodePlugin> getPluginClass() {
        return NodePlugin.class;
    }

    private NodeDefaultsPlugin() {
    }

    private void _configureNode(Project project, String portalVersion) {
        VersionNumber versionNumber = VersionNumber.parse((String)GradleUtil.getProperty((ExtensionAware)project, (String)"release.info.version", (String)null));
        if ("7.0.x".equals(portalVersion)) {
            NodeExtension nodeExtension = (NodeExtension)GradleUtil.getExtension((ExtensionAware)project, NodeExtension.class);
            nodeExtension.setGlobal(false);
            nodeExtension.setNodeVersion((Object)"6.6.0");
            nodeExtension.setNpmVersion((Object)"6.4.1");
        } else if ("7.1.x".equals(portalVersion)) {
            NodeExtension nodeExtension = (NodeExtension)GradleUtil.getExtension((ExtensionAware)project, NodeExtension.class);
            nodeExtension.setNodeVersion((Object)"8.15.0");
            nodeExtension.setNpmVersion((Object)"6.4.1");
        } else if ("7.2.x".equals(portalVersion) || "7.3.x".equals(portalVersion)) {
            NodeExtension nodeExtension = (NodeExtension)GradleUtil.getExtension((ExtensionAware)project, NodeExtension.class);
            nodeExtension.setNodeVersion((Object)"10.15.3");
            nodeExtension.setNpmVersion((Object)"6.4.1");
        } else if (versionNumber.compareTo(VersionNumber.parse((String)"7.x.x")) > 0 && versionNumber.compareTo(VersionNumber.parse((String)"7.4.3.117")) <= 0) {
            NodeExtension nodeExtension = (NodeExtension)GradleUtil.getExtension((ExtensionAware)project, NodeExtension.class);
            nodeExtension.setNodeVersion((Object)"16.13.0");
            nodeExtension.setNpmVersion((Object)"8.1.0");
        }
    }

    private void _configureTaskExecutePackageManager(Project project) {
        TaskContainer taskContainer = project.getTasks();
        ExecutePackageManagerTask executePackageManagerTask = (ExecutePackageManagerTask)taskContainer.findByName("packageRunBuild");
        if (executePackageManagerTask != null) {
            executePackageManagerTask.environment((Object)"LIFERAY_NPM_BUNDLER_NO_TRACKING", (Object)"1");
        }
    }

    private void _configureTaskNpmInstall(Project project, String portalVersion) {
        NpmInstallTask npmInstallTask = (NpmInstallTask)GradleUtil.getTask((Project)project, (String)"npmInstall");
        File file = new File(npmInstallTask.getNodeModulesDir(), ".digest");
        if (!file.exists()) {
            File dir = file.getParentFile();
            try {
                Files.createDirectories(dir.toPath(), new FileAttribute[0]);
                file.createNewFile();
            }
            catch (IOException ioException) {
                throw new UncheckedIOException((Throwable)ioException);
            }
        }
        npmInstallTask.setNodeModulesDigestFile((Object)file);
        if (!"7.0.x".equals(portalVersion)) {
            npmInstallTask.setUseNpmCI((Object)Boolean.TRUE);
        }
    }

    private void _configureTaskPackageRunTest(Project project) {
        TaskContainer taskContainer = project.getTasks();
        PackageRunTestTask packageRunTestTask = (PackageRunTestTask)taskContainer.findByName("packageRunTest");
        if (packageRunTestTask == null) {
            return;
        }
        String ignoreFailures = GradleUtil.getTaskPrefixedProperty((Task)packageRunTestTask, (String)"ignore.failures");
        if (Validator.isNotNull((String)ignoreFailures)) {
            packageRunTestTask.setIgnoreFailures(Boolean.parseBoolean(ignoreFailures));
        }
    }

    private void _configureTaskPublishNodeModule(PublishNodeModuleTask publishNodeModuleTask) {
        final Project project = publishNodeModuleTask.getProject();
        publishNodeModuleTask.doFirst(MavenPublishDefaultsPlugin.failReleaseOnWrongBranchAction);
        if (GradlePluginsDefaultsUtil.isPrivateProject(project)) {
            publishNodeModuleTask.setEnabled(false);
        }
        publishNodeModuleTask.setModuleAuthor((Object)"Nathan Cavanaugh <nathan.cavanaugh@liferay.com> (https://github.com/natecavanaugh)");
        publishNodeModuleTask.setModuleBugsUrl((Object)"https://issues.liferay.com/");
        publishNodeModuleTask.setModuleLicense((Object)"LGPL");
        publishNodeModuleTask.setModuleMain((Object)"package.json");
        publishNodeModuleTask.setModuleRepository((Object)"liferay/liferay-portal");
        publishNodeModuleTask.setModuleVersion((Object)new Callable<String>(){

            @Override
            public String call() throws Exception {
                String version = String.valueOf(project.getVersion());
                if (version.endsWith("-SNAPSHOT")) {
                    int snapshotVersionSuffixLength = "-SNAPSHOT".length();
                    version = version.substring(0, version.length() - snapshotVersionSuffixLength);
                    version = version + "-alpha." + System.currentTimeMillis();
                }
                return version;
            }
        });
        publishNodeModuleTask.setOverriddenPackageJsonKeys(new String[]{"version"});
    }

    private void _configureTasksPublishNodeModule(Project project) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(PublishNodeModuleTask.class, (Action)new Action<PublishNodeModuleTask>(){

            public void execute(PublishNodeModuleTask publishNodeModuleTask) {
                NodeDefaultsPlugin.this._configureTaskPublishNodeModule(publishNodeModuleTask);
            }
        });
    }
}

