/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.defaults.task;

import com.liferay.gradle.plugins.defaults.internal.util.GradleUtil;
import com.liferay.gradle.util.hash.HashUtil;
import com.liferay.gradle.util.hash.HashValue;
import groovy.lang.Closure;
import groovy.util.AntBuilder;
import groovy.util.CharsetToolkit;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.file.CopySpec;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;

public class InstallCacheTask
extends DefaultTask {
    private Object _artifactGroup;
    private Object _artifactName;
    private Object _artifactVersion;
    private CacheFormat _cacheFormat = CacheFormat.GRADLE;
    private Object _cacheRootDir;
    private Object _mavenRootDir;

    public InstallCacheTask() {
        Project project = this.getProject();
        Gradle gradle = project.getGradle();
        this._cacheRootDir = new File(gradle.getGradleUserHomeDir(), "caches/modules-2/files-2.1");
        this._mavenRootDir = new Callable<File>(){

            @Override
            public File call() throws Exception {
                return GradleUtil.getMavenLocalDir(InstallCacheTask.this.getProject());
            }
        };
    }

    @Input
    public String getArtifactGroup() {
        return GradleUtil.toString((Object)this._artifactGroup);
    }

    @Input
    public String getArtifactName() {
        return GradleUtil.toString((Object)this._artifactName);
    }

    @Input
    public String getArtifactVersion() {
        return GradleUtil.toString((Object)this._artifactVersion);
    }

    @Internal
    public File getCacheDestinationDir() {
        CacheFormat cacheFormat = this.getCacheFormat();
        String groupDirName = this.getArtifactGroup();
        if (cacheFormat == CacheFormat.MAVEN) {
            groupDirName = groupDirName.replace('.', '/');
        }
        return new File(this.getCacheRootDir(), groupDirName + "/" + this.getArtifactName() + "/" + this.getArtifactVersion());
    }

    @Input
    public CacheFormat getCacheFormat() {
        return this._cacheFormat;
    }

    @Internal
    public File getCacheRootDir() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._cacheRootDir);
    }

    @InputDirectory
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public File getMavenInputDir() {
        String artifactGroup = this.getArtifactGroup();
        return new File(this.getMavenRootDir(), artifactGroup.replace('.', '/') + "/" + this.getArtifactName() + "/" + this.getArtifactVersion());
    }

    @InputDirectory
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public File getMavenRootDir() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._mavenRootDir);
    }

    @TaskAction
    public void installCache() throws IOException {
        this._installCache("jar");
        this._installCache("pom");
    }

    public void setArtifactGroup(Object artifactGroup) {
        this._artifactGroup = artifactGroup;
    }

    public void setArtifactName(Object artifactName) {
        this._artifactName = artifactName;
    }

    public void setArtifactVersion(Object artifactVersion) {
        this._artifactVersion = artifactVersion;
    }

    public void setCacheFormat(CacheFormat cacheFormat) {
        this._cacheFormat = cacheFormat;
    }

    public void setCacheRootDir(Object cacheRootDir) {
        this._cacheRootDir = cacheRootDir;
    }

    public void setMavenRootDir(Object mavenRootDir) {
        this._mavenRootDir = mavenRootDir;
    }

    private void _copy(final File file, final File destinationDir) {
        Project project = this.getProject();
        project.copy((Action)new Action<CopySpec>(){

            public void execute(CopySpec copySpec) {
                copySpec.from(new Object[]{file});
                copySpec.into((Object)destinationDir);
            }
        });
    }

    private void _installCache(String extension) throws IOException {
        File file = new File(this.getMavenInputDir(), this.getArtifactName() + "-" + this.getArtifactVersion() + "." + extension);
        if (!file.exists()) {
            throw new GradleException("Unable to find " + file);
        }
        if (extension.equals("pom")) {
            file = this._normalizeTextFile(file);
        }
        File destinationDir = this.getCacheDestinationDir();
        CacheFormat cacheFormat = this.getCacheFormat();
        if (cacheFormat == CacheFormat.GRADLE) {
            HashValue hashValue = HashUtil.sha1((File)file);
            String hash = hashValue.asHexString();
            hash = hash.replaceFirst("^0*", "");
            destinationDir = new File(destinationDir, hash);
        }
        this._copy(file, destinationDir);
    }

    private File _normalizeTextFile(File file) throws IOException {
        Project project = this.getProject();
        final File tempFile = new File(this.getTemporaryDir(), file.getName());
        this._copy(file, tempFile.getParentFile());
        CharsetToolkit charsetToolkit = new CharsetToolkit(tempFile);
        final Charset charset = charsetToolkit.getCharset();
        project.ant((Closure)new Closure<Void>((Object)project){

            public void doCall(AntBuilder antBuilder) {
                HashMap<String, Object> args = new HashMap<String, Object>();
                args.put("encoding", charset.name());
                args.put("eol", "lf");
                args.put("file", tempFile);
                args.put("fixlast", false);
                args.put("outputencoding", StandardCharsets.UTF_8);
                antBuilder.invokeMethod("fixcrlf", args);
            }
        });
        return tempFile;
    }

    public static enum CacheFormat {
        GRADLE,
        MAVEN;

    }
}

