/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.defaults.internal;

import com.github.jk1.license.LicenseReportExtension;
import com.github.jk1.license.LicenseReportPlugin;
import com.github.jk1.license.ModuleData;
import com.github.jk1.license.render.ReportRenderer;
import com.github.jk1.license.task.ReportTask;
import com.liferay.gradle.plugins.LiferayAntPlugin;
import com.liferay.gradle.plugins.LiferayOSGiPlugin;
import com.liferay.gradle.plugins.defaults.internal.util.GradlePluginsDefaultsUtil;
import com.liferay.gradle.plugins.defaults.internal.util.GradleUtil;
import com.liferay.gradle.plugins.defaults.internal.util.VersionsXmlReportRenderer;
import com.liferay.gradle.plugins.defaults.internal.util.XMLUtil;
import com.liferay.gradle.plugins.extensions.BundleExtension;
import com.liferay.gradle.plugins.util.BndUtil;
import com.liferay.gradle.util.Validator;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.internal.TaskInputsInternal;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.util.GUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class LicenseReportDefaultsPlugin
implements Plugin<Project> {
    public static final Plugin<Project> INSTANCE = new LicenseReportDefaultsPlugin();

    public void apply(Project project) {
        GradleUtil.withPlugin(project, LiferayAntPlugin.class, new AntLicenseReportConfigurator(project));
        GradleUtil.withPlugin(project, LiferayOSGiPlugin.class, new OSGiLicenseReportConfigurator(project));
    }

    private LicenseReportDefaultsPlugin() {
    }

    private static class ThirdPartyVersionsXmlReportRenderer
    extends VersionsXmlReportRenderer {
        private final Properties _overrideProperties;

        public ThirdPartyVersionsXmlReportRenderer(String fileName, Properties overrideProperties, LicenseReportExtension licenseReportExtension, Callable<String> moduleFileNamePrefixCallable) {
            super(fileName, licenseReportExtension, moduleFileNamePrefixCallable);
            this._overrideProperties = overrideProperties;
        }

        @Override
        protected String getLicenseName(String moduleFileName, ModuleData moduleData) {
            String key = "license.name[" + moduleFileName + "]";
            if (this._overrideProperties.containsKey(key)) {
                return this._overrideProperties.getProperty(key);
            }
            return super.getLicenseName(moduleFileName, moduleData);
        }

        @Override
        protected String getLicenseUrl(String moduleFileName, ModuleData moduleData) {
            String key = "license.url[" + moduleFileName + "]";
            if (this._overrideProperties.containsKey(key)) {
                return this._overrideProperties.getProperty(key);
            }
            return super.getLicenseUrl(moduleFileName, moduleData);
        }

        @Override
        protected boolean isExcluded(String moduleFileName, ModuleData moduleData) {
            String group = moduleData.getGroup();
            String name = moduleData.getName();
            if ((group.equals("com.liferay") || group.startsWith("com.liferay.")) && name.startsWith("com.liferay.")) {
                return true;
            }
            return Validator.isNull((String)this.getLicenseName(moduleFileName, moduleData));
        }
    }

    private static class OSGiLicenseReportConfigurator
    extends BaseLicenseReportConfigurator<LiferayOSGiPlugin> {
        private static final Pattern _bundleDependencyNamePattern = Pattern.compile("[@=]{1,2}(.+)-\\[0-9\\]\\*\\.jar");

        public OSGiLicenseReportConfigurator(Project project) {
            super(project);
        }

        @Override
        protected String[] addConfigurations() throws Exception {
            super.addConfigurations();
            BundleExtension bundleExtension = BndUtil.getBundleExtension((ExtensionContainer)this.project.getExtensions());
            HashSet<String> dependencyNames = new HashSet<String>();
            this._addBundleDependencyNames(bundleExtension, dependencyNames, "-includeresource");
            this._addBundleDependencyNames(bundleExtension, dependencyNames, "Include-Resource");
            this._addDependenciesLicenseReport("compileOnly", dependencyNames);
            return new String[]{"compileInclude", "licenseReport"};
        }

        @Override
        protected String getArchiveExtension() {
            return "jar";
        }

        private void _addBundleDependencyNames(BundleExtension bundleExtension, Set<String> dependencyNames, String key) {
            String value = bundleExtension.getInstruction(key);
            if (Validator.isNull((String)value)) {
                return;
            }
            Matcher matcher = _bundleDependencyNamePattern.matcher(value);
            while (matcher.find()) {
                String dependencyName = matcher.group(1);
                dependencyNames.add(dependencyName);
            }
        }

        private void _addDependenciesLicenseReport(String configurationName, final Set<String> dependencyNames) {
            Configuration configuration = GradleUtil.getConfiguration((Project)this.project, (String)configurationName);
            DependencySet dependencySet = configuration.getDependencies();
            dependencySet.withType(ExternalModuleDependency.class, (Action)new Action<ExternalModuleDependency>(){

                public void execute(ExternalModuleDependency externalModuleDependency) {
                    if (dependencyNames.contains(externalModuleDependency.getName())) {
                        GradleUtil.addDependency((Project)project, (String)"licenseReport", (String)externalModuleDependency.getGroup(), (String)externalModuleDependency.getName(), (String)externalModuleDependency.getVersion());
                    }
                }
            });
        }
    }

    private static abstract class BaseLicenseReportConfigurator<P extends Plugin<? extends Project>>
    implements Action<P> {
        public static final String LICENSE_REPORT_CONFIGURATION_NAME = "licenseReport";
        protected final Project project;
        private final File _overridePropertiesFile;

        public BaseLicenseReportConfigurator(Project project) {
            this.project = project;
            this._overridePropertiesFile = this._getOverridePropertiesFile();
        }

        public void execute(P plugin) {
            GradleUtil.applyPlugin((Project)this.project, LicenseReportPlugin.class);
            LicenseReportExtension licenseReportExtension = (LicenseReportExtension)GradleUtil.getExtension((ExtensionAware)this.project, LicenseReportExtension.class);
            try {
                licenseReportExtension.configurations = this.addConfigurations();
            }
            catch (IOException ioException) {
                throw new UncheckedIOException((Throwable)ioException);
            }
            catch (Exception exception) {
                throw new GradleException("Unable to configure license report for " + this.project, (Throwable)exception);
            }
            licenseReportExtension.excludeOwnGroup = false;
            String fileName = "versions.xml";
            String outputDir = System.getProperty("license.report.output.dir");
            if (Validator.isNotNull((String)outputDir)) {
                fileName = this.project.getName() + ".xml";
                licenseReportExtension.outputDir = outputDir;
            }
            Properties overrideProperties = new Properties();
            if (this._overridePropertiesFile != null) {
                overrideProperties = GUtil.loadProperties((File)this._overridePropertiesFile);
            }
            licenseReportExtension.renderers = new ReportRenderer[]{new ThirdPartyVersionsXmlReportRenderer(fileName, overrideProperties, licenseReportExtension, new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return GradleUtil.getArchivesBaseName(project) + "." + this.getArchiveExtension();
                }
            })};
            if (this._overridePropertiesFile != null) {
                ReportTask reportTask = (ReportTask)GradleUtil.getTask((Project)this.project, (String)"generateLicenseReport");
                TaskInputsInternal taskInputs = reportTask.getInputs();
                taskInputs.file((Object)this._overridePropertiesFile);
            }
        }

        protected String[] addConfigurations() throws Exception {
            Configuration configuration = GradleUtil.addConfiguration((Project)this.project, (String)LICENSE_REPORT_CONFIGURATION_NAME);
            configuration.setDescription("Configures additional dependencies to add to the license report.");
            configuration.setTransitive(false);
            configuration.setVisible(false);
            return new String[]{configuration.getName()};
        }

        protected abstract String getArchiveExtension();

        private File _getOverridePropertiesFile() {
            String overridePropertiesFileName = System.getProperty("license.report.override.properties.file");
            if (Validator.isNull((String)overridePropertiesFileName)) {
                return null;
            }
            File file = new File(overridePropertiesFileName);
            if (!file.exists()) {
                return null;
            }
            return file;
        }
    }

    private static class AntLicenseReportConfigurator
    extends BaseLicenseReportConfigurator<LiferayAntPlugin> {
        public AntLicenseReportConfigurator(Project project) {
            super(project);
        }

        @Override
        public void execute(LiferayAntPlugin liferayAntPlugin) {
            GradlePluginsDefaultsUtil.configureRepositories(this.project, null);
            super.execute(liferayAntPlugin);
        }

        @Override
        protected String[] addConfigurations() throws Exception {
            String[] configurationNames = super.addConfigurations();
            File ivyXmlFile = this.project.file((Object)"ivy.xml");
            if (!ivyXmlFile.exists()) {
                return configurationNames;
            }
            DocumentBuilder documentBuilder = XMLUtil.getDocumentBuilder();
            Document document = documentBuilder.parse(ivyXmlFile);
            Element ivyModuleElement = document.getDocumentElement();
            NodeList dependencyNodeList = ivyModuleElement.getElementsByTagName("dependency");
            for (int i = 0; i < dependencyNodeList.getLength(); ++i) {
                Element dependencyElement = (Element)dependencyNodeList.item(i);
                String group = dependencyElement.getAttribute("org");
                String name = dependencyElement.getAttribute("name");
                String version = dependencyElement.getAttribute("rev");
                GradleUtil.addDependency((Project)this.project, (String)"licenseReport", (String)group, (String)name, (String)version);
            }
            return configurationNames;
        }

        @Override
        protected String getArchiveExtension() {
            return "war";
        }
    }
}

