/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.defaults;

import com.liferay.gradle.plugins.app.javadoc.builder.AppJavadocBuilderExtension;
import com.liferay.gradle.plugins.app.javadoc.builder.AppJavadocBuilderPlugin;
import com.liferay.gradle.plugins.defaults.internal.LiferayRelengPlugin;
import com.liferay.gradle.plugins.defaults.internal.util.FileUtil;
import com.liferay.gradle.plugins.defaults.internal.util.GradleUtil;
import com.liferay.gradle.plugins.defaults.tasks.WritePropertiesTask;
import com.liferay.gradle.util.Validator;
import groovy.lang.Closure;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.javadoc.Javadoc;

public class LiferayAppDefaultsPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        String appDescription = null;
        String appTitle = null;
        String appVersion = null;
        try {
            Properties appBndProperties = FileUtil.readProperties((Project)project, (String)"app.bnd");
            appDescription = appBndProperties.getProperty("Liferay-Releng-App-Description");
            File relengDir = LiferayRelengPlugin.getRelengDir(project);
            if (relengDir != null) {
                File appPropertiesFile = new File(relengDir, "app.properties");
                Properties appProperties = FileUtil.readProperties((File)appPropertiesFile);
                appTitle = appProperties.getProperty("app.marketplace.title");
                appVersion = appProperties.getProperty("app.marketplace.version");
            }
        }
        catch (IOException ioe) {
            throw new UncheckedIOException((Throwable)ioe);
        }
        GradleUtil.applyPlugin((Project)project, AppJavadocBuilderPlugin.class);
        this.configureAppJavadocBuilder(project);
        this.configureProject(project, appDescription, appVersion);
        this.configureTaskAppJavadoc(project, appTitle, appVersion);
    }

    protected void configureAppJavadocBuilder(Project project) {
        AppJavadocBuilderExtension appJavadocBuilderExtension = (AppJavadocBuilderExtension)GradleUtil.getExtension((ExtensionAware)project, AppJavadocBuilderExtension.class);
        appJavadocBuilderExtension.onlyIf((Spec)new Spec<Project>(){

            public boolean isSatisfiedBy(Project project) {
                File outputFile;
                TaskContainer taskContainer = project.getTasks();
                WritePropertiesTask recordArtifactTask = (WritePropertiesTask)((Object)taskContainer.findByName("recordArtifact"));
                return recordArtifactTask != null && (outputFile = recordArtifactTask.getOutputFile()).exists();
            }
        });
        appJavadocBuilderExtension.setGroupNameClosure((Closure)new Closure<String>((Object)project){

            public String doCall(Project subproject) {
                return LiferayAppDefaultsPlugin.this.getAppJavadocGroupName(subproject);
            }
        });
    }

    protected void configureProject(Project project, String description, String version) {
        if (Validator.isNotNull((String)description)) {
            project.setDescription(description);
        }
        if (Validator.isNotNull((String)version)) {
            project.setVersion((Object)version);
        }
    }

    protected void configureTaskAppJavadoc(Project project, String appTitle, String appVersion) {
        if (Validator.isNull((String)appTitle) || Validator.isNull((String)appVersion)) {
            return;
        }
        Javadoc javadoc = (Javadoc)GradleUtil.getTask((Project)project, (String)"appJavadoc");
        String title = String.format("%s %s API", appTitle, appVersion);
        javadoc.setTitle(title);
    }

    protected String getAppJavadocGroupName(Project project) {
        Properties artifactProperties;
        String artifactURL;
        TaskContainer taskContainer;
        WritePropertiesTask recordArtifactTask;
        String groupName = project.getDescription();
        if (Validator.isNull((String)groupName)) {
            groupName = project.getName();
        }
        if ((recordArtifactTask = (WritePropertiesTask)((Object)(taskContainer = project.getTasks()).findByName("recordArtifact"))) != null && Validator.isNotNull((String)(artifactURL = (artifactProperties = LiferayRelengPlugin.getArtifactProperties(recordArtifactTask)).getProperty("artifact.url")))) {
            int start = artifactURL.lastIndexOf(47) + 1;
            int end = artifactURL.lastIndexOf(46);
            int pos = artifactURL.indexOf(45, start);
            String moduleName = artifactURL.substring(start, pos);
            String moduleVersion = artifactURL.substring(pos + 1, end);
            StringBuilder sb = new StringBuilder();
            sb.append("Module ");
            sb.append(moduleName);
            sb.append(' ');
            sb.append(moduleVersion);
            sb.append(" - ");
            sb.append(groupName);
            groupName = sb.toString();
        }
        return groupName;
    }
}

