/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.defaults;

import aQute.bnd.version.Version;
import com.liferay.gradle.plugins.LiferayOSGiPlugin;
import com.liferay.gradle.plugins.cache.CacheExtension;
import com.liferay.gradle.plugins.cache.CachePlugin;
import com.liferay.gradle.plugins.cache.task.TaskCache;
import com.liferay.gradle.plugins.defaults.internal.LiferayRelengPlugin;
import com.liferay.gradle.plugins.defaults.internal.WhipDefaultsPlugin;
import com.liferay.gradle.plugins.defaults.internal.util.FileUtil;
import com.liferay.gradle.plugins.defaults.internal.util.GitUtil;
import com.liferay.gradle.plugins.defaults.internal.util.GradleUtil;
import com.liferay.gradle.plugins.defaults.internal.util.IncrementVersionClosure;
import com.liferay.gradle.plugins.defaults.tasks.BaselineTask;
import com.liferay.gradle.plugins.defaults.tasks.InstallCacheTask;
import com.liferay.gradle.plugins.defaults.tasks.ReplaceRegexTask;
import com.liferay.gradle.plugins.defaults.tasks.WritePropertiesTask;
import com.liferay.gradle.plugins.extensions.LiferayExtension;
import com.liferay.gradle.plugins.extensions.LiferayOSGiExtension;
import com.liferay.gradle.plugins.jasper.jspc.JspCPlugin;
import com.liferay.gradle.plugins.js.module.config.generator.ConfigJSModulesTask;
import com.liferay.gradle.plugins.js.module.config.generator.JSModuleConfigGeneratorPlugin;
import com.liferay.gradle.plugins.node.tasks.PublishNodeModuleTask;
import com.liferay.gradle.plugins.patcher.PatchTask;
import com.liferay.gradle.plugins.service.builder.ServiceBuilderPlugin;
import com.liferay.gradle.plugins.tlddoc.builder.tasks.TLDDocTask;
import com.liferay.gradle.plugins.upgrade.table.builder.UpgradeTableBuilderPlugin;
import com.liferay.gradle.plugins.util.PortalTools;
import com.liferay.gradle.plugins.whip.WhipPlugin;
import com.liferay.gradle.plugins.wsdd.builder.WSDDBuilderPlugin;
import com.liferay.gradle.plugins.wsdl.builder.WSDLBuilderPlugin;
import com.liferay.gradle.plugins.xsd.builder.XSDBuilderPlugin;
import com.liferay.gradle.util.StringUtil;
import com.liferay.gradle.util.Validator;
import com.liferay.gradle.util.copy.ExcludeExistingFileAction;
import com.liferay.gradle.util.copy.RenameDependencyClosure;
import com.liferay.gradle.util.copy.ReplaceLeadingPathAction;
import groovy.json.JsonSlurper;
import groovy.lang.Closure;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nebula.plugin.extraconfigurations.OptionalBasePlugin;
import nebula.plugin.extraconfigurations.ProvidedBasePlugin;
import org.dm.gradle.plugins.bundle.BundleExtension;
import org.gradle.StartParameter;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.JavaVersion;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.ResolutionStrategy;
import org.gradle.api.artifacts.ResolveException;
import org.gradle.api.artifacts.dsl.ArtifactHandler;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.maven.Conf2ScopeMappingContainer;
import org.gradle.api.artifacts.repositories.AuthenticationContainer;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.artifacts.repositories.PasswordCredentials;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.DuplicatesStrategy;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.BasePluginConvention;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.MavenPlugin;
import org.gradle.api.plugins.MavenPluginConvention;
import org.gradle.api.plugins.ReportingBasePlugin;
import org.gradle.api.plugins.quality.FindBugs;
import org.gradle.api.plugins.quality.FindBugsPlugin;
import org.gradle.api.plugins.quality.FindBugsReports;
import org.gradle.api.plugins.quality.FindBugsXmlReport;
import org.gradle.api.plugins.quality.Pmd;
import org.gradle.api.plugins.quality.PmdExtension;
import org.gradle.api.plugins.quality.PmdPlugin;
import org.gradle.api.reporting.SingleFileReport;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetOutput;
import org.gradle.api.tasks.StopActionException;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.javadoc.Javadoc;
import org.gradle.api.tasks.testing.JUnitXmlReport;
import org.gradle.api.tasks.testing.Test;
import org.gradle.api.tasks.testing.TestTaskReports;
import org.gradle.api.tasks.testing.logging.TestExceptionFormat;
import org.gradle.api.tasks.testing.logging.TestLogEvent;
import org.gradle.api.tasks.testing.logging.TestLoggingContainer;
import org.gradle.execution.ProjectConfigurer;
import org.gradle.external.javadoc.CoreJavadocOptions;
import org.gradle.external.javadoc.StandardJavadocDocletOptions;
import org.gradle.internal.authentication.DefaultBasicAuthentication;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.plugins.ide.eclipse.EclipsePlugin;
import org.gradle.plugins.ide.eclipse.model.EclipseClasspath;
import org.gradle.plugins.ide.eclipse.model.EclipseModel;
import org.gradle.plugins.ide.idea.IdeaPlugin;
import org.gradle.plugins.ide.idea.model.IdeaModel;
import org.gradle.plugins.ide.idea.model.IdeaModule;
import org.gradle.process.ExecSpec;
import org.gradle.util.CollectionUtils;

public class LiferayOSGiDefaultsPlugin
implements Plugin<Project> {
    public static final String BASELINE_CONFIGURATION_NAME = "baseline";
    public static final String BASELINE_TASK_NAME = "baseline";
    public static final String COMMIT_CACHE_TASK_NAME = "commitCache";
    public static final String COPY_LIBS_TASK_NAME = "copyLibs";
    public static final String DEFAULT_REPOSITORY_URL = "https://cdn.lfrs.sl/repository.liferay.com/nexus/content/groups/public";
    public static final String DEPLOY_APP_SERVER_LIB_TASK_NAME = "deployAppServerLib";
    public static final String DEPLOY_TOOL_TASK_NAME = "deployTool";
    public static final String INSTALL_CACHE_TASK_NAME = "installCache";
    public static final String JAR_JAVADOC_TASK_NAME = "jarJavadoc";
    public static final String JAR_SOURCES_TASK_NAME = "jarSources";
    public static final String JAR_TLDDOC_TASK_NAME = "jarTLDDoc";
    public static final String PORTAL_TEST_CONFIGURATION_NAME = "portalTest";
    public static final String SNAPSHOT_IF_STALE_PROPERTY_NAME = "snapshotIfStale";
    public static final String UPDATE_FILE_VERSIONS_TASK_NAME = "updateFileVersions";
    private static final String _APP_BND_FILE_NAME = "app.bnd";
    private static final String _CACHE_COMMIT_MESSAGE = "FAKE GRADLE CACHE";
    private static final String _GROUP = "com.liferay";
    private static final JavaVersion _JAVA_VERSION = JavaVersion.VERSION_1_7;
    private static final Version _LOWEST_BASELINE_VERSION = new Version(1, 0, 0);
    private static final boolean _MAVEN_LOCAL_IGNORE = Boolean.getBoolean("maven.local.ignore");
    private static final String _PMD_PORTAL_TOOL_NAME = "com.liferay.pmd";
    private static final String _REPOSITORY_PRIVATE_PASSWORD = System.getProperty("repository.private.password");
    private static final String _REPOSITORY_PRIVATE_URL = System.getProperty("repository.private.url");
    private static final String _REPOSITORY_PRIVATE_USERNAME = System.getProperty("repository.private.username");
    private static final String _REPOSITORY_URL = System.getProperty("repository.url", "https://cdn.lfrs.sl/repository.liferay.com/nexus/content/groups/public");
    private static final String _SERVICE_BUILDER_PORTAL_TOOL_NAME = "com.liferay.portal.tools.service.builder";

    public static boolean isTestProject(Project project) {
        String projectName = project.getName();
        return projectName.endsWith("-test");
    }

    public void apply(final Project project) {
        GradleUtil.applyPlugin((Project)project, LiferayOSGiPlugin.class);
        Gradle gradle = project.getGradle();
        StartParameter startParameter = gradle.getStartParameter();
        List taskNames = startParameter.getTaskNames();
        final File portalRootDir = GradleUtil.getRootDir(project.getRootProject(), "portal-impl");
        boolean publishing = this.isPublishing(project);
        boolean testProject = LiferayOSGiDefaultsPlugin.isTestProject(project);
        boolean deployToAppServerLibs = false;
        boolean deployToTools = false;
        if (FileUtil.exists((Project)project, (String)".lfrbuild-app-server-lib")) {
            deployToAppServerLibs = true;
        } else if (FileUtil.exists((Project)project, (String)".lfrbuild-tool")) {
            deployToTools = true;
        }
        this.applyPlugins(project);
        this.configureMavenConf2ScopeMappings(project);
        this.applyConfigScripts(project);
        this.addDependenciesPmd(project);
        if (testProject || this.hasTests(project)) {
            GradleUtil.applyPlugin((Project)project, WhipDefaultsPlugin.class);
            GradleUtil.applyPlugin((Project)project, WhipPlugin.class);
            Configuration portalConfiguration = GradleUtil.getConfiguration((Project)project, (String)"portal");
            Configuration portalTestConfiguration = this.addConfigurationPortalTest(project);
            this.addDependenciesPortalTest(project);
            this.addDependenciesTestCompile(project);
            this.configureEclipse(project, portalTestConfiguration);
            this.configureIdea(project, portalTestConfiguration);
            this.configureSourceSetTest(project, portalConfiguration, portalTestConfiguration);
            this.configureSourceSetTestIntegration(project, portalConfiguration, portalTestConfiguration);
        }
        Configuration baselineConfiguration = null;
        if (this.hasBaseline(project)) {
            baselineConfiguration = this.addConfigurationBaseline(project);
        }
        this.addTaskBaseline(project, baselineConfiguration);
        InstallCacheTask installCacheTask = this.addTaskInstallCache(project);
        this.addTaskCommitCache(project, installCacheTask);
        this.addTaskCopyLibs(project);
        if (deployToAppServerLibs) {
            this.addTaskAlias(project, DEPLOY_APP_SERVER_LIB_TASK_NAME, "deploy");
        } else if (deployToTools) {
            this.addTaskAlias(project, DEPLOY_TOOL_TASK_NAME, "deploy");
        }
        final Jar jarJavadocTask = this.addTaskJarJavadoc(project);
        final Jar jarSourcesTask = this.addTaskJarSources(project, testProject);
        final Jar jarTLDDocTask = this.addTaskJarTLDDoc(project);
        final ReplaceRegexTask updateFileVersionsTask = this.addTaskUpdateFileVersions(project);
        final ReplaceRegexTask updateVersionTask = this.addTaskUpdateVersion(project);
        this.configureBasePlugin(project, portalRootDir);
        this.configureBundleDefaultInstructions(project, portalRootDir, publishing);
        this.configureConfigurations(project);
        this.configureDeployDir(project, deployToAppServerLibs, deployToTools);
        this.configureJavaPlugin(project);
        this.configurePmd(project, portalRootDir);
        this.configureProject(project);
        LiferayOSGiDefaultsPlugin.configureRepositories(project);
        this.configureSourceSetMain(project);
        this.configureTaskJar(project, testProject);
        this.configureTaskJavadoc(project);
        this.configureTaskTest(project);
        this.configureTaskTestIntegration(project);
        this.configureTaskTlddoc(project, portalRootDir);
        this.configureTasksBaseline(project);
        this.configureTasksFindBugs(project);
        this.configureTasksJavaCompile(project);
        this.configureTasksPmd(project);
        this.configureTasksPublishNodeModule(project);
        if (publishing) {
            this._configureTasksEnabledIfStaleSnapshot(project, "install", "uploadArchives");
        }
        GradleUtil.withPlugin(project, ServiceBuilderPlugin.class, new Action<ServiceBuilderPlugin>(){

            public void execute(ServiceBuilderPlugin serviceBuilderPlugin) {
                LiferayOSGiDefaultsPlugin.this.configureLocalPortalTool(project, portalRootDir, "serviceBuilder", LiferayOSGiDefaultsPlugin._SERVICE_BUILDER_PORTAL_TOOL_NAME);
            }
        });
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                LiferayOSGiDefaultsPlugin.this.checkVersion(project);
                LiferayOSGiDefaultsPlugin.this.configureArtifacts(project, jarJavadocTask, jarSourcesTask, jarTLDDocTask);
                LiferayOSGiDefaultsPlugin.this.configureTaskJarSources(jarSourcesTask);
                LiferayOSGiDefaultsPlugin.this.configureTaskUpdateFileVersions(updateFileVersionsTask, portalRootDir);
                GradleUtil.setProjectSnapshotVersion(project, LiferayOSGiDefaultsPlugin.SNAPSHOT_IF_STALE_PROPERTY_NAME);
                if (GradleUtil.hasPlugin(project, CachePlugin.class)) {
                    LiferayOSGiDefaultsPlugin.this.configureTaskUpdateVersionForCachePlugin(updateVersionTask);
                }
                if (GradleUtil.hasPlugin(project, JspCPlugin.class)) {
                    LiferayOSGiDefaultsPlugin.this.configureTaskCompileJSP(project);
                }
                LiferayOSGiDefaultsPlugin.this.configureTaskUploadArchives(project, updateFileVersionsTask, updateVersionTask);
                LiferayOSGiDefaultsPlugin.this.configureProjectBndProperties(project);
            }
        });
        if (taskNames.contains("eclipse") || taskNames.contains("idea")) {
            this.forceProjectDependenciesEvaluation(project);
        }
        TaskExecutionGraph taskExecutionGraph = gradle.getTaskGraph();
        taskExecutionGraph.whenReady((Closure)new Closure<Void>((Object)project){

            public void doCall(TaskExecutionGraph taskExecutionGraph) {
                Task jarTask = GradleUtil.getTask((Project)project, (String)"jar");
                if (taskExecutionGraph.hasTask(jarTask)) {
                    LiferayOSGiDefaultsPlugin.this.configureBundleInstructions(project);
                }
            }
        });
    }

    protected static void configureRepositories(Project project) {
        RepositoryHandler repositoryHandler = project.getRepositories();
        if (!_MAVEN_LOCAL_IGNORE) {
            repositoryHandler.mavenLocal();
        }
        repositoryHandler.maven((Action)new Action<MavenArtifactRepository>(){

            public void execute(MavenArtifactRepository mavenArtifactRepository) {
                mavenArtifactRepository.setUrl((Object)_REPOSITORY_URL);
            }
        });
        if (Validator.isNotNull((String)_REPOSITORY_PRIVATE_PASSWORD) && Validator.isNotNull((String)_REPOSITORY_PRIVATE_URL) && Validator.isNotNull((String)_REPOSITORY_PRIVATE_USERNAME)) {
            MavenArtifactRepository mavenArtifactRepository = repositoryHandler.maven((Action)new Action<MavenArtifactRepository>(){

                public void execute(MavenArtifactRepository mavenArtifactRepository) {
                    mavenArtifactRepository.setUrl((Object)_REPOSITORY_PRIVATE_URL);
                }
            });
            mavenArtifactRepository.authentication((Action)new Action<AuthenticationContainer>(){

                public void execute(AuthenticationContainer authenticationContainer) {
                    authenticationContainer.add((Object)new DefaultBasicAuthentication("basic"));
                }
            });
            mavenArtifactRepository.credentials((Action)new Action<PasswordCredentials>(){

                public void execute(PasswordCredentials passwordCredentials) {
                    passwordCredentials.setPassword(_REPOSITORY_PRIVATE_PASSWORD);
                    passwordCredentials.setUsername(_REPOSITORY_PRIVATE_USERNAME);
                }
            });
        }
    }

    protected Configuration addConfigurationBaseline(final Project project) {
        Configuration configuration = GradleUtil.addConfiguration((Project)project, (String)"baseline");
        configuration.defaultDependencies((Action)new Action<DependencySet>(){

            public void execute(DependencySet dependencySet) {
                LiferayOSGiDefaultsPlugin.this.addDependenciesBaseline(project);
            }
        });
        configuration.setDescription("Configures the previous released version of this project for baselining.");
        configuration.setVisible(false);
        this._configureConfigurationNoCache(configuration);
        return configuration;
    }

    protected Configuration addConfigurationPortalTest(Project project) {
        Configuration configuration = GradleUtil.addConfiguration((Project)project, (String)PORTAL_TEST_CONFIGURATION_NAME);
        configuration.setDescription("Configures Liferay portal test utility artifacts for this project.");
        configuration.setVisible(false);
        return configuration;
    }

    protected void addDependenciesBaseline(Project project) {
        GradleUtil.addDependency((Project)project, (String)"baseline", (String)String.valueOf(project.getGroup()), (String)GradleUtil.getArchivesBaseName(project), (String)("(," + String.valueOf(project.getVersion()) + ")"), (boolean)false);
    }

    protected void addDependenciesPmd(Project project) {
        String version = PortalTools.getVersion((Project)project, (String)_PMD_PORTAL_TOOL_NAME);
        if (Validator.isNotNull((String)version)) {
            GradleUtil.addDependency((Project)project, (String)"pmd", (String)_GROUP, (String)_PMD_PORTAL_TOOL_NAME, (String)version);
        }
    }

    protected void addDependenciesPortalTest(Project project) {
        GradleUtil.addDependency((Project)project, (String)PORTAL_TEST_CONFIGURATION_NAME, (String)"com.liferay.portal", (String)"com.liferay.portal.test", (String)"default");
        GradleUtil.addDependency((Project)project, (String)PORTAL_TEST_CONFIGURATION_NAME, (String)"com.liferay.portal", (String)"com.liferay.portal.test.integration", (String)"default");
    }

    protected void addDependenciesTestCompile(Project project) {
        GradleUtil.addDependency((Project)project, (String)"testCompile", (String)"org.mockito", (String)"mockito-core", (String)"1.10.8");
        ModuleDependency moduleDependency = (ModuleDependency)GradleUtil.addDependency((Project)project, (String)"testCompile", (String)"org.powermock", (String)"powermock-api-mockito", (String)"1.6.1");
        HashMap<String, String> excludeArgs = new HashMap<String, String>();
        excludeArgs.put("group", "org.mockito");
        excludeArgs.put("module", "mockito-all");
        moduleDependency.exclude(excludeArgs);
        GradleUtil.addDependency((Project)project, (String)"testCompile", (String)"org.powermock", (String)"powermock-module-junit4", (String)"1.6.1");
        GradleUtil.addDependency((Project)project, (String)"testCompile", (String)"org.springframework", (String)"spring-test", (String)"3.2.15.RELEASE");
    }

    protected Task addTaskAlias(Project project, String taskName, String originalTaskName) {
        Task task = project.task(taskName);
        Task originalTask = GradleUtil.getTask((Project)project, (String)originalTaskName);
        task.dependsOn(new Object[]{originalTask});
        task.setDescription("Alias for " + originalTask);
        task.setGroup(originalTask.getGroup());
        return task;
    }

    protected Task addTaskBaseline(final Project project, final Configuration baselineConfiguration) {
        Object task = null;
        if (baselineConfiguration != null) {
            GradleUtil.applyPlugin((Project)project, ReportingBasePlugin.class);
            BaselineTask baselineTask = (BaselineTask)GradleUtil.addTask((Project)project, (String)"baseline", BaselineTask.class);
            final Jar jar = (Jar)GradleUtil.getTask((Project)project, (String)"jar");
            baselineTask.dependsOn(new Object[]{jar});
            baselineTask.doFirst((Action)new Action<Task>(){

                public void execute(Task task) {
                    BaselineTask baselineTask = (BaselineTask)task;
                    File oldJarFile = baselineTask.getOldJarFile();
                    if (GradleUtil.isFromMavenLocal(project, oldJarFile)) {
                        throw new GradleException("Please delete " + oldJarFile.getParent() + " and try again");
                    }
                }
            });
            String ignoreFailures = GradleUtil.getTaskPrefixedProperty((Task)baselineTask, (String)"ignoreFailures");
            if (Validator.isNotNull((String)ignoreFailures)) {
                baselineTask.setIgnoreFailures(Boolean.parseBoolean(ignoreFailures));
            }
            baselineTask.setNewJarFile(new Callable<File>(){

                @Override
                public File call() throws Exception {
                    return jar.getArchivePath();
                }
            });
            baselineTask.setOldJarFile(new Callable<File>(){

                @Override
                public File call() throws Exception {
                    return baselineConfiguration.getSingleFile();
                }
            });
            baselineTask.setSourceDir(new Callable<File>(){

                @Override
                public File call() throws Exception {
                    SourceSet sourceSet = GradleUtil.getSourceSet((Project)project, (String)"main");
                    return GradleUtil.getSrcDir(sourceSet.getResources());
                }
            });
            task = baselineTask;
        } else {
            task = project.task("baseline");
            task.doLast((Action)new Action<Task>(){

                public void execute(Task task) {
                    Logger logger = task.getLogger();
                    if (logger.isLifecycleEnabled()) {
                        logger.lifecycle("Unable to baseline, {} has never been released.", new Object[]{project});
                    }
                }
            });
        }
        task.setDescription("Compares the public API of this project with the public API of the previous released version, if found.");
        task.setGroup("verification");
        return task;
    }

    protected Task addTaskCommitCache(Project project, final InstallCacheTask installCacheTask) {
        Task task = project.task(COMMIT_CACHE_TASK_NAME);
        task.dependsOn(new Object[]{installCacheTask});
        task.doLast((Action)new Action<Task>(){

            public void execute(Task task) {
                File cachedVersionDir = installCacheTask.getCacheDestinationDir();
                File cachedArtifactDir = cachedVersionDir.getParentFile();
                File[] cachedVersionDirs = FileUtil.getDirectories(cachedArtifactDir);
                if (cachedVersionDirs.length != 2) {
                    throw new StopActionException("Skipping old cached version deletion");
                }
                File oldCachedVersionDir = cachedVersionDirs[0];
                if (cachedVersionDir.equals(oldCachedVersionDir)) {
                    oldCachedVersionDir = cachedVersionDirs[1];
                }
                Logger logger = task.getLogger();
                Project project = task.getProject();
                boolean deleted = project.delete(new Object[]{oldCachedVersionDir});
                if (!deleted && logger.isWarnEnabled()) {
                    logger.warn("Unable to delete old cached version in " + oldCachedVersionDir);
                }
            }
        });
        task.doLast((Action)new Action<Task>(){

            public void execute(Task task) {
                Project project = task.getProject();
                project.exec((Action)new Action<ExecSpec>(){

                    public void execute(ExecSpec execSpec) {
                        execSpec.setCommandLine(new Object[]{"git", "add", "."});
                        File cachedVersionDir = installCacheTask.getCacheDestinationDir();
                        execSpec.setWorkingDir((Object)cachedVersionDir.getParentFile());
                    }
                });
            }
        });
        task.doLast((Action)new Action<Task>(){

            public void execute(Task task) {
                Project project = task.getProject();
                final String commitSubject = LiferayOSGiDefaultsPlugin.this.getGitResult(project, "log", "-1", "--pretty=%s");
                project.exec((Action)new Action<ExecSpec>(){

                    public void execute(ExecSpec execSpec) {
                        String message = LiferayOSGiDefaultsPlugin._CACHE_COMMIT_MESSAGE;
                        int index = commitSubject.indexOf(32);
                        if (index != -1) {
                            message = commitSubject.substring(0, index + 1) + LiferayOSGiDefaultsPlugin._CACHE_COMMIT_MESSAGE;
                        }
                        execSpec.setCommandLine(new Object[]{"git", "commit", "-m", message});
                    }
                });
            }
        });
        task.setDescription("Installs and commits the project to the local Gradle cache for testing.");
        task.setGroup("upload");
        return task;
    }

    protected Copy addTaskCopyLibs(Project project) {
        Copy copy = (Copy)GradleUtil.addTask((Project)project, (String)COPY_LIBS_TASK_NAME, Copy.class);
        File libDir = this.getLibDir(project);
        copy.eachFile((Action)new ExcludeExistingFileAction(libDir));
        Configuration configuration = GradleUtil.getConfiguration((Project)project, (String)"runtime");
        copy.from(new Object[]{configuration});
        copy.into((Object)libDir);
        copy.rename((Closure)new RenameDependencyClosure(project, new String[]{configuration.getName()}));
        copy.setEnabled(false);
        Task classesTask = GradleUtil.getTask((Project)project, (String)"classes");
        classesTask.dependsOn(new Object[]{copy});
        return copy;
    }

    protected InstallCacheTask addTaskInstallCache(final Project project) {
        InstallCacheTask installCacheTask = (InstallCacheTask)GradleUtil.addTask((Project)project, (String)INSTALL_CACHE_TASK_NAME, InstallCacheTask.class);
        installCacheTask.dependsOn(new Object[]{"clean" + StringUtil.capitalize((String)installCacheTask.getName()), "install"});
        installCacheTask.doFirst((Action)new Action<Task>(){

            public void execute(Task task) {
                String result = LiferayOSGiDefaultsPlugin.this.getGitResult(task.getProject(), "status", "--porcelain", ".");
                if (Validator.isNotNull((String)result)) {
                    throw new GradleException("Unable to install project to the local Gradle cache, commit changes first");
                }
            }
        });
        installCacheTask.setArtifactGroup(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return project.getGroup();
            }
        });
        installCacheTask.setArtifactName(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return GradleUtil.getArchivesBaseName(project);
            }
        });
        installCacheTask.setArtifactVersion(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return project.getVersion();
            }
        });
        installCacheTask.setDescription("Installs the project to the local Gradle cache for testing.");
        installCacheTask.setGroup("upload");
        GradleUtil.setProperty((ExtensionAware)installCacheTask, (String)"autoClean", (Object)false);
        return installCacheTask;
    }

    protected Jar addTaskJarJavadoc(Project project) {
        Jar jar = (Jar)GradleUtil.addTask((Project)project, (String)JAR_JAVADOC_TASK_NAME, Jar.class);
        jar.setClassifier("javadoc");
        jar.setDescription("Assembles a jar archive containing the Javadoc files for this project.");
        jar.setGroup("build");
        Javadoc javadoc = (Javadoc)GradleUtil.getTask((Project)project, (String)"javadoc");
        jar.from(new Object[]{javadoc});
        return jar;
    }

    protected Jar addTaskJarSources(Project project, boolean testProject) {
        Jar jar = (Jar)GradleUtil.addTask((Project)project, (String)JAR_SOURCES_TASK_NAME, Jar.class);
        jar.setClassifier("sources");
        jar.setGroup("build");
        jar.setDescription("Assembles a jar archive containing the main source files.");
        jar.setDuplicatesStrategy(DuplicatesStrategy.EXCLUDE);
        File docrootDir = project.file((Object)"docroot");
        if (docrootDir.exists()) {
            jar.from(new Object[]{docrootDir});
        } else {
            SourceSet sourceSet = GradleUtil.getSourceSet((Project)project, (String)"main");
            jar.from(new Object[]{sourceSet.getAllSource()});
            if (testProject) {
                sourceSet = GradleUtil.getSourceSet((Project)project, (String)"test");
                jar.from(new Object[]{sourceSet.getAllSource()});
                sourceSet = GradleUtil.getSourceSet((Project)project, (String)"testIntegration");
                jar.from(new Object[]{sourceSet.getAllSource()});
            }
        }
        return jar;
    }

    protected Jar addTaskJarTLDDoc(Project project) {
        Jar jar = (Jar)GradleUtil.addTask((Project)project, (String)JAR_TLDDOC_TASK_NAME, Jar.class);
        jar.setClassifier("taglibdoc");
        jar.setDescription("Assembles a jar archive containing the Tag Library Documentation files for this project.");
        jar.setGroup("build");
        TLDDocTask tlddocTask = (TLDDocTask)GradleUtil.getTask((Project)project, (String)"tlddoc");
        jar.from(new Object[]{tlddocTask});
        return jar;
    }

    protected ReplaceRegexTask addTaskUpdateFileVersions(final Project project) {
        ReplaceRegexTask replaceRegexTask = (ReplaceRegexTask)GradleUtil.addTask((Project)project, (String)UPDATE_FILE_VERSIONS_TASK_NAME, ReplaceRegexTask.class);
        replaceRegexTask.pre(new Closure<String>((Object)project){

            public String doCall(String content, File file) {
                String fileName = file.getName();
                if (!fileName.equals("build.gradle")) {
                    return content;
                }
                String configuration = ProvidedBasePlugin.getPROVIDED_CONFIGURATION_NAME() + " ";
                return content.replaceAll(Pattern.quote(configuration + LiferayOSGiDefaultsPlugin.this.getProjectDependency(project)), Matcher.quoteReplacement(configuration + LiferayOSGiDefaultsPlugin.this.getModuleDependency(project, true)));
            }
        });
        replaceRegexTask.replaceOnlyIf(new Closure<Boolean>((Object)project){

            public Boolean doCall(String group, String replacement, String content) {
                String projectPath = project.getPath();
                if (!(projectPath.startsWith(":apps:") || projectPath.startsWith(":core:") || projectPath.startsWith(":private:") || FileUtil.exists((Project)project.getRootProject(), (String)".gitrepo"))) {
                    return true;
                }
                Version groupVersion = LiferayOSGiDefaultsPlugin.this.getVersion(group);
                Version replacementVersion = LiferayOSGiDefaultsPlugin.this.getVersion(replacement);
                if (groupVersion == null || replacementVersion == null || groupVersion.getMajor() != replacementVersion.getMajor()) {
                    return true;
                }
                return false;
            }
        });
        replaceRegexTask.setDescription("Updates the project version in external files.");
        replaceRegexTask.setReplacement(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return project.getVersion();
            }
        });
        return replaceRegexTask;
    }

    protected ReplaceRegexTask addTaskUpdateVersion(Project project) {
        final ReplaceRegexTask replaceRegexTask = (ReplaceRegexTask)GradleUtil.addTask((Project)project, (String)"updateVersion", ReplaceRegexTask.class);
        replaceRegexTask.match("Bundle-Version: (.+)(?:\\s|$)", "bnd.bnd");
        replaceRegexTask.onlyIf((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                Project project = task.getProject();
                String version = String.valueOf(project.getVersion());
                return !version.contains("LIFERAY-PATCHED-");
            }
        });
        replaceRegexTask.setDescription("Updates the project version in the Bundle-Version header.");
        replaceRegexTask.setReplacement((Object)IncrementVersionClosure.MICRO_INCREMENT);
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                File moduleConfigFile = LiferayOSGiDefaultsPlugin.this.getModuleConfigFile(project);
                if (moduleConfigFile == null || !moduleConfigFile.exists()) {
                    return;
                }
                replaceRegexTask.match("\\n\\t\"version\": \"(.+)\"", moduleConfigFile);
            }
        });
        return replaceRegexTask;
    }

    protected void applyConfigScripts(Project project) {
        GradleUtil.applyScript((Project)project, (String)"com/liferay/gradle/plugins/defaults/dependencies/config-maven.gradle", (Object)project);
    }

    protected void applyPlugins(Project project) {
        GradleUtil.applyPlugin((Project)project, EclipsePlugin.class);
        GradleUtil.applyPlugin((Project)project, FindBugsPlugin.class);
        GradleUtil.applyPlugin((Project)project, IdeaPlugin.class);
        GradleUtil.applyPlugin((Project)project, MavenPlugin.class);
        GradleUtil.applyPlugin((Project)project, OptionalBasePlugin.class);
        GradleUtil.applyPlugin((Project)project, PmdPlugin.class);
        GradleUtil.applyPlugin((Project)project, ProvidedBasePlugin.class);
        if (FileUtil.exists((Project)project, (String)"service.xml")) {
            GradleUtil.applyPlugin((Project)project, ServiceBuilderPlugin.class);
            GradleUtil.applyPlugin((Project)project, UpgradeTableBuilderPlugin.class);
            GradleUtil.applyPlugin((Project)project, WSDDBuilderPlugin.class);
        }
        if (FileUtil.exists((Project)project, (String)"wsdl")) {
            GradleUtil.applyPlugin((Project)project, WSDLBuilderPlugin.class);
        }
        if (FileUtil.exists((Project)project, (String)"xsd")) {
            GradleUtil.applyPlugin((Project)project, XSDBuilderPlugin.class);
        }
    }

    protected void checkVersion(Project project) {
        File moduleConfigFile = this.getModuleConfigFile(project);
        if (moduleConfigFile == null || !moduleConfigFile.exists()) {
            return;
        }
        JsonSlurper jsonSlurper = new JsonSlurper();
        Map moduleConfigMap = (Map)jsonSlurper.parse(moduleConfigFile);
        String moduleConfigVersion = (String)moduleConfigMap.get("version");
        if (Validator.isNotNull((String)moduleConfigVersion) && !moduleConfigVersion.equals(String.valueOf(project.getVersion()))) {
            throw new GradleException("Version in " + project.relativePath((Object)moduleConfigFile) + " must match project version");
        }
    }

    protected void configureArtifacts(Project project, Jar jarJavadocTask, Jar jarSourcesTask, Jar jarTLDDocTask) {
        Task tlddocTask;
        Task javadocTask;
        ArtifactHandler artifactHandler = project.getArtifacts();
        Object spec = new Spec<File>(){

            public boolean isSatisfiedBy(File file) {
                String fileName = file.getName();
                return !fileName.equals("MANIFEST.MF");
            }
        };
        if (FileUtil.hasSourceFiles((Task)jarSourcesTask, spec)) {
            artifactHandler.add("archives", (Object)jarSourcesTask);
        }
        if (FileUtil.hasSourceFiles(javadocTask = GradleUtil.getTask((Project)project, (String)"javadoc"), spec = new Spec<File>(){

            public boolean isSatisfiedBy(File file) {
                String fileName = file.getName();
                return fileName.endsWith(".java");
            }
        })) {
            artifactHandler.add("archives", (Object)jarJavadocTask);
        }
        if (FileUtil.hasSourceFiles(tlddocTask = GradleUtil.getTask((Project)project, (String)"tlddoc"), spec = new Spec<File>(){

            public boolean isSatisfiedBy(File file) {
                String fileName = file.getName();
                return fileName.endsWith(".tld");
            }
        })) {
            artifactHandler.add("archives", (Object)jarTLDDocTask);
        }
    }

    protected void configureBasePlugin(Project project, File portalRootDir) {
        if (portalRootDir == null) {
            return;
        }
        BasePluginConvention basePluginConvention = (BasePluginConvention)GradleUtil.getConvention((Project)project, BasePluginConvention.class);
        File dir = new File(portalRootDir, "tools/sdk/dist");
        String dirName = FileUtil.relativize((File)dir, (File)project.getBuildDir());
        basePluginConvention.setDistsDirName(dirName);
        basePluginConvention.setLibsDirName(dirName);
    }

    protected void configureBundleDefaultInstructions(Project project, File portalRootDir, boolean publishing) {
        File packageJsonFile;
        File appBndFile;
        LiferayOSGiExtension liferayOSGiExtension = (LiferayOSGiExtension)GradleUtil.getExtension((ExtensionAware)project, LiferayOSGiExtension.class);
        HashMap<String, String> bundleDefaultInstructions = new HashMap<String, String>();
        bundleDefaultInstructions.put("-check", "exports");
        bundleDefaultInstructions.put("Bundle-Vendor", "Liferay, Inc.");
        bundleDefaultInstructions.put("-donotcopy", "(.*\\.wsdd|.touch)");
        bundleDefaultInstructions.put("-fixupmessages.deprecated", "annotations are deprecated");
        bundleDefaultInstructions.put("-sources", "false");
        if (publishing) {
            bundleDefaultInstructions.put("Git-Descriptor", "${system-allow-fail;git describe --dirty --always}");
            bundleDefaultInstructions.put("Git-SHA", "${system-allow-fail;git rev-list -1 HEAD}");
        }
        if ((appBndFile = this.getAppBndFile(project, portalRootDir)) != null) {
            bundleDefaultInstructions.put("-include", FileUtil.getRelativePath(project, appBndFile));
        }
        if ((packageJsonFile = project.file((Object)"package.json")).exists()) {
            bundleDefaultInstructions.put("-includeresource.packagejson", FileUtil.getRelativePath(project, packageJsonFile));
        }
        liferayOSGiExtension.bundleDefaultInstructions(bundleDefaultInstructions);
    }

    protected void configureBundleInstructions(Project project) {
        String projectPath = project.getPath();
        if (!(projectPath.startsWith(":apps:") || projectPath.startsWith(":private:") || FileUtil.exists((Project)project.getRootProject(), (String)".gitrepo"))) {
            return;
        }
        Map<String, String> bundleInstructions = this.getBundleInstructions(project);
        String exportPackage = bundleInstructions.get("Export-Package");
        if (Validator.isNull((String)exportPackage)) {
            return;
        }
        exportPackage = "!com.liferay.*.kernel.*," + exportPackage;
        bundleInstructions.put("Export-Package", exportPackage);
    }

    protected void configureConfiguration(Configuration configuration) {
        DependencySet dependencySet = configuration.getDependencies();
        dependencySet.withType(ModuleDependency.class, (Action)new Action<ModuleDependency>(){

            public void execute(ModuleDependency moduleDependency) {
                String name = moduleDependency.getName();
                if (name.equals("com.liferay.arquillian.arquillian-container-liferay") || name.equals("com.liferay.arquillian.extension.junit.bridge") || name.equals("com.liferay.jasper.jspc")) {
                    moduleDependency.exclude(Collections.singletonMap("group", "com.liferay.portal"));
                }
            }
        });
    }

    protected void configureConfigurationDefault(Project project) {
        final Configuration defaultConfiguration = GradleUtil.getConfiguration((Project)project, (String)"default");
        Configuration providedConfiguration = GradleUtil.getConfiguration((Project)project, (String)ProvidedBasePlugin.getPROVIDED_CONFIGURATION_NAME());
        DependencySet dependencySet = providedConfiguration.getDependencies();
        dependencySet.withType(ProjectDependency.class, (Action)new Action<ProjectDependency>(){

            public void execute(ProjectDependency projectDependency) {
                defaultConfiguration.exclude(Collections.singletonMap("module", projectDependency.getName()));
            }
        });
    }

    protected void configureConfigurations(Project project) {
        this.configureConfigurationDefault(project);
        String projectPath = project.getPath();
        if (projectPath.startsWith(":apps:") || projectPath.startsWith(":core:") || projectPath.startsWith(":private:apps:") || projectPath.startsWith(":private:core:") || FileUtil.exists((Project)project.getRootProject(), (String)".gitrepo")) {
            this.configureConfigurationTransitive(project, "compile", false);
        }
        ConfigurationContainer configurationContainer = project.getConfigurations();
        configurationContainer.all((Action)new Action<Configuration>(){

            public void execute(Configuration configuration) {
                LiferayOSGiDefaultsPlugin.this.configureConfiguration(configuration);
            }
        });
    }

    protected void configureConfigurationTransitive(Project project, String name, boolean transitive) {
        Configuration configuration = GradleUtil.getConfiguration((Project)project, (String)name);
        configuration.setTransitive(transitive);
    }

    protected void configureDeployDir(final Project project, final boolean deployToAppServerLibs, final boolean deployToTools) {
        final LiferayExtension liferayExtension = (LiferayExtension)GradleUtil.getExtension((ExtensionAware)project, LiferayExtension.class);
        liferayExtension.setDeployDir((Object)new Callable<File>(){

            @Override
            public File call() throws Exception {
                if (deployToAppServerLibs) {
                    return new File(liferayExtension.getAppServerPortalDir(), "WEB-INF/lib");
                }
                if (deployToTools) {
                    return new File(liferayExtension.getLiferayHome(), "tools/" + project.getName());
                }
                if (FileUtil.exists((Project)project, (String)".lfrbuild-static")) {
                    return new File(liferayExtension.getLiferayHome(), "osgi/static");
                }
                String archivesBaseName = GradleUtil.getArchivesBaseName(project);
                if (archivesBaseName.startsWith("com.liferay.portal.")) {
                    return new File(liferayExtension.getLiferayHome(), "osgi/portal");
                }
                return new File(liferayExtension.getLiferayHome(), "osgi/modules");
            }
        });
    }

    protected void configureEclipse(Project project, Configuration portalTestConfiguration) {
        EclipseModel eclipseModel = (EclipseModel)GradleUtil.getExtension((ExtensionAware)project, EclipseModel.class);
        EclipseClasspath eclipseClasspath = eclipseModel.getClasspath();
        Collection plusConfigurations = eclipseClasspath.getPlusConfigurations();
        plusConfigurations.add(portalTestConfiguration);
    }

    protected void configureIdea(Project project, Configuration portalTestConfiguration) {
        IdeaModel ideaModel = (IdeaModel)GradleUtil.getExtension((ExtensionAware)project, IdeaModel.class);
        IdeaModule ideaModule = ideaModel.getModule();
        Map scopes = ideaModule.getScopes();
        Map testScope = (Map)scopes.get("TEST");
        Collection plusConfigurations = (Collection)testScope.get("plus");
        plusConfigurations.add(portalTestConfiguration);
    }

    protected void configureJavaPlugin(Project project) {
        JavaPluginConvention javaPluginConvention = (JavaPluginConvention)GradleUtil.getConvention((Project)project, JavaPluginConvention.class);
        javaPluginConvention.setSourceCompatibility((Object)_JAVA_VERSION);
        javaPluginConvention.setTargetCompatibility((Object)_JAVA_VERSION);
        File testResultsDir = project.file((Object)"test-results/unit");
        javaPluginConvention.setTestResultsDirName(FileUtil.relativize((File)testResultsDir, (File)project.getBuildDir()));
    }

    protected void configureLocalPortalTool(Project project, File portalRootDir, String configurationName, String portalToolName) {
        if (portalRootDir == null) {
            return;
        }
        Configuration configuration = GradleUtil.getConfiguration((Project)project, (String)configurationName);
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("group", _GROUP);
        args.put("module", portalToolName);
        configuration.exclude(args);
        File dir = new File(portalRootDir, "tools/sdk/dependencies/" + portalToolName + "/lib");
        FileTree fileTree = FileUtil.getJarsFileTree(project, dir, new String[0]);
        GradleUtil.addDependency((Project)project, (String)configuration.getName(), (FileCollection)fileTree);
    }

    protected void configureMavenConf2ScopeMappings(Project project) {
        MavenPluginConvention mavenPluginConvention = (MavenPluginConvention)GradleUtil.getConvention((Project)project, MavenPluginConvention.class);
        Conf2ScopeMappingContainer conf2ScopeMappingContainer = mavenPluginConvention.getConf2ScopeMappings();
        Map mappings = conf2ScopeMappingContainer.getMappings();
        Configuration configuration = GradleUtil.getConfiguration((Project)project, (String)"testCompile");
        mappings.remove(configuration);
        configuration = GradleUtil.getConfiguration((Project)project, (String)"testRuntime");
        mappings.remove(configuration);
    }

    protected void configurePmd(Project project, File portalRootDir) {
        PmdExtension pmdExtension = (PmdExtension)GradleUtil.getExtension((ExtensionAware)project, PmdExtension.class);
        if (portalRootDir != null) {
            File ruleSetFile = new File(portalRootDir, "tools/sdk/dependencies/net.sourceforge.pmd/rulesets/java/standard-rules.xml");
            pmdExtension.setRuleSetFiles((FileCollection)project.files(new Object[]{ruleSetFile}));
        }
        List ruleSets = Collections.emptyList();
        pmdExtension.setRuleSets(ruleSets);
    }

    protected void configureProject(Project project) {
        project.setGroup((Object)_GROUP);
    }

    protected void configureProjectBndProperties(Project project) {
        LiferayExtension liferayExtension = (LiferayExtension)GradleUtil.getExtension((ExtensionAware)project, LiferayExtension.class);
        File appServerPortalDir = liferayExtension.getAppServerPortalDir();
        GradleUtil.setProperty((ExtensionAware)project, (String)"app.server.portal.dir", (Object)project.relativePath((Object)appServerPortalDir));
        File appServerLibPortalDir = new File(appServerPortalDir, "WEB-INF/lib");
        GradleUtil.setProperty((ExtensionAware)project, (String)"app.server.lib.portal.dir", (Object)project.relativePath((Object)appServerLibPortalDir));
    }

    protected void configureSourceSetClassesDir(Project project, SourceSet sourceSet, String classesDirName) {
        SourceSetOutput sourceSetOutput = sourceSet.getOutput();
        if (FileUtil.isChild((File)sourceSetOutput.getClassesDir(), (File)project.getBuildDir())) {
            sourceSetOutput.setClassesDir((Object)classesDirName);
            sourceSetOutput.setResourcesDir((Object)classesDirName);
        }
    }

    protected void configureSourceSetMain(Project project) {
        SourceSet sourceSet = GradleUtil.getSourceSet((Project)project, (String)"main");
        this.configureSourceSetClassesDir(project, sourceSet, "classes");
    }

    protected void configureSourceSetTest(Project project, Configuration portalConfiguration, Configuration portalTestConfiguration) {
        SourceSet sourceSet = GradleUtil.getSourceSet((Project)project, (String)"test");
        this.configureSourceSetClassesDir(project, sourceSet, "test-classes/unit");
        Configuration compileConfiguration = GradleUtil.getConfiguration((Project)project, (String)"compile");
        sourceSet.setCompileClasspath(FileUtil.join(new FileCollection[]{compileConfiguration, portalConfiguration, sourceSet.getCompileClasspath(), portalTestConfiguration}));
        sourceSet.setRuntimeClasspath(FileUtil.join(new FileCollection[]{compileConfiguration, portalConfiguration, sourceSet.getRuntimeClasspath(), portalTestConfiguration}));
    }

    protected void configureSourceSetTestIntegration(Project project, Configuration portalConfiguration, Configuration portalTestConfiguration) {
        SourceSet sourceSet = GradleUtil.getSourceSet((Project)project, (String)"testIntegration");
        this.configureSourceSetClassesDir(project, sourceSet, "test-classes/integration");
        sourceSet.setCompileClasspath(FileUtil.join(new FileCollection[]{portalConfiguration, sourceSet.getCompileClasspath(), portalTestConfiguration}));
        sourceSet.setRuntimeClasspath(FileUtil.join(new FileCollection[]{portalConfiguration, sourceSet.getRuntimeClasspath(), portalTestConfiguration}));
    }

    protected void configureTaskBaseline(BaselineTask baselineTask) {
        Project project = baselineTask.getProject();
        String reportLevel = GradleUtil.getProperty((ExtensionAware)project, (String)"baseline.jar.report.level", (String)"standard");
        boolean reportLevelIsDiff = reportLevel.equals("diff");
        boolean reportLevelIsPersist = reportLevel.equals("persist");
        if (reportLevelIsPersist && FileUtil.exists((Project)project, (String)"bnd.bnd")) {
            baselineTask.setBndFile("bnd.bnd");
        }
        boolean reportDiff = false;
        if (reportLevelIsDiff || reportLevelIsPersist) {
            reportDiff = true;
        }
        baselineTask.setReportDiff(reportDiff);
        boolean reportOnlyDirtyPackages = GradleUtil.getProperty((ExtensionAware)project, (String)"baseline.jar.report.only.dirty.packages", (boolean)true);
        baselineTask.setReportOnlyDirtyPackages(reportOnlyDirtyPackages);
    }

    protected void configureTaskCompileJSP(Project project) {
        Properties artifactProperties;
        String artifactURL;
        boolean jspPrecompileEnabled = GradleUtil.getProperty((ExtensionAware)project, (String)"jsp.precompile.enabled", (boolean)false);
        if (!jspPrecompileEnabled) {
            return;
        }
        JavaCompile javaCompile = (JavaCompile)GradleUtil.getTask((Project)project, (String)"compileJSP");
        String dirName = null;
        TaskContainer taskContainer = project.getTasks();
        WritePropertiesTask recordArtifactTask = (WritePropertiesTask)((Object)taskContainer.findByName("recordArtifact"));
        if (recordArtifactTask != null && Validator.isNotNull((String)(artifactURL = (artifactProperties = LiferayRelengPlugin.getArtifactProperties(recordArtifactTask)).getProperty("artifact.url")))) {
            int index = artifactURL.lastIndexOf(47);
            dirName = artifactURL.substring(index + 1, artifactURL.length() - 4);
        }
        if (Validator.isNull(dirName)) {
            dirName = GradleUtil.getArchivesBaseName(project) + "-" + project.getVersion();
        }
        LiferayExtension liferayExtension = (LiferayExtension)GradleUtil.getExtension((ExtensionAware)project, LiferayExtension.class);
        File dir = new File(liferayExtension.getLiferayHome(), "work/" + dirName);
        javaCompile.setDestinationDir(dir);
    }

    protected void configureTaskFindBugs(FindBugs findBugs) {
        findBugs.setMaxHeapSize("1g");
        FindBugsReports findBugsReports = findBugs.getReports();
        SingleFileReport htmlReport = findBugsReports.getHtml();
        htmlReport.setEnabled(true);
        FindBugsXmlReport xmlReport = findBugsReports.getXml();
        xmlReport.setEnabled(false);
    }

    protected void configureTaskJar(Project project, boolean testProject) {
        Jar jar = (Jar)GradleUtil.getTask((Project)project, (String)"jar");
        if (testProject) {
            jar.dependsOn(new Object[]{"testClasses"});
            SourceSet sourceSet = GradleUtil.getSourceSet((Project)project, (String)"testIntegration");
            jar.dependsOn(new Object[]{sourceSet.getClassesTaskName()});
        }
        jar.setDuplicatesStrategy(DuplicatesStrategy.EXCLUDE);
    }

    protected void configureTaskJarSources(final Jar jarSourcesTask) {
        final Project project = jarSourcesTask.getProject();
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(PatchTask.class, (Action)new Action<PatchTask>(){

            public void execute(final PatchTask patchTask) {
                jarSourcesTask.from((Object)new Callable<FileCollection>(){

                    @Override
                    public FileCollection call() throws Exception {
                        return project.zipTree((Object)patchTask.getOriginalLibSrcFile());
                    }
                }, (Closure)new Closure<Void>((Object)project){

                    public void doCall(CopySpec copySpec) {
                        String originalLibSrcDirName = patchTask.getOriginalLibSrcDirName();
                        if (originalLibSrcDirName.equals(".")) {
                            return;
                        }
                        HashMap<String, String> leadingPathReplacementsMap = new HashMap<String, String>();
                        leadingPathReplacementsMap.put(originalLibSrcDirName, "");
                        copySpec.eachFile((Action)new ReplaceLeadingPathAction(leadingPathReplacementsMap));
                        copySpec.include(new String[]{originalLibSrcDirName + "/"});
                        copySpec.setIncludeEmptyDirs(false);
                    }
                });
                jarSourcesTask.from((Object)new Callable<File>(){

                    @Override
                    public File call() throws Exception {
                        return patchTask.getPatchesDir();
                    }
                }, (Closure)new Closure<Void>((Object)project){

                    public void doCall(CopySpec copySpec) {
                        copySpec.into((Object)"META-INF/patches");
                    }
                });
            }
        });
    }

    protected void configureTaskJavaCompile(JavaCompile javaCompile) {
        CompileOptions compileOptions = javaCompile.getOptions();
        compileOptions.setEncoding(StandardCharsets.UTF_8.name());
        compileOptions.setWarnings(false);
    }

    protected void configureTaskJavadoc(Project project) {
        Javadoc javadoc = (Javadoc)GradleUtil.getTask((Project)project, (String)"javadoc");
        this.configureTaskJavadocFilter(javadoc);
        this.configureTaskJavadocOptions(javadoc);
        JavaVersion javaVersion = JavaVersion.current();
        if (javaVersion.isJava8Compatible()) {
            CoreJavadocOptions coreJavadocOptions = (CoreJavadocOptions)javadoc.getOptions();
            coreJavadocOptions.addStringOption("Xdoclint:none", "-quiet");
        }
    }

    protected void configureTaskJavadocFilter(Javadoc javadoc) {
        String[] exportPackageArray;
        String exportPackage = this.getBundleInstruction(javadoc.getProject(), "Export-Package");
        if (Validator.isNull((String)exportPackage)) {
            javadoc.exclude(new String[]{"**/"});
            return;
        }
        for (String pattern : exportPackageArray = exportPackage.split(",")) {
            int end;
            pattern = pattern.trim();
            boolean excludePattern = false;
            int start = 0;
            if (pattern.startsWith("!")) {
                excludePattern = true;
                start = 1;
            }
            if ((end = pattern.indexOf(59)) == -1) {
                end = pattern.length();
            }
            pattern = pattern.substring(start, end);
            pattern = "**/" + pattern.replace('.', '/');
            pattern = pattern.endsWith("/*") ? pattern.substring(0, pattern.length() - 1) : pattern + "/*";
            if (excludePattern) {
                javadoc.exclude(new String[]{pattern});
                continue;
            }
            javadoc.include(new String[]{pattern});
        }
    }

    protected void configureTaskJavadocOptions(Javadoc javadoc) {
        StandardJavadocDocletOptions standardJavadocDocletOptions = (StandardJavadocDocletOptions)javadoc.getOptions();
        standardJavadocDocletOptions.setEncoding(StandardCharsets.UTF_8.name());
        Project project = javadoc.getProject();
        File overviewFile = null;
        SourceSet sourceSet = GradleUtil.getSourceSet((Project)project, (String)"main");
        SourceDirectorySet sourceDirectorySet = sourceSet.getJava();
        for (File dir : sourceDirectorySet.getSrcDirs()) {
            File file = new File(dir, "overview.html");
            if (!file.exists()) continue;
            overviewFile = file;
            break;
        }
        if (overviewFile != null) {
            standardJavadocDocletOptions.setOverview(project.relativePath(overviewFile));
        }
        standardJavadocDocletOptions.tags(new String[]{"generated"});
    }

    protected void configureTaskPmd(Pmd pmd) {
        pmd.setClasspath(null);
    }

    protected void configureTaskPublishNodeModule(PublishNodeModuleTask publishNodeModuleTask) {
        publishNodeModuleTask.setModuleAuthor((Object)"Nathan Cavanaugh <nathan.cavanaugh@liferay.com> (https://github.com/natecavanaugh)");
        publishNodeModuleTask.setModuleBugsUrl((Object)"https://issues.liferay.com/");
        publishNodeModuleTask.setModuleLicense((Object)"LGPL");
        publishNodeModuleTask.setModuleMain((Object)"package.json");
        publishNodeModuleTask.setModuleRepository((Object)"liferay/liferay-portal");
    }

    protected void configureTasksBaseline(Project project) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(BaselineTask.class, (Action)new Action<BaselineTask>(){

            public void execute(BaselineTask baselineTask) {
                LiferayOSGiDefaultsPlugin.this.configureTaskBaseline(baselineTask);
            }
        });
    }

    protected void configureTasksFindBugs(Project project) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(FindBugs.class, (Action)new Action<FindBugs>(){

            public void execute(FindBugs findBugs) {
                LiferayOSGiDefaultsPlugin.this.configureTaskFindBugs(findBugs);
            }
        });
    }

    protected void configureTasksJavaCompile(Project project) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(JavaCompile.class, (Action)new Action<JavaCompile>(){

            public void execute(JavaCompile javaCompile) {
                LiferayOSGiDefaultsPlugin.this.configureTaskJavaCompile(javaCompile);
            }
        });
    }

    protected void configureTasksPmd(Project project) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(Pmd.class, (Action)new Action<Pmd>(){

            public void execute(Pmd pmd) {
                LiferayOSGiDefaultsPlugin.this.configureTaskPmd(pmd);
            }
        });
    }

    protected void configureTasksPublishNodeModule(Project project) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(PublishNodeModuleTask.class, (Action)new Action<PublishNodeModuleTask>(){

            public void execute(PublishNodeModuleTask publishNodeModuleTask) {
                LiferayOSGiDefaultsPlugin.this.configureTaskPublishNodeModule(publishNodeModuleTask);
            }
        });
    }

    protected void configureTaskTest(Project project) {
        Test test = (Test)GradleUtil.getTask((Project)project, (String)"test");
        this.configureTaskTestIgnoreFailures(test);
        this.configureTaskTestJvmArgs(test, "junit.java.unit.gc");
        this.configureTaskTestLogging(test);
    }

    protected void configureTaskTestIgnoreFailures(Test test) {
        test.setIgnoreFailures(true);
    }

    protected void configureTaskTestIntegration(Project project) {
        Test test = (Test)GradleUtil.getTask((Project)project, (String)"testIntegration");
        this.configureTaskTestIgnoreFailures(test);
        this.configureTaskTestJvmArgs(test, "junit.java.integration.gc");
        this.configureTaskTestLogging(test);
        File resultsDir = project.file((Object)"test-results/integration");
        test.setBinResultsDir(new File(resultsDir, "binary/testIntegration"));
        TestTaskReports testTaskReports = test.getReports();
        JUnitXmlReport jUnitXmlReport = testTaskReports.getJunitXml();
        jUnitXmlReport.setDestination((Object)resultsDir);
    }

    protected void configureTaskTestJvmArgs(Test test, String propertyName) {
        String jvmArgs = GradleUtil.getProperty((ExtensionAware)test.getProject(), (String)propertyName, (String)null);
        if (Validator.isNotNull((String)jvmArgs)) {
            test.jvmArgs((Object[])jvmArgs.split("\\s+"));
        }
    }

    protected void configureTaskTestLogging(Test test) {
        TestLoggingContainer testLoggingContainer = test.getTestLogging();
        testLoggingContainer.setEvents(EnumSet.allOf(TestLogEvent.class));
        testLoggingContainer.setExceptionFormat((Object)TestExceptionFormat.FULL);
        testLoggingContainer.setStackTraceFilters(Collections.emptyList());
    }

    protected void configureTaskTlddoc(Project project, File portalRootDir) {
        if (portalRootDir == null) {
            return;
        }
        TLDDocTask tlddocTask = (TLDDocTask)GradleUtil.getTask((Project)project, (String)"tlddoc");
        File xsltDir = new File(portalRootDir, "tools/styles/taglibs");
        tlddocTask.setXsltDir((Object)xsltDir);
    }

    protected void configureTaskUpdateFileVersions(ReplaceRegexTask updateFileVersionsTask, File portalRootDir) {
        Project project = updateFileVersionsTask.getProject();
        String regex = this.getModuleDependencyRegex(project);
        HashMap<String, Object> args = new HashMap<String, Object>();
        if (portalRootDir == null) {
            portalRootDir = project.getRootDir();
        }
        args.put("dir", portalRootDir);
        args.put("includes", Arrays.asList("**/*.gradle", "**/sdk/*/README.markdown"));
        updateFileVersionsTask.match(regex, project.fileTree(args));
    }

    protected void configureTaskUpdateVersionForCachePlugin(ReplaceRegexTask updateVersionTask) {
        Project project = updateVersionTask.getProject();
        CacheExtension cacheExtension = (CacheExtension)GradleUtil.getExtension((ExtensionAware)project, CacheExtension.class);
        for (TaskCache taskCache : cacheExtension.getTasks()) {
            String regex = "\"" + project.getName() + "@(.+?)\\/";
            HashMap<String, Object> args = new HashMap<String, Object>();
            args.put("dir", taskCache.getCacheDir());
            args.put("includes", Arrays.asList("config.json", "**/*.js"));
            ConfigurableFileTree fileTree = project.fileTree(args);
            updateVersionTask.match(regex, fileTree);
            updateVersionTask.finalizedBy(new Object[]{taskCache.getRefreshDigestTaskName()});
        }
    }

    protected void configureTaskUploadArchives(Project project, ReplaceRegexTask updateFileVersionsTask, ReplaceRegexTask updateVersionTask) {
        if (GradleUtil.isSnapshot(project)) {
            return;
        }
        Task uploadArchivesTask = GradleUtil.getTask((Project)project, (String)"uploadArchives");
        TaskContainer taskContainer = project.getTasks();
        TaskCollection publishNodeModuleTasks = taskContainer.withType(PublishNodeModuleTask.class);
        uploadArchivesTask.dependsOn(new Object[]{publishNodeModuleTasks});
        uploadArchivesTask.finalizedBy(new Object[]{updateFileVersionsTask, updateVersionTask});
    }

    protected void forceProjectDependenciesEvaluation(Project project) {
        GradleInternal gradleInternal = (GradleInternal)project.getGradle();
        ServiceRegistry serviceRegistry = gradleInternal.getServices();
        final ProjectConfigurer projectConfigurer = (ProjectConfigurer)serviceRegistry.get(ProjectConfigurer.class);
        EclipseModel eclipseModel = (EclipseModel)GradleUtil.getExtension((ExtensionAware)project, EclipseModel.class);
        EclipseClasspath eclipseClasspath = eclipseModel.getClasspath();
        for (Configuration configuration : eclipseClasspath.getPlusConfigurations()) {
            DependencySet dependencySet = configuration.getAllDependencies();
            dependencySet.withType(ProjectDependency.class, (Action)new Action<ProjectDependency>(){

                public void execute(ProjectDependency projectDependency) {
                    Project dependencyProject = projectDependency.getDependencyProject();
                    projectConfigurer.configure((ProjectInternal)dependencyProject);
                }
            });
        }
    }

    protected File getAppBndFile(Project project, File portalRootDir) {
        File dir = GradleUtil.getRootDir(project, _APP_BND_FILE_NAME);
        if (dir != null) {
            return new File(dir, _APP_BND_FILE_NAME);
        }
        File modulesDir = new File(portalRootDir, "modules");
        File modulesPrivateDir = new File(modulesDir, "private");
        if (!FileUtil.isChild((File)project.getProjectDir(), (File)modulesPrivateDir)) {
            return null;
        }
        String path = FileUtil.relativize((File)project.getProjectDir(), (File)modulesPrivateDir);
        if (File.pathSeparatorChar != '/') {
            path = path.replace(File.pathSeparatorChar, '/');
        }
        File file;
        while (!(file = new File(modulesDir, path + "/" + _APP_BND_FILE_NAME)).exists()) {
            int index = path.lastIndexOf(47);
            if (index == -1) {
                return null;
            }
            path = path.substring(0, index);
        }
        return file;
    }

    protected String getBundleInstruction(Project project, String key) {
        Map<String, String> bundleInstructions = this.getBundleInstructions(project);
        return bundleInstructions.get(key);
    }

    protected Map<String, String> getBundleInstructions(Project project) {
        BundleExtension bundleExtension = (BundleExtension)GradleUtil.getExtension((ExtensionAware)project, BundleExtension.class);
        return (Map)bundleExtension.getInstructions();
    }

    protected String getGitResult(Project project, final Object ... args) {
        final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        project.exec((Action)new Action<ExecSpec>(){

            public void execute(ExecSpec execSpec) {
                execSpec.args(args);
                execSpec.setExecutable((Object)"git");
                execSpec.setStandardOutput((OutputStream)byteArrayOutputStream);
            }
        });
        String result = byteArrayOutputStream.toString();
        return result.trim();
    }

    protected File getLibDir(Project project) {
        File docrootDir = project.file((Object)"docroot");
        if (docrootDir.exists()) {
            return new File(docrootDir, "WEB-INF/lib");
        }
        return project.file((Object)"lib");
    }

    protected File getModuleConfigFile(Project project) {
        if (!GradleUtil.hasPlugin(project, JSModuleConfigGeneratorPlugin.class)) {
            return null;
        }
        ConfigJSModulesTask configJSModulesTask = (ConfigJSModulesTask)GradleUtil.getTask((Project)project, (String)"configJSModules");
        return configJSModulesTask.getModuleConfigFile();
    }

    protected String getModuleDependency(Project project, boolean roundToMinorVersion) {
        Version version;
        StringBuilder sb = new StringBuilder();
        sb.append("group: \"");
        sb.append(project.getGroup());
        sb.append("\", name: \"");
        sb.append(GradleUtil.getArchivesBaseName(project));
        sb.append("\", version: \"");
        String versionString = String.valueOf(project.getVersion());
        if (roundToMinorVersion && (version = this.getVersion(versionString)) != null) {
            version = new Version(version.getMajor(), version.getMinor(), 0);
            versionString = version.toString();
        }
        sb.append(versionString);
        sb.append('\"');
        return sb.toString();
    }

    protected String getModuleDependencyRegex(Project project) {
        StringBuilder sb = new StringBuilder();
        sb.append("group: \"");
        sb.append(project.getGroup());
        sb.append("\", name: \"");
        sb.append(GradleUtil.getArchivesBaseName(project));
        sb.append("\", version: \"");
        return Pattern.quote(sb.toString()) + "(\\d.+)\"";
    }

    protected String getProjectDependency(Project project) {
        return "project(\"" + project.getPath() + "\")";
    }

    protected Version getVersion(Object version) {
        try {
            return Version.parseVersion((String)String.valueOf(version));
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
    }

    protected boolean hasBaseline(Project project) {
        Version version = this.getVersion(project.getVersion());
        return version != null && version.compareTo(_LOWEST_BASELINE_VERSION) > 0;
    }

    protected boolean hasTests(Project project) {
        SourceSet sourceSet = GradleUtil.getSourceSet((Project)project, (String)"test");
        SourceDirectorySet sourceDirectorySet = sourceSet.getAllSource();
        if (!sourceDirectorySet.isEmpty()) {
            return true;
        }
        sourceSet = GradleUtil.getSourceSet((Project)project, (String)"testIntegration");
        sourceDirectorySet = sourceSet.getAllSource();
        return !sourceDirectorySet.isEmpty();
    }

    protected boolean isPublishing(Project project) {
        Gradle gradle = project.getGradle();
        StartParameter startParameter = gradle.getStartParameter();
        List taskNames = startParameter.getTaskNames();
        return taskNames.contains("install") || taskNames.contains("uploadArchives");
    }

    private void _configureConfigurationNoCache(Configuration configuration) {
        ResolutionStrategy resolutionStrategy = configuration.getResolutionStrategy();
        resolutionStrategy.cacheChangingModulesFor(0, TimeUnit.SECONDS);
        resolutionStrategy.cacheDynamicVersionsFor(0, TimeUnit.SECONDS);
    }

    private void _configureTasksEnabledIfStaleSnapshot(Project project, String ... taskNames) {
        boolean snapshotIfStale = false;
        if (project.hasProperty(SNAPSHOT_IF_STALE_PROPERTY_NAME)) {
            snapshotIfStale = GradleUtil.getProperty((ExtensionAware)project, (String)SNAPSHOT_IF_STALE_PROPERTY_NAME, (boolean)true);
        }
        if (!snapshotIfStale || this._isSnapshotStale(project)) {
            return;
        }
        for (String taskName : taskNames) {
            Task task = GradleUtil.getTask((Project)project, (String)taskName);
            task.setDependsOn(Collections.emptySet());
            task.setEnabled(false);
            task.setFinalizedBy(Collections.emptySet());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long _getArtifactLastModifiedTime(Project project) {
        DependencyHandler dependencyHandler = project.getDependencies();
        HashMap<String, Object> dependencyNotation = new HashMap<String, Object>();
        dependencyNotation.put("group", project.getGroup());
        dependencyNotation.put("name", GradleUtil.getArchivesBaseName(project));
        dependencyNotation.put("version", "latest.integration");
        Dependency dependency = dependencyHandler.create(dependencyNotation);
        ConfigurationContainer configurationContainer = project.getConfigurations();
        Configuration configuration = configurationContainer.detachedConfiguration(new Dependency[]{dependency});
        this._configureConfigurationNoCache(configuration);
        File file = (File)CollectionUtils.single((Iterable)configuration.resolve());
        if (GradleUtil.isFromMavenLocal(project, file)) {
            throw new GradleException("Please delete " + file.getParent() + " and try again");
        }
        try (JarFile jarFile = new JarFile(file);){
            Manifest manifest = jarFile.getManifest();
            Attributes attributes = manifest.getMainAttributes();
            String lastModified = attributes.getValue("Bnd-LastModified");
            long l = Long.valueOf(lastModified);
            return l;
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
    }

    private boolean _isSnapshotStale(Project project) {
        String[] lines;
        Logger logger = project.getLogger();
        try {
            long lastModifiedTime = this._getArtifactLastModifiedTime(project);
        }
        catch (ResolveException re) {
            if (logger.isInfoEnabled()) {
                logger.info("Unable to get artifact last modified time for " + project + ", a new snapshot will be published", (Throwable)re);
            }
            return true;
        }
        String result = GitUtil.getGitResult(project, "log", "--format=%s", "--since=" + (lastModifiedTime /= 1000L), ".");
        for (String line : lines = result.split("\\r?\\n")) {
            if (logger.isInfoEnabled()) {
                logger.info(line);
            }
            if (Validator.isNull((String)line) || line.contains("artifact:ignore")) continue;
            return true;
        }
        return false;
    }
}

