/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.defaults.internal;

import com.liferay.gradle.plugins.cache.CacheExtension;
import com.liferay.gradle.plugins.cache.CachePlugin;
import com.liferay.gradle.plugins.cache.WriteDigestTask;
import com.liferay.gradle.plugins.cache.task.TaskCache;
import com.liferay.gradle.plugins.change.log.builder.BuildChangeLogTask;
import com.liferay.gradle.plugins.change.log.builder.ChangeLogBuilderPlugin;
import com.liferay.gradle.plugins.defaults.LiferayOSGiDefaultsPlugin;
import com.liferay.gradle.plugins.defaults.LiferayThemeDefaultsPlugin;
import com.liferay.gradle.plugins.defaults.internal.util.FileUtil;
import com.liferay.gradle.plugins.defaults.internal.util.GradleUtil;
import com.liferay.gradle.plugins.defaults.tasks.PrintArtifactPublishCommandsTask;
import com.liferay.gradle.plugins.defaults.tasks.ReplaceRegexTask;
import com.liferay.gradle.plugins.defaults.tasks.WritePropertiesTask;
import com.liferay.gradle.util.Validator;
import groovy.lang.Closure;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.PublishArtifactSet;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.maven.MavenDeployer;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.artifacts.publish.ArchivePublishArtifact;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.MavenPlugin;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.Upload;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.process.ExecSpec;

public class LiferayRelengPlugin
implements Plugin<Project> {
    public static final String PRINT_ARTIFACT_PUBLISH_COMMANDS = "printArtifactPublishCommands";
    public static final String PRINT_STALE_ARTIFACT_TASK_NAME = "printStaleArtifact";
    public static final String RECORD_ARTIFACT_TASK_NAME = "recordArtifact";
    public static final String UPDATE_VERSION_TASK_NAME = "updateVersion";

    public static Properties getArtifactProperties(WritePropertiesTask recordArtifactTask) {
        try {
            return FileUtil.readProperties((File)recordArtifactTask.getOutputFile());
        }
        catch (IOException ioe) {
            throw new GradleException("Unable to read artifact properties", (Throwable)ioe);
        }
    }

    public static File getRelengDir(Project project) {
        File rootDir = GradleUtil.getRootDir(project.getRootProject(), ".releng");
        if (rootDir == null) {
            return null;
        }
        File relengDir = new File(rootDir, ".releng");
        return new File(relengDir, FileUtil.relativize((File)project.getProjectDir(), (File)rootDir));
    }

    public void apply(final Project project) {
        File relengDir = LiferayRelengPlugin.getRelengDir(project);
        if (relengDir == null) {
            return;
        }
        GradleUtil.applyPlugin((Project)project, ChangeLogBuilderPlugin.class);
        GradleUtil.applyPlugin((Project)project, MavenPlugin.class);
        final BuildChangeLogTask buildChangeLogTask = (BuildChangeLogTask)GradleUtil.getTask((Project)project, (String)"buildChangeLog");
        WritePropertiesTask recordArtifactTask = this.addTaskRecordArtifact(project, relengDir);
        this.addTaskPrintArtifactPublishCommands(project, recordArtifactTask);
        this.addTaskPrintStaleArtifact(project, recordArtifactTask);
        this.configureTaskBuildChangeLog(buildChangeLogTask, relengDir);
        this.configureTaskUploadArchives(project, (Task)recordArtifactTask);
        GradleUtil.withPlugin(project, JavaPlugin.class, new Action<JavaPlugin>(){

            public void execute(JavaPlugin javaPlugin) {
                LiferayRelengPlugin.this.configureTaskProcessResources(project, buildChangeLogTask);
            }
        });
    }

    protected PrintArtifactPublishCommandsTask addTaskPrintArtifactPublishCommands(Project project, final WritePropertiesTask recordArtifactTask) {
        final PrintArtifactPublishCommandsTask printArtifactPublishCommandsTask = (PrintArtifactPublishCommandsTask)GradleUtil.addTask((Project)project, (String)PRINT_ARTIFACT_PUBLISH_COMMANDS, PrintArtifactPublishCommandsTask.class);
        printArtifactPublishCommandsTask.setArtifactPropertiesFile(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return recordArtifactTask.getOutputFile();
            }
        });
        printArtifactPublishCommandsTask.setDescription("Prints the artifact publish commands if this project has been changed since the last publish.");
        this.configureTaskEnabledIfStale((Task)printArtifactPublishCommandsTask, recordArtifactTask);
        String projectPath = project.getPath();
        if (projectPath.startsWith(":apps:") || projectPath.startsWith(":private:apps:")) {
            this.configureTaskEnabledIfLeaf((Task)printArtifactPublishCommandsTask);
        }
        GradleUtil.withPlugin(project, LiferayOSGiDefaultsPlugin.class, new Action<LiferayOSGiDefaultsPlugin>(){

            public void execute(LiferayOSGiDefaultsPlugin liferayOSGiDefaultsPlugin) {
                LiferayRelengPlugin.this.configureTaskPrintArtifactPublishCommandsForOSGi(printArtifactPublishCommandsTask);
            }
        });
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                TaskContainer taskContainer = project.getTasks();
                Task task = (Task)taskContainer.findByName(LiferayRelengPlugin.UPDATE_VERSION_TASK_NAME);
                if (task instanceof ReplaceRegexTask) {
                    ReplaceRegexTask replaceRegexTask = (ReplaceRegexTask)task;
                    Map<String, FileCollection> matches = replaceRegexTask.getMatches();
                    printArtifactPublishCommandsTask.prepNextFiles(matches.values());
                }
                if (GradleUtil.hasPlugin(project, CachePlugin.class)) {
                    CacheExtension cacheExtension = (CacheExtension)GradleUtil.getExtension((ExtensionAware)project, CacheExtension.class);
                    for (TaskCache taskCache : cacheExtension.getTasks()) {
                        printArtifactPublishCommandsTask.prepNextFiles(new File(taskCache.getCacheDir(), ".digest"));
                    }
                }
                if (GradleUtil.hasPlugin(project, LiferayThemeDefaultsPlugin.class)) {
                    WriteDigestTask writeDigestTask = (WriteDigestTask)GradleUtil.getTask((Project)project, (String)"writeParentThemesDigest");
                    printArtifactPublishCommandsTask.prepNextFiles(writeDigestTask.getDigestFile());
                }
            }
        });
        return printArtifactPublishCommandsTask;
    }

    protected Task addTaskPrintStaleArtifact(Project project, WritePropertiesTask recordArtifactTask) {
        final Task task = project.task(PRINT_STALE_ARTIFACT_TASK_NAME);
        task.doLast((Action)new Action<Task>(){

            public void execute(Task task) {
                Project project = task.getProject();
                File projectDir = project.getProjectDir();
                System.out.println(projectDir.getAbsolutePath());
            }
        });
        task.setDescription("Prints the project directory if this project has been changed since the last publish.");
        task.setGroup("verification");
        this.configureTaskEnabledIfStale(task, recordArtifactTask);
        GradleUtil.withPlugin(project, LiferayOSGiDefaultsPlugin.class, new Action<LiferayOSGiDefaultsPlugin>(){

            public void execute(LiferayOSGiDefaultsPlugin liferayOSGiDefaultsPlugin) {
                LiferayRelengPlugin.this.configureTaskPrintStaleArtifactForOSGi(task);
            }
        });
        return task;
    }

    protected WritePropertiesTask addTaskRecordArtifact(Project project, File destinationDir) {
        final WritePropertiesTask writePropertiesTask = (WritePropertiesTask)GradleUtil.addTask((Project)project, (String)RECORD_ARTIFACT_TASK_NAME, WritePropertiesTask.class);
        writePropertiesTask.property("artifact.git.id", new Callable<String>(){

            @Override
            public String call() throws Exception {
                return LiferayRelengPlugin.this.getGitResult(writePropertiesTask.getProject(), "rev-parse", "HEAD");
            }
        });
        writePropertiesTask.setDescription("Records the commit ID and the artifact URLs.");
        writePropertiesTask.setOutputFile(new File(destinationDir, "artifact.properties"));
        Configuration configuration = GradleUtil.getConfiguration((Project)project, (String)"archives");
        PublishArtifactSet publishArtifactSet = configuration.getArtifacts();
        Action<PublishArtifact> action = new Action<PublishArtifact>(){

            public void execute(final PublishArtifact publishArtifact) {
                String key = publishArtifact.getClassifier();
                key = Validator.isNull((String)key) ? "artifact.url" : "artifact." + key + ".url";
                writePropertiesTask.property(key, new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        if (publishArtifact instanceof ArchivePublishArtifact) {
                            ArchivePublishArtifact archivePublishArtifact = (ArchivePublishArtifact)publishArtifact;
                            return LiferayRelengPlugin.this.getArtifactRemoteURL(archivePublishArtifact.getArchiveTask(), false);
                        }
                        Project project = writePropertiesTask.getProject();
                        return LiferayRelengPlugin.this.getArtifactRemoteURL(project, publishArtifact.getName(), String.valueOf(project.getVersion()), publishArtifact.getExtension(), false);
                    }
                });
            }
        };
        publishArtifactSet.all((Action)action);
        return writePropertiesTask;
    }

    protected void configureTaskBuildChangeLog(BuildChangeLogTask buildChangeLogTask, File destinationDir) {
        buildChangeLogTask.setChangeLogFile((Object)new File(destinationDir, "liferay-releng.changelog"));
    }

    protected void configureTaskEnabledIfLeaf(Task task) {
        task.onlyIf((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                Project project = task.getProject();
                for (Configuration configuration : project.getConfigurations()) {
                    if (!this._hasProjectDependencies(configuration)) continue;
                    return false;
                }
                return true;
            }

            private boolean _hasProjectDependencies(Configuration configuration) {
                for (Dependency dependency : configuration.getDependencies()) {
                    if (!(dependency instanceof ProjectDependency)) continue;
                    return true;
                }
                return false;
            }
        });
    }

    protected void configureTaskEnabledIfRelease(Task task) {
        task.onlyIf((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                Project project = task.getProject();
                return GradleUtil.hasStartParameterTask(project, task.getName()) || !GradleUtil.isSnapshot(project);
            }
        });
    }

    protected void configureTaskEnabledIfStale(Task task, final WritePropertiesTask recordArtifactTask) {
        String force = GradleUtil.getTaskPrefixedProperty((Task)task, (String)"force");
        if (Boolean.parseBoolean(force)) {
            return;
        }
        task.onlyIf((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                return !FileUtil.exists((Project)task.getProject(), (String)".lfrbuild-releng-ignore");
            }
        });
        task.onlyIf((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                Properties artifactProperties = LiferayRelengPlugin.getArtifactProperties(recordArtifactTask);
                return LiferayRelengPlugin.this.isStale(recordArtifactTask.getProject(), artifactProperties);
            }
        });
    }

    protected void configureTaskPrintArtifactPublishCommandsForOSGi(PrintArtifactPublishCommandsTask printArtifactPublishCommandsTask) {
        Project project = printArtifactPublishCommandsTask.getProject();
        if (LiferayOSGiDefaultsPlugin.isTestProject(project)) {
            printArtifactPublishCommandsTask.setEnabled(false);
        }
        printArtifactPublishCommandsTask.setFirstPublishExcludedTaskName("updateFileVersions");
    }

    protected void configureTaskPrintStaleArtifactForOSGi(Task task) {
        if (LiferayOSGiDefaultsPlugin.isTestProject(task.getProject())) {
            task.setEnabled(false);
        }
    }

    protected void configureTaskProcessResources(Project project, final BuildChangeLogTask buildChangeLogTask) {
        Copy copy = (Copy)GradleUtil.getTask((Project)project, (String)"processResources");
        copy.from((Object)new Callable<File>(){

            @Override
            public File call() throws Exception {
                return buildChangeLogTask.getChangeLogFile();
            }
        }, (Closure)new Closure<Void>((Object)project){

            public void doCall(CopySpec copySpec) {
                copySpec.into((Object)"META-INF");
            }
        });
    }

    protected void configureTaskUploadArchives(Project project, Task recordArtifactTask) {
        Task uploadArchivesTask = GradleUtil.getTask((Project)project, (String)"uploadArchives");
        uploadArchivesTask.dependsOn(new Object[]{recordArtifactTask});
        this.configureTaskEnabledIfRelease(recordArtifactTask);
    }

    protected StringBuilder getArtifactRemoteBaseURL(Project project, boolean cdn) throws Exception {
        StringBuilder sb;
        Upload upload = (Upload)GradleUtil.getTask((Project)project, (String)"uploadArchives");
        RepositoryHandler repositoryHandler = upload.getRepositories();
        MavenDeployer mavenDeployer = (MavenDeployer)repositoryHandler.getAt("mavenDeployer");
        Object repository = mavenDeployer.getRepository();
        Class<?> repositoryClass = repository.getClass();
        Method getUrlMethod = repositoryClass.getMethod("getUrl", new Class[0]);
        String url = (String)getUrlMethod.invoke(repository, new Object[0]);
        if (cdn) {
            url = url.replace("http://", "http://cdn.");
            url = url.replace("https://", "https://cdn.");
        }
        if ((sb = new StringBuilder(url)).charAt(sb.length() - 1) != '/') {
            sb.append('/');
        }
        String group = String.valueOf(project.getGroup());
        sb.append(group.replace('.', '/'));
        sb.append('/');
        return sb;
    }

    protected String getArtifactRemoteURL(AbstractArchiveTask abstractArchiveTask, boolean cdn) throws Exception {
        StringBuilder sb = this.getArtifactRemoteBaseURL(abstractArchiveTask.getProject(), cdn);
        sb.append(abstractArchiveTask.getBaseName());
        sb.append('/');
        sb.append(abstractArchiveTask.getVersion());
        sb.append('/');
        sb.append(abstractArchiveTask.getArchiveName());
        return sb.toString();
    }

    protected String getArtifactRemoteURL(Project project, String name, String version, String extension, boolean cdn) throws Exception {
        StringBuilder sb = this.getArtifactRemoteBaseURL(project, cdn);
        sb.append(name);
        sb.append('/');
        sb.append(version);
        sb.append('/');
        sb.append(name);
        sb.append('-');
        sb.append(version);
        sb.append('.');
        sb.append(extension);
        return sb.toString();
    }

    protected String getGitResult(Project project, final Object ... args) {
        final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        project.exec((Action)new Action<ExecSpec>(){

            public void execute(ExecSpec execSpec) {
                execSpec.args(args);
                execSpec.setExecutable((Object)"git");
                execSpec.setStandardOutput((OutputStream)byteArrayOutputStream);
            }
        });
        String result = byteArrayOutputStream.toString();
        return result.trim();
    }

    protected boolean isStale(Project project, Properties artifactProperties) {
        String[] lines;
        Logger logger = project.getLogger();
        String artifactGitId = artifactProperties.getProperty("artifact.git.id");
        if (Validator.isNull((String)artifactGitId)) {
            if (logger.isInfoEnabled()) {
                logger.info("{} has never been published", (Object)project);
            }
            return true;
        }
        String result = this.getGitResult(project, "log", "--format=%s", artifactGitId + "..HEAD", ".");
        for (String line : lines = result.split("\\r?\\n")) {
            if (logger.isInfoEnabled()) {
                logger.info(line);
            }
            if (Validator.isNull((String)line) || line.contains("artifact:ignore")) continue;
            return true;
        }
        if (GradleUtil.hasPlugin(project, LiferayThemeDefaultsPlugin.class)) {
            WriteDigestTask writeDigestTask = (WriteDigestTask)GradleUtil.getTask((Project)project, (String)"writeParentThemesDigest");
            String digest = writeDigestTask.getDigest();
            String oldDigest = writeDigestTask.getOldDigest();
            if (logger.isInfoEnabled()) {
                logger.info("Digest for {} is {}, old digest is {}", new Object[]{writeDigestTask, digest, oldDigest});
            }
            if (!Objects.equals(digest, oldDigest)) {
                return true;
            }
        }
        return false;
    }
}

