/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.db.support.task;

import com.liferay.gradle.plugins.db.support.internal.util.GradleUtil;
import com.liferay.gradle.plugins.db.support.task.BaseDBSupportTask;
import com.liferay.gradle.util.FileUtil;
import java.io.File;
import java.util.List;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;

@CacheableTask
public class CleanServiceBuilderTask
extends BaseDBSupportTask {
    private Object _serviceXmlFile;
    private Object _servletContextName;

    @Override
    public String getCommand() {
        return "clean-service-builder";
    }

    @InputFile
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public File getServiceXmlFile() {
        return GradleUtil.toFile(this.getProject(), this._serviceXmlFile);
    }

    @Input
    public String getServletContextName() {
        return GradleUtil.toString((Object)this._servletContextName);
    }

    public void setServiceXmlFile(Object serviceXmlFile) {
        this._serviceXmlFile = serviceXmlFile;
    }

    public void setServletContextName(Object servletContextName) {
        this._servletContextName = servletContextName;
    }

    @Override
    @Internal
    protected List<String> getCompleteArgs() {
        List<String> completeArgs = super.getCompleteArgs();
        completeArgs.add("--service-xml-file");
        completeArgs.add(FileUtil.getAbsolutePath((File)this.getServiceXmlFile()));
        completeArgs.add("--servlet-context-name");
        completeArgs.add(this.getServletContextName());
        return completeArgs;
    }
}

