/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.css.builder;

import com.liferay.gradle.util.FileUtil;
import com.liferay.gradle.util.GradleUtil;
import com.liferay.gradle.util.Validator;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectories;
import org.gradle.api.tasks.OutputFiles;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.util.CollectionUtils;
import org.gradle.util.GUtil;

public class BuildCSSTask
extends JavaExec {
    private boolean _appendCssImportTimestamps = true;
    private final Set<Object> _dirNames = new LinkedHashSet<Object>();
    private Object _docrootDir;
    private boolean _generateSourceMap;
    private Object _outputDirName = ".sass-cache/";
    private Object _portalCommonDir;
    private Object _portalCommonFile;
    private Object _precision = 9;
    private final Set<Object> _rtlExcludedPathRegexps = new LinkedHashSet<Object>();
    private Object _sassCompilerClassName;

    public BuildCSSTask() {
        this.setDefaultCharacterEncoding(StandardCharsets.UTF_8.toString());
        this.setDirNames("/");
        this.setMain("com.liferay.css.builder.CSSBuilder");
    }

    public BuildCSSTask dirNames(Iterable<Object> dirNames) {
        GUtil.addToCollection(this._dirNames, (Iterable[])new Iterable[]{dirNames});
        return this;
    }

    public BuildCSSTask dirNames(Object ... dirNames) {
        return this.dirNames(Arrays.asList(dirNames));
    }

    public void exec() {
        this.setArgs(this._getCompleteArgs());
        super.exec();
    }

    @InputFiles
    @SkipWhenEmpty
    public FileCollection getCSSFiles() {
        Project project = this.getProject();
        List<String> dirNames = this.getDirNames();
        File docrootDir = this.getDocrootDir();
        if (dirNames.isEmpty() || docrootDir == null) {
            return project.files(new Object[0]);
        }
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("dir", docrootDir);
        args.put("exclude", "**/" + this._addTrailingSlash(this.getOutputDirName()));
        for (String dirName : dirNames) {
            if ((dirName = dirName.replace('\\', '/')).equals("/")) {
                dirName = "";
            } else {
                dirName = this._removeLeadingSlash(dirName);
                dirName = this._removeTrailingSlash(dirName);
                dirName = dirName + "/";
            }
            ArrayList<String> includes = new ArrayList<String>(2);
            includes.add(dirName + "**/*.css");
            includes.add(dirName + "**/*.scss");
            args.put("includes", includes);
        }
        return project.fileTree(args);
    }

    public List<String> getDirNames() {
        return GradleUtil.toStringList(this._dirNames);
    }

    public File getDocrootDir() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._docrootDir);
    }

    @Input
    public String getOutputDirName() {
        return GradleUtil.toString((Object)this._outputDirName);
    }

    @OutputDirectories
    public FileCollection getOutputDirs() {
        Project project = this.getProject();
        HashSet<File> outputDirs = new HashSet<File>();
        FileCollection cssFiles = this.getCSSFiles();
        String outputDirName = this._removeTrailingSlash(this.getOutputDirName());
        for (File cssFile : cssFiles) {
            File outputDir = project.file((Object)(cssFile + "/../" + outputDirName));
            outputDirs.add(outputDir);
        }
        return project.files(new Object[]{outputDirs});
    }

    @InputDirectory
    @Optional
    public File getPortalCommonDir() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._portalCommonDir);
    }

    @InputFile
    @Optional
    public File getPortalCommonFile() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._portalCommonFile);
    }

    @Input
    public File getPortalCommonPath() {
        File portalCommonPath = this.getPortalCommonDir();
        if (portalCommonPath == null) {
            portalCommonPath = this.getPortalCommonFile();
        }
        return portalCommonPath;
    }

    @Input
    public int getPrecision() {
        return GradleUtil.toInteger((Object)this._precision);
    }

    @Input
    public List<String> getRtlExcludedPathRegexps() {
        return GradleUtil.toStringList(this._rtlExcludedPathRegexps);
    }

    @Input
    @Optional
    public String getSassCompilerClassName() {
        return GradleUtil.toString((Object)this._sassCompilerClassName);
    }

    @OutputFiles
    public FileCollection getSourceMapFiles() {
        Project project = this.getProject();
        ArrayList<File> sourceMapFiles = new ArrayList<File>();
        if (this.isGenerateSourceMap()) {
            FileCollection cssFiles = this.getCSSFiles();
            for (File cssFile : cssFiles) {
                File sourceMapFile = project.file((Object)(cssFile + ".map"));
                sourceMapFiles.add(sourceMapFile);
            }
        }
        return project.files(new Object[]{sourceMapFiles});
    }

    @Input
    public boolean isAppendCssImportTimestamps() {
        return this._appendCssImportTimestamps;
    }

    @Input
    public boolean isGenerateSourceMap() {
        return this._generateSourceMap;
    }

    public BuildCSSTask rtlExcludedPathRegexps(Iterable<Object> rtlExcludedPathRegexps) {
        GUtil.addToCollection(this._rtlExcludedPathRegexps, (Iterable[])new Iterable[]{rtlExcludedPathRegexps});
        return this;
    }

    public BuildCSSTask rtlExcludedPathRegexps(Object ... rtlExcludedPathRegexps) {
        return this.rtlExcludedPathRegexps(Arrays.asList(rtlExcludedPathRegexps));
    }

    public void setAppendCssImportTimestamps(boolean appendCssImportTimestamps) {
        this._appendCssImportTimestamps = appendCssImportTimestamps;
    }

    public void setDirNames(Iterable<Object> dirNames) {
        this._dirNames.clear();
        this.dirNames(dirNames);
    }

    public void setDirNames(Object ... dirNames) {
        this.setDirNames(Arrays.asList(dirNames));
    }

    public void setDocrootDir(Object docrootDir) {
        this._docrootDir = docrootDir;
    }

    public void setGenerateSourceMap(boolean generateSourceMap) {
        this._generateSourceMap = generateSourceMap;
    }

    public void setOutputDirName(Object outputDirName) {
        this._outputDirName = outputDirName;
    }

    public void setPortalCommonDir(Object portalCommonDir) {
        this._portalCommonDir = portalCommonDir;
    }

    public void setPortalCommonFile(Object portalCommonFile) {
        this._portalCommonFile = portalCommonFile;
    }

    public void setPrecision(Object precision) {
        this._precision = precision;
    }

    public void setRtlExcludedPathRegexps(Iterable<Object> rtlExcludedPathRegexps) {
        this._rtlExcludedPathRegexps.clear();
        this.rtlExcludedPathRegexps(rtlExcludedPathRegexps);
    }

    public void setRtlExcludedPathRegexps(Object ... rtlExcludedPathRegexps) {
        this.setRtlExcludedPathRegexps(Arrays.asList(rtlExcludedPathRegexps));
    }

    public void setSassCompilerClassName(Object sassCompilerClassName) {
        this._sassCompilerClassName = sassCompilerClassName;
    }

    private String _addTrailingSlash(String path) {
        if (Validator.isNull((String)path)) {
            return path;
        }
        if ((path = path.replace('\\', '/')).charAt(path.length() - 1) != '/') {
            path = path + '/';
        }
        return path;
    }

    private List<String> _getCompleteArgs() {
        ArrayList<String> args = new ArrayList<String>(this.getArgs());
        args.add("sass.append.css.import.timestamps=" + this.isAppendCssImportTimestamps());
        List<String> dirNames = this.getDirNames();
        if (dirNames.size() == 1) {
            args.add("sass.dir=/" + this._removeLeadingSlash(dirNames.get(0)));
        } else {
            for (int i = 0; i < dirNames.size(); ++i) {
                String dirName = dirNames.get(i);
                args.add("sass.dir." + i + "=/" + this._removeLeadingSlash(dirName));
            }
        }
        String docrootDirName = FileUtil.getAbsolutePath((File)this.getDocrootDir());
        args.add("sass.docroot.dir=" + this._removeTrailingSlash(docrootDirName));
        args.add("sass.generate.source.map=" + this.isGenerateSourceMap());
        args.add("sass.output.dir=" + this._addTrailingSlash(this.getOutputDirName()));
        String portalCommonPath = FileUtil.getAbsolutePath((File)this.getPortalCommonPath());
        args.add("sass.portal.common.path=" + portalCommonPath);
        args.add("sass.precision=" + this.getPrecision());
        String rtlExcludedPathRegexps = CollectionUtils.join((String)",", this.getRtlExcludedPathRegexps());
        args.add("sass.rtl.excluded.path.regexps=" + rtlExcludedPathRegexps);
        String sassCompilerClassName = this.getSassCompilerClassName();
        if (Validator.isNotNull((String)sassCompilerClassName)) {
            args.add("sass.compiler.class.name=" + sassCompilerClassName);
        }
        return args;
    }

    private String _removeLeadingSlash(String path) {
        if (Validator.isNull((String)path)) {
            return path;
        }
        if ((path = path.replace('\\', '/')).charAt(0) == '/') {
            path = path.substring(1);
        }
        return path;
    }

    private String _removeTrailingSlash(String path) {
        if (Validator.isNull((String)path)) {
            return path;
        }
        if ((path = path.replace('\\', '/')).charAt(path.length() - 1) == '/') {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }
}

