/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.css.builder;

import com.liferay.css.builder.CSSBuilderArgs;
import com.liferay.gradle.util.ArrayUtil;
import com.liferay.gradle.util.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectories;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.process.JavaExecSpec;

public class BuildCSSTask
extends JavaExec {
    private final CSSBuilderArgs _cssBuilderArgs = new CSSBuilderArgs();
    private final Project _project = this.getProject();

    public JavaExecSpec args(Iterable<?> args) {
        throw new UnsupportedOperationException();
    }

    public JavaExec args(Object ... args) {
        throw new UnsupportedOperationException();
    }

    public JavaExec classpath(Object ... paths) {
        throw new UnsupportedOperationException();
    }

    public void exec() {
        super.setArgs(this.getArgs());
        super.setClasspath(this.getClasspath());
        super.setWorkingDir((Object)this.getWorkingDir());
        super.exec();
    }

    public List<String> getArgs() {
        ArrayList<String> args = new ArrayList<String>();
        String[] dirNames = this.getDirNames();
        if (dirNames.length == 1) {
            args.add("sass.dir=/" + this._removeLeadingSlash(dirNames[0]));
        } else {
            for (int i = 0; i < dirNames.length; ++i) {
                args.add("sass.dir." + i + "=/" + this._removeLeadingSlash(dirNames[i]));
            }
        }
        args.add("sass.docroot.dir=" + this._removeTrailingSlash(this.getDocrootDirName()));
        args.add("sass.portal.common.dir=" + this.getPortalCommonDirName());
        args.add("sass.rtl.excluded.path.regexps=" + StringUtil.merge((String[])this.getRtlExcludedPathRegexps(), (String)","));
        args.add("sass.compiler.class.name=" + this.getSassCompilerClassName());
        return args;
    }

    public FileCollection getClasspath() {
        Project project = this.getProject();
        ConfigurationContainer configurationContainer = project.getConfigurations();
        return configurationContainer.getByName("cssBuilder");
    }

    @OutputDirectories
    public FileCollection getCSSCacheDirs() {
        HashSet<File> cssCacheDirs = new HashSet<File>();
        FileCollection cssFiles = this.getCSSFiles();
        for (File cssFile : cssFiles) {
            File cssCacheDir = this._project.file((Object)(cssFile + "/../.sass-cache"));
            cssCacheDirs.add(cssCacheDir);
        }
        return this._project.files(new Object[]{cssCacheDirs});
    }

    @InputFiles
    @SkipWhenEmpty
    public FileCollection getCSSFiles() {
        Object[] dirNames = this.getDirNames();
        if (ArrayUtil.isEmpty((Object[])dirNames)) {
            return this._project.files(new Object[0]);
        }
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("dir", this._project.file((Object)this.getDocrootDirName()));
        args.put("exclude", "**/.sass-cache/**");
        for (Object dirName : dirNames) {
            if (((String)(dirName = ((String)dirName).replace('\\', '/'))).equals("/")) {
                dirName = "";
            } else {
                dirName = this._removeLeadingSlash((String)dirName);
                dirName = this._removeTrailingSlash((String)dirName);
                dirName = (String)dirName + "/";
            }
            ArrayList<String> includes = new ArrayList<String>(2);
            includes.add((String)dirName + "**/*.css");
            includes.add((String)dirName + "**/*.scss");
            args.put("includes", includes);
        }
        return this._project.fileTree(args);
    }

    public String[] getDirNames() {
        return this._cssBuilderArgs.getDirNames();
    }

    public String getDocrootDirName() {
        return this._cssBuilderArgs.getDocrootDirName();
    }

    public String getMain() {
        return "com.liferay.css.builder.CSSBuilder";
    }

    @InputDirectory
    public File getPortalCommonDir() {
        return this._project.file((Object)this.getPortalCommonDirName());
    }

    public String getPortalCommonDirName() {
        return this._cssBuilderArgs.getPortalCommonDirName();
    }

    @Input
    public String[] getRtlExcludedPathRegexps() {
        return this._cssBuilderArgs.getRtlExcludedPathRegexps();
    }

    @Input
    @Optional
    public String getSassCompilerClassName() {
        return this._cssBuilderArgs.getSassCompilerClassName();
    }

    public File getWorkingDir() {
        return this._project.getProjectDir();
    }

    public JavaExec setArgs(Iterable<?> applicationArgs) {
        throw new UnsupportedOperationException();
    }

    public JavaExec setClasspath(FileCollection classpath) {
        throw new UnsupportedOperationException();
    }

    public void setDirNames(String ... dirNames) {
        this._cssBuilderArgs.setDirNames(dirNames);
    }

    public void setDocrootDirName(String docrootDirName) {
        this._cssBuilderArgs.setDocrootDirName(docrootDirName);
    }

    public void setPortalCommonDirName(String portalCommonDirName) {
        this._cssBuilderArgs.setPortalCommonDirName(portalCommonDirName);
    }

    public void setRtlExcludedPathRegexps(String ... rtlExcludedPathRegexps) {
        this._cssBuilderArgs.setRtlExcludedPathRegexps(rtlExcludedPathRegexps);
    }

    public void setSassCompilerClassName(String sassCompilerClassName) {
        this._cssBuilderArgs.setSassCompilerClassName(sassCompilerClassName);
    }

    public void setWorkingDir(Object dir) {
        throw new UnsupportedOperationException();
    }

    private String _removeLeadingSlash(String path) {
        if ((path = path.replace('\\', '/')).charAt(0) == '/') {
            path = path.substring(1);
        }
        return path;
    }

    private String _removeTrailingSlash(String path) {
        if ((path = path.replace('\\', '/')).charAt(path.length() - 1) == '/') {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }
}

