/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.baseline;

import com.liferay.gradle.plugins.baseline.internal.util.GradleUtil;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.concurrent.Callable;
import org.gradle.api.Project;

public class BaselineConfigurationExtension {
    private boolean _allowMavenLocal;
    private Object _lowestBaselineVersion = "1.0.0";
    private Object _lowestMajorVersion;
    private Object _lowestMajorVersionRequired;
    private final Project _project;

    public BaselineConfigurationExtension(Project project) {
        this._project = project;
        this._lowestMajorVersion = new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                File file = BaselineConfigurationExtension.this._project.file((Object)".lfrbuild-lowest-major-version");
                file = GradleUtil.getProperty((Project)BaselineConfigurationExtension.this._project, (String)"baseline.lowest.major.version.file", (File)file);
                if (!file.exists()) {
                    return null;
                }
                String content = new String(Files.readAllBytes(file.toPath()), StandardCharsets.UTF_8);
                return Integer.valueOf(content);
            }
        };
    }

    public String getLowestBaselineVersion() {
        return GradleUtil.toString((Object)this._lowestBaselineVersion);
    }

    public Integer getLowestMajorVersion() {
        return GradleUtil.toInteger((Object)this._lowestMajorVersion);
    }

    public boolean isAllowMavenLocal() {
        return this._allowMavenLocal;
    }

    public boolean isLowestMajorVersionRequired() {
        return GradleUtil.toBoolean(this._lowestMajorVersionRequired);
    }

    public void setAllowMavenLocal(boolean allowMavenLocal) {
        this._allowMavenLocal = allowMavenLocal;
    }

    public void setLowestBaselineVersion(Object lowestBaselineVersion) {
        this._lowestBaselineVersion = lowestBaselineVersion;
    }

    public void setLowestMajorVersion(Object lowestMajorVersion) {
        this._lowestMajorVersion = lowestMajorVersion;
    }

    public void setLowestMajorVersionRequired(Object lowestMajorVersionRequired) {
        this._lowestMajorVersionRequired = lowestMajorVersionRequired;
    }
}

