/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.baseline;

import aQute.bnd.header.Attrs;
import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Instruction;
import aQute.bnd.osgi.Instructions;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Verifier;
import aQute.bnd.service.RepositoryPlugin;
import aQute.bnd.service.repository.InfoRepository;
import aQute.bnd.service.repository.Phase;
import aQute.bnd.service.repository.SearchableRepository;
import aQute.bnd.version.Version;
import aQute.lib.collections.SortedList;
import java.io.Closeable;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;

public class BaselineProcessor
extends Analyzer {
    public Jar getBaselineJar() throws Exception {
        String bl = this.getProperty("-baseline");
        if (bl == null || "none".equals(bl)) {
            return null;
        }
        Instructions baselines = new Instructions(this.getProperty("-baseline"));
        if (baselines.isEmpty()) {
            return null;
        }
        RepositoryPlugin repo = this.getBaselineRepo();
        if (repo == null) {
            return null;
        }
        String bsn = this.getBsn();
        Version version = new Version(this.getVersion());
        for (Map.Entry e : baselines.entrySet()) {
            File file;
            SortedSet<Version> later;
            if (!((Instruction)e.getKey()).matches(bsn)) continue;
            Attrs attrs = (Attrs)e.getValue();
            if (attrs.containsKey("version")) {
                SortedSet<Version> versions = this.removeStagedAndFilter(repo.versions(bsn), repo, bsn);
                if (versions.isEmpty()) {
                    Version v = new Version(this.getVersion());
                    if (v.getWithoutQualifier().compareTo(Version.ONE) > 0) {
                        this.warning("There is no baseline for %s in the baseline repo %s. The build is for version %s, which is <= 1.0.0 which suggests that there should be a prior version.", new Object[]{this.getBsn(), repo, v});
                    }
                    return null;
                }
                String v = attrs.get("version");
                if (!Verifier.isVersion((String)v)) {
                    this.error("Not a valid version in %s %s", new Object[]{"-baseline", v});
                    return null;
                }
                Version base = new Version(v);
                later = versions.tailSet(base);
                if (later.isEmpty()) {
                    this.error("For baselineing %s-%s, specified version %s not found", new Object[]{bsn, version, base});
                    return null;
                }
            } else {
                if (attrs.containsKey("file")) {
                    File f = this.getFile(attrs.get("file"));
                    if (f != null && f.isFile()) {
                        Jar jar = new Jar(f);
                        this.addClose((Closeable)jar);
                        return jar;
                    }
                    this.error("Specified file for baseline but could not find it %s", new Object[]{f});
                    return null;
                }
                throw new IllegalArgumentException("Instruction must contain the version or file attribute!");
            }
            Version target = later.first();
            if (target.getWithoutQualifier().compareTo(version.getWithoutQualifier()) > 0) {
                this.error("The baseline version %s is higher than the current version %s for %s in %s", new Object[]{target, version, bsn, repo});
                return null;
            }
            if (target.getWithoutQualifier().compareTo(version.getWithoutQualifier()) == 0 && this.isPedantic()) {
                this.warning("Baselining against jar", new Object[0]);
            }
            if ((file = repo.get(bsn, target, (Map)attrs, new RepositoryPlugin.DownloadListener[0])) == null || !file.isFile()) {
                this.error("Decided on version %s-%s but cannot get file from repo %s", new Object[]{bsn, version, repo});
                return null;
            }
            Jar jar = new Jar(file);
            this.addClose((Closeable)jar);
            return jar;
        }
        return null;
    }

    private RepositoryPlugin getBaselineRepo() {
        String repoName = this.getProperty("-baselinerepo");
        if (repoName == null) {
            return this.getReleaseRepo();
        }
        List repos = this.getPlugins(RepositoryPlugin.class);
        for (RepositoryPlugin r : repos) {
            if (!r.getName().equals(repoName)) continue;
            return r;
        }
        this.error("Could not find -baselinerepo %s", new Object[]{repoName});
        return null;
    }

    private RepositoryPlugin getReleaseRepo() {
        String repoName = this.getProperty("-releaserepo");
        List repos = this.getPlugins(RepositoryPlugin.class);
        for (RepositoryPlugin r : repos) {
            if (!r.canWrite() || repoName != null && !r.getName().equals(repoName)) continue;
            return r;
        }
        if (repoName == null) {
            this.error("Could not find a writable repo for the release repo (-releaserepo is not set)", new Object[0]);
        } else {
            this.error("No such -releaserepo %s found", new Object[]{repoName});
        }
        return null;
    }

    private boolean isMaster(InfoRepository repo, String bsn, Version v) throws Exception {
        SearchableRepository.ResourceDescriptor descriptor = repo.getDescriptor(bsn, v);
        if (descriptor == null) {
            return false;
        }
        return descriptor.phase == Phase.MASTER;
    }

    private SortedSet<Version> removeStagedAndFilter(SortedSet<Version> versions, RepositoryPlugin repo, String bsn) throws Exception {
        ArrayList<Version> filtered = new ArrayList<Version>(versions);
        Collections.reverse(filtered);
        InfoRepository ir = repo instanceof InfoRepository ? (InfoRepository)repo : null;
        Version last = null;
        Iterator i = filtered.iterator();
        while (i.hasNext()) {
            Version v = (Version)i.next();
            Version current = v.getWithoutQualifier();
            if (last != null && current.equals(last)) {
                i.remove();
                continue;
            }
            if (ir != null && !this.isMaster(ir, bsn, v)) {
                i.remove();
            }
            last = current;
        }
        SortedList set = new SortedList(filtered);
        this.trace("filtered for only latest staged: %s from %s in range ", new Object[]{set, versions});
        return set;
    }
}

