/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.baseline;

import com.liferay.gradle.plugins.baseline.BaselineConfigurationExtension;
import com.liferay.gradle.plugins.baseline.BaselineTask;
import com.liferay.gradle.plugins.baseline.internal.util.GradleUtil;
import com.liferay.gradle.util.Validator;
import java.io.File;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ComponentSelection;
import org.gradle.api.artifacts.ComponentSelectionRules;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.ResolutionStrategy;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.plugins.ReportingBasePlugin;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.util.VersionNumber;

public class BaselinePlugin
implements Plugin<Project> {
    public static final String BASELINE_CONFIGURATION_NAME = "baseline";
    public static final String BASELINE_TASK_NAME = "baseline";
    public static final String EXTENSION_NAME = "baselineConfiguration";

    public void apply(Project project) {
        GradleUtil.applyPlugin((Project)project, JavaPlugin.class);
        GradleUtil.applyPlugin((Project)project, ReportingBasePlugin.class);
        final BaselineConfigurationExtension baselineConfigurationExtension = (BaselineConfigurationExtension)GradleUtil.addExtension((ExtensionAware)project, (String)EXTENSION_NAME, BaselineConfigurationExtension.class);
        final Jar jar = (Jar)GradleUtil.getTask((Project)project, (String)"jar");
        final Configuration baselineConfiguration = this._addConfigurationBaseline((AbstractArchiveTask)jar, baselineConfigurationExtension);
        final BaselineTask baselineTask = this._addTaskBaseline((AbstractArchiveTask)jar);
        this._configureTasksBaseline(project, baselineConfigurationExtension);
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                BaselinePlugin.this._configureTaskBaseline(baselineTask, (AbstractArchiveTask)jar, (FileCollection)baselineConfiguration, baselineConfigurationExtension);
            }
        });
    }

    private Configuration _addConfigurationBaseline(final AbstractArchiveTask newJarTask, final BaselineConfigurationExtension baselineConfigurationExtension) {
        Project project = newJarTask.getProject();
        ConfigurationContainer configurationContainer = project.getConfigurations();
        Configuration configuration = (Configuration)configurationContainer.maybeCreate("baseline");
        configuration.defaultDependencies((Action)new Action<DependencySet>(){

            public void execute(DependencySet dependencySet) {
                Dependency dependency = BaselinePlugin.this._createDependencyBaseline(newJarTask, baselineConfigurationExtension.getLowestMajorVersion());
                dependencySet.add((Object)dependency);
            }
        });
        configuration.setDescription("Configures the previous released version of this project for baselining.");
        this._configureConfigurationBaseline(configuration);
        return configuration;
    }

    private BaselineTask _addTaskBaseline(AbstractArchiveTask newJarTask) {
        final BaselineTask baselineTask = this._addTaskBaseline(newJarTask, "baseline", true);
        baselineTask.setDescription("Compares the public API of this project with the public API of the previous released version, if found.");
        baselineTask.setGroup("verification");
        Project project = baselineTask.getProject();
        PluginContainer pluginContainer = project.getPlugins();
        pluginContainer.withId("biz.aQute.bnd.builder", (Action)new Action<Plugin>(){

            public void execute(Plugin plugin) {
                BaselinePlugin.this._configureTaskBaselineForBndBuilderPlugin(baselineTask);
            }
        });
        return baselineTask;
    }

    private BaselineTask _addTaskBaseline(AbstractArchiveTask newJarTask, int majorVersion) {
        BaselineTask baselineTask = this._addTaskBaseline(newJarTask, "baseline" + majorVersion, false);
        baselineTask.dependsOn(new Object[]{newJarTask});
        baselineTask.setDescription("Compares the public API of this project with the public API of the previous released version in the " + majorVersion + ".x series, if found.");
        Project project = baselineTask.getProject();
        ConfigurationContainer configurationContainer = project.getConfigurations();
        Dependency dependency = this._createDependencyBaseline(newJarTask, majorVersion);
        final Configuration configuration = configurationContainer.detachedConfiguration(new Dependency[]{dependency});
        this._configureConfigurationBaseline(configuration);
        baselineTask.setOldJarFile(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return configuration.getSingleFile();
            }
        });
        return baselineTask;
    }

    private BaselineTask _addTaskBaseline(final AbstractArchiveTask newJarTask, String taskName, boolean overwrite) {
        Project project = newJarTask.getProject();
        final BaselineTask baselineTask = GradleUtil.addTask(project, taskName, BaselineTask.class, overwrite);
        File bndFile = project.file((Object)"bnd.bnd");
        if (bndFile.exists()) {
            baselineTask.setBndFile(bndFile);
        }
        baselineTask.setNewJarFile(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return newJarTask.getArchivePath();
            }
        });
        baselineTask.setSourceDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                SourceSet sourceSet = GradleUtil.getSourceSet((Project)baselineTask.getProject(), (String)"main");
                return GradleUtil.getSrcDir(sourceSet.getResources());
            }
        });
        return baselineTask;
    }

    private void _configureConfigurationBaseline(Configuration configuration) {
        configuration.setTransitive(false);
        configuration.setVisible(false);
        ResolutionStrategy resolutionStrategy = configuration.getResolutionStrategy();
        ComponentSelectionRules componentSelectionRules = resolutionStrategy.getComponentSelection();
        componentSelectionRules.all((Action)new Action<ComponentSelection>(){

            public void execute(ComponentSelection componentSelection) {
                ModuleComponentIdentifier moduleComponentIdentifier = componentSelection.getCandidate();
                String version = moduleComponentIdentifier.getVersion();
                if (version.endsWith("-SNAPSHOT")) {
                    componentSelection.reject("no snapshots are allowed");
                }
            }
        });
        resolutionStrategy.cacheChangingModulesFor(0, TimeUnit.SECONDS);
        resolutionStrategy.cacheDynamicVersionsFor(0, TimeUnit.SECONDS);
    }

    private void _configureTaskBaseline(BaselineTask baselineTask, AbstractArchiveTask newJarTask, final FileCollection oldJarFileCollection, BaselineConfigurationExtension baselineConfigurationExtension) {
        VersionNumber versionNumber;
        VersionNumber lowestBaselineVersionNumber = VersionNumber.parse((String)baselineConfigurationExtension.getLowestBaselineVersion());
        if (lowestBaselineVersionNumber.compareTo(versionNumber = VersionNumber.parse((String)newJarTask.getVersion())) >= 0) {
            baselineTask.setEnabled(false);
            return;
        }
        Integer lowestMajorVersion = baselineConfigurationExtension.getLowestMajorVersion();
        if (lowestMajorVersion != null) {
            BaselineTask previousVersionBaselineTask = baselineTask;
            int maxMajorVersion = versionNumber.getMajor();
            if (versionNumber.getMinor() == 0 && versionNumber.getMicro() == 0) {
                --maxMajorVersion;
            }
            if (maxMajorVersion >= lowestMajorVersion + 1) {
                baselineTask.setIgnoreExcessiveVersionIncreases(true);
            }
            for (int majorVersion = lowestMajorVersion + 1; majorVersion <= maxMajorVersion; ++majorVersion) {
                BaselineTask majorVersionBaselineTask = this._addTaskBaseline(newJarTask, majorVersion);
                if (majorVersion < maxMajorVersion) {
                    majorVersionBaselineTask.setIgnoreExcessiveVersionIncreases(true);
                }
                previousVersionBaselineTask.dependsOn(new Object[]{majorVersionBaselineTask});
                previousVersionBaselineTask = majorVersionBaselineTask;
            }
        } else if (baselineConfigurationExtension.isLowestMajorVersionRequired()) {
            throw new GradleException("Please configure a lowest major version for " + baselineTask.getProject());
        }
        baselineTask.dependsOn(new Object[]{newJarTask});
        baselineTask.setOldJarFile(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return oldJarFileCollection.getSingleFile();
            }
        });
    }

    private void _configureTaskBaseline(BaselineTask baselineTask, final BaselineConfigurationExtension baselineConfigurationExtension) {
        baselineTask.doFirst((Action)new Action<Task>(){

            public void execute(Task task) {
                if (baselineConfigurationExtension.isAllowMavenLocal()) {
                    return;
                }
                BaselineTask baselineTask = (BaselineTask)task;
                File oldJarFile = baselineTask.getOldJarFile();
                if (oldJarFile != null && GradleUtil.isFromMavenLocal(task.getProject(), oldJarFile)) {
                    throw new GradleException("Please delete " + oldJarFile.getParent() + " and try again");
                }
            }
        });
        String ignoreFailures = GradleUtil.getTaskPrefixedProperty((Task)baselineTask, (String)"ignoreFailures");
        if (Validator.isNotNull((String)ignoreFailures)) {
            baselineTask.setIgnoreFailures(Boolean.parseBoolean(ignoreFailures));
        }
        Project project = baselineTask.getProject();
        String reportLevel = GradleUtil.getProperty((ExtensionAware)project, (String)"baseline.jar.report.level", (String)"standard");
        boolean reportLevelIsDiff = reportLevel.equals("diff");
        boolean reportLevelIsPersist = reportLevel.equals("persist");
        boolean reportDiff = false;
        if (reportLevelIsDiff || reportLevelIsPersist) {
            reportDiff = true;
        }
        baselineTask.setReportDiff(reportDiff);
        boolean reportOnlyDirtyPackages = GradleUtil.getProperty((ExtensionAware)project, (String)"baseline.jar.report.only.dirty.packages", (boolean)true);
        baselineTask.setReportOnlyDirtyPackages(reportOnlyDirtyPackages);
    }

    private void _configureTaskBaselineForBndBuilderPlugin(BaselineTask baselineTask) {
        GradleUtil.setProperty((ExtensionAware)baselineTask, (String)"bundleTask", null);
    }

    private void _configureTasksBaseline(Project project, final BaselineConfigurationExtension baselineConfigurationExtension) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(BaselineTask.class, (Action)new Action<BaselineTask>(){

            public void execute(BaselineTask baselineTask) {
                BaselinePlugin.this._configureTaskBaseline(baselineTask, baselineConfigurationExtension);
            }
        });
    }

    private Dependency _createDependencyBaseline(AbstractArchiveTask newJarTask, Integer majorVersion) {
        Project project = newJarTask.getProject();
        DependencyHandler dependencyHandler = project.getDependencies();
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("group", String.valueOf(project.getGroup()));
        args.put("name", newJarTask.getBaseName());
        String version = null;
        if (majorVersion != null) {
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            sb.append(majorVersion);
            sb.append(".0.0,");
            sb.append(majorVersion + 1);
            sb.append(".0.0)");
            version = sb.toString();
        } else {
            version = "(," + newJarTask.getVersion() + ")";
        }
        args.put("version", version);
        return dependencyHandler.create(args);
    }
}

