/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.theme.fjord.site.initializer.internal;

import com.liferay.fragment.importer.FragmentsImporter;
import com.liferay.layout.page.template.importer.LayoutPageTemplatesImporter;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryLocalService;
import com.liferay.layout.util.LayoutCopyHelper;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Theme;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.LayoutSetLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ThemeLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.site.exception.InitializationException;
import com.liferay.site.initializer.SiteInitializer;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"site.initializer.key=fjord-site-initializer"}, service={SiteInitializer.class})
public class FjordSiteInitializer
implements SiteInitializer {
    public static final String KEY = "fjord-site-initializer";
    private static final String _PATH = "com/liferay/frontend/theme/fjord/site/initializer/internal/dependencies";
    private static final String _THEME_ID = "fjord_WAR_fjordtheme";
    private static final String _THEME_NAME = "Fjord";
    private static final Log _log = LogFactoryUtil.getLog(FjordSiteInitializer.class);
    private Bundle _bundle;
    @Reference
    private FragmentsImporter _fragmentsImporter;
    @Reference
    private LayoutCopyHelper _layoutCopyHelper;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutPageTemplateEntryLocalService _layoutPageTemplateEntryLocalService;
    @Reference
    private LayoutPageTemplatesImporter _layoutPageTemplatesImporter;
    @Reference
    private LayoutSetLocalService _layoutSetLocalService;
    @Reference
    private Portal _portal;
    @Reference(target="(osgi.web.symbolicname=com.liferay.frontend.theme.fjord.site.initializer)")
    private ServletContext _servletContext;
    @Reference
    private ThemeLocalService _themeLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public String getDescription(Locale locale) {
        return "";
    }

    public String getKey() {
        return KEY;
    }

    public String getName(Locale locale) {
        return _THEME_NAME;
    }

    public String getThumbnailSrc() {
        return this._servletContext.getContextPath() + "/images/thumbnail.png";
    }

    public void initialize(long groupId) throws InitializationException {
        try {
            ServiceContext serviceContext = this._createServiceContext(groupId);
            this._updateLogo(serviceContext);
            this._updateLookAndFeel(serviceContext);
            this._importFragmentEntries(serviceContext);
            this._importLayoutPageTemplateEntries(serviceContext);
            this._addLayout("Home", serviceContext);
            this._addLayout("Features", serviceContext);
            this._addLayout("Download", serviceContext);
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            throw new InitializationException((Throwable)exception);
        }
    }

    public boolean isActive(long companyId) {
        return true;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundle = bundleContext.getBundle();
    }

    private void _addLayout(String name, ServiceContext serviceContext) throws Exception {
        String layoutPageTemplateEntryKey = StringUtil.toLowerCase((String)name.trim());
        layoutPageTemplateEntryKey = StringUtil.replace((String)layoutPageTemplateEntryKey, (char)' ', (char)'-');
        LayoutPageTemplateEntry layoutPageTemplateEntry = this._layoutPageTemplateEntryLocalService.fetchLayoutPageTemplateEntry(serviceContext.getScopeGroupId(), layoutPageTemplateEntryKey);
        if (layoutPageTemplateEntry == null) {
            throw new IllegalArgumentException("Unable to get layout page template entry " + name);
        }
        HashMap nameMap = HashMapBuilder.put((Object)LocaleUtil.getSiteDefault(), (Object)name).build();
        Layout layout = this._layoutLocalService.addLayout(serviceContext.getUserId(), serviceContext.getScopeGroupId(), false, 0L, this._portal.getClassNameId(LayoutPageTemplateEntry.class), layoutPageTemplateEntry.getLayoutPageTemplateEntryId(), (Map)nameMap, new HashMap(), new HashMap(), new HashMap(), new HashMap(), "content", null, false, false, new HashMap(), 0L, serviceContext);
        TransactionCommitCallbackUtil.registerCallback(() -> {
            this._copyLayout(layout);
            this._layoutLocalService.updateStatus(serviceContext.getUserId(), layout.getPlid(), 0, serviceContext);
            return null;
        });
    }

    private void _copyLayout(Layout layout) throws Exception {
        Layout draftLayout = this._layoutLocalService.fetchLayout(this._portal.getClassNameId(Layout.class), layout.getPlid());
        if (draftLayout != null) {
            this._layoutCopyHelper.copyLayout(draftLayout, layout);
        }
    }

    private ServiceContext _createServiceContext(long groupId) throws PortalException {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        User user = this._userLocalService.getUser(PrincipalThreadLocal.getUserId());
        Locale locale = LocaleUtil.getSiteDefault();
        serviceContext.setLanguageId(LanguageUtil.getLanguageId((Locale)locale));
        serviceContext.setScopeGroupId(groupId);
        serviceContext.setTimeZone(user.getTimeZone());
        serviceContext.setUserId(user.getUserId());
        return serviceContext;
    }

    private void _importFragmentEntries(ServiceContext serviceContext) throws Exception {
        URL url = this._bundle.getEntry("/fragments.zip");
        File file = FileUtil.createTempFile((InputStream)url.openStream());
        this._fragmentsImporter.importFile(serviceContext.getUserId(), serviceContext.getScopeGroupId(), 0L, file, false);
    }

    private void _importLayoutPageTemplateEntries(ServiceContext serviceContext) throws Exception {
        URL url = this._bundle.getEntry("/page-templates.zip");
        File file = FileUtil.createTempFile((InputStream)url.openStream());
        this._layoutPageTemplatesImporter.importFile(serviceContext.getUserId(), serviceContext.getScopeGroupId(), file, false);
    }

    private void _updateLogo(ServiceContext serviceContext) throws Exception {
        URL url = this._bundle.getEntry("com/liferay/frontend/theme/fjord/site/initializer/internal/dependencies/images/logo.png");
        byte[] bytes = null;
        try (InputStream is = url.openStream();){
            bytes = FileUtil.getBytes((InputStream)is);
        }
        this._layoutSetLocalService.updateLogo(serviceContext.getScopeGroupId(), false, true, bytes);
    }

    private void _updateLookAndFeel(ServiceContext serviceContext) throws PortalException {
        Theme theme = this._themeLocalService.fetchTheme(serviceContext.getCompanyId(), _THEME_ID);
        if (theme == null) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)"No theme found for fjord_WAR_fjordtheme");
            }
            return;
        }
        this._layoutSetLocalService.updateLookAndFeel(serviceContext.getScopeGroupId(), _THEME_ID, "", "");
    }
}

