/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.theme.fjord.site.initializer.internal;

import com.liferay.fragment.model.FragmentCollection;
import com.liferay.fragment.model.FragmentEntry;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.service.FragmentCollectionLocalService;
import com.liferay.fragment.service.FragmentEntryLinkLocalService;
import com.liferay.fragment.service.FragmentEntryLocalService;
import com.liferay.layout.page.template.model.LayoutPageTemplateCollection;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.model.LayoutPageTemplateStructure;
import com.liferay.layout.page.template.service.LayoutPageTemplateCollectionLocalService;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryLocalService;
import com.liferay.layout.page.template.service.LayoutPageTemplateStructureLocalService;
import com.liferay.layout.page.template.util.LayoutPageTemplateStructureHelperUtil;
import com.liferay.layout.util.LayoutCopyHelper;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.model.Theme;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.LayoutSetLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ThemeLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.site.exception.InitializationException;
import com.liferay.site.initializer.SiteInitializer;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"site.initializer.key=fjord-site-initializer"}, service={SiteInitializer.class})
public class FjordSiteInitializer
implements SiteInitializer {
    public static final String KEY = "fjord-site-initializer";
    private static final String _PATH = "com/liferay/frontend/theme/fjord/site/initializer/internal/dependencies";
    private static final String _THEME_ID = "fjord_WAR_fjordtheme";
    private static final String _THEME_NAME = "Fjord";
    private static final Log _log = LogFactoryUtil.getLog(FjordSiteInitializer.class);
    private Bundle _bundle;
    @Reference
    private FragmentCollectionLocalService _fragmentCollectionLocalService;
    @Reference
    private FragmentEntryLinkLocalService _fragmentEntryLinkLocalService;
    @Reference
    private FragmentEntryLocalService _fragmentEntryLocalService;
    @Reference
    private LayoutCopyHelper _layoutCopyHelper;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutPageTemplateCollectionLocalService _layoutPageTemplateCollectionLocalService;
    @Reference
    private LayoutPageTemplateEntryLocalService _layoutPageTemplateEntryLocalService;
    @Reference
    private LayoutPageTemplateStructureLocalService _layoutPageTemplateStructureLocalService;
    @Reference
    private LayoutSetLocalService _layoutSetLocalService;
    @Reference
    private Portal _portal;
    @Reference(target="(osgi.web.symbolicname=com.liferay.frontend.theme.fjord.site.initializer)")
    private ServletContext _servletContext;
    @Reference
    private ThemeLocalService _themeLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public String getDescription(Locale locale) {
        return "";
    }

    public String getKey() {
        return KEY;
    }

    public String getName(Locale locale) {
        return _THEME_NAME;
    }

    public String getThumbnailSrc() {
        return this._servletContext.getContextPath() + "/images/thumbnail.png";
    }

    public void initialize(long groupId) throws InitializationException {
        try {
            ServiceContext serviceContext = this._createServiceContext(groupId);
            this._updateLogo(serviceContext);
            this._updateLookAndFeel(serviceContext);
            FragmentCollection fragmentCollection = this._addFragmentCollection(serviceContext);
            this._addFileEntries(fragmentCollection.getFragmentCollectionId(), fragmentCollection.getResourcesFolderId(), serviceContext);
            LayoutPageTemplateCollection layoutPageTemplateCollection = this._addLayoutPageTemplateCollection(serviceContext);
            List<FragmentEntry> homeFragmentEntries = this._addFragmentEntries(fragmentCollection.getFragmentCollectionId(), "com/liferay/frontend/theme/fjord/site/initializer/internal/dependencies/fragments/home", serviceContext);
            List<FragmentEntry> downloadFragmentEntries = this._addFragmentEntries(fragmentCollection.getFragmentCollectionId(), "com/liferay/frontend/theme/fjord/site/initializer/internal/dependencies/fragments/download", serviceContext);
            homeFragmentEntries.addAll(downloadFragmentEntries);
            List<FragmentEntry> featuresFragmentEntries = this._addFragmentEntries(fragmentCollection.getFragmentCollectionId(), "com/liferay/frontend/theme/fjord/site/initializer/internal/dependencies/fragments/features", serviceContext);
            homeFragmentEntries.addAll(featuresFragmentEntries);
            List<FragmentEntry> headerFragmentEntries = this._addFragmentEntries(fragmentCollection.getFragmentCollectionId(), "com/liferay/frontend/theme/fjord/site/initializer/internal/dependencies/fragments/common/header", serviceContext);
            FragmentEntry headerFullscreenFragmentEntry = this._getFragmentEntry(headerFragmentEntries, "Header");
            downloadFragmentEntries.add(0, headerFullscreenFragmentEntry);
            featuresFragmentEntries.add(0, headerFullscreenFragmentEntry);
            homeFragmentEntries.add(0, headerFullscreenFragmentEntry);
            List<FragmentEntry> footerFragmentEntries = this._addFragmentEntries(fragmentCollection.getFragmentCollectionId(), "com/liferay/frontend/theme/fjord/site/initializer/internal/dependencies/fragments/common/footer", serviceContext);
            downloadFragmentEntries.addAll(footerFragmentEntries);
            featuresFragmentEntries.addAll(footerFragmentEntries);
            homeFragmentEntries.addAll(footerFragmentEntries);
            this._addLayout(homeFragmentEntries, layoutPageTemplateCollection.getLayoutPageTemplateCollectionId(), "Home", "com/liferay/frontend/theme/fjord/site/initializer/internal/dependencies/fragments/home", serviceContext);
            this._addLayout(featuresFragmentEntries, layoutPageTemplateCollection.getLayoutPageTemplateCollectionId(), "Features", "com/liferay/frontend/theme/fjord/site/initializer/internal/dependencies/fragments/features", serviceContext);
            this._addLayout(downloadFragmentEntries, layoutPageTemplateCollection.getLayoutPageTemplateCollectionId(), "Download", "com/liferay/frontend/theme/fjord/site/initializer/internal/dependencies/fragments/download", serviceContext);
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            throw new InitializationException((Throwable)exception);
        }
    }

    public boolean isActive(long companyId) {
        return true;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundle = bundleContext.getBundle();
    }

    private void _addFileEntries(long fragmentCollectionId, long folderId, ServiceContext serviceContext) throws Exception {
        Enumeration urls = this._bundle.findEntries("com/liferay/frontend/theme/fjord/site/initializer/internal/dependencies/images", "*", false);
        while (urls.hasMoreElements()) {
            URL url = (URL)urls.nextElement();
            byte[] bytes = null;
            try (InputStream is = url.openStream();){
                bytes = FileUtil.getBytes((InputStream)is);
            }
            String fileName = FileUtil.getShortFileName((String)url.getPath());
            PortletFileRepositoryUtil.addPortletFileEntry((long)serviceContext.getScopeGroupId(), (long)serviceContext.getUserId(), (String)FragmentCollection.class.getName(), (long)fragmentCollectionId, (String)"com_liferay_fragment_web_portlet_FragmentPortlet", (long)folderId, (byte[])bytes, (String)fileName, (String)MimeTypesUtil.getContentType((String)fileName), (boolean)false);
        }
    }

    private FragmentCollection _addFragmentCollection(ServiceContext serviceContext) throws PortalException {
        return this._fragmentCollectionLocalService.addFragmentCollection(serviceContext.getUserId(), serviceContext.getScopeGroupId(), _THEME_NAME, null, serviceContext);
    }

    private List<FragmentEntry> _addFragmentEntries(long fragmentCollectionId, String path, ServiceContext serviceContext) throws Exception {
        ArrayList<FragmentEntry> fragmentEntries = new ArrayList<FragmentEntry>();
        Enumeration enumeration = this._bundle.findEntries(path, "*.html", false);
        while (enumeration.hasMoreElements()) {
            URL url = (URL)enumeration.nextElement();
            String shortFileName = FileUtil.getShortFileName((String)url.getPath());
            StringBundler sb = new StringBundler(4);
            sb.append(path);
            sb.append("/");
            sb.append(FileUtil.stripExtension((String)shortFileName));
            sb.append(".css");
            URL cssURL = this._bundle.getEntry(sb.toString());
            FragmentEntry fragmentEntry = this._fragmentEntryLocalService.addFragmentEntry(serviceContext.getUserId(), serviceContext.getScopeGroupId(), fragmentCollectionId, null, StringUtil.upperCaseFirstLetter((String)FileUtil.stripExtension((String)shortFileName)), StringUtil.read((InputStream)cssURL.openStream()), StringUtil.read((InputStream)url.openStream()), "", "", 0L, 0, 0, serviceContext);
            long fragmentEntryPreviewFileEntryId = this._getPreviewFileEntryId("com_liferay_fragment_web_portlet_FragmentPortlet", FragmentEntry.class.getName(), fragmentEntry.getFragmentEntryId(), path, shortFileName, serviceContext);
            fragmentEntry = this._fragmentEntryLocalService.updateFragmentEntry(fragmentEntry.getFragmentEntryId(), fragmentEntryPreviewFileEntryId);
            fragmentEntries.add(fragmentEntry);
        }
        return fragmentEntries;
    }

    private List<FragmentEntryLink> _addFragmentEntryLinks(List<FragmentEntry> fragmentEntries, long plid, ServiceContext serviceContext) throws PortalException {
        ArrayList<FragmentEntryLink> fragmentEntryLinks = new ArrayList<FragmentEntryLink>();
        for (FragmentEntry fragmentEntry : fragmentEntries) {
            FragmentEntryLink fragmentEntryLink = this._fragmentEntryLinkLocalService.addFragmentEntryLink(serviceContext.getUserId(), serviceContext.getScopeGroupId(), 0L, fragmentEntry.getFragmentEntryId(), this._portal.getClassNameId(Layout.class.getName()), plid, fragmentEntry.getCss(), fragmentEntry.getHtml(), fragmentEntry.getJs(), fragmentEntry.getConfiguration(), "", "", 0, null, serviceContext);
            fragmentEntryLinks.add(fragmentEntryLink);
        }
        return fragmentEntryLinks;
    }

    private void _addLayout(List<FragmentEntry> fragmentEntries, long layoutPageTemplateCollectionId, String name, String path, ServiceContext serviceContext) throws Exception {
        LayoutPageTemplateEntry layoutPageTemplateEntry = this._addLayoutPageTemplateEntry(fragmentEntries, layoutPageTemplateCollectionId, name, path, serviceContext);
        HashMap nameMap = HashMapBuilder.put((Object)LocaleUtil.getSiteDefault(), (Object)name).build();
        Layout layout = this._layoutLocalService.addLayout(serviceContext.getUserId(), serviceContext.getScopeGroupId(), false, 0L, this._portal.getClassNameId(LayoutPageTemplateEntry.class), layoutPageTemplateEntry.getLayoutPageTemplateEntryId(), (Map)nameMap, new HashMap(), new HashMap(), new HashMap(), new HashMap(), "content", null, false, false, new HashMap(), 0L, serviceContext);
        TransactionCommitCallbackUtil.registerCallback(() -> {
            this._copyLayout(layout);
            this._layoutLocalService.updateStatus(serviceContext.getUserId(), layout.getPlid(), 0, serviceContext);
            return null;
        });
    }

    private LayoutPageTemplateCollection _addLayoutPageTemplateCollection(ServiceContext serviceContext) throws PortalException {
        return this._layoutPageTemplateCollectionLocalService.addLayoutPageTemplateCollection(serviceContext.getUserId(), serviceContext.getScopeGroupId(), _THEME_NAME, _THEME_NAME, serviceContext);
    }

    private LayoutPageTemplateEntry _addLayoutPageTemplateEntry(List<FragmentEntry> fragmentEntries, long layoutPageTemplateCollectionId, String name, String path, ServiceContext serviceContext) throws Exception {
        LayoutPageTemplateEntry layoutPageTemplateEntry = this._layoutPageTemplateEntryLocalService.addLayoutPageTemplateEntry(serviceContext.getUserId(), serviceContext.getScopeGroupId(), layoutPageTemplateCollectionId, name, 0, 0L, 0, serviceContext);
        long previewFileEntryId = this._getPreviewFileEntryId("com_liferay_layout_admin_web_portlet_GroupPagesPortlet", LayoutPageTemplateEntry.class.getName(), layoutPageTemplateEntry.getLayoutPageTemplateEntryId(), path, StringUtil.toLowerCase((String)name) + "_thumbnail.jpg", serviceContext);
        layoutPageTemplateEntry = this._layoutPageTemplateEntryLocalService.updateLayoutPageTemplateEntry(layoutPageTemplateEntry.getLayoutPageTemplateEntryId(), previewFileEntryId);
        Layout layoutPageTemplateEntryLayout = this._layoutLocalService.fetchLayout(layoutPageTemplateEntry.getPlid());
        Layout layoutPageTemplateEntryDraftLayout = this._layoutLocalService.fetchLayout(this._portal.getClassNameId(Layout.class), layoutPageTemplateEntryLayout.getPlid());
        List<FragmentEntryLink> fragmentEntryLinks = this._addFragmentEntryLinks(fragmentEntries, layoutPageTemplateEntryDraftLayout.getPlid(), serviceContext);
        JSONObject layoutDataJSONObject = LayoutPageTemplateStructureHelperUtil.generateContentLayoutStructure(fragmentEntryLinks);
        LayoutPageTemplateStructure layoutPageTemplateStructure = this._layoutPageTemplateStructureLocalService.fetchLayoutPageTemplateStructure(layoutPageTemplateEntry.getGroupId(), this._portal.getClassNameId(Layout.class.getName()), layoutPageTemplateEntryDraftLayout.getPlid());
        if (layoutPageTemplateStructure == null) {
            this._layoutPageTemplateStructureLocalService.addLayoutPageTemplateStructure(serviceContext.getUserId(), layoutPageTemplateEntry.getGroupId(), this._portal.getClassNameId(Layout.class.getName()), layoutPageTemplateEntryDraftLayout.getPlid(), layoutDataJSONObject.toString(), serviceContext);
        } else {
            this._layoutPageTemplateStructureLocalService.updateLayoutPageTemplateStructure(layoutPageTemplateEntry.getGroupId(), this._portal.getClassNameId(Layout.class.getName()), layoutPageTemplateEntryDraftLayout.getPlid(), layoutDataJSONObject.toString());
        }
        TransactionCommitCallbackUtil.registerCallback(() -> {
            this._copyLayout(layoutPageTemplateEntryLayout);
            this._layoutLocalService.updateStatus(serviceContext.getUserId(), layoutPageTemplateEntryLayout.getPlid(), 0, serviceContext);
            return null;
        });
        return layoutPageTemplateEntry;
    }

    private void _copyLayout(Layout layout) throws Exception {
        Layout draftLayout = this._layoutLocalService.fetchLayout(this._portal.getClassNameId(Layout.class), layout.getPlid());
        if (draftLayout != null) {
            this._layoutCopyHelper.copyLayout(draftLayout, layout);
        }
    }

    private ServiceContext _createServiceContext(long groupId) throws PortalException {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        User user = this._userLocalService.getUser(PrincipalThreadLocal.getUserId());
        Locale locale = LocaleUtil.getSiteDefault();
        serviceContext.setLanguageId(LanguageUtil.getLanguageId((Locale)locale));
        serviceContext.setScopeGroupId(groupId);
        serviceContext.setTimeZone(user.getTimeZone());
        serviceContext.setUserId(user.getUserId());
        return serviceContext;
    }

    private FragmentEntry _getFragmentEntry(List<FragmentEntry> fragmentEntries, String name) {
        for (FragmentEntry fragmentEntry : fragmentEntries) {
            if (!name.equals(fragmentEntry.getName())) continue;
            return fragmentEntry;
        }
        throw new IllegalArgumentException("Unable to get fragment entry " + name);
    }

    private long _getPreviewFileEntryId(String portletId, String className, long classPK, String path, String fileName, ServiceContext serviceContext) throws Exception {
        StringBundler sb = new StringBundler(4);
        sb.append(path);
        sb.append("/");
        sb.append(StringUtil.split((String)fileName, (String)".")[0]);
        sb.append(".jpg");
        URL url = this._bundle.getEntry(sb.toString());
        if (url == null) {
            return 0L;
        }
        Repository repository = PortletFileRepositoryUtil.fetchPortletRepository((long)serviceContext.getScopeGroupId(), (String)portletId);
        if (repository == null) {
            repository = PortletFileRepositoryUtil.addPortletRepository((long)serviceContext.getScopeGroupId(), (String)portletId, (ServiceContext)serviceContext);
        }
        String imageFileName = classPK + "_preview." + FileUtil.getExtension((String)url.getPath());
        byte[] bytes = null;
        try (InputStream is = url.openStream();){
            bytes = FileUtil.getBytes((InputStream)is);
        }
        FileEntry fileEntry = PortletFileRepositoryUtil.addPortletFileEntry((long)serviceContext.getScopeGroupId(), (long)serviceContext.getUserId(), (String)className, (long)classPK, (String)portletId, (long)repository.getDlFolderId(), (byte[])bytes, (String)imageFileName, (String)MimeTypesUtil.getContentType((String)imageFileName), (boolean)false);
        return fileEntry.getFileEntryId();
    }

    private void _updateLogo(ServiceContext serviceContext) throws Exception {
        URL url = this._bundle.getEntry("com/liferay/frontend/theme/fjord/site/initializer/internal/dependencies/images/logo.png");
        byte[] bytes = null;
        try (InputStream is = url.openStream();){
            bytes = FileUtil.getBytes((InputStream)is);
        }
        this._layoutSetLocalService.updateLogo(serviceContext.getScopeGroupId(), false, true, bytes);
    }

    private void _updateLookAndFeel(ServiceContext serviceContext) throws PortalException {
        Theme theme = this._themeLocalService.fetchTheme(serviceContext.getCompanyId(), _THEME_ID);
        if (theme == null) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)"No theme found for fjord_WAR_fjordtheme");
            }
            return;
        }
        this._layoutSetLocalService.updateLookAndFeel(serviceContext.getScopeGroupId(), _THEME_ID, "", "");
    }
}

