/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.theme.favicon.servlet.internal;

import com.liferay.client.extension.model.ClientExtensionEntryRel;
import com.liferay.client.extension.service.ClientExtensionEntryRelLocalService;
import com.liferay.client.extension.type.CET;
import com.liferay.client.extension.type.ThemeFaviconCET;
import com.liferay.client.extension.type.manager.CETManager;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.Theme;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpComponentsUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"servlet.type=favicon"}, service={Servlet.class})
public class FaviconServlet
extends HttpServlet {
    private static final String _PATH_DOCUMENTS = "/documents/d/";
    private static final long serialVersionUID = 1L;
    @Reference
    private CETManager _cetManager;
    @Reference
    private ClientExtensionEntryRelLocalService _clientExtensionEntryRelLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private Portal _portal;

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        String faviconURL;
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (themeDisplay != null) {
            httpServletResponse.sendRedirect(themeDisplay.getFaviconURL());
            return;
        }
        LayoutSet layoutSet = (LayoutSet)httpServletRequest.getAttribute("VIRTUAL_HOST_LAYOUT_SET");
        if (layoutSet == null) {
            return;
        }
        String referer = GetterUtil.getString((String)httpServletRequest.getHeader("Referer"));
        if (Validator.isNotNull((String)referer)) {
            layoutSet = this._getLayoutSet(layoutSet, referer);
        }
        if (Validator.isNotNull((String)(faviconURL = this._getFaviconURL(layoutSet)))) {
            httpServletResponse.sendRedirect(faviconURL);
            return;
        }
        Theme theme = layoutSet.getTheme();
        httpServletResponse.sendRedirect(theme.getContextPath() + theme.getImagesPath() + "/favicon.ico");
    }

    private CET _getCET(long classNameId, long classPK, long companyId) {
        ClientExtensionEntryRel clientExtensionEntryRel = this._clientExtensionEntryRelLocalService.fetchClientExtensionEntryRel(classNameId, classPK, "themeFavicon");
        if (clientExtensionEntryRel == null) {
            return null;
        }
        return this._cetManager.getCET(companyId, clientExtensionEntryRel.getCETExternalReferenceCode());
    }

    private String _getFaviconURL(LayoutSet layoutSet) {
        String faviconURL = this._getThemeFaviconCETURL(this._portal.getClassNameId(LayoutSet.class), layoutSet.getLayoutSetId(), layoutSet.getCompanyId());
        if (Validator.isNotNull((String)faviconURL)) {
            return faviconURL;
        }
        faviconURL = layoutSet.getFaviconURL();
        if (Validator.isNotNull((String)faviconURL)) {
            return faviconURL;
        }
        return null;
    }

    private LayoutSet _getLayoutSet(LayoutSet layoutSet, String path) {
        String groupFriendlyURL;
        String groupFriendlyURLDomain = HttpComponentsUtil.getDomain((String)path);
        int pos = path.indexOf(groupFriendlyURLDomain);
        if (pos > 0) {
            pos = path.indexOf(47, pos + groupFriendlyURLDomain.length());
        }
        if ((groupFriendlyURL = path.substring(pos)).startsWith(_PATH_DOCUMENTS)) {
            String fileEntryFriendlyURL = groupFriendlyURL.substring(_PATH_DOCUMENTS.length() - 1);
            groupFriendlyURL = fileEntryFriendlyURL.substring(0, fileEntryFriendlyURL.indexOf(47, 1));
        } else {
            pos = groupFriendlyURL.indexOf(47, 1);
            if (pos > 0) {
                groupFriendlyURL = groupFriendlyURL.substring(0, pos);
            }
        }
        Group group = this._groupLocalService.fetchFriendlyURLGroup(layoutSet.getCompanyId(), groupFriendlyURL);
        if (group != null) {
            return group.getPublicLayoutSet();
        }
        return layoutSet;
    }

    private String _getThemeFaviconCETURL(long classNameId, long classPK, long companyId) {
        CET cet = this._getCET(classNameId, classPK, companyId);
        if (cet == null) {
            return null;
        }
        ThemeFaviconCET themeFaviconCET = (ThemeFaviconCET)cet;
        return themeFaviconCET.getURL();
    }
}

