/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.theme.contributor.extender.internal.servlet.taglib;

import com.liferay.frontend.theme.contributor.extender.internal.BundleWebResources;
import com.liferay.osgi.util.ServiceTrackerFactory;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.content.security.policy.ContentSecurityPolicyNonceProviderUtil;
import com.liferay.portal.kernel.servlet.PortalWebResourcesUtil;
import com.liferay.portal.kernel.servlet.taglib.DynamicInclude;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Portal;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(service={DynamicInclude.class})
public class ThemeContributorTopHeadDynamicInclude
implements DynamicInclude {
    private BundleContext _bundleContext;
    private final Collection<ServiceReference<BundleWebResources>> _bundleWebResourcesServiceReferences = new TreeSet<ServiceReference<BundleWebResources>>();
    private String _comboContextPath;
    @Reference
    private Portal _portal;
    private volatile ResourceURLsBag _resourceURLsBag;
    private ServiceTracker<BundleWebResources, BundleWebResources> _serviceTracker;

    public void include(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String key) throws IOException {
        List jsResourceURLs;
        ResourceURLsBag resourceURLsBag;
        List cssResourceURLs;
        long themeLastModified = PortalWebResourcesUtil.getLastModified((String)"theme_contributor");
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String portalCDNURL = themeDisplay.getCDNBaseURL();
        if (!this._portal.isCDNDynamicResourcesEnabled(themeDisplay.getCompanyId())) {
            portalCDNURL = themeDisplay.getPortalURL();
        }
        if (!(cssResourceURLs = (resourceURLsBag = this._getResourceURLsBag())._cssResourceURLs).isEmpty()) {
            if (themeDisplay.isThemeCssFastLoad()) {
                this._renderComboCSS(themeLastModified, httpServletRequest, portalCDNURL, httpServletResponse.getWriter());
            } else {
                this._renderSimpleCSS(themeLastModified, httpServletRequest, portalCDNURL, httpServletResponse.getWriter(), cssResourceURLs);
            }
        }
        if ((jsResourceURLs = resourceURLsBag._jsResourceURLs).isEmpty()) {
            return;
        }
        if (themeDisplay.isThemeJsFastLoad()) {
            this._renderComboJS(themeLastModified, httpServletRequest, portalCDNURL, httpServletResponse.getWriter());
        } else {
            this._renderSimpleJS(themeLastModified, httpServletRequest, portalCDNURL, httpServletResponse.getWriter(), jsResourceURLs);
        }
    }

    public void register(DynamicInclude.DynamicIncludeRegistry dynamicIncludeRegistry) {
        dynamicIncludeRegistry.register("/html/common/themes/top_head.jsp#post");
    }

    @Activate
    protected void activate(final BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        this._comboContextPath = this._portal.getPathContext() + "/combo";
        this._serviceTracker = ServiceTrackerFactory.open((BundleContext)bundleContext, BundleWebResources.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<BundleWebResources, BundleWebResources>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public BundleWebResources addingService(ServiceReference<BundleWebResources> serviceReference) {
                Collection collection = ThemeContributorTopHeadDynamicInclude.this._bundleWebResourcesServiceReferences;
                synchronized (collection) {
                    ThemeContributorTopHeadDynamicInclude.this._bundleWebResourcesServiceReferences.add(serviceReference);
                    ThemeContributorTopHeadDynamicInclude.this._resourceURLsBag = null;
                }
                return (BundleWebResources)bundleContext.getService(serviceReference);
            }

            public void modifiedService(ServiceReference<BundleWebResources> serviceReference, BundleWebResources bundleWebResources) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void removedService(ServiceReference<BundleWebResources> serviceReference, BundleWebResources bundleWebResources) {
                Collection collection = ThemeContributorTopHeadDynamicInclude.this._bundleWebResourcesServiceReferences;
                synchronized (collection) {
                    ThemeContributorTopHeadDynamicInclude.this._bundleWebResourcesServiceReferences.remove(serviceReference);
                    ThemeContributorTopHeadDynamicInclude.this._resourceURLsBag = null;
                }
                bundleContext.ungetService(serviceReference);
            }
        });
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTracker.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceURLsBag _getResourceURLsBag() {
        ResourceURLsBag resourceURLsBag = this._resourceURLsBag;
        if (resourceURLsBag != null) {
            return resourceURLsBag;
        }
        Collection<ServiceReference<BundleWebResources>> collection = this._bundleWebResourcesServiceReferences;
        synchronized (collection) {
            if (this._resourceURLsBag != null) {
                return this._resourceURLsBag;
            }
            this._resourceURLsBag = this._rebuild();
            return this._resourceURLsBag;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceURLsBag _rebuild() {
        ArrayList<String> cssResourceURLs = new ArrayList<String>();
        ArrayList<String> jsResourceURLs = new ArrayList<String>();
        for (ServiceReference<BundleWebResources> bundleWebResourcesServiceReference : this._bundleWebResourcesServiceReferences) {
            BundleWebResources bundleWebResources = (BundleWebResources)this._bundleContext.getService(bundleWebResourcesServiceReference);
            try {
                String servletContextPath = bundleWebResources.getServletContextPath();
                for (String cssResourcePath : bundleWebResources.getCssResourcePaths()) {
                    cssResourceURLs.add(servletContextPath.concat(cssResourcePath));
                }
                for (String jsResourcePath : bundleWebResources.getJsResourcePaths()) {
                    jsResourceURLs.add(servletContextPath.concat(jsResourcePath));
                }
            }
            finally {
                this._bundleContext.ungetService(bundleWebResourcesServiceReference);
            }
        }
        return new ResourceURLsBag(cssResourceURLs, jsResourceURLs);
    }

    private void _renderComboCSS(long themeLastModified, HttpServletRequest httpServletRequest, String portalURL, PrintWriter printWriter) {
        printWriter.write("<link");
        printWriter.write(ContentSecurityPolicyNonceProviderUtil.getNonce((HttpServletRequest)httpServletRequest));
        printWriter.write(" data-senna-track=\"permanent\" href=\"");
        String staticResourceURL = this._portal.getStaticResourceURL(httpServletRequest, this._comboContextPath, "minifierType=css", themeLastModified);
        printWriter.write(portalURL + staticResourceURL);
        ResourceURLsBag resourceURLsBag = this._getResourceURLsBag();
        printWriter.write(resourceURLsBag.getMergedCSSResourceURLs());
    }

    private void _renderComboJS(long themeLastModified, HttpServletRequest httpServletRequest, String portalURL, PrintWriter printWriter) {
        printWriter.write("<script");
        printWriter.write(ContentSecurityPolicyNonceProviderUtil.getNonceAttribute((HttpServletRequest)httpServletRequest));
        printWriter.write(" data-senna-track=\"permanent\" src=\"");
        String staticResourceURL = this._portal.getStaticResourceURL(httpServletRequest, this._comboContextPath, "minifierType=js", themeLastModified);
        printWriter.write(portalURL + staticResourceURL);
        ResourceURLsBag resourceURLsBag = this._getResourceURLsBag();
        printWriter.write(resourceURLsBag.getMergedJSResourceURLs());
    }

    private void _renderSimpleCSS(long themeLastModified, HttpServletRequest httpServletRequest, String portalURL, PrintWriter printWriter, List<String> resourceURLs) {
        for (String resourceURL : resourceURLs) {
            printWriter.write("<link data-senna-track=\"permanent\" href=\"");
            printWriter.write(this._portal.getStaticResourceURL(httpServletRequest, StringBundler.concat((String[])new String[]{portalURL, this._portal.getPathProxy(), resourceURL}), themeLastModified));
            printWriter.write("\"");
            printWriter.write(ContentSecurityPolicyNonceProviderUtil.getNonce((HttpServletRequest)httpServletRequest));
            printWriter.write(" rel=\"stylesheet\" type = \"text/css\" />\n");
        }
    }

    private void _renderSimpleJS(long themeLastModified, HttpServletRequest httpServletRequest, String portalURL, PrintWriter printWriter, List<String> resourceURLs) {
        for (String resourceURL : resourceURLs) {
            printWriter.write("<script");
            printWriter.write(ContentSecurityPolicyNonceProviderUtil.getNonceAttribute((HttpServletRequest)httpServletRequest));
            printWriter.write(" data-senna-track=\"permanent\" src=\"");
            printWriter.write(this._portal.getStaticResourceURL(httpServletRequest, StringBundler.concat((String[])new String[]{portalURL, this._portal.getPathProxy(), resourceURL}), themeLastModified));
            printWriter.write("\" type = \"text/javascript\"></script>\n");
        }
    }

    private static class ResourceURLsBag {
        private final List<String> _cssResourceURLs;
        private final List<String> _jsResourceURLs;
        private volatile String _mergedCSSResourceURLs;
        private volatile String _mergedJSResourceURLs;

        public String getMergedCSSResourceURLs() {
            String mergedCSSResourceURLs = this._mergedCSSResourceURLs;
            if (mergedCSSResourceURLs == null) {
                this._mergedCSSResourceURLs = mergedCSSResourceURLs = this._mergeURLs(this._cssResourceURLs) + "\" rel=\"stylesheet\" type = \"text/css\" />\n";
            }
            return mergedCSSResourceURLs;
        }

        public String getMergedJSResourceURLs() {
            String mergedJSResourceURLs = this._mergedJSResourceURLs;
            if (mergedJSResourceURLs == null) {
                this._mergedJSResourceURLs = mergedJSResourceURLs = this._mergeURLs(this._jsResourceURLs) + "\" type = \"text/javascript\"></script>\n";
            }
            return mergedJSResourceURLs;
        }

        private ResourceURLsBag(List<String> cssResourceURLs, List<String> jsResourceURLs) {
            this._cssResourceURLs = cssResourceURLs;
            this._jsResourceURLs = jsResourceURLs;
        }

        private String _mergeURLs(List<String> urls) {
            StringBundler sb = new StringBundler(urls.size() * 2);
            for (String url : urls) {
                sb.append("&");
                sb.append(url);
            }
            return sb.toString();
        }
    }
}

