/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.theme.contributor.extender.internal;

import com.liferay.frontend.theme.contributor.extender.internal.BundleWebResourcesImpl;
import com.liferay.frontend.theme.contributor.extender.internal.ThemeContributorExtension;
import com.liferay.osgi.felix.util.AbstractExtender;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.GetterUtil;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import org.apache.felix.utils.extender.Extension;
import org.apache.felix.utils.log.Logger;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(immediate=true, service={})
public class ThemeContributorExtender
extends AbstractExtender {
    private Logger _logger;

    @Activate
    protected void activate(BundleContext bundleContext) throws Exception {
        this._logger = new Logger(bundleContext);
        this.start(bundleContext);
    }

    @Deactivate
    protected void deactivate(BundleContext bundleContext) throws Exception {
        this.stop(bundleContext);
    }

    protected void debug(Bundle bundle, String s) {
        this._logger.log(4, StringBundler.concat((Object[])new Object[]{"[", bundle, "] ", s}));
    }

    protected Extension doCreateExtension(Bundle bundle) throws Exception {
        String type = this._getProperty(bundle, "Liferay-Theme-Contributor-Type", "themeContributorType");
        if (type == null) {
            return null;
        }
        BundleWebResourcesImpl bundleWebResources = this._scanForResources(bundle);
        if (bundleWebResources == null) {
            return null;
        }
        int themeContributorWeight = GetterUtil.getInteger((String)this._getProperty(bundle, "Liferay-Theme-Contributor-Weight", "themeContributorWeight"));
        return new ThemeContributorExtension(bundle, bundleWebResources, themeContributorWeight);
    }

    protected void error(String s, Throwable t) {
        this._logger.log(1, s, t);
    }

    protected void warn(Bundle bundle, String s, Throwable t) {
        this._logger.log(2, StringBundler.concat((Object[])new Object[]{"[", bundle, "] ", s}), t);
    }

    private String _getProperty(Bundle bundle, String headerName, String jsonName) {
        URL entryURL;
        Dictionary headers = bundle.getHeaders("");
        String type = (String)headers.get(headerName);
        if (type == null && (entryURL = bundle.getEntry("/package.json")) != null) {
            try (InputStreamReader reader = new InputStreamReader(entryURL.openStream());){
                JSONTokener jsonTokener = new JSONTokener((Reader)reader);
                JSONObject packageJSONObject = new JSONObject(jsonTokener);
                JSONObject liferayThemeJSONObject = packageJSONObject.optJSONObject("liferayTheme");
                if (liferayThemeJSONObject != null) {
                    type = liferayThemeJSONObject.getString(jsonName);
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        return type;
    }

    private BundleWebResourcesImpl _scanForResources(Bundle bundle) {
        String path;
        URL url;
        ArrayList<String> cssResourcePaths = new ArrayList<String>();
        ArrayList<String> jsResourcePaths = new ArrayList<String>();
        Enumeration cssEntries = bundle.findEntries("/META-INF/resources", "*.css", true);
        Enumeration jsEntries = bundle.findEntries("/META-INF/resources", "*.js", true);
        if (cssEntries != null) {
            while (cssEntries.hasMoreElements()) {
                int index;
                url = (URL)cssEntries.nextElement();
                path = url.getFile();
                if ("_".equals(Character.valueOf((path = path.replace("/META-INF/resources", "")).charAt((index = path.lastIndexOf(47)) + 1))) || path.endsWith("_rtl.css")) continue;
                cssResourcePaths.add(path);
            }
        }
        if (jsEntries != null) {
            while (jsEntries.hasMoreElements()) {
                url = (URL)jsEntries.nextElement();
                path = url.getFile();
                jsResourcePaths.add(path.replace("/META-INF/resources", ""));
            }
        }
        if (cssResourcePaths.isEmpty() && jsResourcePaths.isEmpty()) {
            return null;
        }
        return new BundleWebResourcesImpl(cssResourcePaths, jsResourcePaths);
    }
}

