/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.frontend.js.loader.modules.extender.internal.resolution;

import com.liferay.frontend.js.loader.modules.extender.internal.resolution.adapter.JSBrowserModule;
import com.liferay.frontend.js.loader.modules.extender.npm.JSModule;
import com.liferay.frontend.js.loader.modules.extender.npm.NPMRegistry;

import java.util.HashMap;
import java.util.Map;

/**
 * @author Iván Zaera Avellón
 */
public class BrowserModulesMap {

	public BrowserModulesMap(
		BrowserModulesResolution browserModulesResolution,
		NPMRegistry npmRegistry) {

		_browserModulesResolution = browserModulesResolution;
		_npmRegistry = npmRegistry;
	}

	public JSBrowserModule get(String resolvedModuleId) {
		JSBrowserModule jsBrowserModule = _map.get(resolvedModuleId);

		if (jsBrowserModule == null) {
			JSModule jsModule = _npmRegistry.getResolvedJSModule(
				resolvedModuleId);

			if (jsModule != null) {
				jsBrowserModule = new JSBrowserModule(
					_browserModulesResolution, jsModule, _npmRegistry);

				_map.put(jsBrowserModule.getName(), jsBrowserModule);
			}
		}

		return jsBrowserModule;
	}

	private final BrowserModulesResolution _browserModulesResolution;
	private final Map<String, JSBrowserModule> _map = new HashMap<>();
	private final NPMRegistry _npmRegistry;

}