/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.js.loader.modules.extender.internal.npm;

import com.github.yuchi.semver.Range;
import com.github.yuchi.semver.Version;
import com.liferay.frontend.js.loader.modules.extender.internal.config.generator.JSConfigGeneratorPackage;
import com.liferay.frontend.js.loader.modules.extender.internal.configuration.Details;
import com.liferay.frontend.js.loader.modules.extender.internal.npm.NPMRegistryUpdateImpl;
import com.liferay.frontend.js.loader.modules.extender.npm.JSBundle;
import com.liferay.frontend.js.loader.modules.extender.npm.JSBundleProcessor;
import com.liferay.frontend.js.loader.modules.extender.npm.JSBundleTracker;
import com.liferay.frontend.js.loader.modules.extender.npm.JSModule;
import com.liferay.frontend.js.loader.modules.extender.npm.JSModuleAlias;
import com.liferay.frontend.js.loader.modules.extender.npm.JSPackage;
import com.liferay.frontend.js.loader.modules.extender.npm.JSPackageDependency;
import com.liferay.frontend.js.loader.modules.extender.npm.ModuleNameUtil;
import com.liferay.frontend.js.loader.modules.extender.npm.NPMJavaScriptLastModifiedUtil;
import com.liferay.frontend.js.loader.modules.extender.npm.NPMRegistry;
import com.liferay.frontend.js.loader.modules.extender.npm.NPMRegistryUpdate;
import com.liferay.frontend.js.loader.modules.extender.npm.NPMRegistryUpdatesListener;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerList;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerListFactory;
import com.liferay.osgi.util.ServiceTrackerFactory;
import com.liferay.petra.concurrent.DCLSingleton;
import com.liferay.petra.lang.CentralizedThreadLocal;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyFactory;
import com.liferay.portal.kernel.util.URLUtil;
import com.liferay.portal.kernel.util.Validator;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import javax.servlet.ServletContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(configurationPid={"com.liferay.frontend.js.loader.modules.extender.internal.configuration.Details"}, service={NPMRegistry.class})
public class NPMRegistryImpl
implements NPMRegistry {
    private static final JSPackage _NULL_JS_PACKAGE = (JSPackage)ProxyFactory.newDummyInstance(JSPackage.class);
    private static final Log _log = LogFactoryUtil.getLog(NPMRegistryImpl.class);
    private static final ThreadLocal<Boolean> _activationThreadLocal = new CentralizedThreadLocal(NPMRegistryImpl.class.getName() + "._activationThreadLocal", () -> Boolean.FALSE);
    private volatile Boolean _applyVersioning;
    private BundleContext _bundleContext;
    private BundleTracker<JSBundle> _bundleTracker;
    private final DCLSingleton<DataBag> _dataBagDCLSingleton = new DCLSingleton();
    private volatile Supplier<DataBag> _dataBagSupplier;
    private final Map<String, String> _globalAliases = new HashMap<String, String>();
    @Reference
    private JSBundleProcessor _jsBundleProcessor;
    @Reference
    private JSONFactory _jsonFactory;
    private ServiceTrackerList<NPMRegistryUpdatesListener> _npmRegistryUpdatesListeners;
    private final Map<String, String> _partialMatchMap = new ConcurrentHashMap<String, String>();
    private volatile ServiceTracker<ServletContext, JSConfigGeneratorPackage> _serviceTracker;

    @Deprecated
    public void addJSBundleTracker(JSBundleTracker jsBundleTracker) {
    }

    public void finishUpdate(NPMRegistryUpdate npmRegistryUpdate) {
        this._setDataBagSupplier(() -> this._createDataBag(null));
        this._notifyNPMRegistryUpdatesListeners();
    }

    public Map<String, String> getGlobalAliases() {
        return this._globalAliases;
    }

    public Collection<JSBundle> getJSBundles() {
        Map tracked = this._bundleTracker.getTracked();
        return tracked.values();
    }

    public JSModule getJSModule(String identifier) {
        DataBag dataBag = this._getDataBag();
        Map jsModules = dataBag._jsModules;
        return (JSModule)jsModules.get(identifier);
    }

    public JSPackage getJSPackage(String identifier) {
        DataBag dataBag = this._getDataBag();
        Map jsPackages = dataBag._jsPackages;
        return (JSPackage)jsPackages.get(identifier);
    }

    public Collection<JSPackage> getJSPackages() {
        DataBag dataBag = this._getDataBag();
        Map jsPackages = dataBag._jsPackages;
        return jsPackages.values();
    }

    public JSModule getResolvedJSModule(String identifier) {
        DataBag dataBag = this._getDataBag();
        Map resolvedJSModules = dataBag._resolvedJSModules;
        return (JSModule)resolvedJSModules.get(identifier);
    }

    public Collection<JSModule> getResolvedJSModules() {
        DataBag dataBag = this._getDataBag();
        Map resolvedJSModules = dataBag._resolvedJSModules;
        return resolvedJSModules.values();
    }

    public JSPackage getResolvedJSPackage(String identifier) {
        DataBag dataBag = this._getDataBag();
        Map resolvedJSPackages = dataBag._resolvedJSPackages;
        return (JSPackage)resolvedJSPackages.get(identifier);
    }

    public Collection<JSPackage> getResolvedJSPackages() {
        DataBag dataBag = this._getDataBag();
        Map resolvedJSPackages = dataBag._resolvedJSPackages;
        return resolvedJSPackages.values();
    }

    public String mapModuleName(String moduleName) {
        String resolvedId;
        DataBag dataBag = this._getDataBag();
        Map exactMatchMap = dataBag._exactMatchMap;
        String mappedModuleName = (String)exactMatchMap.get(moduleName);
        if (Validator.isNotNull((String)mappedModuleName)) {
            return this.mapModuleName(mappedModuleName);
        }
        for (Map.Entry<String, String> entry : this._globalAliases.entrySet()) {
            resolvedId = entry.getKey();
            if (!resolvedId.equals(moduleName) && !moduleName.startsWith(resolvedId + "/")) continue;
            return this.mapModuleName(entry.getValue() + moduleName.substring(resolvedId.length()));
        }
        for (Map.Entry<String, String> entry : this._partialMatchMap.entrySet()) {
            resolvedId = entry.getKey();
            if (!resolvedId.equals(moduleName) && !moduleName.startsWith(resolvedId + "/")) continue;
            return this.mapModuleName(entry.getValue() + moduleName.substring(resolvedId.length()));
        }
        return moduleName;
    }

    @Deprecated
    public void removeJSBundleTracker(JSBundleTracker jsBundleTracker) {
    }

    public JSPackage resolveJSPackageDependency(JSPackageDependency jsPackageDependency) {
        String packageName = jsPackageDependency.getPackageName();
        String versionConstraints = jsPackageDependency.getVersionConstraints();
        String cacheKey = StringBundler.concat((String[])new String[]{packageName, "_", versionConstraints});
        DataBag dataBag = this._getDataBag();
        Map dependencyJSPackages = dataBag._dependencyJSPackages;
        JSPackage jsPackage = (JSPackage)dependencyJSPackages.get(cacheKey);
        if (jsPackage != null) {
            if (jsPackage == _NULL_JS_PACKAGE) {
                return null;
            }
            return jsPackage;
        }
        Range range = Range.from((Object)versionConstraints, (boolean)true);
        List jsPackageVersions = dataBag._jsPackageVersions;
        for (JSPackageVersion jsPackageVersion : jsPackageVersions) {
            JSPackage innerJSPackage = jsPackageVersion._jsPackage;
            Version version = jsPackageVersion._version;
            if (!packageName.equals(innerJSPackage.getName()) || !range.test(version)) continue;
            jsPackage = innerJSPackage;
            break;
        }
        if (jsPackage == null) {
            dependencyJSPackages.put(cacheKey, _NULL_JS_PACKAGE);
        } else {
            dependencyJSPackages.put(cacheKey, jsPackage);
        }
        return jsPackage;
    }

    public NPMRegistryUpdate update() {
        return new NPMRegistryUpdateImpl(this);
    }

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) {
        this._bundleContext = bundleContext;
        this._bundleTracker = new BundleTracker(this._bundleContext, 32, (BundleTrackerCustomizer)new NPMRegistryBundleTrackerCustomizer());
        _activationThreadLocal.set(Boolean.TRUE);
        this._bundleTracker.open();
        _activationThreadLocal.set(Boolean.FALSE);
        Map tracked = this._bundleTracker.getTracked();
        this._setDataBagSupplier(() -> this._createDataBag(tracked.values()));
        Details details = (Details)ConfigurableUtil.createConfigurable(Details.class, properties);
        this._applyVersioning = details.applyVersioning();
        this._serviceTracker = this._openServiceTracker();
    }

    @Deactivate
    protected void deactivate() {
        if (this._npmRegistryUpdatesListeners != null) {
            this._npmRegistryUpdatesListeners.close();
        }
        this._serviceTracker.close();
        _activationThreadLocal.set(Boolean.TRUE);
        this._bundleTracker.close();
        _activationThreadLocal.set(Boolean.FALSE);
    }

    @Modified
    protected void modified(Map<String, Object> properties) {
        Details details = (Details)ConfigurableUtil.createConfigurable(Details.class, properties);
        if (details.applyVersioning() != this._applyVersioning.booleanValue()) {
            this._applyVersioning = details.applyVersioning();
            this._serviceTracker.close();
            this._serviceTracker = this._openServiceTracker();
        }
    }

    private DataBag _createDataBag(Collection<JSBundle> jsBundles) {
        if (jsBundles == null) {
            Map tracked = this._bundleTracker.getTracked();
            jsBundles = tracked.values();
        }
        HashMap<String, JSModule> jsModules = new HashMap<String, JSModule>();
        HashMap<String, JSPackage> jsPackages = new HashMap<String, JSPackage>();
        ArrayList<JSPackageVersion> jsPackageVersions = new ArrayList<JSPackageVersion>();
        HashMap<String, JSModule> resolvedJSModules = new HashMap<String, JSModule>();
        HashMap<String, JSPackage> resolvedJSPackages = new HashMap<String, JSPackage>();
        HashMap<String, String> exactMatchMap = new HashMap<String, String>();
        for (JSBundle jSBundle : jsBundles) {
            for (JSPackage jsPackage : jSBundle.getJSPackages()) {
                jsPackages.put(jsPackage.getId(), jsPackage);
                jsPackageVersions.add(new JSPackageVersion(jsPackage));
                String resolvedId = jsPackage.getResolvedId();
                resolvedJSPackages.put(resolvedId, jsPackage);
                exactMatchMap.put(resolvedId, ModuleNameUtil.getModuleResolvedId((JSPackage)jsPackage, (String)jsPackage.getMainModuleName()));
                for (JSModuleAlias jsModuleAlias : jsPackage.getJSModuleAliases()) {
                    String aliasResolvedId = ModuleNameUtil.getModuleResolvedId((JSPackage)jsPackage, (String)jsModuleAlias.getAlias());
                    exactMatchMap.put(aliasResolvedId, ModuleNameUtil.getModuleResolvedId((JSPackage)jsPackage, (String)jsModuleAlias.getModuleName()));
                }
                for (JSModule jsModule : jsPackage.getJSModules()) {
                    jsModules.put(jsModule.getId(), jsModule);
                    resolvedJSModules.put(jsModule.getResolvedId(), jsModule);
                }
            }
        }
        Comparator<JSPackageVersion> comparator = Comparator.comparing(JSPackageVersion::getVersion);
        jsPackageVersions.sort(comparator.reversed());
        return new DataBag(exactMatchMap, jsModules, jsPackages, jsPackageVersions, resolvedJSModules, resolvedJSPackages);
    }

    private DataBag _getDataBag() {
        return (DataBag)this._dataBagDCLSingleton.getSingleton(this._dataBagSupplier);
    }

    private ServiceTrackerList<NPMRegistryUpdatesListener> _getNPMRegistryUpdatesListeners() {
        if (this._npmRegistryUpdatesListeners == null) {
            this._npmRegistryUpdatesListeners = ServiceTrackerListFactory.open((BundleContext)this._bundleContext, NPMRegistryUpdatesListener.class);
        }
        return this._npmRegistryUpdatesListeners;
    }

    private JSONObject _getPackageJSONObject(Bundle bundle) {
        try {
            URL url = bundle.getEntry("package.json");
            if (url == null) {
                return null;
            }
            return this._jsonFactory.createJSONObject(URLUtil.toString((URL)url));
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return null;
        }
    }

    private void _notifyNPMRegistryUpdatesListeners() {
        for (NPMRegistryUpdatesListener npmRegistryUpdatesListener : this._getNPMRegistryUpdatesListeners()) {
            npmRegistryUpdatesListener.onAfterUpdate();
        }
    }

    private ServiceTracker<ServletContext, JSConfigGeneratorPackage> _openServiceTracker() {
        return ServiceTrackerFactory.open((BundleContext)this._bundleContext, (String)("(&(objectClass=" + ServletContext.class.getName() + ")(osgi.web.contextpath=*))"), (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<ServletContext, JSConfigGeneratorPackage>(){

            public JSConfigGeneratorPackage addingService(ServiceReference<ServletContext> serviceReference) {
                Bundle bundle = serviceReference.getBundle();
                URL url = bundle.getEntry("META-INF/config.json");
                if (url == null) {
                    return null;
                }
                JSConfigGeneratorPackage jsConfigGeneratorPackage = new JSConfigGeneratorPackage(NPMRegistryImpl.this._applyVersioning, serviceReference.getBundle(), (String)serviceReference.getProperty("osgi.web.contextpath"));
                String jsConfigGeneratorPackageResolvedId = jsConfigGeneratorPackage.getName() + "@" + jsConfigGeneratorPackage.getVersion();
                NPMRegistryImpl.this._partialMatchMap.put(jsConfigGeneratorPackage.getName(), jsConfigGeneratorPackageResolvedId);
                return jsConfigGeneratorPackage;
            }

            public void modifiedService(ServiceReference<ServletContext> serviceReference, JSConfigGeneratorPackage jsConfigGeneratorPackage) {
            }

            public void removedService(ServiceReference<ServletContext> serviceReference, JSConfigGeneratorPackage jsConfigGeneratorPackage) {
                NPMRegistryImpl.this._partialMatchMap.remove(jsConfigGeneratorPackage.getName());
            }
        });
    }

    private void _processLegacyBridges(Bundle bundle) {
        Dictionary headers = bundle.getHeaders("");
        String jsSubmodulesBridge = GetterUtil.getString((String)((String)headers.get("Liferay-JS-Submodules-Bridge")));
        if (Validator.isNotNull((String)jsSubmodulesBridge)) {
            String[] bridges = jsSubmodulesBridge.split(",");
            JSONObject packageJSONObject = this._getPackageJSONObject(bundle);
            for (String bridge : bridges) {
                bridge = bridge.trim();
                this._globalAliases.put(bridge, StringBundler.concat((String[])new String[]{packageJSONObject.getString("name"), "@", packageJSONObject.getString("version"), "/bridge/", bridge}));
            }
        }
    }

    private void _setDataBagSupplier(Supplier<DataBag> dataBagSupplier) {
        this._dataBagSupplier = dataBagSupplier;
        this._dataBagDCLSingleton.destroy(null);
    }

    private class NPMRegistryBundleTrackerCustomizer
    implements BundleTrackerCustomizer<JSBundle> {
        private NPMRegistryBundleTrackerCustomizer() {
        }

        public JSBundle addingBundle(Bundle bundle, BundleEvent bundleEvent) {
            JSBundle jsBundle = NPMRegistryImpl.this._jsBundleProcessor.process(bundle);
            if (jsBundle == null) {
                return null;
            }
            NPMRegistryImpl.this._processLegacyBridges(bundle);
            if (!((Boolean)_activationThreadLocal.get()).booleanValue()) {
                Map tracked = NPMRegistryImpl.this._bundleTracker.getTracked();
                ArrayList jsBundles = new ArrayList(tracked.values());
                jsBundles.add(jsBundle);
                NPMRegistryImpl.this._setDataBagSupplier(() -> NPMRegistryImpl.this._createDataBag(jsBundles));
                NPMRegistryImpl.this._notifyNPMRegistryUpdatesListeners();
                NPMJavaScriptLastModifiedUtil.updateLastModified((long)bundle.getLastModified());
            }
            return jsBundle;
        }

        public void modifiedBundle(Bundle bundle, BundleEvent bundleEvent, JSBundle jsBundle) {
        }

        public void removedBundle(Bundle bundle, BundleEvent bundleEvent, JSBundle jsBundle) {
            if (!((Boolean)_activationThreadLocal.get()).booleanValue()) {
                NPMRegistryImpl.this._setDataBagSupplier(() -> NPMRegistryImpl.this._createDataBag(null));
                NPMRegistryImpl.this._notifyNPMRegistryUpdatesListeners();
            }
        }
    }

    private static class JSPackageVersion {
        private final JSPackage _jsPackage;
        private final Version _version;

        public Version getVersion() {
            return this._version;
        }

        private JSPackageVersion(JSPackage jsPackage) {
            this._jsPackage = jsPackage;
            this._version = Version.from((Object)jsPackage.getVersion(), (boolean)true);
        }
    }

    private static class DataBag {
        private final Map<String, JSPackage> _dependencyJSPackages = new ConcurrentHashMap<String, JSPackage>();
        private final Map<String, String> _exactMatchMap;
        private final Map<String, JSModule> _jsModules;
        private final Map<String, JSPackage> _jsPackages;
        private final List<JSPackageVersion> _jsPackageVersions;
        private final Map<String, JSModule> _resolvedJSModules;
        private final Map<String, JSPackage> _resolvedJSPackages;

        private DataBag(Map<String, String> exactMatchMap, Map<String, JSModule> jsModules, Map<String, JSPackage> jsPackages, List<JSPackageVersion> jsPackageVersions, Map<String, JSModule> resolvedJSModules, Map<String, JSPackage> resolvedJSPackages) {
            this._exactMatchMap = exactMatchMap;
            this._jsModules = jsModules;
            this._jsPackages = jsPackages;
            this._jsPackageVersions = jsPackageVersions;
            this._resolvedJSModules = resolvedJSModules;
            this._resolvedJSPackages = resolvedJSPackages;
        }
    }
}

