/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.js.loader.modules.extender.internal.servlet;

import com.liferay.frontend.js.loader.modules.extender.internal.resolution.BrowserModulesResolution;
import com.liferay.frontend.js.loader.modules.extender.internal.resolution.BrowserModulesResolver;
import com.liferay.frontend.js.loader.modules.extender.npm.NPMRegistryUpdatesListener;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.frontend.js.loader.modules.extender.internal.configuration.Details"}, property={"osgi.http.whiteboard.servlet.name=com.liferay.frontend.js.loader.modules.extender.internal.servlet.JSResolveModulesServlet", "osgi.http.whiteboard.servlet.pattern=/js_resolve_modules", "service.ranking:Integer=2147482647"}, service={JSResolveModulesServlet.class, NPMRegistryUpdatesListener.class, Servlet.class})
public class JSResolveModulesServlet
extends HttpServlet
implements NPMRegistryUpdatesListener {
    @Reference
    private BrowserModulesResolver _browserModulesResolver;
    private volatile String _etag;

    public JSResolveModulesServlet() {
        this.onAfterUpdate();
    }

    public void onAfterUpdate() {
        this._etag = StringBundler.concat((Object[])new Object[]{"W/\"", UUID.randomUUID(), "\""});
    }

    protected void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        if (this._etag.equals(httpServletRequest.getHeader("If-None-Match"))) {
            httpServletResponse.setStatus(304);
            return;
        }
        httpServletResponse.addHeader("Cache-Control", "no-cache");
        httpServletResponse.addHeader("ETag", this._etag);
        httpServletResponse.setCharacterEncoding("UTF-8");
        httpServletResponse.setContentType("application/json");
        PrintWriter printWriter = new PrintWriter((OutputStream)httpServletResponse.getOutputStream(), true);
        BrowserModulesResolution browserModulesResolution = this._browserModulesResolver.resolve(this._getModuleNames(httpServletRequest), httpServletRequest);
        printWriter.write(browserModulesResolution.toJSON());
        printWriter.close();
    }

    private List<String> _getModuleNames(HttpServletRequest httpServletRequest) throws IOException {
        String[] moduleNames = null;
        String method = httpServletRequest.getMethod();
        if (method.equals("GET")) {
            moduleNames = ParamUtil.getStringValues((HttpServletRequest)httpServletRequest, (String)"modules");
        } else {
            String body = StringUtil.read((InputStream)httpServletRequest.getInputStream());
            if (!(body = URLDecoder.decode(body, httpServletRequest.getCharacterEncoding())).isEmpty()) {
                body = body.substring(8);
                moduleNames = body.split(",");
            }
        }
        if (moduleNames != null) {
            return Arrays.asList(moduleNames);
        }
        return Collections.emptyList();
    }
}

