/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.frontend.js.loader.modules.extender.internal.resolution.adapter;

import com.liferay.frontend.js.loader.modules.extender.internal.config.generator.JSConfigGeneratorModule;
import com.liferay.frontend.js.loader.modules.extender.internal.resolution.BrowserModule;
import com.liferay.portal.kernel.json.JSONObject;

import java.util.Collection;
import java.util.Map;

/**
 * This is the browser's domain equivalent of {@link JSConfigGeneratorModule} in
 * server's domain.
 *
 * @author Rodolfo Roza Miranda
 */
public class JSConfigGeneratorBrowserModule implements BrowserModule {

	public JSConfigGeneratorBrowserModule(
		JSConfigGeneratorModule jsConfigGeneratorModule) {

		_jsConfigGeneratorModule = jsConfigGeneratorModule;
	}

	@Override
	public Collection<String> getDependencies() {
		return _jsConfigGeneratorModule.getDependencies();
	}

	@Override
	public Map<String, String> getDependenciesMap() {
		return null;
	}

	@Override
	public JSONObject getFlagsJSONObject() {
		return null;
	}

	@Override
	public String getName() {
		return _jsConfigGeneratorModule.getId();
	}

	@Override
	public String getPath() {
		return _jsConfigGeneratorModule.getURL();
	}

	private final JSConfigGeneratorModule _jsConfigGeneratorModule;

}