/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.frontend.js.loader.modules.extender.internal.npm.flat;

import com.liferay.frontend.js.loader.modules.extender.internal.npm.builtin.BaseBuiltInJSModule;
import com.liferay.frontend.js.loader.modules.extender.npm.JSModule;
import com.liferay.frontend.js.loader.modules.extender.npm.ModuleNameUtil;
import com.liferay.portal.kernel.json.JSONObject;

import java.io.IOException;
import java.io.InputStream;

import java.net.URL;

import java.util.Collection;

/**
 * Provides a complete implementation of {@link JSModule}.
 *
 * @author Iván Zaera
 */
public class FlatJSModule extends BaseBuiltInJSModule implements JSModule {

	/**
	 * Constructs a <code>FlatJSModule</code> with the module's package, name,
	 * and dependencies.
	 *
	 * @param flatJSPackage the module's package
	 * @param name the module's name
	 * @param dependencies the module names this module depends on
	 */
	public FlatJSModule(
		FlatJSPackage flatJSPackage, String name,
		Collection<String> dependencies, JSONObject flagsJSONObject) {

		super(flatJSPackage, name, dependencies, flagsJSONObject);

		_flatJSPackage = flatJSPackage;
	}

	@Override
	public InputStream getInputStream() throws IOException {
		String fileName = ModuleNameUtil.toFileName(getName());

		URL url = _flatJSPackage.getResourceURL(fileName);

		if (url == null) {
			return null;
		}

		return url.openStream();
	}

	@Override
	public InputStream getSourceMapInputStream() throws IOException {
		String fileName = ModuleNameUtil.toFileName(getName());

		URL url = _flatJSPackage.getResourceURL(fileName + ".map");

		if (url == null) {
			return null;
		}

		return url.openStream();
	}

	private final FlatJSPackage _flatJSPackage;

}