/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.frontend.js.loader.modules.extender.internal.npm;

import com.liferay.frontend.js.loader.modules.extender.npm.JSPackage;
import com.liferay.frontend.js.loader.modules.extender.npm.NPMResolver;

import org.osgi.framework.Bundle;

/**
 * @author Iván Zaera Avellón
 */
public class InvalidNPMResolverImpl implements NPMResolver {

	public InvalidNPMResolverImpl(Bundle bundle) {
		_bundle = bundle;
	}

	@Override
	public JSPackage getDependencyJSPackage(String packageName) {
		_throwIllegalStateException();

		return null;
	}

	@Override
	public JSPackage getJSPackage() {
		_throwIllegalStateException();

		return null;
	}

	@Override
	public String resolveModuleName(String moduleName) {
		_throwIllegalStateException();

		return null;
	}

	private void _throwIllegalStateException() {
		throw new IllegalStateException(
			"Unable to find META-INF/resources/package.json in " +
				_bundle.getSymbolicName());
	}

	private final Bundle _bundle;

}