/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.frontend.js.loader.modules.extender.internal.npm.dynamic;

import com.liferay.frontend.js.loader.modules.extender.internal.npm.builtin.BaseBuiltInJSModule;
import com.liferay.frontend.js.loader.modules.extender.npm.JSModule;
import com.liferay.frontend.js.loader.modules.extender.npm.JSPackage;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

import java.util.Collection;

/**
 * Provides an implementation of {@link JSModule} to hold in-memory modules.
 *
 * @author Iván Zaera
 * @review
 */
public class DynamicJSModule extends BaseBuiltInJSModule implements JSModule {

	public DynamicJSModule(
		JSPackage jsPackage, String name, Collection<String> dependencies,
		String js, String map) {

		super(jsPackage, name, dependencies, null);

		_js = js;
		_map = map;
	}

	@Override
	public InputStream getInputStream() throws IOException {
		return new ByteArrayInputStream(_js.getBytes("UTF-8"));
	}

	@Override
	public InputStream getSourceMapInputStream() throws IOException {
		if (_map == null) {
			return null;
		}

		return new ByteArrayInputStream(_map.getBytes("UTF-8"));
	}

	private final String _js;
	private final String _map;

}