/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.js.loader.modules.extender.internal.npm;

import com.liferay.frontend.js.loader.modules.extender.npm.JSPackage;
import com.liferay.frontend.js.loader.modules.extender.npm.JSPackageDependency;
import com.liferay.frontend.js.loader.modules.extender.npm.ModuleNameUtil;
import com.liferay.frontend.js.loader.modules.extender.npm.NPMRegistry;
import com.liferay.frontend.js.loader.modules.extender.npm.NPMResolver;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.osgi.framework.Bundle;

public class NPMResolverImpl
implements NPMResolver {
    private final String _jsPackageIdentifier;
    private final NPMRegistry _npmRegistry;
    private final Map<String, String> _packageNamesMap;

    public NPMResolverImpl(Bundle bundle, JSONFactory jsonFactory, NPMRegistry npmRegistry) {
        this._npmRegistry = npmRegistry;
        this._jsPackageIdentifier = this._resolveJSPackageIdentifier(bundle, jsonFactory);
        this._packageNamesMap = this._loadPackageNamesMap(bundle, jsonFactory);
    }

    public JSPackage getDependencyJSPackage(String packageName) {
        JSPackageDependency jsPackageDependency;
        JSPackage jsPackage = this.getJSPackage();
        String destPackageName = this._packageNamesMap.get(packageName);
        if (Validator.isNull((String)destPackageName)) {
            destPackageName = packageName;
        }
        if ((jsPackageDependency = jsPackage.getJSPackageDependency(destPackageName)) == null) {
            return null;
        }
        return this._npmRegistry.resolveJSPackageDependency(jsPackageDependency);
    }

    public JSPackage getJSPackage() {
        return this._npmRegistry.getJSPackage(this._jsPackageIdentifier);
    }

    public String resolveModuleName(String moduleName) {
        JSPackage jsPackage;
        String packageName = ModuleNameUtil.getPackageName((String)moduleName);
        if (!packageName.equals((jsPackage = this.getJSPackage()).getName()) && (jsPackage = this.getDependencyJSPackage(packageName)) == null) {
            return null;
        }
        StringBundler sb = new StringBundler(3);
        sb.append(jsPackage.getResolvedId());
        String packagePath = ModuleNameUtil.getPackagePath((String)moduleName);
        if (packagePath != null) {
            sb.append("/");
            sb.append(packagePath);
        }
        return sb.toString();
    }

    private Map<String, String> _loadPackageNamesMap(Bundle bundle, JSONFactory jsonFactory) {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            URL url = bundle.getEntry("META-INF/resources/manifest.json");
            if (url != null) {
                String content = StringUtil.read((InputStream)url.openStream());
                JSONObject jsonObject = jsonFactory.createJSONObject(content);
                JSONObject packagesJSONObject = jsonObject.getJSONObject("packages");
                Iterator iterator = packagesJSONObject.keys();
                while (iterator.hasNext()) {
                    String packageId = (String)iterator.next();
                    JSONObject packageJSONObject = packagesJSONObject.getJSONObject(packageId);
                    JSONObject srcJSONObject = packageJSONObject.getJSONObject("src");
                    JSONObject destJSONObject = packageJSONObject.getJSONObject("dest");
                    map.put(srcJSONObject.getString("name"), destJSONObject.getString("name"));
                }
            }
            return map;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private String _resolveJSPackageIdentifier(Bundle bundle, JSONFactory jsonFactory) {
        try {
            StringBundler sb = new StringBundler(5);
            sb.append(bundle.getBundleId());
            sb.append("/");
            URL url = bundle.getEntry("META-INF/resources/package.json");
            String content = StringUtil.read((InputStream)url.openStream());
            JSONObject jsonObject = jsonFactory.createJSONObject(content);
            String name = jsonObject.getString("name");
            sb.append(name);
            sb.append("@");
            String version = jsonObject.getString("version");
            sb.append(version);
            return sb.toString();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }
}

