/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.js.loader.modules.extender.internal.resolution;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.HashMapBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BrowserModulesResolution {
    private final Map<String, Map<String, String>> _dependenciesMap = new HashMap<String, Map<String, String>>();
    private final Set<String> _errors = new HashSet<String>();
    private int _explainIndentation;
    private List<String> _explanation;
    private final Map<String, JSONObject> _flagsJSONObjects = new HashMap<String, JSONObject>();
    private final JSONFactory _jsonFactory;
    private final Map<String, Object> _mappedModuleNamesMap = new HashMap<String, Object>();
    private final Map<String, String> _pathsMap = new HashMap<String, String>();
    private final Set<String> _processedModuleNames = new HashSet<String>();
    private final List<String> _resolvedModuleNames = new ArrayList<String>();
    private final Set<String> _warnings = new HashSet<String>();

    public BrowserModulesResolution(JSONFactory jsonFactory, boolean explain) {
        this._jsonFactory = jsonFactory;
        if (explain) {
            this._explanation = new ArrayList<String>();
        }
    }

    public void addError(String error) {
        this._errors.add(error);
    }

    public void addProcessedModuleName(String moduleName) {
        this._processedModuleNames.add(moduleName);
    }

    public void addResolvedModuleName(String moduleName) {
        this._resolvedModuleNames.add(moduleName);
        if (this._explanation == null) {
            return;
        }
        StringBundler sb = new StringBundler(this._explainIndentation);
        for (int i = 0; i < this._explainIndentation; ++i) {
            sb.append("  ");
        }
        sb.append(moduleName);
        this._explanation.add(0, sb.toString());
    }

    public void addWarning(String warning) {
        this._warnings.add(warning);
    }

    public void dedentExplanation() {
        --this._explainIndentation;
    }

    public List<String> getResolvedModuleNames() {
        return this._resolvedModuleNames;
    }

    public void indentExplanation() {
        ++this._explainIndentation;
    }

    public boolean isProcessedModuleName(String moduleName) {
        return this._processedModuleNames.contains(moduleName);
    }

    public void putDependenciesMap(String moduleName, Map<String, String> dependenciesMap) {
        this._dependenciesMap.put(moduleName, dependenciesMap);
    }

    public void putMappedModuleName(String moduleName, String mappedModuleName, boolean exactMatch) {
        Object value = mappedModuleName;
        if (exactMatch) {
            HashMap map = HashMapBuilder.put((Object)"exactMatch", (Object)true).put((Object)"value", (Object)mappedModuleName).build();
            value = map;
        }
        this._mappedModuleNamesMap.put(moduleName, value);
    }

    public void putModuleFlags(String moduleName, JSONObject flagsJSONObject) {
        this._flagsJSONObjects.put(moduleName, flagsJSONObject);
    }

    public void putPath(String moduleName, String path) {
        this._pathsMap.put(moduleName, path);
    }

    public String toJSON() {
        HashMap map = HashMapBuilder.put((Object)"configMap", this._mappedModuleNamesMap).build();
        if (this._errors.size() > 0) {
            ArrayList<String> sortedErrors = new ArrayList<String>(this._errors);
            Collections.sort(sortedErrors);
            map.put("errors", sortedErrors);
        }
        if (this._explanation != null) {
            map.put("explanation", this._resolvedModuleNames);
        }
        map.put("moduleFlags", this._flagsJSONObjects);
        map.put("moduleMap", this._dependenciesMap);
        map.put("pathMap", this._pathsMap);
        map.put("resolvedModules", this._resolvedModuleNames);
        if (this._warnings.size() > 0) {
            ArrayList<String> sortedWarnings = new ArrayList<String>(this._warnings);
            Collections.sort(sortedWarnings);
            map.put("warnings", sortedWarnings);
        }
        return this._jsonFactory.looseSerializeDeep((Object)map);
    }
}

