/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.frontend.js.loader.modules.extender.internal.npm.flat;

import com.liferay.portal.kernel.json.JSONObject;

/**
 * @author Iván Zaera Avellón
 */
public class Manifest {

	public Manifest(JSONObject packagesJSONObject) {
		_packagesJSONObject = packagesJSONObject;
	}

	public JSONObject getFlagsJSONObject(String packageId, String fileName) {
		if (_packagesJSONObject == null) {
			return null;
		}

		JSONObject packageJSONObject = _packagesJSONObject.getJSONObject(
			packageId);

		if (packageJSONObject == null) {
			return null;
		}

		JSONObject modulesJSONObject = packageJSONObject.getJSONObject(
			"modules");

		if (modulesJSONObject == null) {
			return null;
		}

		JSONObject moduleJSONObject = modulesJSONObject.getJSONObject(fileName);

		if (moduleJSONObject == null) {
			return null;
		}

		return moduleJSONObject.getJSONObject("flags");
	}

	private final JSONObject _packagesJSONObject;

}