/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.frontend.js.loader.modules.extender.internal.npm.builtin;

import com.liferay.frontend.js.loader.modules.extender.npm.JSPackage;

/**
 * @author Iván Zaera Avellón
 */
public class ResourceDescriptor {

	public ResourceDescriptor(JSPackage jsPackage, String packagePath) {
		_jsPackage = jsPackage;
		_packagePath = packagePath;
	}

	public JSPackage getJsPackage() {
		return _jsPackage;
	}

	public String getPackagePath() {
		return _packagePath;
	}

	@Override
	public String toString() {
		return _jsPackage.getResolvedId() + _jsPackage;
	}

	private final JSPackage _jsPackage;
	private final String _packagePath;

}