/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.js.loader.modules.extender.internal.npm;

import com.github.yuchi.semver.Range;
import com.github.yuchi.semver.Version;
import com.liferay.frontend.js.loader.modules.extender.internal.config.generator.JSConfigGeneratorPackage;
import com.liferay.frontend.js.loader.modules.extender.internal.configuration.Details;
import com.liferay.frontend.js.loader.modules.extender.npm.JSBundle;
import com.liferay.frontend.js.loader.modules.extender.npm.JSBundleProcessor;
import com.liferay.frontend.js.loader.modules.extender.npm.JSBundleTracker;
import com.liferay.frontend.js.loader.modules.extender.npm.JSModule;
import com.liferay.frontend.js.loader.modules.extender.npm.JSModuleAlias;
import com.liferay.frontend.js.loader.modules.extender.npm.JSPackage;
import com.liferay.frontend.js.loader.modules.extender.npm.JSPackageDependency;
import com.liferay.frontend.js.loader.modules.extender.npm.ModuleNameUtil;
import com.liferay.frontend.js.loader.modules.extender.npm.NPMRegistry;
import com.liferay.osgi.util.ServiceTrackerFactory;
import com.liferay.petra.lang.CentralizedThreadLocal;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyFactory;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(configurationPid={"com.liferay.frontend.js.loader.modules.extender.internal.configuration.Details"}, immediate=true, service={NPMRegistry.class})
public class NPMRegistryImpl
implements NPMRegistry {
    private static final JSPackage _NULL_JS_PACKAGE = (JSPackage)ProxyFactory.newDummyInstance(JSPackage.class);
    private static final ThreadLocal<Boolean> _activationThreadLocal = new CentralizedThreadLocal(NPMRegistryImpl.class.getName() + "._activationThreadLocal", () -> Boolean.FALSE);
    private Boolean _applyVersioning;
    private BundleContext _bundleContext;
    private BundleTracker<JSBundle> _bundleTracker;
    private final Map<String, JSPackage> _dependencyJSPackages = new ConcurrentHashMap<String, JSPackage>();
    private Map<String, String> _exactMatchMap;
    private final Map<String, String> _globalAliases = new HashMap<String, String>();
    @Reference
    private JSBundleProcessor _jsBundleProcessor;
    private Map<String, JSModule> _jsModules = new HashMap<String, JSModule>();
    @Reference
    private JSONFactory _jsonFactory;
    private Map<String, JSPackage> _jsPackages = new HashMap<String, JSPackage>();
    private List<JSPackageVersion> _jsPackageVersions = new ArrayList<JSPackageVersion>();
    private final Map<String, String> _partialMatchMap = new ConcurrentHashMap<String, String>();
    private Map<String, JSModule> _resolvedJSModules = new HashMap<String, JSModule>();
    private Map<String, JSPackage> _resolvedJSPackages = new HashMap<String, JSPackage>();
    private ServiceTracker<ServletContext, JSConfigGeneratorPackage> _serviceTracker;

    @Deprecated
    public void addJSBundleTracker(JSBundleTracker jsBundleTracker) {
    }

    public Map<String, String> getGlobalAliases() {
        return this._globalAliases;
    }

    public Collection<JSBundle> getJSBundles() {
        Map tracked = this._bundleTracker.getTracked();
        return tracked.values();
    }

    public JSModule getJSModule(String identifier) {
        return this._jsModules.get(identifier);
    }

    public JSPackage getJSPackage(String identifier) {
        return this._jsPackages.get(identifier);
    }

    public Collection<JSPackage> getJSPackages() {
        return this._jsPackages.values();
    }

    public JSModule getResolvedJSModule(String identifier) {
        return this._resolvedJSModules.get(identifier);
    }

    public Collection<JSModule> getResolvedJSModules() {
        return this._resolvedJSModules.values();
    }

    public JSPackage getResolvedJSPackage(String identifier) {
        return this._resolvedJSPackages.get(identifier);
    }

    public Collection<JSPackage> getResolvedJSPackages() {
        return this._resolvedJSPackages.values();
    }

    public String mapModuleName(String moduleName) {
        String resolvedId;
        String mappedModuleName = this._exactMatchMap.get(moduleName);
        if (Validator.isNotNull((String)mappedModuleName)) {
            return mappedModuleName;
        }
        for (Map.Entry<String, String> entry : this._globalAliases.entrySet()) {
            resolvedId = entry.getKey();
            if (!resolvedId.equals(moduleName) && !moduleName.startsWith(resolvedId + "/")) continue;
            return entry.getValue() + moduleName.substring(resolvedId.length());
        }
        for (Map.Entry<String, String> entry : this._partialMatchMap.entrySet()) {
            resolvedId = entry.getKey();
            if (!resolvedId.equals(moduleName) && !moduleName.startsWith(resolvedId + "/")) continue;
            return entry.getValue() + moduleName.substring(resolvedId.length());
        }
        return moduleName;
    }

    @Deprecated
    public void removeJSBundleTracker(JSBundleTracker jsBundleTracker) {
    }

    public JSPackage resolveJSPackageDependency(JSPackageDependency jsPackageDependency) {
        String versionConstraints;
        String packageName = jsPackageDependency.getPackageName();
        String cacheKey = StringBundler.concat((String[])new String[]{packageName, "_", versionConstraints = jsPackageDependency.getVersionConstraints()});
        JSPackage jsPackage = this._dependencyJSPackages.get(cacheKey);
        if (jsPackage != null) {
            if (jsPackage == _NULL_JS_PACKAGE) {
                return null;
            }
            return jsPackage;
        }
        Range range = Range.from((Object)versionConstraints, (boolean)true);
        for (JSPackageVersion jsPackageVersion : this._jsPackageVersions) {
            JSPackage innerJSPackage = jsPackageVersion._jsPackage;
            Version version = jsPackageVersion._version;
            if (!packageName.equals(innerJSPackage.getName()) || !range.test(version)) continue;
            jsPackage = innerJSPackage;
            break;
        }
        if (jsPackage == null) {
            this._dependencyJSPackages.put(cacheKey, _NULL_JS_PACKAGE);
        } else {
            this._dependencyJSPackages.put(cacheKey, jsPackage);
        }
        return jsPackage;
    }

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) {
        this._bundleContext = bundleContext;
        this._bundleTracker = new BundleTracker(this._bundleContext, 32, (BundleTrackerCustomizer)new NPMRegistryBundleTrackerCustomizer());
        _activationThreadLocal.set(Boolean.TRUE);
        this._bundleTracker.open();
        _activationThreadLocal.set(Boolean.FALSE);
        Map tracked = this._bundleTracker.getTracked();
        this._refreshJSModuleCaches(tracked.values());
        Details details = (Details)ConfigurableUtil.createConfigurable(Details.class, properties);
        this._applyVersioning = details.applyVersioning();
        this._serviceTracker = this._openServiceTracker();
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTracker.close();
        this._bundleTracker.close();
    }

    @Modified
    protected void modified(Map<String, Object> properties) {
        Details details = (Details)ConfigurableUtil.createConfigurable(Details.class, properties);
        if (details.applyVersioning() != this._applyVersioning.booleanValue()) {
            this._applyVersioning = details.applyVersioning();
            this._serviceTracker.close();
            this._serviceTracker = this._openServiceTracker();
        }
    }

    private JSONObject _getPackageJSONObject(Bundle bundle) {
        try {
            String content;
            URL url = bundle.getEntry("package.json");
            if (url == null) {
                return null;
            }
            try {
                content = StringUtil.read((InputStream)url.openStream());
            }
            catch (IOException ioException) {
                return null;
            }
            if (content == null) {
                return null;
            }
            return this._jsonFactory.createJSONObject(content);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private ServiceTracker<ServletContext, JSConfigGeneratorPackage> _openServiceTracker() {
        return ServiceTrackerFactory.open((BundleContext)this._bundleContext, (String)("(&(objectClass=" + ServletContext.class.getName() + ")(osgi.web.contextpath=*))"), (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<ServletContext, JSConfigGeneratorPackage>(){

            public JSConfigGeneratorPackage addingService(ServiceReference<ServletContext> serviceReference) {
                Bundle bundle = serviceReference.getBundle();
                URL url = bundle.getEntry("META-INF/config.json");
                if (url == null) {
                    return null;
                }
                JSConfigGeneratorPackage jsConfigGeneratorPackage = new JSConfigGeneratorPackage(NPMRegistryImpl.this._applyVersioning, serviceReference.getBundle(), (String)serviceReference.getProperty("osgi.web.contextpath"));
                String jsConfigGeneratorPackageResolvedId = jsConfigGeneratorPackage.getName() + "@" + jsConfigGeneratorPackage.getVersion();
                NPMRegistryImpl.this._partialMatchMap.put(jsConfigGeneratorPackage.getName(), jsConfigGeneratorPackageResolvedId);
                return jsConfigGeneratorPackage;
            }

            public void modifiedService(ServiceReference<ServletContext> serviceReference, JSConfigGeneratorPackage jsConfigGeneratorPackage) {
            }

            public void removedService(ServiceReference<ServletContext> serviceReference, JSConfigGeneratorPackage jsConfigGeneratorPackage) {
                NPMRegistryImpl.this._partialMatchMap.remove(jsConfigGeneratorPackage.getName());
            }
        });
    }

    private void _processLegacyBridges(Bundle bundle) {
        Dictionary headers = bundle.getHeaders("");
        String jsSubmodulesBridge = GetterUtil.getString((String)((String)headers.get("Liferay-JS-Submodules-Bridge")));
        if (Validator.isNotNull((String)jsSubmodulesBridge)) {
            String[] bridges = jsSubmodulesBridge.split(",");
            JSONObject packageJSONObject = this._getPackageJSONObject(bundle);
            for (String bridge : bridges) {
                bridge = bridge.trim();
                StringBundler sb = new StringBundler(5);
                sb.append(packageJSONObject.getString("name"));
                sb.append("@");
                sb.append(packageJSONObject.getString("version"));
                sb.append("/bridge/");
                sb.append(bridge);
                this._globalAliases.put(bridge, sb.toString());
            }
        }
    }

    private void _refreshJSModuleCaches(Collection<JSBundle> jsBundles) {
        this._dependencyJSPackages.clear();
        HashMap<String, JSModule> jsModules = new HashMap<String, JSModule>();
        HashMap<String, JSPackage> jsPackages = new HashMap<String, JSPackage>();
        ArrayList<JSPackageVersion> jsPackageVersions = new ArrayList<JSPackageVersion>();
        HashMap<String, JSModule> resolvedJSModules = new HashMap<String, JSModule>();
        HashMap<String, JSPackage> resolvedJSPackages = new HashMap<String, JSPackage>();
        HashMap<String, String> exactMatchMap = new HashMap<String, String>();
        for (JSBundle jsBundle : jsBundles) {
            for (JSPackage jsPackage : jsBundle.getJSPackages()) {
                jsPackages.put(jsPackage.getId(), jsPackage);
                jsPackageVersions.add(new JSPackageVersion(jsPackage));
                String resolvedId = jsPackage.getResolvedId();
                resolvedJSPackages.put(resolvedId, jsPackage);
                exactMatchMap.put(resolvedId, ModuleNameUtil.getModuleResolvedId((JSPackage)jsPackage, (String)jsPackage.getMainModuleName()));
                for (JSModuleAlias jsModuleAlias : jsPackage.getJSModuleAliases()) {
                    String aliasResolvedId = ModuleNameUtil.getModuleResolvedId((JSPackage)jsPackage, (String)jsModuleAlias.getAlias());
                    String moduleResolvedId = ModuleNameUtil.getModuleResolvedId((JSPackage)jsPackage, (String)jsModuleAlias.getModuleName());
                    exactMatchMap.put(aliasResolvedId, moduleResolvedId);
                }
                for (JSModule jsModule : jsPackage.getJSModules()) {
                    jsModules.put(jsModule.getId(), jsModule);
                    resolvedJSModules.put(jsModule.getResolvedId(), jsModule);
                }
            }
        }
        Comparator<JSPackageVersion> comparator = Comparator.comparing(JSPackageVersion::getVersion);
        jsPackageVersions.sort(comparator.reversed());
        this._jsModules = jsModules;
        this._jsPackages = jsPackages;
        this._jsPackageVersions = jsPackageVersions;
        this._resolvedJSModules = resolvedJSModules;
        this._resolvedJSPackages = resolvedJSPackages;
        this._exactMatchMap = exactMatchMap;
    }

    private class NPMRegistryBundleTrackerCustomizer
    implements BundleTrackerCustomizer<JSBundle> {
        private NPMRegistryBundleTrackerCustomizer() {
        }

        public JSBundle addingBundle(Bundle bundle, BundleEvent bundleEvent) {
            JSBundle jsBundle = NPMRegistryImpl.this._jsBundleProcessor.process(bundle);
            if (jsBundle == null) {
                return null;
            }
            NPMRegistryImpl.this._processLegacyBridges(bundle);
            if (!((Boolean)_activationThreadLocal.get()).booleanValue()) {
                Map tracked = NPMRegistryImpl.this._bundleTracker.getTracked();
                ArrayList jsBundles = new ArrayList(tracked.values());
                jsBundles.add(jsBundle);
                NPMRegistryImpl.this._refreshJSModuleCaches(jsBundles);
            }
            return jsBundle;
        }

        public void modifiedBundle(Bundle bundle, BundleEvent bundleEvent, JSBundle jsBundle) {
        }

        public void removedBundle(Bundle bundle, BundleEvent bundleEvent, JSBundle jsBundle) {
            if (!((Boolean)_activationThreadLocal.get()).booleanValue()) {
                Map tracked = NPMRegistryImpl.this._bundleTracker.getTracked();
                NPMRegistryImpl.this._refreshJSModuleCaches(tracked.values());
            }
        }
    }

    private static class JSPackageVersion {
        private final JSPackage _jsPackage;
        private final Version _version;

        public Version getVersion() {
            return this._version;
        }

        private JSPackageVersion(JSPackage jsPackage) {
            this._jsPackage = jsPackage;
            this._version = Version.from((Object)jsPackage.getVersion(), (boolean)true);
        }
    }
}

