/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.js.loader.modules.extender.internal.resolution.adapter;

import com.liferay.frontend.js.loader.modules.extender.internal.resolution.BrowserModule;
import com.liferay.frontend.js.loader.modules.extender.npm.JSModule;
import com.liferay.frontend.js.loader.modules.extender.npm.JSPackage;
import com.liferay.frontend.js.loader.modules.extender.npm.JSPackageDependency;
import com.liferay.frontend.js.loader.modules.extender.npm.NPMRegistry;
import com.liferay.petra.string.StringBundler;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class JSBrowserModule
implements BrowserModule {
    private final Map<String, String> _dependenciesMap = new HashMap<String, String>();
    private final JSModule _jsModule;

    public JSBrowserModule(JSModule jsModule, NPMRegistry npmRegistry) {
        this._jsModule = jsModule;
        this._populateDependenciesMap(npmRegistry);
    }

    @Override
    public Collection<String> getDependencies() {
        return this._jsModule.getDependencies();
    }

    @Override
    public Map<String, String> getDependenciesMap() {
        return this._dependenciesMap;
    }

    @Override
    public String getName() {
        return this._jsModule.getResolvedId();
    }

    @Override
    public String getPath() {
        return this._jsModule.getResolvedURL();
    }

    private void _populateDependenciesMap(NPMRegistry npmRegistry) {
        JSPackage jsPackage = this._jsModule.getJSPackage();
        for (String dependencyPackageName : this._jsModule.getDependencyPackageNames()) {
            if (dependencyPackageName == null) continue;
            if (dependencyPackageName.equals(jsPackage.getName())) {
                this._dependenciesMap.put(dependencyPackageName, jsPackage.getResolvedId());
                continue;
            }
            JSPackageDependency jsPackageDependency = jsPackage.getJSPackageDependency(dependencyPackageName);
            if (jsPackageDependency == null) {
                String errorMessage = StringBundler.concat((String[])new String[]{":ERROR:Missing version constraints for ", dependencyPackageName, " in package.json of ", jsPackage.getResolvedId()});
                this._dependenciesMap.put(dependencyPackageName, errorMessage);
                continue;
            }
            JSPackage dependencyJSPackage = npmRegistry.resolveJSPackageDependency(jsPackageDependency);
            if (dependencyJSPackage == null) {
                String errorMessage = StringBundler.concat((String[])new String[]{":ERROR:Package ", dependencyPackageName, " which is a dependency of ", jsPackage.getResolvedId(), " is not deployed in the server"});
                this._dependenciesMap.put(dependencyPackageName, errorMessage);
                continue;
            }
            this._dependenciesMap.put(dependencyJSPackage.getName(), dependencyJSPackage.getResolvedId());
        }
    }
}

