/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.js.loader.modules.extender.internal.resolution;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BrowserModulesResolution {
    private final Map<String, Map<String, String>> _dependenciesMap = new HashMap<String, Map<String, String>>();
    private int _explainIndentation;
    private List<String> _explanation;
    private final JSONFactory _jsonFactory;
    private final Map<String, Object> _mappedModuleNamesMap = new HashMap<String, Object>();
    private final Map<String, String> _pathsMap = new HashMap<String, String>();
    private final Set<String> _processedModuleNames = new HashSet<String>();
    private final List<String> _resolvedModuleNames = new ArrayList<String>();

    public BrowserModulesResolution(JSONFactory jsonFactory, boolean explain) {
        this._jsonFactory = jsonFactory;
        if (explain) {
            this._explanation = new ArrayList<String>();
        }
    }

    public void addProcessedModuleName(String moduleName) {
        this._processedModuleNames.add(moduleName);
    }

    public void addResolvedModuleName(String moduleName) {
        this._resolvedModuleNames.add(moduleName);
        if (this._explanation == null) {
            return;
        }
        StringBundler sb = new StringBundler(this._explainIndentation);
        for (int i = 0; i < this._explainIndentation; ++i) {
            sb.append("  ");
        }
        sb.append(moduleName);
        this._explanation.add(0, sb.toString());
    }

    public void dedentExplanation() {
        --this._explainIndentation;
    }

    public List<String> getResolvedModuleNames() {
        return this._resolvedModuleNames;
    }

    public void indentExplanation() {
        ++this._explainIndentation;
    }

    public boolean isProcessedModuleName(String moduleName) {
        return this._processedModuleNames.contains(moduleName);
    }

    public void putDependenciesMap(String moduleName, Map<String, String> dependenciesMap) {
        this._dependenciesMap.put(moduleName, dependenciesMap);
    }

    public void putMappedModuleName(String moduleName, String mappedModuleName, boolean exactMatch) {
        Object value = mappedModuleName;
        if (exactMatch) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("exactMatch", true);
            map.put("value", mappedModuleName);
            value = map;
        }
        this._mappedModuleNamesMap.put(moduleName, value);
    }

    public void putPath(String moduleName, String path) {
        this._pathsMap.put(moduleName, path);
    }

    public String toJSON() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("configMap", this._mappedModuleNamesMap);
        if (this._explanation != null) {
            map.put("explanation", this._resolvedModuleNames);
        }
        map.put("moduleMap", this._dependenciesMap);
        map.put("pathMap", this._pathsMap);
        map.put("resolvedModules", this._resolvedModuleNames);
        return this._jsonFactory.looseSerializeDeep(map);
    }
}

