/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.js.loader.modules.extender.internal.resolution;

import com.liferay.frontend.js.loader.modules.extender.internal.config.generator.JSConfigGeneratorPackage;
import com.liferay.frontend.js.loader.modules.extender.internal.config.generator.JSConfigGeneratorPackagesTracker;
import com.liferay.frontend.js.loader.modules.extender.internal.resolution.BrowserModuleNameMapperCache;
import com.liferay.frontend.js.loader.modules.extender.npm.JSModuleAlias;
import com.liferay.frontend.js.loader.modules.extender.npm.JSPackage;
import com.liferay.frontend.js.loader.modules.extender.npm.NPMRegistry;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;

@Component(immediate=true, service={BrowserModuleNameMapper.class})
public class BrowserModuleNameMapper {
    private final AtomicReference<BrowserModuleNameMapperCache> _browserModuleNameMapperCache = new AtomicReference();
    private BundleTracker<?> _bundleTracker;
    private BundleTrackerCustomizer<?> _bundleTrackerCustomizer = new BundleTrackerCustomizer<Object>(){

        public Object addingBundle(Bundle bundle, BundleEvent event) {
            URL url = bundle.getResource("META-INF/resources/package.json");
            if (url == null) {
                return null;
            }
            BrowserModuleNameMapper.this._clearCache();
            return null;
        }

        public void modifiedBundle(Bundle bundle, BundleEvent event, Object object) {
        }

        public void removedBundle(Bundle bundle, BundleEvent event, Object object) {
            URL url = bundle.getResource("META-INF/resources/package.json");
            if (url == null) {
                return;
            }
            BrowserModuleNameMapper.this._clearCache();
        }
    };
    @Reference
    private JSConfigGeneratorPackagesTracker _jsConfigGeneratorPackagesTracker;
    @Reference
    private NPMRegistry _npmRegistry;

    public String mapModuleName(String moduleName) {
        return this.mapModuleName(moduleName, null);
    }

    public String mapModuleName(String moduleName, Map<String, String> dependenciesMap) {
        String mappedModuleName;
        BrowserModuleNameMapperCache browserModuleNameMapperCache = this._browserModuleNameMapperCache.get();
        if (browserModuleNameMapperCache.isOlderThan(this._jsConfigGeneratorPackagesTracker.getLastModified())) {
            this._clearCache();
            browserModuleNameMapperCache = this._browserModuleNameMapperCache.get();
        }
        if ((mappedModuleName = browserModuleNameMapperCache.get(moduleName, dependenciesMap)) != null) {
            return mappedModuleName;
        }
        mappedModuleName = moduleName;
        if (dependenciesMap != null) {
            mappedModuleName = this._map(moduleName, dependenciesMap, dependenciesMap);
        }
        mappedModuleName = this._map(mappedModuleName, browserModuleNameMapperCache.getExactMatchMap(), browserModuleNameMapperCache.getPartialMatchMap());
        browserModuleNameMapperCache.put(moduleName, dependenciesMap, mappedModuleName);
        return mappedModuleName;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        int stateMask = 36;
        this._bundleTracker = new BundleTracker(bundleContext, stateMask, this._bundleTrackerCustomizer);
        this._bundleTracker.open();
    }

    @Deactivate
    protected void deactivate() {
        this._bundleTracker.close();
        this._bundleTracker = null;
    }

    private static String _getModuleResolvedId(JSPackage jsPackage, String moduleName) {
        StringBundler sb = new StringBundler(3);
        sb.append(jsPackage.getResolvedId());
        sb.append("/");
        sb.append(moduleName);
        return sb.toString();
    }

    private void _clearCache() {
        this._browserModuleNameMapperCache.set(new BrowserModuleNameMapperCache(this._getExactMatchMap(), this._getPartialMatchMap()));
    }

    private Map<String, String> _getExactMatchMap() {
        HashMap<String, String> exactMatchMap = new HashMap<String, String>();
        for (JSPackage jsPackage : this._npmRegistry.getResolvedJSPackages()) {
            String mainModuleResolvedId = BrowserModuleNameMapper._getModuleResolvedId(jsPackage, jsPackage.getMainModuleName());
            exactMatchMap.put(jsPackage.getResolvedId(), mainModuleResolvedId);
            for (JSModuleAlias jsModuleAlias : jsPackage.getJSModuleAliases()) {
                String aliasResolvedId = BrowserModuleNameMapper._getModuleResolvedId(jsPackage, jsModuleAlias.getAlias());
                String moduleResolvedId = BrowserModuleNameMapper._getModuleResolvedId(jsPackage, jsModuleAlias.getModuleName());
                exactMatchMap.put(aliasResolvedId, moduleResolvedId);
            }
        }
        return exactMatchMap;
    }

    private Map<String, String> _getPartialMatchMap() {
        HashMap<String, String> partialMatchMap = new HashMap<String, String>();
        Collection<JSConfigGeneratorPackage> jsConfigGeneratorPackages = this._jsConfigGeneratorPackagesTracker.getJSConfigGeneratorPackages();
        for (JSConfigGeneratorPackage jsConfigGeneratorPackage : jsConfigGeneratorPackages) {
            String jsConfigGeneratorPackageResolvedId = jsConfigGeneratorPackage.getName() + "@" + jsConfigGeneratorPackage.getVersion();
            partialMatchMap.put(jsConfigGeneratorPackage.getName(), jsConfigGeneratorPackageResolvedId);
        }
        partialMatchMap.putAll(this._npmRegistry.getGlobalAliases());
        return partialMatchMap;
    }

    private String _map(String moduleName, Map<String, String> exactMatchMap, Map<String, String> partialMatchMap) {
        String mappedModuleName = exactMatchMap.get(moduleName);
        if (Validator.isNotNull((String)mappedModuleName)) {
            return mappedModuleName;
        }
        for (Map.Entry<String, String> entry : partialMatchMap.entrySet()) {
            String resolvedId = entry.getKey();
            if (!resolvedId.equals(moduleName) && !moduleName.startsWith(resolvedId + "/")) continue;
            return entry.getValue() + moduleName.substring(resolvedId.length());
        }
        return moduleName;
    }
}

