/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.js.loader.modules.extender.internal.npm.flat;

import com.liferay.frontend.js.loader.modules.extender.internal.npm.flat.FlatJSBundle;
import com.liferay.frontend.js.loader.modules.extender.internal.npm.flat.FlatJSModule;
import com.liferay.frontend.js.loader.modules.extender.internal.npm.flat.FlatJSPackage;
import com.liferay.frontend.js.loader.modules.extender.npm.JSBundle;
import com.liferay.frontend.js.loader.modules.extender.npm.JSBundleProcessor;
import com.liferay.frontend.js.loader.modules.extender.npm.JSPackageDependency;
import com.liferay.frontend.js.loader.modules.extender.npm.ModuleNameUtil;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.framework.Bundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={JSBundleProcessor.class})
public class FlatNPMBundleProcessor
implements JSBundleProcessor {
    private static final Log _log = LogFactoryUtil.getLog(FlatNPMBundleProcessor.class);
    private static final Pattern _moduleDefinitionPattern = Pattern.compile("Liferay\\.Loader\\.define.*\\[(.*)\\].*");
    @Reference
    private JSONFactory _jsonFactory;

    @Override
    public JSBundle process(Bundle bundle) {
        URL url = bundle.getResource("META-INF/resources/package.json");
        if (url == null) {
            return null;
        }
        FlatJSBundle flatJSBundle = new FlatJSBundle(bundle);
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Processing NPM bundle: " + flatJSBundle));
        }
        this._processRootPackage(flatJSBundle);
        this._processNodePackages(flatJSBundle);
        return flatJSBundle;
    }

    private String _getResourceContent(FlatJSBundle flatJSBundle, String location) {
        URL url = flatJSBundle.getResourceURL(location);
        if (url == null) {
            return null;
        }
        try {
            return StringUtil.read((InputStream)url.openStream());
        }
        catch (IOException ioe) {
            return null;
        }
    }

    private String _normalizeModuleContent(String moduleContent) {
        int index = (moduleContent = moduleContent.replaceAll("\n", " ")).indexOf("Liferay.Loader.define(");
        if (index == -1) {
            return "";
        }
        if ((index = (moduleContent = moduleContent.substring(index)).indexOf("function")) == -1) {
            return "";
        }
        return moduleContent.substring(0, index);
    }

    private Collection<String> _parseModuleDependencies(URL url) throws IOException {
        String urlContent = this._normalizeModuleContent(StringUtil.read((InputStream)url.openStream()));
        Matcher matcher = _moduleDefinitionPattern.matcher(urlContent);
        if (!matcher.find()) {
            return Collections.emptyList();
        }
        String group = matcher.group(1);
        String[] dependencies = group.split(",");
        if (dependencies.length == 1 && dependencies[0].equals("")) {
            return Collections.emptyList();
        }
        for (int i = 0; i < dependencies.length; ++i) {
            dependencies[i] = dependencies[i].trim();
            dependencies[i] = dependencies[i].replaceAll("'", "");
            dependencies[i] = dependencies[i].replaceAll("\"", "");
        }
        return Arrays.asList(dependencies);
    }

    private void _processDependencies(FlatJSPackage flatJSPackage, JSONObject jsonObject, String key) {
        JSONObject dependencies = jsonObject.getJSONObject(key);
        if (dependencies != null) {
            Iterator dependencyNames = dependencies.keys();
            while (dependencyNames.hasNext()) {
                String dependencyName = (String)dependencyNames.next();
                String versionConstraints = dependencies.getString(dependencyName);
                flatJSPackage.addJSPackageDependency(new JSPackageDependency(flatJSPackage, dependencyName, versionConstraints));
            }
        }
    }

    private void _processModules(FlatJSPackage flatJSPackage, String location) {
        String nodeModulesPath = "/" + location + "/node_modules/";
        FlatJSBundle flatJSBundle = flatJSPackage.getJSBundle();
        Enumeration<URL> urls = flatJSBundle.findEntries(location, "*.js", true);
        if (urls == null) {
            return;
        }
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            String path = url.getPath();
            if (path.startsWith(nodeModulesPath)) continue;
            String name = path.substring(location.length() + 2);
            name = ModuleNameUtil.toModuleName(name);
            Collection<String> dependencies = null;
            try {
                dependencies = this._parseModuleDependencies(url);
            }
            catch (IOException ioe) {
                _log.error((Object)("Unable to read URL: " + url), (Throwable)ioe);
                continue;
            }
            FlatJSModule flatJSModule = new FlatJSModule(flatJSPackage, name, dependencies);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Adding NPM module: " + flatJSModule));
            }
            flatJSPackage.addJSModule(flatJSModule);
        }
    }

    private void _processNodePackages(FlatJSBundle flatJSBundle) {
        Enumeration<URL> urls = flatJSBundle.findEntries("META-INF/resources", "package.json", true);
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            String path = url.getPath();
            if (path.equals("/META-INF/resources/package.json")) continue;
            String location = path.substring(1, path.length() - 13);
            this._processPackage(flatJSBundle, location, false);
        }
    }

    private void _processPackage(FlatJSBundle flatJSBundle, String location, boolean root) {
        JSONObject jsonObject = null;
        try {
            jsonObject = this._jsonFactory.createJSONObject(this._getResourceContent(flatJSBundle, location + "/package.json"));
        }
        catch (Exception e) {
            _log.error((Object)StringBundler.concat((String[])new String[]{"Unable to parse package of ", String.valueOf(flatJSBundle), ": ", location, "/package.json"}), (Throwable)e);
            return;
        }
        String mainModuleName = null;
        String main = jsonObject.getString("main");
        if (Validator.isNull((String)main)) {
            mainModuleName = "index";
        } else {
            mainModuleName = ModuleNameUtil.toModuleName(main);
            if (mainModuleName.startsWith("./")) {
                mainModuleName = mainModuleName.substring(2);
            }
        }
        FlatJSPackage flatJSPackage = new FlatJSPackage(flatJSBundle, jsonObject.getString("name"), jsonObject.getString("version"), mainModuleName, root);
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Adding NPM package: " + flatJSPackage));
        }
        this._processDependencies(flatJSPackage, jsonObject, "dependencies");
        this._processDependencies(flatJSPackage, jsonObject, "peerDependencies");
        this._processModules(flatJSPackage, location);
        flatJSBundle.addJSPackage(flatJSPackage);
    }

    private void _processRootPackage(FlatJSBundle flatJSBundle) {
        String location = "META-INF/resources";
        this._processPackage(flatJSBundle, location, true);
    }
}

