/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.js.loader.modules.extender.internal.npm;

import com.github.yuchi.semver.Range;
import com.github.yuchi.semver.Version;
import com.liferay.frontend.js.loader.modules.extender.npm.JSBundle;
import com.liferay.frontend.js.loader.modules.extender.npm.JSBundleProcessor;
import com.liferay.frontend.js.loader.modules.extender.npm.JSModule;
import com.liferay.frontend.js.loader.modules.extender.npm.JSPackage;
import com.liferay.frontend.js.loader.modules.extender.npm.JSPackageDependency;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;

@Component(immediate=true, service={NPMRegistry.class})
public class NPMRegistry {
    private BundleContext _bundleContext;
    private BundleTracker<JSBundle> _bundleTracker;
    private final List<JSBundleProcessor> _jsBundleProcessors = new ArrayList<JSBundleProcessor>();
    private final Set<JSBundle> _jsBundles = new ConcurrentSkipListSet<JSBundle>(new Comparator<JSBundle>(){

        @Override
        public int compare(JSBundle jsBundle1, JSBundle jsBundle2) {
            String id1 = jsBundle1.getId();
            String id2 = jsBundle2.getId();
            return id1.compareTo(id2);
        }
    });
    private Map<String, JSModule> _jsModules = new HashMap<String, JSModule>();
    private Map<String, JSPackage> _jsPackages = new HashMap<String, JSPackage>();
    private Map<String, JSModule> _resolvedJSModules = new HashMap<String, JSModule>();

    public Collection<JSBundle> getJSBundles() {
        return this._jsBundles;
    }

    public JSModule getJSModule(String identifier) {
        return this._jsModules.get(identifier);
    }

    public Collection<JSPackage> getJSPackages() {
        return this._jsPackages.values();
    }

    public JSModule getResolvedJSModule(String identifier) {
        return this._resolvedJSModules.get(identifier);
    }

    public Collection<JSModule> getResolvedJSModules() {
        return this._resolvedJSModules.values();
    }

    public JSPackage resolveJSPackageDependency(JSPackageDependency jsPackageDependency) {
        String packageName = jsPackageDependency.getPackageName();
        ArrayList<JSPackage> jsPackages = new ArrayList<JSPackage>();
        for (JSPackage jsPackage : this._jsPackages.values()) {
            if (!packageName.equals(jsPackage.getName())) continue;
            jsPackages.add(jsPackage);
        }
        Collections.sort(jsPackages, new Comparator<JSPackage>(){

            @Override
            public int compare(JSPackage jsPackage1, JSPackage jsPackage2) {
                Version version1 = Version.from((Object)jsPackage1.getVersion(), (boolean)true);
                Version version2 = Version.from((Object)jsPackage2.getVersion(), (boolean)true);
                return version1.compareTo(version2);
            }
        });
        Range range = Range.from((Object)jsPackageDependency.getVersionConstraints(), (boolean)true);
        for (JSPackage jsPackage : jsPackages) {
            Version version = Version.from((Object)jsPackage.getVersion(), (boolean)true);
            if (!range.test(version)) continue;
            return jsPackage;
        }
        return null;
    }

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) throws Exception {
        if (this._bundleTracker != null) {
            this._bundleTracker.close();
        }
        this._bundleContext = bundleContext;
        this._bundleTracker = new BundleTracker(this._bundleContext, 32, (BundleTrackerCustomizer)new NPMRegistryBundleTrackerCustomizer());
        this._bundleTracker.open();
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="unbindBundleProcessor")
    protected synchronized void bindBundleProcessor(JSBundleProcessor jsBundleProcessor) {
        this._jsBundleProcessors.add(jsBundleProcessor);
        this._reopenBundleTracker();
    }

    @Deactivate
    protected synchronized void deactivate() {
        this._bundleTracker.close();
        this._bundleTracker = null;
    }

    protected synchronized void unbindBundleProcessor(JSBundleProcessor jsBundleProcessor) {
        this._jsBundleProcessors.remove(jsBundleProcessor);
        this._reopenBundleTracker();
    }

    private synchronized JSBundle _processBundle(Bundle bundle) {
        for (JSBundleProcessor jsBundleProcessor : this._jsBundleProcessors) {
            JSBundle jsBundle = jsBundleProcessor.process(bundle);
            if (jsBundle == null) continue;
            this._jsBundles.add(jsBundle);
            this._refreshJSModuleCaches();
            return jsBundle;
        }
        return null;
    }

    private synchronized void _refreshJSModuleCaches() {
        HashMap<String, JSModule> jsModules = new HashMap<String, JSModule>();
        HashMap<String, JSPackage> jsPackages = new HashMap<String, JSPackage>();
        HashMap<String, JSModule> resolvedJSModules = new HashMap<String, JSModule>();
        for (JSBundle jsBundle : this._jsBundles) {
            for (JSPackage jsPackage : jsBundle.getJSPackages()) {
                jsPackages.put(jsPackage.getId(), jsPackage);
                for (JSModule jsModule : jsPackage.getJSModules()) {
                    jsModules.put(jsModule.getId(), jsModule);
                    resolvedJSModules.put(jsModule.getResolvedId(), jsModule);
                }
            }
        }
        this._jsModules = jsModules;
        this._jsPackages = jsPackages;
        this._resolvedJSModules = resolvedJSModules;
    }

    private synchronized boolean _removeBundle(JSBundle jsBundle) {
        boolean removed = this._jsBundles.remove(jsBundle);
        if (removed) {
            this._refreshJSModuleCaches();
        }
        return removed;
    }

    private synchronized void _reopenBundleTracker() {
        if (this._bundleTracker != null) {
            this._bundleTracker.close();
            this._bundleTracker.open();
        }
    }

    private class NPMRegistryBundleTrackerCustomizer
    implements BundleTrackerCustomizer<JSBundle> {
        private NPMRegistryBundleTrackerCustomizer() {
        }

        public JSBundle addingBundle(Bundle bundle, BundleEvent bundleEvent) {
            return NPMRegistry.this._processBundle(bundle);
        }

        public void modifiedBundle(Bundle bundle, BundleEvent bundleEvent, JSBundle jsBundle) {
            this.removedBundle(bundle, bundleEvent, jsBundle);
            this.addingBundle(bundle, bundleEvent);
        }

        public void removedBundle(Bundle bundle, BundleEvent bundleEvent, JSBundle jsBundle) {
            NPMRegistry.this._removeBundle(jsBundle);
        }
    }
}

