/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.frontend.js.loader.modules.extender.internal;

import aQute.lib.converter.Converter;
import com.liferay.frontend.js.loader.modules.extender.internal.Details;
import com.liferay.frontend.js.loader.modules.extender.internal.JSLoaderModule;
import com.liferay.osgi.util.ServiceTrackerFactory;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import javax.servlet.ServletContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(configurationPid={"com.liferay.frontend.js.loader.modules.extender.internal.Details"}, immediate=true, service={JSLoaderModulesTracker.class})
public class JSLoaderModulesTracker
implements ServiceTrackerCustomizer<ServletContext, ServiceReference<ServletContext>> {
    private volatile Details _details;
    private final Map<ServiceReference<ServletContext>, JSLoaderModule> _jsLoaderModules = new ConcurrentSkipListMap<ServiceReference<ServletContext>, JSLoaderModule>();
    private volatile long _lastModified = System.currentTimeMillis();
    private ServiceTracker<ServletContext, ServiceReference<ServletContext>> _serviceTracker;

    @Activate
    @Modified
    public void activate(ComponentContext componentContext, Map<String, Object> properties) throws Exception {
        if (this._serviceTracker != null) {
            this._serviceTracker.close();
        }
        this.setDetails(Converter.cnv(Details.class, properties));
        this._jsLoaderModules.clear();
        this._serviceTracker = ServiceTrackerFactory.open((BundleContext)componentContext.getBundleContext(), (String)("(&(objectClass=" + ServletContext.class.getName() + ")(osgi.web.contextpath=*))"), (ServiceTrackerCustomizer)this);
    }

    public ServiceReference<ServletContext> addingService(ServiceReference<ServletContext> serviceReference) {
        String contextPath = (String)serviceReference.getProperty("osgi.web.contextpath");
        Bundle bundle = serviceReference.getBundle();
        URL url = bundle.getEntry("META-INF/config.json");
        if (url == null) {
            return serviceReference;
        }
        JSLoaderModule jsLoaderModule = new JSLoaderModule(this._details.applyVersioning(), serviceReference.getBundle(), contextPath);
        this._jsLoaderModules.put(serviceReference, jsLoaderModule);
        this._lastModified = System.currentTimeMillis();
        return serviceReference;
    }

    public Collection<JSLoaderModule> getJSLoaderModules() {
        return this._jsLoaderModules.values();
    }

    public long getLastModified() {
        return this._lastModified;
    }

    public long getTrackingCount() {
        return this._serviceTracker.getTrackingCount();
    }

    public void modifiedService(ServiceReference<ServletContext> serviceReference, ServiceReference<ServletContext> trackedServiceReference) {
        this.removedService(serviceReference, trackedServiceReference);
        this.addingService(serviceReference);
    }

    public void removedService(ServiceReference<ServletContext> serviceReference, ServiceReference<ServletContext> trackedServiceReference) {
        this._jsLoaderModules.remove(serviceReference);
        this._lastModified = System.currentTimeMillis();
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTracker.close();
        this._serviceTracker = null;
    }

    protected void setDetails(Details details) {
        this._details = details;
    }
}

