/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.frontend.js.loader.modules.extender.npm.model;

import com.liferay.frontend.js.loader.modules.extender.npm.JSBundle;
import com.liferay.frontend.js.loader.modules.extender.npm.JSPackage;

import java.util.ArrayList;
import java.util.Collection;

/**
 * Provides an incomplete implementation of {@link JSBundle} that can be reused
 * by existing implementations.
 *
 * @author Iván Zaera
 */
public abstract class JSBundleAdapter implements JSBundle {

	/**
	 * Constructs a <code>JSBundleAdapter</code> with the ID, name, and version.
	 *
	 * @param id the OSGi bundle's ID
	 * @param name the OSGi bundle's name
	 * @param version the OSGi bundle's version
	 */
	public JSBundleAdapter(String id, String name, String version) {
		_id = id;
		_name = name;
		_version = version;
	}

	/**
	 * Adds the NPM package description to the bundle.
	 *
	 * @param jsPackage the NPM package
	 */
	public void addJSPackage(JSPackage jsPackage) {
		_jsPackages.add(jsPackage);
	}

	@Override
	public String getId() {
		return _id;
	}

	@Override
	public Collection<JSPackage> getJSPackages() {
		return _jsPackages;
	}

	@Override
	public String getName() {
		return _name;
	}

	@Override
	public String getVersion() {
		return _version;
	}

	private final String _id;
	private final Collection<JSPackage> _jsPackages = new ArrayList<>();
	private final String _name;
	private final String _version;

}