/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.frontend.js.loader.modules.extender.npm;

/**
 * Represents a {@link JSBundleAsset} that is selected/resolved from a pool of
 * equivalent objects of the same type.
 *
 * <p>
 * For example, several {@link JSModule} objects may point to the same physical
 * asset living in different bundles; each of those objects can be requested
 * using its {@link JSBundleAsset} URL. Only the resolved instance chosen by a
 * predefined algorithm, however, is eligible to be requested via the {@link
 * JSResolvableBundleAsset} URL. This is useful to disambiguate duplicated
 * assets.
 * </p>
 *
 * @author Iván Zaera
 */
public interface JSResolvableBundleAsset extends JSBundleAsset {

	/**
	 * Returns the asset's resolved ID; this differs from the canonical ID
	 * defined in the {@link JSBundleAsset}. See this class's package summary
	 * for more information about resolved assets.
	 *
	 * @return the asset's resolved ID
	 */
	public String getResolvedId();

	/**
	 * Returns the asset's resolved URL; this differs from the canonical URL
	 * defined in the {@link JSBundleAsset}. See this class's package summary
	 * for more information about resolved assets.
	 *
	 * @return the asset's resolved URL
	 */
	public String getResolvedURL();

}